#ifndef			BOBILLY_BALL
#define			BOBILLY_BALL


#include "BPlayer.h"

class BBall : public BObject {
	protected:
		float v;			// speed of the ball
		float dir;			// direction of the ball
		float g;			// the gravity constant
		float air;			// air density/resistance factor
		float bounce;		// ball bounce factor
		int side;			// on which side of the net is the ball?
		enum { LEFT, RIGHT, BETWEEN };
		bool is_in_play;
		int hit;			// number of times hit by the same player
		int hplayer;		// which player hit the ball last?
		int cplayer;		// which player hit the ball in the previous frame?
		int splayer;		// which player serves?

		void UpdateSpeedAndDirection(float vx, float vy);
		bool CollisionDetection(BObject *p, int& cx, int &cy);
		bool BounceTheBall(BObject *obj, int newx, int newy);

	public:
		BBall();
		~BBall();

		virtual void MsgStart();
		int Update(BPlayer *p1, BPlayer *p2);
		void Serve(BPlayer *p);
		enum { UPDATE_SCORE1=MSG_SUSER, UPDATE_SCORE2, ESCAPE_GAME, GAME_OVER };
		float Speed() { return v; }
		float Angle() { return dir; }
};


#endif			//BOBILLY_BALL
