#include <allegro.h>
#include <alleggl.h>
#include <math.h>
#include <stdlib.h>
#include <time.h>

typedef struct BLOB BLOB;
struct BLOB
{
	float ox, oy, ow, oh, mx, my;

	float x, y, a, s, rs, r, sa;
	int z;
	
	char id;

	int bubbletime;
	int bubbler;
	int alive;
	int who;
	
	float ex, ey;
	
	float shields;

	void (*logic) (BLOB *self);
	void (*render) (BLOB *self);
};

static FONT *agl_font = NULL;

static BITMAP *art;
static GLuint texture;

static int frames;
static int cd;
static SAMPLE *tok;
static SAMPLE *boom;
static SAMPLE *blip;

/* Look just below if you want to cheat. */
static int wave = 0; /* Level, from 0 to 29. */
static int lives = 3; /* Lives. */
static int shields = 0; /* Extra shields. */
static int shots = 0; /* Extra shots. */

static int getready;

static volatile int ticks = 0;

static int blobs_count = 0;
static BLOB blobs[1024];
static int bubbles_count = 0;
static BLOB bubbles[1024];

static void bubble_logic (BLOB *self);
static void player_logic (BLOB *self);
static void enemy_logic (BLOB *self);
static void friend_logic (BLOB *self);
static void explosion_logic (BLOB *self);
static BLOB *blob_collide (BLOB *self);

static void blob_render (BLOB *self);
static void player_render (BLOB *self);
static void blob_render_life (BLOB *self);

static void
ticker (void)
{
	ticks++;
}

static BLOB *
blob_new (char id, float x, float y, float w, float h, float mx, float my, float r,
		  void (*logic) (BLOB *self), BLOB *list)
{
	int b;
	
	if (list == blobs)
	{
		if (blobs_count == 1024)
			return NULL;
		b = blobs_count++;
	}
	else
	{
		if (bubbles_count == 1024)
			return NULL;
		b = bubbles_count++;
	}

	BLOB *self = &list[b];

	self->id = id;

	self->ox = x;
	self->oy = y;
	self->ow = w;
	self->oh = h;
	self->mx = mx;
	self->my = my;
	self->r = r;

	self->x = 0;
	self->y = 0;
	self->a = (rand () % 360) * AL_PI / 180.0;
	self->sa = self->a;
	self->z = 0;

	self->s = 1;
	self->rs = 0.125;
	
	self->shields = 0;

	self->alive = 0;
	self->bubbletime = 0;
	self->bubbler = 0;

	self->alive = 1;
	self->logic = logic;
	self->who = 0;

	self->render = blob_render;

	return self;
}

static void
blob_del (int b, BLOB *list)
{
	int l;

	if (list == blobs)
		l = --blobs_count;
	else
		l = --bubbles_count;
	list[b] = list[l];
}

char const *waves[] =
{
	"SSSSSSSB",
	"SSSSSSSSSSSSSSR",
	"SSSSSSSSSSSSSSTTB",
	"TTTTTTQR",
	"SSSSSSSSTTTTTTTTGC",
	"SSSSSSCSSSSTTTTTTTTTTBBB",
	"QQQQSSSSTTTTRGB",
	"QQCCCSSSSTTTTGB",
	"CCCCCCCCCCGBGRBGBSSS",
	"WWWWSSSSSSSSTTTTTGBGB", /* 10 */
	"SSTTQQCCWWRGGBB",
	"SSSSTTTTTQQQQCCCCWWWWRGGBB",
	"WWWWWWWWWWWWWWBBG",
	"GTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTT",
	"QRQGSQBQSQGRRQBQSTTTTTTTTTTTTT",
	"QTQTQTQTQTQTQTQTQTQTQTQTQRQRQGQB",
	"SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSRGBTTSSSSSSSSWWWW",
	"SSSSSSSSSSSSSSSSSSSSWWWWCCCCTTTTTTTTTTTCCGBBGBRSSSSSSS",
	"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOORGBGGGCCTTT",
	"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFSSSSSSSSSSSSSSRGB", /* 20 */
	"KKKKKKKORGBBB",
	"KKKKKKKKKKSSSSSSSSSSSSSSSSSFFFRGGBBB",
	"KKKKKKKOOOOOOOTTTTTTTTTTTTTTRGBGB",
	"DDDDDCCCCFFFFQSSSSRGB",
	"DDDDDDDDDDDDQTOORGGBBB",
	"ERGBWWWWBBQQQQBB",
	"EQQQQQQQQQQQQKRRKKGGGBBBBBBB",
	"ECCCCCDDDDKKRRGGGBBB",
	"EEERRGGGGGBBBBBBBBBBB",
	"ARGBBGBBGBBGGBGGG",
	"RRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRR"
	"GGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGG"
	"BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB"
	"PPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPP",
	NULL
};

static BLOB *
create_id (char id)
{
	BLOB *b = NULL;
	switch (id)
	{
		case 'P':
			if (!(b = blob_new (' ', 96, 0, 32, 32, 112, 15, 14, friend_logic, blobs)))
				break;
			b->s = 0.1;
		break;
		case 'R':
			if (!(b = blob_new ('R', 0, 0, 32, 32, 16, 16, 12, friend_logic, blobs)))
				break;
			b->s = 0.1;
		break;
		case 'G':
			if (!(b = blob_new ('G', 32, 0, 32, 32, 48, 16, 12, friend_logic, blobs)))
				break;
			b->s = 0.1;
		break;
		case 'B':
			if (!(b = blob_new ('B', 64, 0, 32, 32, 80, 16, 12, friend_logic, blobs)))
				break;
			b->s = 0.1;
		break;
		case 'S':
			if (!(b = blob_new ('S', 0, 32, 32, 32, 15, 48, 12, enemy_logic, blobs)))
				break;
			b->s = 0.2;
		break;
		case 'F':
			if (!(b = blob_new ('S', 0, 32, 32, 32, 15, 48, 12, enemy_logic, blobs)))
				break;
			b->s = 1.1;
		break;
		case 'T':
			if (!(b = blob_new ('T', 32, 32, 32, 32, 48, 48, 16, enemy_logic, blobs)))
				break;
			b->s = 1;
		break;
		case 'Q':
			if (!(b = blob_new ('Q', 64, 32, 32, 32, 79, 48, 16, enemy_logic, blobs)))
				break;
			b->s = 0.9;
			b->rs = 0.05;
			b->bubbler = 40;
		break;	
		case 'C':
			if (!(b = blob_new ('C', 96, 32, 32, 64, 111, 63, 16, enemy_logic, blobs)))
				break;
			b->s = 2;
			b->bubbler = 60;
			b->shields = 1;
		break;	
		case 'D':
			if (!(b = blob_new ('D', 96, 32, 32, 64, 111, 63, 16, enemy_logic, blobs)))
				break;
			b->s = 1.5;
			b->bubbler = 60;
			b->bubbletime = 60;
			b->shields = 1;
		break;
		case 'W':
			if (!(b = blob_new ('W', 128, 32, 64, 64, 159, 68, 32, enemy_logic, blobs)))
				break;
			b->s = 1;
			b->rs = 0.5;
			b->bubbler = 120;
			b->shields = 3;
		break;
		case 'O':
			if (!(b = blob_new ('O', 192, 0, 32, 32, 208, 16, 15, enemy_logic, blobs)))
				break;
			b->s = 0.1;
			b->rs = 0.01;
			b->bubbler = 300;
			b->bubbletime = 300;
			b->shields = 10;
		break;
		case 'E':
			if (!(b = blob_new ('E', 192, 32, 64, 64, 224, 64, 32, enemy_logic, blobs)))
				break;
			b->s = 0.2;
			b->rs = 0.4;
			b->bubbler = 30;
			b->shields = 30;
		break;
		case 'K':
			if (!(b = blob_new ('K', 0, 64, 64, 32, 32, 86, 21, enemy_logic, blobs)))
				break;
			b->s = 1;
			b->rs = 0.5;
			b->bubbler = 120;
			b->shields = 9;
		break;
		case 'A':
			if (!(b = blob_new ('A', 192, 32, 64, 64, 224, 64, 32, enemy_logic, blobs)))
				break;
			b->s = 0.1;
			b->rs = 0.1;
			b->bubbler = 100;
			b->shields = 400;
			b->render = blob_render_life;
		break;
	}
	return b;
}

static void
new_wave (void)
{
	char const *w = waves[wave];
	char const *c;
	BLOB *b;
	
	if (!w)
	{
		wave = 0;
		w = waves[0];
	}

	blobs_count = 0;
	bubbles_count = 0;

	b = blob_new ('P', 96, 0, 32, 32, 112, 15, 14, player_logic, blobs);
	b->x = 320;
	b->y = 240;
	b->render = player_render;
	b->shields = shields;
	b->s = 3;

	for (c = w; *c; c++)
	{
		b = create_id (*c);
		int t = 0;
		for (t = 0; t < 10000; t++)
		{
			float x = rand () % 640;
			float y = rand () % 480;
			b->x = x;
			b->y = y;
			if ((x - 320) * (x - 320) + (y - 240) * (y - 240) > 100 * 100 &&
				!blob_collide (b))
				break;
		}
	}

	wave++;
	getready = 200;
	if (wave == 1)
		getready += 100;
}

static void
init (void)
{
	tok = load_sample ("nnn.wav");
	boom = load_sample ("boom.wav");
	blip = load_sample ("blip.wav");
	
	allegro_gl_set_texture_format (GL_ALPHA8);
	agl_font =
		allegro_gl_convert_allegro_font (font, AGL_FONT_TYPE_TEXTURED, 1);

	allegro_gl_set_texture_format (GL_RGBA8);
	set_color_conversion (COLORCONV_NONE);

	art = load_bitmap ("nnn.tga", NULL);
	texture = allegro_gl_make_texture (art);

	glDisable (GL_CULL_FACE);
	glDisable (GL_DEPTH_TEST);

	allegro_gl_set_projection ();
	
	new_wave ();
}

static void
blob_render_blend (BLOB *self)
{
	glPushMatrix ();

	glTranslatef (self->x, self->y, 0);
	glRotatef (self->a * 180 / AL_PI, 0, 0, 1);
	glTranslatef (-self->mx, -self->my, 0);

	glBegin (GL_TRIANGLE_FAN);

	GLfloat w = art->w;
	GLfloat h = art->h;

	GLfloat l = self->ox;
	GLfloat t = self->oy;
	GLfloat r = self->ox + self->ow;
	GLfloat b = self->oy + self->oh;

	glTexCoord2f ((r + 0.5) / w, (art->h - b - 0.5) / h);
	glVertex2d (r, b);

	glTexCoord2f (l / w, (art->h - b - 0.5) / h);
	glVertex2d (l, b);

	glTexCoord2f (l / w, (art->h - t) / h);
	glVertex2d (l, t);

	glTexCoord2f ((r + 0.5) / w, (art->h - t) / h);
	glVertex2d (r, t);

	glEnd ();

	glPopMatrix ();
}

static void
blob_render (BLOB *self)
{
	glColor4f (1, 1, 1, 1);

	glEnable (GL_BLEND);
	glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glBindTexture (GL_TEXTURE_2D, texture);

	blob_render_blend (self);
}

static void
blob_render_life (BLOB *self)
{
	float p = self->shields / 400.0f;
	glColor4f (1, 1, 1, p);

	glEnable (GL_BLEND);
	glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glBindTexture (GL_TEXTURE_2D, texture);

	blob_render_blend (self);
}

static void
explosion_render (BLOB *self)
{
	glColor4f (1, 1, 1, 1);
	glEnable (GL_BLEND);
	glBlendFunc (GL_SRC_ALPHA, GL_ONE);
	glBindTexture (GL_TEXTURE_2D, texture);

	blob_render_blend (self);
}

static void
player_render (BLOB *self)
{
	BLOB gun;
	gun.x = self->x;
	gun.y = self->y;
	gun.ox = 128;
	gun.oy = 0;
	gun.ow = 32;
	gun.oh = 32;
	gun.mx = 144;
	gun.my = 32;
	gun.a = self->sa;

	blob_render (self);
	blob_render (&gun);
}

static void
digit (float x, float y, int v)
{
	BLOB d;
	d.x = x;
	d.y = y;
	d.ox = v * 16;
	d.oy = 192;
	d.ow = 16;
	d.oh = 32;
	d.mx = v * 16 + 8;
	d.my = 192;
	d.a = 0;
	blob_render (&d);
}

static void
number (float x, float y, int num, int zeroes)
{
	int i = 10;
	int d = 1000000000;
	while (d)
	{
		if (num >= d || zeroes >= i)
		{
			int z = (num / d) % 10;
			digit (x, y, z);
			x += 20;
		}
		d /= 10;
		i--;
	}
}

static void
render (void)
{
	glClearColor (1.0, 0.9, 1.0, 0.0);
	glClear (GL_COLOR_BUFFER_BIT);

	glMatrixMode (GL_MODELVIEW);
	glLoadIdentity ();

	glEnable (GL_TEXTURE_2D);
	glDisable (GL_BLEND);
	glBindTexture (GL_TEXTURE_2D, texture);

	int i;

	for (i = 0; i < blobs_count; i++)
	{
		if (blobs[i].alive)
			blobs[i].render (&blobs[i]);
	}
	for (i = 0; i < bubbles_count; i++)
	{
		if (bubbles[i].alive)
			bubbles[i].render (&bubbles[i]);
	}

	if (getready)
	{
		glPushMatrix ();
		glTranslatef (320, 240, 0);
		if (getready < 100)
		{
			glRotatef (2 * 360 * sqrt (getready) / 10, 0, 0, 1);
		}

		/* wave */
		BLOB text;
		text.ox = 160;
		text.oy = 192;
		text.ow = 96;
		text.oh = 32;
		text.mx = 208;
		text.my = 208;
		text.x = -48;
		text.y = 30;
		text.a = 0;
		blob_render (&text);

		number (20, 20, wave, 1);

		/* get ready */
		text.ox = 0;
		text.oy = 160;
		text.ow = 256;
		text.oh = 32;
		text.mx = 128;
		text.my = 196;
		text.x = 0;
		text.y = 0;
		text.a = 0;
		blob_render (&text);
		
		if (wave == 1)
		{
			/* instructions */
			text.ox = 0;
			text.oy = 224;
			text.ow = 256;
			text.oh = 32;
			text.mx = 128;
			text.my = 140;
			text.x = 0;
			text.y = 80;
			text.a = 0;
			blob_render (&text);
		}

		for (i = 0; i < lives; i ++)
		{
			BLOB l = blobs[0];
			l.x = 0 - 10 * (lives - 1) + i * 20;
			l.y = 60;
			blob_render (&l);
		}
		
		for (i = 0; i < shields; i ++)
		{
			BLOB l;
			l.ox = 64;
			l.oy = 0;
			l.ow = 32;
			l.oh = 32;
			l.mx = 80;
			l.my = 16;
			l.a = 0;
			l.x = 0 - 10 * (shields - 1) + i * 20;
			l.y = 80;
			blob_render (&l);
		}

		glPopMatrix ();
	}

	glFlush ();

	allegro_gl_flip ();

}

static int
blobs_overlap (BLOB *self, BLOB *other)
{
	float dx = self->x - other->x;
	float dy = self->y - other->y;
	float r = self->r + other->r;

	return dx * dx + dy * dy <= r * r;
}

static BLOB *
blob_collide (BLOB *self)
{
	int i;

	for (i = 0; i < blobs_count; i++)
	{
		BLOB *other = &blobs[i];

		if (other != self && other->alive)
			if (blobs_overlap (self, other))
				return other;
	}
	return NULL;
}

static float
turn_angle (float angle, float dx, float dy, float dilate)
{
	float a = AL_PI * 0.5 + atan2 (dy, dx);
	float da = a - angle;

	if (da >= AL_PI)
		da -= AL_PI * 2;
	if (da < -AL_PI)
		da += AL_PI * 2;
	if (da > 0)
	{
		angle += da * dilate;
		if (angle >= AL_PI * 2)
			angle -= AL_PI * 2;
	}
	else
	{
		angle += da * dilate;
		if (angle < 0)
			angle += AL_PI * 2;
	}
	return angle;
}

static void
turn (BLOB *self, float dx, float dy, float dilate)
{
	self->a = turn_angle (self->a, dx, dy, dilate);
}

static void
turnshot (BLOB *self, float dx, float dy, float dilate)
{
	self->sa = turn_angle (self->sa, dx, dy, dilate);
}

static BLOB *
move (BLOB *self, float dx, float dy)
{
	float ox = self->x;
	float oy = self->y;

	self->x += dx;
	self->y += dy;
	
	if (self->x - self->r > 640)
		self->x -= 640 + self->r * 2;
	if (self->x + self->r < 0)
		self->x += 640 + self->r * 2;
	if (self->y - self->r > 480)
		self->y -= 480 + self->r * 2;
	if (self->y + self->r < 0)
		self->y += 480 + self->r * 2;

	BLOB *c = blob_collide (self);

	if (c)
	{
		self->x = ox;
		self->y = oy;
	}
	return c;
}

static int
explode (BLOB *self)
{
	if (self->logic != explosion_logic)
	{
		if (self->shields)
		{
			play_sample (tok, self->id == 'P' ? 255 : 70, 128, 1000, 0);
			self->shields--;
			return 0;
		}
		else
		{
			BLOB *ex = blob_new ('*', 192, 96, 64, 64, 224, 128, 8,
				explosion_logic, bubbles);
			if (ex)
			{
				ex->render = explosion_render;
				ex->s = 1;
				ex->z = 20;
				ex->x = self->x;
				ex->y = self->y;
				ex->a = self->a;
			}

			self->alive = 0;

			if (self->id == '$')
			{
				char const *ids = "FFSTTTQQQDDCCWOK";
				int r = rand () & 15;
				BLOB *b = create_id (ids[r]);
				if (b)
				{
					int col = 1;
					int t;
					for (t = 0; t < 7; t++)
					{
						int a = t * 10;
						b->x = self->x + rand () % (1 + a * 2) - a;
						b->y = self->y + rand () % (1 + a * 2) - a;
						if (!blob_collide (b))
						{
							col = 0;
							break;
						}
					}
					if (col)
						b->alive = 0;
				}
			}

			return 1;
		}
	}
	return 0;
}

static void
blub (BLOB *self, float angle, float offset)
{
	float a = self->sa + angle;

	BLOB *bubble = blob_new ('~', 128, 0, 32, 32, 144, 16, 8, bubble_logic,
							 bubbles);
	
	if (!bubble)
		return;
	
	float c = cos (a);
	float s = sin (a);

	bubble->who = 1;

	float br = self->r + bubble->r + 1;

	bubble->x = self->x + s * br + c * offset;
	bubble->y = self->y - c * br + s * offset;
	bubble->a = a;
	bubble->z = 60;
	bubble->s = 8;
}

static void
player_logic (BLOB *self)
{
	float dx = 0, dy = 0;
	int sx = 0, sy = 0;

	if (wave < 31)
	{
		if (key[KEY_LEFT] && key[KEY_RIGHT])
		{
		}
		else if (key[KEY_LEFT])
		{
			dx = -1;
		}
		else if (key[KEY_RIGHT])
		{
			dx = 1;
		}
	
		if (key[KEY_UP] && key[KEY_DOWN])
		{
		}
		else if (key[KEY_UP])
		{
			dy = -1;
		}
		else if (key[KEY_DOWN])
		{
			dy = 1;
		}
		
		if (key[KEY_A] && key[KEY_D])
		{
		}
		else if (key[KEY_A])
		{
			sx = -1;
		}
		else if (key[KEY_D])
		{
			sx = 1;
		}
	
		if (key[KEY_W] && key[KEY_S])
		{
		}
		else if (key[KEY_W])
		{
			sy = -1;
		}
		else if (key[KEY_S])
		{
			sy = 1;
		}
	}
	else
	{
		sx = rand () % 3 - 1;
		sx = rand () % 3 - 1;
		dx = rand () % 3 - 1;
		dx = rand () % 3 - 1;
	}
	float r = sqrt (dx * dx + dy * dy);
	float shoot = sqrt (sx * sx + sy * sy);

	if (r)
	{
		BLOB *c = NULL;
		if (wave < 31)
			c = move (self, self->s * dx / r, self->s * dy / r);
		if (c)
		{
			if (c->id == 'R')
			{
				lives++;
				c->alive = 0;
			}
			if (c->id == 'B')
			{
				self->shields++;
				c->alive = 0;
			}
			if (c->id == 'G')
			{
				shots += 150;
				c->alive = 0;
			}
		}
		turn (self, dx, dy, 0.125);
	}
	
	if (shoot)
	{
		turnshot (self, sx, sy, 0.3);
	}

	if (self->bubbletime)
	{
		self->bubbletime--;
	}
	else if (shoot)
	{
		if (wave == 31)
		{
			play_sample (blip, 70, 128, 2000 + rand () % 5000, 0);
			self->bubbletime = 10;
			return;
		}
		self->bubbletime = 15;
		if (shots)
		{
			if (shots > 100)
			{
				play_sample (blip, 70, 128, 2000, 0);
				blub (self, -AL_PI / 16, 0);
				blub (self, 0, 0);
				blub (self, AL_PI / 16, 0);
				shots -= 2;
			}
			else
			{
				play_sample (blip, 70, 128, 1500, 0);
				blub (self, 0, 4);
				blub (self, 0, -4);
				shots--;
			}
		}
		else
		{
			play_sample (blip, 70, 128, 1000, 0);
			blub (self, 0, 0);
		}
	}
}

static void
enemy_logic (BLOB *self)
{
	BLOB *player = &blobs[0];
	float dx = player->x - self->x;
	float dy = player->y - self->y;
	int no = 0;

	if (dx > 320)
		dx -= 640;
	if (dx < -320)
		dx += 640;
	if (dy > 240)
		dy -= 480;
	if (dy < -240)
		dy += 480;

	if (self->id == 'E')
	{
		/*
		collision:
		dx + pdx * t = u * t (1)
		dy + pdy * t = v * t (2)
		
		speed of projectile:
		u * u + v * v = s * s (3)
		
		solve:
		(1) u = dx / t + pdx (4)
		(2) v = dy / t + pdy (5)
		(4+5 in 3) (dx * dx + dy * dy) / (t * t) +
		    2 * (dx * pdx + dy * pdy) / t +
		    pdx * pdx + pdy * pdy - s * s = 0
		
		A = dx * dx + dy * dy
		B = 2 * (dx * pdx + dy * pdy)
		C = pdx * pdx + pdy * pdy - s * s
		
		D = B * B - 4 * A * C
		
		1/t1 = (sqrt(D) - B) / (2 * A)
		1/t2 = (-sqrt(D) - B) / (2 * A)
		
		*/
		no = 1;
		float s = 5; /* assume too fast speed so we aim short, since player
		most probably stops shortly  */
		float pdx = player->x - self->ex;
		float pdy = player->y - self->ey;

		self->ex = player->x;
		self->ey = player->y;

		float A = dx * dx + dy * dy;
		float B = 2 * (dx * pdx + dy * pdy);
		float C = pdx * pdx + pdy * pdy - s * s;
		float D = B * B - 4 * A * C;

		if (D >= 0)
		{
			float s1 = (sqrt (D) - B) / (2 * A);
			float s2 = (-sqrt (D) - B) / (2 * A);
			if (s1 > 0 || s2 > 0)
			{
				float X = s1;
				if (X < s2)
					X = s2;
				dx += pdx / X;
				dy += pdy / X;
			}
			no = 0;
		}
		
	}
	else if (self->id == '.' && self->bubbletime < 20)
	{
		dx = -dx + rand () % 101 - 50;
		dy = -dy + rand () % 101 - 50;
		if (self->bubbletime == 0)
		{
			int r = rand () % 4;
			self->s -= r / 100.0;
			self->bubbletime = r;
		}
	}

	float r = sqrt (dx * dx + dy * dy);

	if (r)
	{
		BLOB *c = NULL;
		if (self->id == 'A' && r < 200)
			c = move (self, self->s * -dx / r, self->s * -dy / r);
		else
			c = move (self, self->s * dx / r, self->s * dy / r);
		turn (self, dx, dy, self->rs);
		if (c == player)
		{
			if (!explode (player))
			{
				explode (self);
			}
		}
		else
		{
			if (self->id == 'K' || self->id == 'A')
			{
				if (self->ex > 0)
				{
					if (move (self, 2 * self->s * dy / r, 2 * -self->s * dx / r))
						self->ex = -1;
				}
				else
				{
					if (move (self, 2 * -self->s * dy / r, 2 * self->s * dx / r))
						self->ex = 1;
				}
			}
		}
	}
	if (self->bubbletime)
	{
		self->bubbletime--;
	}
	else if (self->bubbler && !no)
	{
		float c = cos (self->a);
		float s = sin (self->a);
		self->bubbletime = self->bubbler;

		if (self->id == '.')
		{
			/* grow */
			if (blob_collide (self))
			{
				self->r = 7;
			}
			else
			{
				int rn = rand () % 10;
				self->id = rn ? 'd' : 'C';
				self->ox = 64;
				self->oy = 64;
				self->ow = 32;
				self->oh = 32;
				self->mx = 80;
				self->my = 80;
				self->s = 2;
				self->bubbler = 60 + rand () % 100;
				self->bubbletime = 50 + rand () % (self->bubbler - 50);
			}
		}
		else if (self->id == 'd' || self->id == 'D')
		{
			/* divide */
			float ox = self->x;
			float oy = self->y;
			int gotroom = 0;
			self->r = (self->id == 'd') ? 7 : 10;
			int i;
			for (i = 0; i < 4; i++)
			{
				float a = (rand () % 360) * AL_PI / 180.0;
				self->x = ox + sin (a) * self->r * 2.1;
				self->y = oy - cos (a) * self->r * 2.1;
				if (!blob_collide (self))
				{
					gotroom = 1;
					break;
				}
			}
			if (gotroom)
			{
				BLOB *di[2];
				self->alive = 0;
				for (i = 0; i < 2; i++)
				{
					if (self->id == 'd')
					{
						di[i] = blob_new ('.', 224, 0, 32, 32, 240, 16, 7, enemy_logic, blobs);
						if (!di[i])
							return;
						di[i]->s = 2.5;
					}
					else
					{
						di[i] = blob_new ('d', 64, 64, 32, 32, 80, 80, 10, enemy_logic, blobs);
						if (!di[i])
							return;
						di[i]->s = 2;
					}
					di[i]->bubbler = 60 + rand () % 100;
					di[i]->shields = 0;
					di[i]->bubbletime = 50 + rand () % (di[i]->bubbler - 50);
				}
				di[0]->x = ox;
				di[0]->y = oy;
				di[0]->a = self->a;

				di[1]->x = self->x;
				di[1]->y = self->y;
				di[1]->a = self->a + AL_PI;
			}
		}
		else if (self->id == 'A')
		{
			BLOB *bubble;
			play_sample (tok, 255, 128, 10000, 0);
			bubble = blob_new ('$', 128, 0, 32, 32, 144, 16, 8, bubble_logic,
							 bubbles);
			float br = self->r + bubble->r + 1;
			bubble->x = self->x + s * br;
			bubble->y = self->y - c * br;
			bubble->a = self->a;
			bubble->z = 30;
			bubble->s = 8;
		}
		else
		{
			BLOB *bubble;
			bubble = blob_new ('^', 160, 0, 32, 32, 178, 18, 8, bubble_logic,
				bubbles);
			float br = self->r + bubble->r + 1;
			bubble->x = self->x + s * br;
			bubble->y = self->y - c * br;
			bubble->a = self->a;
			bubble->z = 120;
			bubble->s = self->id == 'E' ? 4 : 2;
		}
	}
}

static void
friend_logic (BLOB *self)
{
	BLOB *player = &blobs[0];
	float dx = player->x - self->x;
	float dy = player->y - self->y;

	float r = sqrt (dx * dx + dy * dy);

	if (r)
	{
		move (self, self->s * dx / r, self->s * dy / r);
		turn (self, dx, dy, self->rs);
	}
}

static void
bubble_logic (BLOB *self)
{
	BLOB *player = &blobs[0];
	float dx = sin (self->a);
	float dy = -cos (self->a);

	BLOB *c = move (self, self->s * dx, self->s * dy);

	if (c)
	{
		play_sample (boom, 255, 128, 1000, 0);
		explode (self);
		if (c->logic != friend_logic)
		{
			if ((self->who == 0 && c == player))
			{
				explode (c);
			}
			else if (self->who == 1 && c != player)
			{
				explode (c);
			}
		}
		return;
	}

	if (self->z > 0)
		self->z--;
	else
	{
		play_sample (boom, 255, 128, 1000, 0);
		explode (self);
	}
}

static void
explosion_logic (BLOB *self)
{
	float dx = sin (self->a);
	float dy = -cos (self->a);

	self->x += dx * self->s;
    self->y += dy * self->s;
    self->z--;
    self->s *= 0.9;

	if (self->z > 15)
	{
		
	}
	else if (self->z > 10)
	{
		self->ox = 128;
		self->mx = 160;
	}
	else if (self->z > 5)
	{
		self->ox = 64;
		self->mx = 96;
	}
	else if (self->z > 0)
	{
		self->ox = 0;
		self->mx = 32;
	}
	else
	{
		if (self->id == '*')
		{
			BLOB *ex = blob_new (' ', 192, 96, 64, 64, 224, 128, 8,
				explosion_logic, bubbles);
			ex->s = 1;
			ex->z = 20;
			ex->x = self->x;
			ex->y = self->y;
			ex->a = self->a;
		}
		self->alive = 0;
	}
}

static void
logic (void)
{
	int i;
	int alive = 0;
	
	if (getready)
	{
		getready--;
		return;
	}

	for (i = 0; i < blobs_count; i++)
	{
		if (blobs[i].alive)
		{
			blobs[i].logic (&blobs[i]);
			if (blobs[i].id != 'R' && blobs[i].id != 'G' && blobs[i].id != 'B')
				alive++;
		}
		else
		{
			blob_del (i, blobs);
			i--;
		}
	}
	for (i = 0; i < bubbles_count; i++)
	{
		if (bubbles[i].alive)
		{
			bubbles[i].logic (&bubbles[i]);
		}
		else
		{
			blob_del (i, bubbles);
			i--;
		}
	}

	if (blobs[0].alive == 0)
	{
		shields = 0;
		shots = 0;
		if (lives)
		{
			lives--;
			wave--;
		}
		else
			wave = 0;
		new_wave ();
	}
	else
	{
		if (alive == 1 && wave < 31)
		{
			shields = blobs[0].shields;
			new_wave ();
		}
	}
}

extern int _mangled_main (void);
int
main (void)
{
	srand (time (NULL));
	allegro_init ();
	install_allegro_gl ();

	cd = desktop_color_depth ();

	allegro_gl_set (AGL_COLOR_DEPTH, cd);
	allegro_gl_set (AGL_DOUBLEBUFFER, 1);

	allegro_gl_set (AGL_SUGGEST, AGL_COLOR_DEPTH | AGL_DOUBLEBUFFER);

	set_color_depth (cd);
	request_refresh_rate (60);
	if (set_gfx_mode (GFX_OPENGL /*_WINDOWED*/ , 640, 480, 0, 0) < 0)
	{
		allegro_message ("Cannot set graphics mode.\n");
		exit (-1);
	}

	install_keyboard ();
	install_mouse ();
	install_timer ();
	install_int_ex (ticker, BPS_TO_TIMER (60));
	install_sound (DIGI_AUTODETECT, MIDI_NONE, NULL);

	init ();

	frames = ticks;
	int rframes = 0;
	while (!key[KEY_ESC])
	{
		while (frames <= ticks)
		{
			logic ();
			frames++;
		}
		render ();
		rframes++;
	}

	return 0;
}

END_OF_MAIN ();
