/* BlitzHack 2003 code snippets */

#ifndef _SNIPPET_H_
#define _SNIPPET_H_

#include <allegro.h>

#ifdef __cplusplus
extern "C" {
#endif

/* --- data --- */
AL_CONST char *sn_datafile_name(AL_CONST char *def);



/* --- snow --- */
int sn_create_snow(int quantity);
void sn_destroy_snow(void);
void sn_move_snow(void);
void sn_show_snow(BITMAP* bmp, BITMAP* snow);



/* --- scoreblock --- */
typedef struct _score_structure SN_SCOREBLOCK;

/* Create and destroy a score object */
SN_SCOREBLOCK *sn_create_scoreblock (void);
void sn_destroy_scoreblock (SN_SCOREBLOCK *);

/* Initialise the object: number of digits to display,
 * the font with which to draw digits
 * and the foreground/background colours
 * Pass -1 for foreround if using a coloured font
 */
int sn_init_scoreblock (SN_SCOREBLOCK *, int digits, FONT *, int fg, int bg);

/* Update the digit position with a new value.
 * Keep calling this function to make the digits roll round
 */
void sn_update_scoreblock (SN_SCOREBLOCK *, unsigned int new_value);

/*Draw the current state onto this bitmap
*/
void sn_display_scoreblock (SN_SCOREBLOCK *, BITMAP *, int, int);



/* --- particle --- */

/* Simple particle library - good for explosions and trails of flame */
typedef struct _particle_generator SN_PGEN;

/* Create and destroy generator */
SN_PGEN *sn_create_pgen (void);
void sn_destroy_pgen (SN_PGEN *);

/* Initialise:
 * size=size of particles (pixels) (can be 0 for single pixel)
 * lifetime=number of cycles they survive
 * speed=flight speed (pixels/cycle)
 */
int sn_init_pgen (SN_PGEN *, int size, int lifetime, int speed);

/* Initialise some particles
 * (xi,yi)=initial coords
 * angle=angle to emit (0-255) or a PGEN_* constant
 * count=how many particles to emit
 */
int sn_fire_pgen (SN_PGEN *, int xi, int yi, int angle, int count);
/* These are good for explosions */
#define SN_PGEN_ISO2D 1000
#define SN_PGEN_ISO3D 1001


/* Display all particles on the specified bitmap */
int sn_display_pgen (SN_PGEN *, BITMAP * bmp);



/* --- menu --- */
int sn_menu(FONT *tf, char *title, FONT *stf, char *subtitle,
            unsigned int n_opt, FONT* of, char *options, int col1, int col2);



/* --- hiscore --- */

typedef struct
{
    char name[30];
    int score;
} SN_HISCORE;

typedef struct
{
    char filename[30];
    int size;
    SN_HISCORE *hiscores;
} SN_HISCORE_LIST;

SN_HISCORE_LIST *sn_create_hiscore_list(int size, char *filename);
void sn_destroy_hiscore_list(SN_HISCORE_LIST *hl);
void sn_reset_hiscore_list(SN_HISCORE_LIST *hl);
int sn_is_hiscore(SN_HISCORE_LIST *hl, int score);
void sn_insert_hiscore(SN_HISCORE_LIST *hl, char *name, int score);
void sn_load_hiscore_list(SN_HISCORE_LIST *hl);
void sn_save_hiscore_list(SN_HISCORE_LIST *hl);



/* --- collide --- */
int sn_collision(BITMAP *s1, int s1x, int s1y, BITMAP *s2, int s2x, int s2y);

#ifdef __cplusplus
}
#endif

#endif  // SNIPPET_H
