#include <allegro.h>
#include <string.h>
#include <time.h>
#include <stdlib.h>

#include "main.h"
#include "game.h"


int frames;
int fps;
BITMAP *page;

static volatile int ticks = 0;
static void
ticker ()
{
	ticks++;
}

static void
run_init ()
{
	game_init ();
}

void
run_end ()
{
	exit (0);
}

static void
run_frame ()
{
	game_frame ();
}

static void
run_render ()
{
	game_render ();

	//textprintf_right (page, font, SCREEN_W, 0,
	//						makecol (100, 100, 100), "%d fps", fps);
}

static int
scan_int_arg (int argc, char *argv[], const char *arg, int def)
{
	int i;

	for (i = 1; i < argc; i++)
	{
		if (!strcmp (argv[i], arg))
		{
			i++;
			if (i < argc)
			{
				return strtol (argv[i], NULL, 0);
			}
		}
	}
	return def;
}

int
main (int argc, char *argv[])
{
	BITMAP *vpage[3];
	int pagenum = 0;
	int cd;
	int w;
	int h;
	int vpages;
	int fs;
	int gframes;
	int framecounttime, framecounter;

	srand (time (NULL));
	
	allegro_init ();
	
	cd = desktop_color_depth ();
	w = 320;
	h = 240;
	vpages = 0;
	fs = 1;

	cd = scan_int_arg (argc, argv, "-c", cd);
	w = scan_int_arg (argc, argv, "-w", w);
	h = scan_int_arg (argc, argv, "-h", h);
	vpages = scan_int_arg (argc, argv, "-p", vpages);
	fs = scan_int_arg (argc, argv, "-f", fs);
	
	set_color_depth (cd);
	
	if (set_gfx_mode (fs ? GFX_AUTODETECT : GFX_AUTODETECT_WINDOWED, w, h, 0, 0) < 0)
	{
		allegro_message ("Cannot set graphics mode.\n");
		exit (-1);
	}

	install_keyboard ();

	install_mouse ();

	install_timer ();

	install_int_ex (ticker, BPS_TO_TIMER (FPS));

	install_sound (DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);
	set_volume (255, 32);

	if (vpages == 0)
	{
		vpage[0] = create_bitmap (SCREEN_W, SCREEN_H);
		pagenum = 0;
	}
	if (vpages == 1)
	{
		vpage[0] = screen;
		pagenum = 0;
	}
	if (vpages == 2)
	{
		vpage[0] = create_video_bitmap (SCREEN_W, SCREEN_H);
		if (vpage[0])
		{
			vpage[1] = create_video_bitmap (SCREEN_W, SCREEN_H);
			pagenum = 1;
		}
	}
	if (vpages == 3)
	{
		vpage[0] = create_video_bitmap (SCREEN_W, SCREEN_H);
		vpage[1] = create_video_bitmap (SCREEN_W, SCREEN_H);
		vpage[2] = create_video_bitmap (SCREEN_W, SCREEN_H);
		pagenum = 2;
	}
	
	page = vpage[pagenum];
	
	{
		int i;
		for (i = 0; i <= pagenum; i++)
		{
			if (!vpage[i])
			{
				allegro_message ("Cannot allocate video buffers.\n");
				exit (-1);
			}
		}
	}

	run_init ();

	framecounter = 0;
	framecounttime = ticks;
	gframes = ticks;
	frames = ticks;
	while (1)
	{

		while (frames <= ticks)
		{
			run_frame ();
			frames++;
		}
		if (gframes < frames)
		{
			run_render ();

			if (vpages == 0)
			{
				blit (page, screen, 0, 0, 0, 0, page->w, page->h);
			}
			if (vpages == 2)
			{
				show_video_bitmap (page);
				pagenum++;
				if (pagenum == vpages)
					pagenum = 0;
				page = vpage[pagenum];
			}
			if (vpages == 3)
			{
				while (poll_scroll ());	/* in case not done with previous flip */
				request_video_bitmap (page);
				pagenum++;
				if (pagenum == vpages)
					pagenum = 0;
				page = vpage[pagenum];
			}

			gframes = frames;
			framecounter++;

			if (ticks - framecounttime >= FPS)
			{
				fps = framecounter;
				framecounter = 0;
				framecounttime = ticks;
			}

		}

	}
	run_end ();
	return -1;
}

END_OF_MAIN ();
