#include <stdio.h>

#include "main.h"
#include "game.h"

#include "data.h"
#include "snippets.h"

DATAFILE *dat;

typedef struct THING THING;
	
struct THING
{
	int type;
	int x, y;
	int dir;
	int jump;
	int step;
};

THING thing[1000];
int thing_count = 1;

int mx = 0, my = 0;
int prev_lmb = 0;
int prev_rmb = 0;
int selected_thing = 0;
int selected_x, selected_y;
int selected_type = B_FURRY_STILL;
int player = 1;
int mode = 0;
int scroll_x = 0, scroll_y = 0;
BITMAP * cursor = NULL;
SN_PGEN * particles = NULL;
int game_over = 0;
int got_key = 0;
int got_gem = 0;
int idle_time = 0;
int win = 0;

static void
thing_show (int t)
{
	BITMAP *sprite;
	int s = thing[t].step;
	int x,y;
	if (s == -1)
		s = 0;
	else
		s = 1 + s / 4;
	sprite = (BITMAP *)(dat[thing[t].type + s].dat);
	x = thing[t].x - scroll_x;
	y = thing[t].y - scroll_y;
	(thing[t].dir ? draw_sprite_h_flip : draw_sprite) (page, sprite, x, y);
}

static int
thing_collide (int t, int i)
{
	for (; i < thing_count; i++)
	{
		if (i == t)
			continue;
		if (sn_collision ((BITMAP *)(dat[thing[t].type].dat), thing[t].x, thing[t].y,
			(BITMAP *)(dat[thing[i].type].dat),	thing[i].x, thing[i].y))
		{
			return i;
		}
	}
	return 0;
}

static void
things_save (void)
{
	int i;
	PACKFILE *file = pack_fopen ("level.dat", "w");
	pack_iputl (thing_count, file);
	for (i = 1; i < thing_count; i++)
	{
		pack_iputl (6, file);
		pack_iputl (thing[i].type, file);
		pack_iputl (thing[i].x, file);
		pack_iputl (thing[i].y, file);
		pack_iputl (thing[i].dir, file);
		pack_iputl (thing[i].jump, file);
		pack_iputl (thing[i].step, file);
	}
	pack_fclose (file);
}

static void
things_load (void)
{
	int i;
	PACKFILE *file = pack_fopen ("level.dat", "r");
	thing_count = pack_igetl (file);
	for (i = 1; i < thing_count; i++)
	{
		pack_igetl (file);
		thing[i].type = pack_igetl (file);
		thing[i].x = pack_igetl (file);
		thing[i].y = pack_igetl (file);
		thing[i].dir = pack_igetl (file);
		thing[i].jump = pack_igetl (file);
		thing[i].step = pack_igetl (file);
	}
	pack_fclose (file);
}

void
game_init (void)
{
	int i;
	packfile_password("fruitpunch");
	dat = load_datafile ("data.dat");
	packfile_password(NULL);
	
	play_midi (dat[M_TRACK_4].dat, 1);
	
	i = sn_menu(dat[F_MEDIUM_0].dat, "BlitzHack", dat[F_MEDIUM_0].dat, "by networm", 2,
		dat[F_MEDIUM_0].dat, "Start\0Quit", makecol (100, 0, 0), makecol (255, 255, 0));

	if (i == 1)
		run_end ();
	
	cursor = create_bitmap (10, 10);
	clear_to_color (cursor, bitmap_mask_color (cursor));
	line (cursor, 0, 0, 9, 9, makecol (0, 255, 0));
	
	particles = sn_create_pgen();

	sn_init_pgen(particles, 0, 200, 2);
	
	things_load ();

	play_midi (dat[M_TRACK_2].dat, 1);
}

void
game_frame (void)
{
	int lmb = mouse_b & 1;
	int lmbdown = 0, lmbhit = 0, lmbrel = 0;
	int rmb = mouse_b & 2;
	int rmbdown = 0, rmbhit = 0, rmbrel = 0;
	
	if (lmb && (!prev_lmb))
		lmbhit = 1;
	if ((!lmb) && prev_lmb)
		lmbrel = 1;
	if (lmb && prev_lmb)
		lmbdown = 1;
	
	prev_lmb = lmb;
	
	if (rmb && (!prev_rmb))
		rmbhit = 1;
	if ((!rmb) && prev_rmb)
		rmbrel = 1;
	if (rmb && prev_rmb)
		rmbdown = 1;
	
	prev_lmb = lmb;
	
	mx = mouse_x;
	my = mouse_y;
		
	while (keypressed ())
	{
		int k = readkey ();

		k >>= 8;
		if (k == KEY_ESC)
			run_end ();
		
		if (k == KEY_G)
		{
			//mode = !mode;
		}
		
		if (mode == 1)
		{
			if (k == KEY_INSERT)
			{
				selected_thing = thing_count;
				thing[selected_thing].type = selected_type;
				thing[selected_thing].x = scroll_x + mx;
				thing[selected_thing].y = scroll_y + my;
				thing[selected_thing].dir = 0;
				thing[selected_thing].jump = 0;
				thing[selected_thing].step = -1;
				thing_count++;

				position_mouse (mouse_x + ((BITMAP *)(dat[selected_type].dat))->w, mouse_y);
			}
			
			if (k == KEY_PGDN)
			{
				selected_type++;
			}
			
			if (k == KEY_PGUP)
			{
				selected_type--;
			}
						
			if (k == KEY_F2)
			{
				things_save ();
			}
			
			if (k == KEY_F3)
			{
				things_load ();
			}
			
			if (k == KEY_LEFT)
			{
				scroll_x -= 50;
			}
			if (k == KEY_RIGHT)
			{
				scroll_x += 50;
			}
			if (k == KEY_UP)
			{
				scroll_y -= 50;
			}
			if (k == KEY_DOWN)
			{
				scroll_y += 50;
			}
		}
	}
		
	if (mode == 0)
	{
		int coll;
		int ground = 0;
		int kx = 0, ky = 0;
		if (key[KEY_LEFT])
			kx = -1;
		if (key[KEY_RIGHT])
			kx = 1;
		if (key[KEY_UP])
			ky = -1;
		if (key[KEY_DOWN])
			ky = 1;
		
		if (game_over || win)
		{
			if (kx || ky)
			{
				if (game_over > 30 || win > 70)
				{
					things_load ();
					game_over = 0;
					play_midi (dat[M_TRACK_2].dat, 1);
				}
			}
			return;
		}
				
		if (kx > 0)
		{
			thing[player].dir = 0;
			thing[player].step++;
			idle_time = 0;
		}
		if (kx < 0)
		{
			thing[player].dir = 1;
			thing[player].step++;
			idle_time = 0;
		}
		
		thing[player].step &= 31;
		
		if (kx == 0 && ky == 0)
		{
			thing[player].step = -1;
			idle_time++;
		}
		
		if (thing[player].jump)
		{
			thing[player].step = 10;
			thing[player].y --;
			thing[player].jump ++;
			if (thing_collide (player, 2))
			{
				thing[player].y ++;
				thing[player].jump = 0;
			}
			if (ky >= 0)
				thing[player].jump = 0;
			if (thing[player].jump > 40)
				thing[player].jump = 0;
		}
		else
		{
			thing[player].y ++;
		
			coll = thing_collide (player, 2);
			if (coll)
			{
				thing[player].y --;
				ground = 1;
				
				if (thing[coll].type == B_TURTLE_0)
				{
					thing[coll].type = B_ORB_0;
					thing[coll].y += 20;
					thing[coll].step = -1;
					play_sample (dat[S_CARTOON_3].dat, 255, 128, 1000, 0);
				}
				if (thing[coll].type == B_GEM)
				{
					thing[coll].type = B_ORB_1;
					thing[coll].y += 20;
					thing[coll].step = -1;
					play_sample (dat[S_CARTOON_6].dat, 255, 128, 1000, 0);
					got_gem = 1;
				}
				if (thing[coll].type == B_KEY_0)
				{
					thing[coll].type = B_ORB_2;
					thing[coll].x -= 30;
					thing[coll].step = -1;
					play_sample (dat[S_CARTOON_6].dat, 255, 128, 1000, 0);
					got_key = 1;
				}
				if (thing[coll].type == B_BEE_1 && got_key && got_gem)
				{
					win = 1;
				}
			}
			
			if (ky < 0)
			{
				idle_time = 0;
				if (ground)
				{
					thing[player].jump = 1;
					play_sample (dat[S_CARTOON_2].dat, 255, 128, 1000, 0);
				}
			}
			
			if (thing[player].y > 500)
			{
				game_over = 1;
				play_sample (dat[S_GRENADE].dat, 255, 128, 1000, 0);
				play_midi (dat[M_TRACK_3].dat, 1);
			}
		}
		
		sn_fire_pgen(particles, thing[player].x - scroll_x + 20 - thing[player].dir * 10, thing[player].y - scroll_y + 20, SN_PGEN_ISO3D, 1);

		thing[player].x += kx;
		
		coll = thing_collide (player, 2);
		if (coll)
		{
			thing[player].x -= kx;
		}
		
		if (thing[player].x - scroll_x < 100)
			scroll_x = thing[player].x - 100;
		
		if (thing[player].y - scroll_y < 100)
			scroll_y = thing[player].y - 100;
		
		if (thing[player].x - scroll_x > 320 - 100 - 20)
			scroll_x = thing[player].x + 100 + 20 - 320;
		
		if (thing[player].y - scroll_y > 240 - 100 - 20)
			scroll_y = thing[player].y + 100 + 20 - 240;
		
		{
			int i;
			for (i = 2; i < thing_count; i++)
			{
				if (thing[i].type == B_TURTLE_0)
				{
					if (thing[i].dir)
						thing[i].x--;
					else
						thing[i].x++;
					
					thing[i].step++;
					thing[i].step &= 7;
				
					if ((coll = thing_collide (i, 1)))
					{
						if (coll == player)
						{
							game_over = 1;
							play_sample (dat[S_GRENADE].dat, 255, 128, 1000, 0);
							play_midi (dat[M_TRACK_3].dat, 1);
						}
						thing[i].dir = !thing[i].dir;
					}
				}
			}
		}
	}
	
	if (lmbhit || rmbhit)
	{
		int i;
		selected_thing = 0;
		for (i = 1; i < thing_count; i++)
		{
			if (sn_collision (cursor, scroll_x + mx, scroll_y + my, (BITMAP *)(dat[thing[i].type].dat),
				thing[i].x, thing[i].y))
			{
				selected_thing = i;
				if (lmb)
				{
					selected_x = scroll_x + mx - thing[i].x;
					selected_y = scroll_y + my - thing[i].y;
				}
				else
				{
					selected_type = thing[i].type;
				}
			}
		}
	}
	if (lmbdown)
	{
		if (selected_thing)
		{
			thing[selected_thing].x = scroll_x + mx - selected_x;
			thing[selected_thing].y = scroll_y + my - selected_y;
		}
	}
}

void
game_render (void)
{
	int i;
	clear (page);
	
	for (i = 1; i < thing_count; i++)
		thing_show (i);

	sn_display_pgen (particles, page);
	
	if (mode == 1)
	{
		BITMAP *b = (BITMAP *)(dat[selected_type].dat);
		masked_blit (b, page, 0, 0, 0, 0, b->w, b->h);
		
		masked_blit (cursor, page, 0, 0, mx, my, cursor->w, cursor->h);
	}
	
	text_mode (-1);
	
	if (game_over)
	{
		game_over++;
		textprintf_centre (page, dat[F_HUGE_1].dat, 160, 60, makecol (255, 0, 0), "GAME");
		textprintf_centre (page, dat[F_HUGE_1].dat, 160, 120, makecol (255, 0, 0), "OVER");
		
		textprintf (page, dat[F_SMALL_2].dat, 3, SCREEN_H - 20, makecol (255, 0, 0), "Press key to restart.");
	}
	
	if (win)
	{
		win++;
		textprintf_centre (page, dat[F_HUGE_1].dat, 160, 60, makecol (255, 255, 0), "YOU");
		textprintf_centre (page, dat[F_HUGE_1].dat, 160, 120, makecol (255, 255, 0), "WIN!");
		
		textprintf (page, dat[F_SMALL_2].dat, 3, SCREEN_H - 20, makecol (255, 255, 0), "That's all! Press key to restart.");
	}
	
	if (idle_time > 70 && !game_over && !win)
	{
		if (!got_gem)
			textprintf (page, dat[F_SMALL_2].dat, 3, SCREEN_H - 20, makecol (255, 255, 0), "Find the Red Gem!");
		if (!got_key)
			textprintf (page, dat[F_SMALL_2].dat, 3, SCREEN_H - 40, makecol (255, 255, 0), "Find the key to your spaceship!");
		if (got_gem && got_key)
			textprintf (page, dat[F_SMALL_2].dat, 3, SCREEN_H - 60, makecol (255, 255, 0), "Leave Dex and return to King Sakkar!");
	}
}
