/* Implementation of d_grid_proc() function
   Copyright (c) Michal Molhanec, 2001, see grid.h for details */
#include <stdlib.h>
#include <allegro.h>
#include "grid.h"

struct grid_data* create_grid_data(const int w, const int h, BITMAP* bdefault) {
	struct grid_data* gd = malloc( sizeof(struct grid_data) );
	int i, j;
	
	gd->w = w;
	gd->h = h;
	gd->x = 0;
	gd->y = h - 25 > 0 ? h - 25 : 0;
	gd->granularity = 25;
	gd->pics = malloc( h*sizeof(BITMAP**) );
	gd->type = malloc( h*sizeof(int*) );
	for (i = 0; i < h; i++) {
		gd->pics[i] = malloc( w*sizeof(BITMAP*) );
		gd->type[i] = malloc( w*sizeof(int) );
		for (j = 0; j < w; j++) {
			gd->pics[i][j] = bdefault;
			gd->type[i][j] = 0;
		}
	}

	return gd;
}

void destroy_grid_data(struct grid_data* gd) {
	int i;
	if (gd) {
		for (i = 0; i < gd->h; i++)
			free( gd->pics[i] );
		free(gd->pics);
		free(gd);
	}
}

int d_grid_proc(int msg, DIALOG *d, int c) {
	struct grid_data* gd = (struct grid_data*) d->dp;
	int cell_width = d->w / (gd->w < gd->granularity ? gd->w : gd->granularity);
	int cell_height = d->h / (gd->h < gd->granularity ? gd->h : gd->granularity);
	int i;
   int x, y;
	char txt[5];

	if (gd->x+gd->granularity > gd->w) gd->x = gd->w - gd->granularity > 0 ? gd->w - gd->granularity : 0;
	if (gd->y+gd->granularity > gd->h) gd->y = gd->h - gd->granularity > 0 ? gd->h - gd->granularity : 0;
	switch (msg) {
	
      case MSG_DRAW:
      {
         int lastw = cell_width * (gd->w < gd->granularity ? gd->w : gd->granularity) + d->x;
         int lasth = cell_height * (gd->h < gd->granularity ? gd->h : gd->granularity) + d->y;
         for (y = gd->y; y < (gd->h < gd->y + gd->granularity ? gd->h : gd->y + gd->granularity); y++)
	         for (x = gd->x; x < (gd->w < gd->x + gd->granularity ? gd->w : gd->x + gd->granularity); x++)
					if	(gd->pics[y][x]) {
						stretch_blit(gd->pics[y][x], screen, 0, 0,
							gd->pics[y][x]->w, gd->pics[y][x]->h,
							d->x + cell_width * (x-gd->x) + 1,
							d->y + cell_height * (y-gd->y) + 1,
							cell_width-2, cell_height-2);
						itoa(gd->type[y][x], txt, 10);
						textout(screen, font, txt, d->x + cell_width * (x-gd->x) + 1, d->y + cell_height * (y-gd->y) + 1, makecol(255,255,255));
					}
         for (i = 0; i <= (gd->w < gd->granularity ? gd->w : gd->granularity); i++)
            vline(screen, d->x + cell_width * i, d->y, lasth, d->fg);
         for (i = 0; i <= (gd->h < gd->granularity ? gd->h : gd->granularity); i++)
            hline(screen, d->x, d->y + cell_height * i, lastw, d->fg);
      	break;
		}
		
      case MSG_CLICK:
      {
         x = (gui_mouse_x() - d->x) / cell_width + gd->x;
         y = (gui_mouse_y() - d->y) / cell_height + gd->y;
			if (d->dp2) return ((int(*)(int,int,DIALOG*))(d->dp2))(x, y, d);
			break;
		}
	}
   return D_O_K;
}

