/*
   d_grid_proc() function header file

   Copyright (c) Michal Molhanec, 2001
   molsoft@centrum.cz or mol@raz-dva.cz

	Public domain - no restrictions, no responsibility

	If you find a bug or if you make some improvement please email it
	to me I'll publish it on my WWW pages.
*/

#ifndef __GRID_H__
#define __GRID_H__

#ifdef __cplusplus
   extern "C" {
#endif

struct grid_data {
	int w;	/* No. of cells */
	int h;
	BITMAP*** pics;	/* array of array of pointers to BITMAP :-) */
	int** type;
	int x,y;
	int granularity;	// max. visible number of cells
};

int d_grid_proc(int msg, DIALOG *d, int c);

struct grid_data* create_grid_data(const int w, const int h, BITMAP* bdefault);
void destroy_grid_data(struct grid_data* gd);

#ifdef __cplusplus
	}
#endif

#endif
