#include <algorithm>
#include <fstream>
#include <string>
#include <vector>
using namespace std;
#include <stdlib.h>

#include <allegro.h>
#include "grid.h"

vector<BITMAP*> textures;
vector<BITMAP*> textures_with_flag;
vector<char> types;
vector<string> tex_names;	// textures names for saving
int selected = 0;
void load_texture(const char* filename);
DIALOG* dlg;
BITMAP* no_tex;
BITMAP* no_tex_with_flag;
int last_clicked_x = 0;
int last_clicked_y = 0;

int grid_clicked( int wherex, int wherey, DIALOG* d ) {
	if (gui_mouse_b() & 1) {	// left mouse button
		grid_data* gd = (grid_data*)d->dp;
		gd->pics[wherey][wherex] = textures[selected];
	} else if (gui_mouse_b() & 2) {	// right mouse button
		grid_data* gd = (grid_data*)d->dp;
		gd->pics[wherey][wherex] = textures_with_flag[selected];
	} else {
		grid_data* gd = (grid_data*)d->dp;
		(gd->type[wherey][wherex])++;
		if (gd->type[wherey][wherex] > 2) gd->type[wherey][wherex] = 0;
	}
	return D_REDRAWME;
}

// texture selector button
int d_tex_proc(int msg, DIALOG *d, int c) {
	if (msg==MSG_CLICK) {
		d_icon_proc(msg, d, c);	// draw button in down-state

		char path[255] =  "./data/*.t";
		int i = file_select("Select texture", path, "t");
		if (i) load_texture(path);

		d->flags &= ~D_SELECTED;	// deselect button
      return D_REDRAW;			// redraw icon button
	}
	return d_icon_proc(msg, d, c);
}

int d_left_proc(int msg, DIALOG *d, int c) {
	if (msg==MSG_CLICK) {
		while (gui_mouse_b() & 1) ;
		d_button_proc(msg, d, c);	// draw button in down-state
		selected--;
		if (selected < 0) selected = textures.size()-1;
		dlg[3].dp = textures[selected];
		static_cast<char*>(dlg[6].dp)[0] = types[selected];
		d->flags &= ~D_SELECTED;	// deselect button
      return D_REDRAW;			// redraw button
	}
	return d_button_proc(msg, d, c);
}

int d_right_proc(int msg, DIALOG *d, int c) {
	if (msg==MSG_CLICK) {
		while (gui_mouse_b() & 1) ;
		d_button_proc(msg, d, c);	// draw button in down-state
		selected++;
		if (selected >= textures.size()) selected = 0;
		dlg[3].dp = textures[selected];
		static_cast<char*>(dlg[6].dp)[0] = types[selected];
		d->flags &= ~D_SELECTED;	// deselect button
      return D_REDRAW;			// redraw button
	}
	return d_button_proc(msg, d, c);
}


int d_fill_proc(int msg, DIALOG *d, int c) {
	if (msg==MSG_CLICK) {
		while (gui_mouse_b() & 1) ;
		d_button_proc(msg, d, c);	// draw button in down-state

					grid_data* gd = (grid_data*)dlg[2].dp;
//					(grid_data*)dlg[2].dp = gd;
					for (int i=0; i<gd->h; i++)
					  	for (int j=0; j<gd->w; j++) {
							if (gd->pics[i][j] == textures[0]) {
				  				gd->pics[i][j] = textures[selected];
							}
						}
		
		d->flags &= ~D_SELECTED;	// deselect button
      return D_REDRAW;			// redraw button
	}
	return d_button_proc(msg, d, c);
}

int d_type_proc(int msg, DIALOG *d, int c) {
	return d_edit_proc(msg, d, c);
}

int d_lastx_proc(int msg, DIALOG *d, int c) {
	return d_edit_proc(msg, d, c);
}

int d_lasty_proc(int msg, DIALOG *d, int c) {
	return d_edit_proc(msg, d, c);
}

int d_load_proc(int msg, DIALOG *d, int c) {
	if (msg==MSG_CLICK) {
		d_button_proc(msg, d, c);	// draw button in down-state

		char path[255] =  "./data/*.w";
		int i = file_select("Select world", path, "w");
		if (i) {
			ifstream fin(path);
			if (fin) {
				int ver;
				fin >> ver;
				int ntex;
				if (fin >> ntex) {
					textures.resize(1);	// leave only "no-texture" texture :-)
					textures_with_flag.resize(1);
					types.resize(1);
					tex_names.resize(1);
					selected=0;
					for (int j=0; j<ntex; j++) {
						string tex_filename;
				   	fin >> tex_filename;
						load_texture((string("./data/")+tex_filename).c_str());
					}
				}
				int w,h;
				if (fin >> w &&  fin >> h) {
					grid_data* gd = (grid_data*)dlg[2].dp;
					destroy_grid_data(gd);
					gd = create_grid_data(w, h, no_tex);
					/*(grid_data*)*/dlg[2].dp = (void*)gd;
					for (int i=h-1; i>=0; i--)
					  	for (int j=0; j<w; j++) {
							int k;
							if (fin >> k) {
								if (k>=0 && k<textures.size()) {
					  				gd->pics[i][j] = textures[k];
								}
							}
							if (ver > 1) {
								int bythesee;
								if (fin >> bythesee) {
									gd->type[i][j] = bythesee;
								}
							}
						}
					if (fin >> i) {
						for (int j=0; j<i; j++) {
							int x; int y;
							fin >> x >> y;
							vector<BITMAP*>::iterator q = find(textures.begin(), textures.end(), gd->pics[y][x]);
							if (q != textures.end()) gd->pics[y][x] = textures_with_flag[q-textures.begin()];
						}
					}
				}
			}
		}

		d->flags &= ~D_SELECTED;	// deselect button
      return D_REDRAW;			// redraw icon button
	}
	return d_button_proc(msg, d, c);
}

int d_save_proc(int msg, DIALOG *d, int c) {
	if (msg==MSG_CLICK) {
		d_button_proc(msg, d, c);	// draw button in down-state

		char path[255] =  "./data/*.w";
		int i = file_select("Select world", path, "w");
		if (i) {
			if (!exists(path) ||
				alert("File exists!", "", "OVERWRITE?", "Yes", "No", 0, 0)==1) {
				ofstream fout(path);
				if (fout) {
					fout << 2 << endl;	// we're using version 2
					fout << textures.size() - 1 << "\n";
					for (int j=1; j<textures.size(); j++) {
						fout << get_filename(tex_names[j].c_str()) << "\n";
					}
					grid_data* gd = static_cast<grid_data*>(dlg[2].dp);
					fout << gd->w << "\t" << gd->h << "\n";
					vector<int> x_flags;
					vector<int> y_flags;
					for (int i=gd->h-1; i>=0; i--) {
						for (int j=0; j<gd->w; j++) {
							vector<BITMAP*>::iterator q = find(textures.begin(), textures.end(), gd->pics[i][j]);
							if (q != textures.end()) {
								fout << q-textures.begin() << "\t";
								fout << gd->type[i][j] << "\t";
							} else {
								vector<BITMAP*>::iterator qq = find(textures_with_flag.begin(), textures_with_flag.end(), gd->pics[i][j]);
								if (qq != textures_with_flag.end()) {
									fout << qq-textures_with_flag.begin() << "\t";
									fout << gd->type[i][j] << "\t";
									x_flags.push_back(j);
									y_flags.push_back(i);
								}
							}
						}
						fout << "\n";
					}
					fout << x_flags.size() << "\n";
					for (int abcdef = 0; abcdef < x_flags.size(); abcdef++) {
						fout << x_flags[abcdef] << "\t" << y_flags[abcdef] << "\n";
					}
				}
			}
		}

		d->flags &= ~D_SELECTED;	// deselect button
      return D_REDRAW;			// redraw icon button
	}
	return d_button_proc(msg, d, c);
}

int lb;	//light blue
int db;	//dark blue
char tokb[] = "OK";
char tcnb[] = "Cancel";
static DIALOG d_sizes[] = {
	/* proc,        x,   y,   w,   h,   fg, bg, key, flags, d1, d2, *dp,  *dp2,			*dp3 */
	{ d_button_proc,0,  60,   80,  20,  0,  0,   0,   D_EXIT,0,  0,  tokb, 0,            NULL },
	{ d_edit_proc,  0,   0,   80,  20,  0,  0,   0,   0,     3,  0,  0,    0,            NULL },
	{ d_edit_proc,  0,  30,   80,  20,  0,  0,   0,   0,     3,  0,  0,    0,            NULL },
	{ d_button_proc,0,  90,   80,  20,  0,  0,   0,   D_EXIT,0,  0,  tcnb, 0,            NULL },
   { NULL,         0,   0,   0,   0,   0,  0,   0,   0,     0,  0,  NULL, NULL,         NULL }
};

int d_sizes_proc(int msg, DIALOG *d, int c) {
	if (msg==MSG_CLICK) {
		d_button_proc(msg, d, c);	// draw button in down-state

		d_sizes[0].fg = lb;
		d_sizes[1].fg = lb;
		d_sizes[2].fg = lb;
		d_sizes[3].fg = lb;
		d_sizes[0].bg = db;
		d_sizes[1].bg = db;
		d_sizes[2].bg = db;
		d_sizes[3].bg = db;

		grid_data* gd = static_cast<grid_data*>(dlg[2].dp);
		char str1[33], str2[33];
		itoa(gd->w, str1, 10);
		itoa(gd->h, str2, 10);
		d_sizes[1].dp = str1;
		d_sizes[2].dp = str2;
		int i = do_dialog(d_sizes, -1);
		if (i==0) {
			int neww = atoi((char*)(d_sizes[1].dp));
			int newh = atoi((char*)(d_sizes[2].dp));
			if (neww>0 && newh>0) {
				grid_data* newgd = create_grid_data(neww, newh, no_tex);
				grid_data* oldgd = static_cast<grid_data*>(dlg[2].dp);
				int w = oldgd->w;
				int h = oldgd->h;
				for (int i=0; i<(h<newh?h:newh); i++)
					for (int j=0; j<(w<neww?w:neww); j++)
						newgd->pics[i][j] = oldgd->pics[i][j];
				dlg[2].dp = (void*)newgd;
				destroy_grid_data(oldgd);
			}
		}

		d->flags &= ~D_SELECTED;	// deselect button
      return D_REDRAW;			// redraw icon button
	}
	return d_button_proc(msg, d, c);
}

int scroll_horiz(void*, int d2) {
	grid_data* gd = static_cast<grid_data*>(dlg[2].dp);
	gd->x = d2 * (gd->w- (gd->w < gd->granularity ? gd->w : gd->granularity) ) / 100;
	return D_REDRAW;
}

int scroll_vert(void*, int d2) {
	grid_data* gd = static_cast<grid_data*>(dlg[2].dp);
	gd->y = (100-d2) * (gd->h- (gd->h < gd->granularity ? gd->h : gd->granularity)) / 100;
	return D_REDRAW;
}

int minus() {
	grid_data* gd = static_cast<grid_data*>(dlg[2].dp);
	if (gd->granularity < gd->w-1) gd->granularity++;
	return D_REDRAW;
}

int plus() {
	grid_data* gd = static_cast<grid_data*>(dlg[2].dp);
	if (gd->granularity > 1) gd->granularity--;
	return D_REDRAW;
}

char t[] = "E&xit";
char tl[] = "&<";
char tr[] = "&>";
char tt[] = "0";
char tlx[] = "0";
char tly[] = "0";
char tld[] = "&Load";
char tsv[] = "&Save";
char tsz[] = "Sizes";
char tf[] = "Fill";
static DIALOG d[] = {
	/* proc,        x,   y,   w,   h,   fg, bg, key, flags, d1, d2, *dp,  *dp2,			*dp3 */
   { d_clear_proc, 0,   0,   640, 480, lb, db,  0,   0,     0,  0,  NULL, NULL,         NULL },
   { d_button_proc,550, 440, 80,  20,  lb, db,KEY_K<<8,D_EXIT,0,0,  (void*)t,    NULL,         NULL },
   { d_grid_proc,  0,   20,  520, 450, lb, db,  0,   0,     0,  0,  NULL, (void*)grid_clicked, NULL },
	{ d_tex_proc,   550, 20,  64,  64,  lb, db,  0,   0,     0,  0,  NULL, NULL,         NULL },
	{ d_left_proc,  534, 20,  16,  64,  lb, db,KEY_L<<8, 0,  0,  0,  (void*)tl,   NULL,			 NULL },
	{ d_right_proc, 614, 20,  16,  64,  lb, db,KEY_R<<8, 0,  0,  0,  (void*)tr,   NULL,			 NULL },
	{ d_type_proc,  550, 90,  80,  20,  lb, db,KEY_T<<8, 0,  1,  0,  (void*)tt,   NULL,         NULL },
	{ d_load_proc,  550, 380, 80,  20,  lb, db,  0,   0,     0,  0,  (void*)tld,  NULL,         NULL },
	{ d_save_proc,  550, 410, 80,  20,  lb, db,  0,   0,     0,  0,  (void*)tsv,  NULL,         NULL },
	{ d_sizes_proc, 550, 350, 80,  20,  lb, db,  0,   0,     0,  0,  (void*)tsz,  NULL,			 NULL },
	{ d_fill_proc,  550, 320, 80,  20,  lb, db,  0,   0,     0,  0,  (void*)tf,   NULL,         NULL },
	{ d_lastx_proc, 550, 110, 80,  10,  lb, db,  0,   0,     0,  0,  (void*)tlx,  NULL,         NULL },
	{ d_lasty_proc, 550, 130, 80,  10,  lb, db,  0,   0,     0,  0,  (void*)tly,  NULL,         NULL },
	{ d_slider_proc,0,	0,   520, 14,  lb, db,  0,   0,   100,  0,  NULL, (void*)scroll_horiz, NULL },
	{ d_slider_proc,521,	20,  14,  450, lb, db,  0,   0,   100,  0,  NULL, (void*)scroll_vert,  NULL },
	{ d_keyboard_proc,0, 0,   0,   0,   0,  0,   '+', 0,		0,  0,  (void*)plus, NULL,			 NULL },
	{ d_keyboard_proc,0, 0,   0,   0,   0,  0,   '-', 0,		0,  0,  (void*)minus,NULL,			 NULL },
   { NULL,         0,   0,   0,   0,   0,  0,   0,   0,     0,  0,  NULL, NULL,         NULL }
};

//template<typename T, int size>
//inline int arraysize(T (&Dummy)[size]) { return size; }
int arraysize(DIALOG[]) { return 18; }

void load_texture(const char* filename) {
	ifstream fin(filename);
	if (fin) {
		string bmp_filename;
		fin >> bmp_filename;
//		alert("BMP filename:", (string("./data/")+bmp_filename).c_str(), 0, "OK", 0, 0, 0);
		BITMAP* b = load_bitmap((string("./data/")+bmp_filename).c_str(), 0);
		if (b) {
			char c;
			fin >> c;
			if (fin) {
				textures.push_back(b);
				selected++;
				d[3].dp = textures[selected];
				types.push_back(c);
				static_cast<char*>(d[6].dp)[0] = c;
				tex_names.push_back(filename);

				BITMAP* b_with_flag = create_bitmap(b->w, b->h);
				blit(b, b_with_flag, 0, 0, 0, 0, b->w, b->h);
//				textout(b_with_flag, font, "***", 0, 0, makecol(255, 255, 0));
				circlefill(b_with_flag, b->w/2, b->h/2, b->w<b->h?b->w/2-1:b->h/2-1, makecol(255,255,0));
				textures_with_flag.push_back(b_with_flag);
			}
		}
	}
}

int main()
{
	struct grid_data* gd;
	
	allegro_init();
	install_timer();
 	install_keyboard();
 	install_mouse();
	set_color_depth(16);
	set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0);

	lb = makecol(0,0,255);	// light blue
	db = makecol(0,0,127);	// dark blue
	for (int i=0; i<arraysize(d); i++) {
		d[i].fg = lb;
		d[i].bg = db;
	}

   no_tex = create_bitmap(64, 64);
	clear_bitmap(no_tex);
	textout(no_tex, font, "No Texture", 0, 30, makecol(128, 128, 128));
	textures.push_back(no_tex);
	types.push_back('0');
	tex_names.push_back("no name");
	no_tex_with_flag = create_bitmap(64, 64);
	blit(no_tex, no_tex_with_flag, 0, 0, 0, 0, 64, 64);
//	textout(no_tex_with_flag, font, "***", 0, 0, makecol(255, 255, 0));
	circlefill(no_tex_with_flag, 31, 31, 30, makecol(255,255,0));
	textures_with_flag.push_back(no_tex_with_flag);
	
	d[3].dp = no_tex;
	
	gd = create_grid_data(20, 20, no_tex); /* 20x20 cells */
	d[2].dp = gd;

	dlg = d;

	do_dialog(d, -1);

	return 0;
}
END_OF_MAIN();
