/*
	Becherovka game 2001 (c) Michal Molhanec

	world.cpp - World manipulation functions
*/
#include <fstream>
using std::ifstream;

#include <string>
using std::string;

#include <vector>
using std::vector;

#include "common.h"
#include "basic.h"
#include "running.h"

//GLuint world;


void basic_game::load_world( const char* filename )
{
	int i, j, verze;
	string s;
/*	vector<Tex> textury;
	int pocet_textur;
	vector<vector<int> > w;
	int sirka, vyska;*/

	last_filename = filename;

//	vector<Tex> textury;
	if (textury.size() > 0) {
		for (i=textury.size()-1; i>=0; i--) glDeleteTextures(1, &textury[i].tex);
		textury.resize(0);
	}
//	vector<vector<int> > w;
	w.resize(0);
//	GLuint player_tex;
	if (player_tex > -1) {
		glDeleteTextures(1, &player_tex);
		player_tex = -1;
	}
//	GLuint pozadi_tex;
	if (pozadi_tex > -1) {
		glDeleteTextures(1, &player_tex);
		pozadi_tex = -1;
	}
//	GLuint hrac_vpravo[10];
	for (i=0; i<10; i++) {
		glDeleteTextures(1, &hrac_vpravo[i]);
		hrac_vpravo[i] = -1;
	}
//	GLuint hrac_vlevo[10];
	for (i=0; i<10; i++) {
		glDeleteTextures(1, &hrac_vlevo[i]);
		hrac_vlevo[i] = -1;
	}
//	vector<Zradlo> zradla;
	if (zradla.size() > 0) {
//		for (i=zradla.size()-1; i>=0; i--) glDeleteTextures(1, zradla[i].
		zradla.resize(0);
	}
//	vector<GLuint> pictures;
	if (pictures.size() > 0) {
		for (i=pictures.size()-1; i>=0; i--) glDeleteTextures(1, &pictures[i]);
		pictures.resize(0);
	}
//	list<sprite*> sprity;
	sprity.resize(0);

	ifstream fin( (string("./data/")+filename+".w").c_str() );
	if (!fin) ERR(msg[FILENOTFOUND], filename);
	fin >> verze;
	if (verze != 2) ERR("Need version 2 of world file!", "");
	fin >> pocet_textur;
	textury.resize(pocet_textur);

	allegro_gl_begin();
	//glDisable (GL_DITHER);
	glEnable (GL_TEXTURE_2D);
	//glTexEnvi (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);
	//glHint (GL_PERSPECTIVE_CORRECTION_HINT, GL_FASTEST);
	allegro_gl_use_mipmapping(TRUE);

	for (i=0; i < pocet_textur; i++) {
		fin >> s;
		ifstream ftex((string("./data/")+s).c_str());
		if (!ftex) ERR(msg[FILENOTFOUND], s.c_str());
		string texname;
		ftex >> texname;
		BITMAP* tex = load_bitmap((string("./data/")+texname).c_str(), 0);
		if (!tex) ERR(msg[FILENOTFOUND], (string("../data/")+texname).c_str());
		textury[i].tex = allegro_gl_make_texture (tex);
		destroy_bitmap(tex);
		ftex >> j;
		textury[i].type = j;
	}

//	allegro_gl_use_mipmapping(TRUE);
	BITMAP* tex = load_bitmap("./data/panak3d.pcx", 0);
	if (!tex) ERR(msg[FILENOTFOUND], "../data/panak3d.pcx");
	player_tex = allegro_gl_make_masked_texture (tex);
	destroy_bitmap(tex);
/*	tex = load_bitmap("../data/p.bmp", 0);
	player_mask = allegro_gl_make_texture (tex);
	destroy_bitmap(tex);*/


	DATAFILE* dat = load_datafile("running.dat");
	if (!dat) ERR(msg[FILENOTFOUND], "running.dat");

/*	if (!dat) {
		set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
		allegro_message("Unable to load running.dat!\n");
		return -2;
	}*/

	allegro_gl_use_mipmapping(TRUE);

	/* Convert running ball thingie */
	for (j = 0; j < 10; j++) {
		BITMAP *bmp = (BITMAP*)dat[FRAME_00_BMP + j].dat;
		hrac_vpravo[j] = allegro_gl_make_masked_texture(bmp);
		BITMAP*  bmprot = create_bitmap(bmp->w, bmp->h);
		clear_to_color(bmprot, makecol(255,0,255));
		rotate_sprite_v_flip(bmprot, bmp, 0, 0, itofix(128));
		hrac_vlevo[j] = allegro_gl_make_masked_texture(bmprot);
		destroy_bitmap(bmprot);
	}
	unload_datafile(dat);

	load_sprites();

	allegro_gl_end();

	fin >> sirka;
	fin >> vyska;

	w.resize(vyska);
	for (i=0; i<vyska; i++) {
		w[i].resize(sirka);
	}

//	LOG("Loading sprites");
	int quak;
	for (i=0; i<vyska; i++) {
		for (j=0; j<sirka; j++) {
			fin >> quak;
			w[i][j] = quak-1;
//			LOG("quak-1");
			fin >> quak;
			if (quak == 1) sprity.push_back( new potvora_sprite(j<<4,i<<4,player_tex) );
			if (quak == 2) sprity.push_back( new konec_sprite(j<<4,i<<4,pictures[FLYING_5_SPRITE]) );
		}
	}

	allegro_gl_begin();
	allegro_gl_use_mipmapping(TRUE);
	BITMAP* texturka = load_bitmap("./data/pozadi.pcx", 0);
	if (!texturka) ERR(msg[FILENOTFOUND], "../data/pozadi.pcx");
	pozadi_tex = allegro_gl_make_masked_texture (texturka);
	destroy_bitmap(texturka);

/*	world = glGenLists(1);
	glNewList(world,GL_COMPILE);
//	glEnable(GL_BLEND);
//	glBlendFunc(GL_ONE, GL_ZERO);

	allegro_gl_use_mipmapping(TRUE);
	BITMAP* texturka = load_bitmap("../data/pozadi.pcx", 0);
	if (!texturka) ERR(msg[FILENOTFOUND], "../data/pozadi.pcx");
	int texturka_number = allegro_gl_make_masked_texture (texturka);
	destroy_bitmap(texturka);
	glEnable (GL_TEXTURE_2D);
	glBindTexture (GL_TEXTURE_2D, texturka_number);
				glBegin(GL_QUADS);
					glTexCoord2f(1.0f, 1.0f); glVertex3f(sirka, vyska, -1);
					glTexCoord2f(0.0f, 1.0f); glVertex3f(0,     vyska, -1);
					glTexCoord2f(0.0f, 0.0f); glVertex3f(0,     0,     -1);
					glTexCoord2f(1.0f, 0.0f); glVertex3f(sirka, 0,     -1);
				glEnd(); */
/*
	for (i=0; i<vyska; i++) {
		for (j=0; j<sirka; j++) {
			if (w[i][j] == -1) {
				glDisable (GL_TEXTURE_2D);
			} else {
				glEnable (GL_TEXTURE_2D);
				glBindTexture (GL_TEXTURE_2D, textury[w[i][j]].tex);
			}
			if (textury[w[i][j]].type == 0) {
				glBegin(GL_QUADS);
					glTexCoord2f(1.0f, 1.0f); glVertex3f(j+1, i+1, 0);
					glTexCoord2f(0.0f, 1.0f); glVertex3f(j,   i+1, 0);
					glTexCoord2f(0.0f, 0.0f); glVertex3f(j,   i,   0);
					glTexCoord2f(1.0f, 0.0f); glVertex3f(j+1, i,   0);

					//leva strana
					if (j>0 && textury[w[i][j-1]].type>0) {
						glTexCoord2f(1.0f, 1.0f); glVertex3f(j,   i+1, 0);
						glTexCoord2f(0.0f, 1.0f); glVertex3f(j,   i+1, -1);
						glTexCoord2f(0.0f, 0.0f); glVertex3f(j,   i,   -1);
						glTexCoord2f(1.0f, 0.0f); glVertex3f(j,   i,   0);
					}

					//prava strana
					if (j<sirka-1 && textury[w[i][j+1]].type>0) {
						glTexCoord2f(1.0f, 1.0f); glVertex3f(j+1, i+1, -1);
						glTexCoord2f(0.0f, 1.0f); glVertex3f(j+1, i+1, 0);
						glTexCoord2f(0.0f, 0.0f); glVertex3f(j+1, i,   0);
						glTexCoord2f(1.0f, 0.0f); glVertex3f(j+1, i,   -1);
					}

					//horni strana
					if (i>0 && textury[w[i-1][j]].type>0) {
						glTexCoord2f(1.0f, 1.0f); glVertex3f(j+1, i,   0);
						glTexCoord2f(0.0f, 1.0f); glVertex3f(j,   i,   0);
						glTexCoord2f(0.0f, 0.0f); glVertex3f(j,   i,   -1);
						glTexCoord2f(1.0f, 0.0f); glVertex3f(j+1, i,   -1);
					}

					//dolni strana
					if (i<vyska-1 && textury[w[i+1][j]].type>0) {
						glTexCoord2f(1.0f, 1.0f); glVertex3f(j+1, i+1, -1);
						glTexCoord2f(0.0f, 1.0f); glVertex3f(j,   i+1, -1);
						glTexCoord2f(0.0f, 0.0f); glVertex3f(j,   i+1, 0);
						glTexCoord2f(1.0f, 0.0f); glVertex3f(j+1, i+1, 0);
					}

				glEnd();
			} else {
				glBegin(GL_QUADS);
					glTexCoord2f(1.0f, 1.0f); glVertex3f(j+1, i+1, -1);
					glTexCoord2f(0.0f, 1.0f); glVertex3f(j,   i+1, -1);
					glTexCoord2f(0.0f, 0.0f); glVertex3f(j,   i,   -1);
					glTexCoord2f(1.0f, 0.0f); glVertex3f(j+1, i,   -1);
				glEnd();
			}
		}
	}

	glEndList();*/
	allegro_gl_end();

	int pocet_zradel;
	if (fin >> pocet_zradel) {
		zradla.resize(pocet_zradel);
		for (int h = 0; h < pocet_zradel; h++) {
			fin >> i >> j;
			zradla[h].stav = true;
			zradla[h].x = i;
			zradla[h].y = vyska-j-1;
		}
	}

/*	int i,j;
	ifstream fin( filename );
	if ( !fin ) {
		//allegro_message(msg[FILENOTFOUND], filename);
		//exit(1);
		ERR(msg[FILENOTFOUND], filename);
	}
	int pocet_bodu;
	fin >> pocet_bodu;
	if (!fin || !pocet_bodu) exit(1);	//ERROR
	vector<vector<float> > body(pocet_bodu);
	for (i=0; i<pocet_bodu; i++) {
		body[i].resize(3);
		fin >> body[i][0];
		if (!fin) exit(1);					//ERROR
		fin >> body[i][1];
		if (!fin) exit(1);					//ERROR
		fin >> body[i][2];
		if (!fin) exit(1);					//ERROR
	}
	int pocet_objektu;
	fin >> pocet_objektu;
	if (!fin || !pocet_objektu) exit(1);//ERROR
	if (pocet_objektu != 1) exit(2); //ZATIM NEUMIME
	int pocet_stran;
	fin >> pocet_stran;
	if (!fin || !pocet_stran) exit(1);	//ERROR
	vector<vector<int> > strany(pocet_stran);
	for (i=0; i<pocet_stran; i++) {
		strany[i].resize(4);
		for (j=0; j<4; j++) {
			fin >> strany[i][j];
			if (!fin) exit(1);				//ERROR
		}
	}

	std::ofstream fout("info.txt");
	allegro_gl_begin();
	world = glGenLists(1);
	glNewList(world,GL_COMPILE);
		glBegin(GL_QUADS);
		for (i=0; i<pocet_stran; i++) {
			for (j=0; j<4; j++) {
				glVertex3f(
					body[strany[i][j]][0],
					body[strany[i][j]][1],
					body[strany[i][j]][2]
				);
				fout << 
					body[strany[i][j]][0] << " " <<
					body[strany[i][j]][1] << " " <<
					body[strany[i][j]][2] << " " <<
				std::endl;
			}
		}
		glEnd();
	glEndList();
	allegro_gl_end();*/
}
