/*************************************************************************
 textdata.c - by Chris La Mantia
 v2.00 WIP 4  August 14, 2001
 For use with the Allegro library

**************************************************************************/
#include "textdata.h"


char **create_textdata(void)
{
   char **p=NULL;

   p=malloc(2*sizeof(char *));
   if(p==NULL)
      return(p);
   (int)p[0]=0;
   return p+1;
}

char **add_textdata_string(char **tdo, char *string)
{
   char *s;
   int count;
   char **p;

   if(tdo==NULL)
      return NULL;
   s=malloc(ustrsizez(string));
   if(s==NULL)
      return NULL;
   ustrcpy(s,string);
   count=strcount(tdo)+1;
   p=(char **)realloc(tdo-1,(count+1)*sizeof(char *));
   if(p==NULL)
      return NULL;
   if(p) {
      (int)p[0]=count;
      p[count]=s;
   }
   return p+1;
}

char **delete_textdata_string(char **tdo, int s)
{
   int count;
   int index;
   char **p;

   if(tdo==NULL)
      return NULL;
   count=strcount(tdo);
   if(s>=count)
      return tdo;
   if(tdo[s]!=NULL)
      free(tdo[s]);
   for(index=s;index<count;index++)
      tdo[index]=tdo[index+1];
   count--;
   strcount(tdo)=count;
   p=(char **)realloc(tdo-1,(count+1)*sizeof(char *));
   if(p==NULL)
      return p;
   else
      return p+1;
}

char **insert_textdata_string(char **tdo, char *string, int s)
{
   char *str;
   int count;
   char **p;
   int index;

   if(tdo==NULL)
      return NULL;
   count=strcount(tdo)+1;
   p=(char **)realloc(tdo-1,(count+1)*sizeof(char *));
   if(p==NULL)
      return NULL;
   tdo=p+1;
   str=malloc(ustrsizez(string));
   if(str==NULL)
      return NULL;
   ustrcpy(str,string);
   (int)p[0]=count;
   if(s>=count-1) {
      p[count]=str;
   } else {
      for(index=count-2;index>=s;index--)
         tdo[index+1]=tdo[index];
      p[s]=str;
   }
   return tdo;
}


char **replace_textdata_string(char **tdo, int s, char *string)
{
   char *str;
   int count;

   count=strcount(tdo);
   if(s>=count)
      return NULL;
   if(tdo==NULL)
      return NULL;
   str=malloc(ustrsizez(string));
   if(str==NULL)
      return NULL;
   if(tdo[s])
      free(tdo[s]);
   tdo[s]=str;
   ustrcpy(str,string);
   return tdo;
}

int save_textdata(char **tdo, char *filename, int method)
{
   int index;
   FILE *f;
   char omode[3][3]={"wb","wt","wt"};

   f=fopen(filename,omode[method]);
   if(f==NULL)
      return -1;
   for(index=0;index<strcount(tdo);index++) {
      if(method==TD_COMMA)
         if(fputc('\"',f)==EOF)
            return -1;
      if(fputs(tdo[index],f)==EOF)
         return -1;
      switch(method) {
         default:
         case TD_ZERO:
            if(fputc(0,f)==EOF)
               return -1;
            break;
         case TD_NEWLINE:
            if(fputc('\n',f)==EOF)
               return -1;
            break;
         case TD_COMMA:
            if(fputc('\"',f)==EOF)
               return -1;
            if(index<strcount(tdo)-1)
               if(fputc(',',f)==EOF)
                  return -1;
            break;
      }
   }
   fclose(f);
   return 0;
}

static int help_sort_textdata_a(const void *e1,const void *e2)
{
   return ustrcmp(*(char **)e1, *(char **)e2);
}

static int help_sort_textdata_d(const void *e1,const void *e2)
{
   return -(ustrcmp(*(char **)e1, *(char **)e2));
}
static int help_sort_textdata_a_nc(const void *e1,const void *e2)
{
   return ustricmp(*(char **)e1, *(char **)e2);
}

static int help_sort_textdata_d_nc(const void *e1,const void *e2)
{
   return -(ustricmp(*(char **)e1, *(char **)e2));
}



void sort_textdata(char **tdo, int method)
{
   switch(method) {
      default:
      case TD_SORT_ASCENDING:
         qsort(tdo,strcount(tdo),sizeof(char *),help_sort_textdata_a);
         break;
      case TD_SORT_DESCENDING:
         qsort(tdo,strcount(tdo),sizeof(char *),help_sort_textdata_d);
         break;
      case TD_SORT_ASCENDING_NOCASE:
         qsort(tdo,strcount(tdo),sizeof(char *),help_sort_textdata_a_nc);
         break;
      case TD_SORT_DESCENDING_NOCASE:
         qsort(tdo,strcount(tdo),sizeof(char *),help_sort_textdata_d_nc);
         break;
   }
}



char **concatenate_textdata(char **tdo1, char **tdo2)
{
   int index;

   if((tdo1==NULL)||(tdo2==NULL))
      return NULL;
   for(index=0;index<strcount(tdo2);index++) {
      tdo1=add_textdata_string(tdo1,tdo2[index]);
      if(tdo1==NULL)
         return NULL;
   }
   destroy_textdata(tdo2);
   return tdo1;
}

char **load_textdata(char *filename)
{
   char **tdo;
   PACKFILE *f;

   f = pack_fopen(filename, F_READ);
   if (!f)
      return NULL;
   tdo=(char **)load_textdata_object(f,0);
   pack_fclose(f);
   return tdo;
}

void *load_textdata_object(PACKFILE *f, long size)
{
   char **p=NULL;
   char *s;
   int c;
   int ccount;


   for (c=1; (!pack_feof(f)); c++) {
      p=(char **)realloc(p,(c+1)*sizeof(char *));
      if(p==NULL)
         return(p);
      s=NULL;
      ccount=0;
      do {
         s=(char *)realloc(s,ccount+1);
         if(s==NULL)
            break;
         s[ccount]=pack_getc(f);
         if(s[ccount]=='\n')
            s[ccount]=0;
//         if(s[ccount]
         ccount++;
      } while((s[ccount-1])&&(!pack_feof(f)));
      if(s!=NULL) {
         if(s[ccount-1]!=0) {
            s=(char *)realloc(s,ccount+1);
            s[ccount]=0;
         }
      }
      p[c]=s;
   }
   if(p!=NULL) {
      c--;
      (int)p[0]=c;
      p++;
   }
   return (void *)p;
}

void destroy_textdata(void *data)
{
   int index;
   int count;


   if(data) {
      count=(int)((char **)data-1)[0];
      for(index=0;index<count;index++)
         free(((char **)data)[index]); 
      free((char **)data-1);
   }
}

