#include <typeinfo>
#include "common.h"
#include "basic.h"

void basic_game::do_collision(sprite& a, sprite& b) {
	if (typeid(a) == typeid(strela_sprite)) {
		if (typeid(b) == typeid(potvora_sprite)) {
			a.delete_me = true;
			b.delete_me = true;
			score += 5;
			sprity.push_back( new skore_sprite(b.x,b.y,pictures[FLYING_5_SPRITE]) );
		}
	}
}

void basic_game::do_collisions() {
	for (list<sprite*>::iterator i = sprity.begin(); i != sprity.end(); i++) {
		sprite& s = **i;
		int sx2 = s.w * 15.0f + s.x;
		int sy2 = s.h * 15.0f + s.y;
		//check collision with player
		if (s.x < px+15 && s.y < py+15 && sx2 > px && sy2 > py) {
			s.collision_with_player();
		}
		// check for other types of collisions
		for (list<sprite*>::iterator j = i; j != sprity.end(); j++) {
			sprite& t = **j;
			int tx2 = t.w * 15.0f + t.x;
			int ty2 = t.h * 15.0f + t.y;
			if (s.x < tx2 && s.y < ty2 && sx2 > t.x && sy2 > t.y) {
				do_collision(s, t);
				do_collision(t, s);
			}
		}
	}
}

void strela_sprite::let() {
	if (time > 0) {
		if (smer == vpravo) {
			if (hra->can_move_right(x,y,h)) {
				hra->move_right(3, *this);
			} else {
				delete_me = true;
			}
		} else {
			if ( hra->can_move_left(x,y,h) ) {
				hra->move_left(3, *this);
			} else {
				delete_me = true;
			}
		}
	}
}

void potvora_sprite::move() {
	if (time > 3) {
		if (smer == vpravo) {
			if (hra->can_move_right(x,y,h)&& !hra->can_move_down(x+15,y) ) {
				x++;
			} else {
				smer = vlevo;
			}
		} else {
			if (hra->can_move_left(x,y,h) && !hra->can_move_down(x-15,y) ) {
				x--;
			} else {
				smer = vpravo;
			}
		}
	}
}

void basic_game::load_sprites() {
	BITMAP* tex = load_bitmap("./data/5.bmp", 0);
	if (!tex) ERR("Nemohu najit ../data/5.bmp","");
	pictures.push_back(allegro_gl_make_masked_texture (tex));
	destroy_bitmap(tex);
}