/*
	Becherovka game 2001 (c) Michal Molhanec

	main.cpp
*/
#include <cassert>
#include <vector>
using namespace std;
#include "common.h"
#include "basic.h"

basic_game* hra;
bool want_to_play_again;
bool want_to_quit;

bool basic_game::is_visible(sprite* s) {
	if (s->x > px+(13<<4)) return false;
	if (s->y > py+(12<<4)) return false;
	if (s->x < px-(12<<4)) return false;
	if (s->y < py-(7<<4)) return false;
	return true;
}

bool basic_game::can_move_left() {
	if (px < 16) return false;
	if (px & 0xF) return true;
	if (textury[w[py >> 4][(px >> 4) - 1]].type == 0)	return false;
	if (py & 0xF) if (textury[w[(py >> 4) + 1][(px >> 4) - 1]].type == 0) return false;
	return true;
}
bool basic_game::can_move_right() {
	if ((px >> 4) >= w[0].size()-1) return false;
	if (px & 0xF) return true;
	if (textury[w[py >> 4][(px >> 4) + 1]].type == 0)	return false;
	if (py & 0xF) if (textury[w[(py >> 4) + 1][(px >> 4) + 1]].type == 0) return false;
	return true;
}
bool basic_game::can_move_up() {
	if ((py >> 4) >= w.size()-1) return false;
	if (py & 0xF) return true;
	if (textury[w[(py >> 4) + 1][px >> 4]].type == 0) return false;
	if (px & 0xF) if (textury[w[(py >> 4) + 1][(px >> 4) + 1]].type == 0) return false;
	return true;
}
bool basic_game::can_move_down() {
	if (py < 16) return false;
	if (py & 0xF) return true;
	if (textury[w[(py >> 4) - 1][px >> 4]].type == 0) return false;
	if (px & 0xF) if (textury[w[(py >> 4) - 1][(px >> 4) + 1]].type == 0) return false;
	return true;
}
bool basic_game::can_move_left(int xx, int yy, float h) {
	if (xx < 16) return false;
	if (xx & 0xF) return true;
	if (textury[w[yy >> 4][(xx >> 4) - 1]].type == 0)	return false;
	int ph = h*(float)16;
	if (textury[w[(yy+ph) >> 4][(xx >> 4) - 1]].type == 0) return false;
	return true;
}
bool basic_game::can_move_right(int xx, int yy, float h) {
	if ((xx >> 4) >= w[0].size()-1) return false;
	if (xx & 0xF) return true;
	if (textury[w[yy >> 4][(xx >> 4) + 1]].type == 0)	return false;
	int ph = h*(float)16;
	if (textury[w[(yy+ph) >> 4][(xx >> 4) + 1]].type == 0) return false;
//	if (py & 0xF) if (textury[w[(py >> 4) + 1][(px >> 4) + 1]].type == 0) return false;
	return true;
}
bool basic_game::can_move_up(int xx, int yy) {
	if ((yy >> 4) >= w.size()-1) return false;
	if (yy & 0xF) return true;
	if (textury[w[(yy >> 4) + 1][xx >> 4]].type == 0) return false;
	if (xx & 0xF) if (textury[w[(yy >> 4) + 1][(xx >> 4) + 1]].type == 0) return false;
	return true;
}
bool basic_game::can_move_down(int xx, int yy) {
	if (yy < 16) return false;
	if (yy & 0xF) return true;
	if (textury[w[(yy >> 4) - 1][xx >> 4]].type == 0) return false;
	if (xx & 0xF) if (textury[w[(yy >> 4) - 1][(xx >> 4) + 1]].type == 0) return false;
	return true;
}
void basic_game::move_left(int max, sprite& s) {
	int i = 0;
	while (can_move_left(s.x, s.y, s.h) && i < max) { s.x--; i++; }
}
void basic_game::move_right(int max, sprite& s) {
	int i = 0;
	while (can_move_right(s.x, s.y, s.h) && i < max) { s.x++; i++; }
}
void basic_game::move_down(int max, sprite& s) {
	int i = 0;
	while (can_move_down(s.x, s.y) && i < max) { s.y--; i++; }
}
void basic_game::move_up(int max, sprite& s) {
	int i = 0;
	while (can_move_up(s.x, s.y) && i < max) { s.y++; i++; }
}
void basic_game::go_left(int max) {
	int i = 0;
	while (can_move_left() && i < max) { px--; i++; }
	i_hrac++;
	if (i_hrac>9) i_hrac = 0;
	smer = &hrac_vlevo;
}
void basic_game::go_right(int max) {
	int i = 0;
	while (can_move_right() && i < max) { px++; i++; }
	i_hrac++;
	if (i_hrac>9) i_hrac = 0;
	smer = &hrac_vpravo;
}
void basic_game::go_down(int max) {
	int i = 0;
	while (can_move_down() && i < max) { py--; i++; }
}
void basic_game::go_up(int max) {
	int i = 0;
	while (can_move_up() && i < max) { py++; i++; }
}

void basic_game::stand() {
	time += delta_time;
	if (time > 2) {
		time = 0;
		if (key[KEY_LEFT] && can_move_left()) go_left(2);
		if (key[KEY_RIGHT] && can_move_right()) go_right(2);
		if (key[KEY_UP] && can_move_up()) {
			run = &basic_game::jump;
			yspeed = 11;
		}
//		if (key[KEY_DOWN] && can_move_down()) py-=0.1;
		if (can_move_down()) {
			run = &basic_game::fall;
			yspeed = 1;
		}
	}
}
void basic_game::fall() {
	time += delta_time;
	if (time > 3) {
		time = 0;
		if (key[KEY_LEFT] && can_move_left()) go_left(2);
		if (key[KEY_RIGHT] && can_move_right()) go_right(2);
		go_down(yspeed);
		if (yspeed < 32) yspeed++;
		if (!can_move_down()) run = &basic_game::stand;
	}
}
void basic_game::jump() {
	time += delta_time;
	if (time > 3) {
		time = 0;
		if (key[KEY_LEFT] && can_move_left()) go_left(2);
		if (key[KEY_RIGHT] && can_move_right()) go_right(2);
		go_up(yspeed);
		yspeed--;
		if (!can_move_up() || yspeed <= 0) {
			if (can_move_down()) run = &basic_game::fall;
			else run = &basic_game::stand;
		}
	}
}

void basic_game::display_player()
{
	float x = (float)(px >> 4) + (float)(px & 0xF) / 16;
	float y = (float)(py >> 4) + (float)(py & 0xF) / 16;
//   glColor3f(1.0, 1.0, 1.0);
//	glEnable (GL_TEXTURE_2D);
//	glEnable(GL_BLEND);
//	glDisable(GL_DEPTH_TEST);
	//glBlendFunc(GL_SRC_ALPHA, GL_ONE);
//	glBlendFunc(GL_ONE, GL_ZERO);

/*	glBlendFunc(GL_DST_COLOR,GL_ZERO);				// Blend Screen Color With Zero (Black)
	glBindTexture (GL_TEXTURE_2D, player_mask);
	glBegin(GL_QUADS);
		glTexCoord2f(0,0); glVertex3f(x, y, -0.5);
		glTexCoord2f(1,0); glVertex3f(x+1.0f, y, -0.5);
		glTexCoord2f(1,1); glVertex3f(x+1.0f, y+1.0f, -0.5);
		glTexCoord2f(0,1); glVertex3f(x, y+1.0f, -0.5);
	glEnd();*/

glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	///glBlendFunc(GL_ONE, GL_ONE);					// Copy Image 2 Color To The Screen
	glBindTexture (GL_TEXTURE_2D, (*smer)[i_hrac]);
	glBegin(GL_QUADS);
		glTexCoord2f(0,0); glVertex3f(x, y, -0.5);
		glTexCoord2f(1,0); glVertex3f(x+1.0f, y, -0.5);
		glTexCoord2f(1,1); glVertex3f(x+1.0f, y+1.0f, -0.5);
		glTexCoord2f(0,1); glVertex3f(x, y+1.0f, -0.5);
	glEnd();
//	glDisable(GL_BLEND);
//	glBlendFunc(GL_ONE, GL_ZERO);
//	glEnable(GL_DEPTH_TEST);
}

void basic_game::display_zradla()
{
//	glEnable(GL_TEXTURE_2D);
//	glEnable(GL_BLEND);
	//glDisable(GL_DEPTH_TEST);
	for (int i=0; i<zradla.size(); i++) {
		if (zradla[i].stav) {
/*		glBlendFunc(GL_DST_COLOR,GL_ZERO);				// Blend Screen Color With Zero (Black)
		glBindTexture (GL_TEXTURE_2D, player_mask);
		glBegin(GL_QUADS);
			glTexCoord2f(0,0); glVertex3f(zradla[i].x, zradla[i].y, -0.5);
			glTexCoord2f(1,0); glVertex3f(zradla[i].x+1.0f, zradla[i].y, -0.5);
			glTexCoord2f(1,1); glVertex3f(zradla[i].x+1.0f, zradla[i].y+1.0f, -0.5);
			glTexCoord2f(0,1); glVertex3f(zradla[i].x, zradla[i].y+1.0f, -0.5);
		glEnd();*/
//		glBlendFunc(GL_ONE, GL_ONE);					// Copy Image 2 Color To The Screen
		//glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

/* !!! working !!!
		glBindTexture (GL_TEXTURE_2D, player_tex);
		glBegin(GL_QUADS);
			glTexCoord2f(0,0); glVertex3f(zradla[i].x, zradla[i].y, -0.5);
			glTexCoord2f(1,0); glVertex3f(zradla[i].x+1.0f, zradla[i].y, -0.5);
			glTexCoord2f(1,1); glVertex3f(zradla[i].x+1.0f, zradla[i].y+1.0f, -0.5);
			glTexCoord2f(0,1); glVertex3f(zradla[i].x, zradla[i].y+1.0f, -0.5);
		glEnd();		
*/
		glPushMatrix();
		glTranslatef(zradla[i].x+0.5f,zradla[i].y+0.5f, -0.5);
		glRotatef(sprite_rot,0,1,0);
		glBindTexture (GL_TEXTURE_2D, player_tex);
		glBegin(GL_QUADS);
			glTexCoord2f(0,0); glVertex3f(-0.5f, -0.5f, 0);
			glTexCoord2f(1,0); glVertex3f( 0.5f, -0.5f, 0);
			glTexCoord2f(1,1); glVertex3f( 0.5f,  0.5f, 0);
			glTexCoord2f(0,1); glVertex3f(-0.5f,  0.5f, 0);
		glEnd();		
		glPopMatrix();
		}
	}
//	glBlendFunc(GL_ONE, GL_ZERO);
}

void basic_game::testuj_zradlo()
{
	for (int i=0; i<zradla.size(); i++) {
		if (zradla[i].stav) {
			if (zradla[i].x == px >> 4 && zradla[i].y == py >> 4) {
				zradla[i].stav = false;
				score += 5;
				sprity.push_back(new skore_sprite((zradla[i].x << 4)|4, (zradla[i].y << 4)|8, pictures[FLYING_5_SPRITE]));
			}
			if (px & 0xF) if (zradla[i].x == (px >> 4) + 1 && zradla[i].y == py >> 4) {
				zradla[i].stav = false;
				score += 5;
				sprity.push_back(new skore_sprite((zradla[i].x << 4)|4, (zradla[i].y << 4)|8, pictures[FLYING_5_SPRITE]));
			} 
			else if (py & 0xF) if (zradla[i].x == px >> 4 && zradla[i].y == (py >> 4) + 1) {
				zradla[i].stav = false;
				score += 5;
				sprity.push_back(new skore_sprite((zradla[i].x << 4)|4, (zradla[i].y << 4)|8, pictures[FLYING_5_SPRITE]));
			}
		}
	}
}

void basic_game::display_sprity() {
	float x,y,w,h;
	for (list<sprite*>::iterator iter = sprity.begin(); iter != sprity.end(); iter++) {
		x = (float)((*iter)->x >> 4) + (float)((*iter)->x & 0xF) / 16;
		y = (float)((*iter)->y >> 4) + (float)((*iter)->y & 0xF) / 16;
		w = (*iter)->w;
		h = (*iter)->h;
		//glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		if (is_visible(*iter)) {
			glBindTexture (GL_TEXTURE_2D, (*iter)->pict);
			glBegin(GL_QUADS);
				glTexCoord2f(0,0); glVertex3f(x, y, -0.5);
				glTexCoord2f(1,0); glVertex3f(x+w, y, -0.5);
				glTexCoord2f(1,1); glVertex3f(x+w, y+h, -0.5);
				glTexCoord2f(0,1); glVertex3f(x, y+h, -0.5);
			glEnd();		
		}
	}
}

void basic_game::proved_sprity() {
	for (list<sprite*>::iterator iter = sprity.begin(); iter != sprity.end();) {
		if ((*iter)->delete_me) {
			list<sprite*>::iterator iiiii = iter;
			iiiii++;
			delete *iter;
			sprity.erase( iter );
			iter = iiiii;
		} else {
			(*iter)->update_time(delta_time);
	//		(this->*run)();
			((*iter)->*((*iter)->run))();
			if (want_death) return;
			iter++;
		}
	}
}

void basic_game::display_world() {
/*	int odkudx = (px >> 4) - 8;
	if (odkudx <0) odkudx = 0;
	int kamx = (px >> 4) + 9;
	if (kamx > sirka) kamx = sirka;
//	if (odkudx < 1) kamx += 4 - odkudx;
//	if (kamx > sirka - 3) odkudx -= kamx - sirka + 3;
	int odkudy = (py >> 4) - 5;
	if (odkudy <0) odkudy = 0;
	int kamy = (py >> 4) + 8;
	if (kamy > vyska) kamy = vyska;
//	if (odkudy < 6) kamy += 6 - odkudy;
//	if (kamy > vyska - 3) odkudy -= kamy - vyska + 3;*/

	int odkudx, kamx;
	int stredx = px >> 4;
	if (stredx < (sirka >> 1)) {
		odkudx = stredx - 8;
		if (odkudx < 0) odkudx = 0;
		kamx = odkudx + 17;
	} else {
		kamx = stredx + 9;
		if (kamx > sirka) kamx = sirka;
		odkudx = kamx - 17;
	}
	int odkudy, kamy;
	int stredy = py >> 4;
	if (stredy < (vyska >> 1)) {
		odkudy = stredy - 5;
		if (odkudy < 0) odkudy = 0;
		kamy = odkudy + 13;
	} else {
		kamy = stredy + 8;
		if (kamy > vyska) kamy = vyska;
		odkudy = kamy - 13;
	}

		glEnable (GL_TEXTURE_2D);
		glBindTexture (GL_TEXTURE_2D, pozadi_tex);
				glBegin(GL_QUADS);
					glTexCoord2f((float)kamx/sirka, (float)kamy/vyska); glVertex3f(kamx, kamy, -1);
					glTexCoord2f((float)odkudx/sirka, (float)kamy/vyska); glVertex3f(odkudx, kamy, -1);
					glTexCoord2f((float)odkudx/sirka, (float)odkudy/vyska); glVertex3f(odkudx, odkudy, -1);
					glTexCoord2f((float)kamx/sirka, (float)odkudy/vyska); glVertex3f(kamx, odkudy, -1);
				glEnd(); 

	for (int i=odkudy; i<kamy; i++) {
		for (int j=odkudx; j<kamx; j++) {
			if (w[i][j] == -1) {
				glDisable (GL_TEXTURE_2D);
			} else {
				glEnable (GL_TEXTURE_2D);
				LOG(i);
				LOG(j);
				LOG(w[i][j]);
				LOG(textury[w[i][j]].tex);
				glBindTexture (GL_TEXTURE_2D, textury[w[i][j]].tex);
			}
			if (textury[w[i][j]].type == 0) {
				glBegin(GL_QUADS);
					glTexCoord2f(1.0f, 1.0f); glVertex3f(j+1, i+1, 0);
					glTexCoord2f(0.0f, 1.0f); glVertex3f(j,   i+1, 0);
					glTexCoord2f(0.0f, 0.0f); glVertex3f(j,   i,   0);
					glTexCoord2f(1.0f, 0.0f); glVertex3f(j+1, i,   0);

					//leva strana
					if (j>0 && textury[w[i][j-1]].type>0) {
						glTexCoord2f(1.0f, 1.0f); glVertex3f(j,   i+1, 0);
						glTexCoord2f(0.0f, 1.0f); glVertex3f(j,   i+1, -1);
						glTexCoord2f(0.0f, 0.0f); glVertex3f(j,   i,   -1);
						glTexCoord2f(1.0f, 0.0f); glVertex3f(j,   i,   0);
					}

					//prava strana
					if (j<sirka-1 && textury[w[i][j+1]].type>0) {
						glTexCoord2f(1.0f, 1.0f); glVertex3f(j+1, i+1, -1);
						glTexCoord2f(0.0f, 1.0f); glVertex3f(j+1, i+1, 0);
						glTexCoord2f(0.0f, 0.0f); glVertex3f(j+1, i,   0);
						glTexCoord2f(1.0f, 0.0f); glVertex3f(j+1, i,   -1);
					}

					//horni strana
					if (i>0 && textury[w[i-1][j]].type>0) {
						glTexCoord2f(1.0f, 1.0f); glVertex3f(j+1, i,   0);
						glTexCoord2f(0.0f, 1.0f); glVertex3f(j,   i,   0);
						glTexCoord2f(0.0f, 0.0f); glVertex3f(j,   i,   -1);
						glTexCoord2f(1.0f, 0.0f); glVertex3f(j+1, i,   -1);
					}

					//dolni strana
					if (i<vyska-1 && textury[w[i+1][j]].type>0) {
						glTexCoord2f(1.0f, 1.0f); glVertex3f(j+1, i+1, -1);
						glTexCoord2f(0.0f, 1.0f); glVertex3f(j,   i+1, -1);
						glTexCoord2f(0.0f, 0.0f); glVertex3f(j,   i+1, 0);
						glTexCoord2f(1.0f, 0.0f); glVertex3f(j+1, i+1, 0);
					}

				glEnd();
			} else {
				glBegin(GL_QUADS);
					glTexCoord2f(1.0f, 1.0f); glVertex3f(j+1, i+1, -1);
					glTexCoord2f(0.0f, 1.0f); glVertex3f(j,   i+1, -1);
					glTexCoord2f(0.0f, 0.0f); glVertex3f(j,   i,   -1);
					glTexCoord2f(1.0f, 0.0f); glVertex3f(j+1, i,   -1);
				glEnd();
			}
		}
	}
	glEnable(GL_TEXTURE_2D);
}

void basic_game::display()
{
znova:
	int frame = 1;
	int frame_time = 0;
	int strela_time = 0;
	float fps = 0;
	int total_frame = 1;
	int total_time  = 0;
	const int F = 5;
	do {
		allegro_gl_begin();

		glEnable(GL_TEXTURE_2D);
		glMatrixMode (GL_PROJECTION);
		glLoadIdentity ();
		glFrustum (-2.0, 2.0, -2*0.75, 2*0.75, 1.0, 40.0);
		glMatrixMode (GL_MODELVIEW);

      // Clear the RGB buffer and the depth buffer
      glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

//		glEnable(GL_LIGHT0);					// Quick And Dirty Lighting (Assumes Light0 Is Set Up)
//		glEnable(GL_LIGHTING);					// Enable Lighting
//		glEnable(GL_COLOR_MATERIAL);				// Enable Material Coloring

		// Set the modelview matrix to be the identity matrix
      glLoadIdentity();

		//Set the camera
		static float kolik=0;
		static float z=-3;
		static float y=-1;
		static float x=0;

		update_delta_time();
		key_time += delta_time;
		frame_time += delta_time;
		strela_time += delta_time;
		total_time += delta_time;
		sprite_rot += (float)delta_time;
		if (key_time > 10) {
			if (key[KEY_4_PAD]) x++;
			if (key[KEY_6_PAD]) x--;
			if (key[KEY_2_PAD]) y++;
			if (key[KEY_8_PAD]) y--;
			if (key[KEY_PGUP]) z--;
			if (key[KEY_PGDN]) z++;
			key_time = 0;
		}

		if (strela_time > 80 && score > 0) {
			if (key[KEY_LCONTROL] || key[KEY_RCONTROL]) {
				strela_sprite* s = new strela_sprite(px, py+4, player_tex, smer==&hrac_vpravo ? strela_sprite::vpravo : strela_sprite::vlevo);
				smer==&hrac_vpravo ? move_right(13, *s) : move_left(13, *s);
				sprity.push_back(s);
				strela_time = 0;
				score--;
			}
		}


		(this->*run)();
		testuj_zradlo();
		proved_sprity();
		do_collisions();

		float xxx = (float)(px >> 4) + (float)(px & 0xF) / 16;
		float yyy = (float)(py >> 4) + (float)(py & 0xF) / 16;
		if (xxx < 6.0f) xxx = 6.0f;
		if (yyy < 3.5f) yyy = 3.5f;
		if (xxx > sirka-6) xxx = sirka - 6;
		if (yyy > (float)vyska-5.5f) yyy = (float)vyska - 5.5f;
		glTranslatef (x-xxx, y-yyy, z);
	
		if (key[KEY_R]) {
			glRotatef(kolik,1,0,0);
			kolik += 0.2f;
		}

      //glColor3f(0.0, 0.0, 0.0);

	//	glDisable(GL_BLEND);
		display_world();
//		glCallList(world);
		
//		glEnable(GL_BLEND);

//		glAlphaFunc(GL_EQUAL,1.0f);// -> to co je jednicka se vykresli
//		glAlphaFunc(GL_NOTEQUAL,0.0f);// -> to co je jednicka se vykresli
		glAlphaFunc(GL_GREATER,0.99f);// -> to co je jednicka se vykresli
		glEnable(GL_ALPHA_TEST);

		display_zradla();
		display_player();
		display_sprity();	

		glDisable(GL_ALPHA_TEST);

		glDisable (GL_DEPTH_TEST);
//		allegro_gl_printf(fnt, xxx-12, yyy-10, -10, makecol(255,255,255), "x=%d y=%d yspeed=%d xx=%f yy=%f", px, py, yspeed, xxx, yyy);
		//allegro_gl_printf(fnt, xxx-24, yyy-16, -10, makecol(255,255,255), "FPS %f", fps);
//		allegro_gl_printf(fnt, xxx-12, yyy-8, -10, makecol(255,255,255), "FPS %f", (double)1.0/(double)delta_time*(double)200);
//		allegro_gl_printf(fnt, xxx-12, yyy-8, -10, makecol(255,255,255), "FPS %f", (float)frame/(float)::time*(float)200);
		allegro_gl_printf(fnt, xxx-14, yyy+12, -5, makecol(255,0,0), msg[SCORE], score);
		allegro_gl_printf(fnt, xxx-14, yyy+13, -5, makecol(255,0,0), msg[LIVES], lives);
		glEnable (GL_DEPTH_TEST);
      glColor3f(1.0, 1.0, 1.0);

		//allegro_gl_end();

		//glFlush();

		allegro_gl_flip();
		allegro_gl_end();

		frame++;
		total_frame++;
		if (frame>F) {
			fps = (double)F/(double)frame_time*(double)200;
			frame = 1;
			frame_time = 0;
		}
	} while (!key[KEY_ESC] && !want_death && !want_next_level);
	if (want_death) {
		death();
		if (lives >= 0) goto znova;
	}
	if (want_next_level) {
		level_num++;
		if (level_num < 3) {
			restart();
			goto znova;
		}
		else
			victory();
	}
	if (key[KEY_ESC]) want_to_play_again = false;
#ifdef MYDEBUG
	{ 
		ofstream logfile("bgame.log", ios_base::app | ios_base::out); 
		logfile << "Total FPS: " <<  (double)total_frame/(double)total_time*(double)200 << endl; 
	}
#endif
}

int main (int argc, char *argv[])
{
#ifdef MYDEBUG
	{ ofstream o("bgame.log"); }
#endif

	want_to_play_again = true;
	want_to_quit = false;
	while (want_to_play_again) {
		want_to_play_again = true;
		want_to_quit = false;
	
	LOG("I'm in main()");
	init_game();
	LOG("After game init");

	basic_game bg;
	LOG("Basic game object created");
	hra = &bg;

	if (argc == 2) {
		bg.load_world( argv[1] );
	} else {
		bg.load_world( "0" );
	}
	LOG("World loaded");

	bg.display();
	LOG("All displayed");

	done_game();
	LOG("The End.");

	}


	return 0;
}
END_OF_MAIN();
