/*
	Becherovka game 2001 (c) Michal Molhanec

	initdone.h - Inicialization & deinicialization
*/
#include <textdata.h>
#include "myfont.h"
#include "common.h"

DATAFILE *data;
char **msg; 
FONT* fnt;
FONT* myfnt;
int xres,yres,depth;

static volatile int time_counter = 0;

void increase_time() {
	time_counter++;
}
END_OF_FUNCTION(increase_time);

void koncime() {
	ERR("Mejte se pekne\r\nHave a nice day","");
}

void init_game() {
	allegro_init();
	set_window_close_hook(koncime);
	install_keyboard();
	install_timer();
	depth = desktop_color_depth();
	if (depth == 0) depth = 32;
	if (get_desktop_resolution(&xres, &yres) != 0) {
		xres = 640;
		yres = 480;
	} else {
		xres -= 160;
		yres -= 120;
	}

	DATAFILE* df = load_datafile("myfont.dat");
	if (!df) ERR("Nelze nalezt soubor\r\nCan't find file\r\n%s", "myfont.dat");
	myfnt = static_cast<FONT*>(df[myfont].dat);

	int myska = install_mouse();
	set_color_depth (depth);
	int resset = set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0);
	if (resset != 0) ERR("Nemohu zobrazit okno\r\nCan't show window","");

   install_textdata();
   data = load_datafile( "messages.dat" );
	if (!data) ERR("Nelze nalezt soubor\r\nCan't find file\r\n%s", "messages.dat");//ERR("Nemohu najit messages.dat","" );

	ask_for_language();
	if (myska > 0) remove_mouse();


   
	install_allegro_gl();
	
	allegro_gl_clear_settings();
// allegro_gl_set (AGL_COLOR_DEPTH, 32);
	allegro_gl_set (AGL_COLOR_DEPTH, depth);
	allegro_gl_set (AGL_Z_DEPTH, 8);
	allegro_gl_set	(AGL_WINDOWED, TRUE);
	allegro_gl_set (AGL_DOUBLEBUFFER, 1);
	allegro_gl_set	(AGL_RENDERMETHOD, 1);
   allegro_gl_set (AGL_SUGGEST, AGL_COLOR_DEPTH | AGL_Z_DEPTH /*| AGL_DOUBLEBUFFER*/ | AGL_WINDOWED | AGL_RENDERMETHOD);
	allegro_gl_set (AGL_REQUIRE, AGL_DOUBLEBUFFER);

	set_color_depth (depth);

	bool zkusznovu = false;
	int pokusu = 0;
	
	do {
		zkusznovu = false;
		if (set_gfx_mode(GFX_OPENGL, xres, yres, 0, 0) < 0) {
			allegro_message ("Error setting graphics mode:\n%s\n", allegro_error);
			exit(1);
		}

		if (allegro_gl_get(AGL_DOUBLEBUFFER) != 1) {
			pokusu++;
			if (pokusu > 20) {
				ERR("Chybi podpora doublebufferingu", "");
			} else {
				LOG("Chybi podpora doublebufferingu");
				zkusznovu = true;
			}
		}
	} while (zkusznovu);

	LOCK_VARIABLE(time_counter);
	LOCK_FUNCTION(increase_time);
	install_int(increase_time, 5);

	allegro_gl_begin();
	glClearColor (0, 0, 0, 0);
//	glShadeModel (GL_FLAT);
// glPolygonMode (GL_FRONT/*_AND_BACK*/, GL_FILL);
//	glPolygonMode (GL_BACK, GL_POINTS);
	glEnable (GL_DEPTH_TEST);
//	glCullFace (GL_BACK);
//	glEnable(GL_CULL_FACE);
//	glFrontFace(GL_CCW);
//	glEnable (GL_CULL_FACE);

/*
		glHint(GL_FOG_HINT, GL_DONT_CARE);
		glHint(GL_POLYGON_SMOOTH_HINT, GL_DONT_CARE);

		glShadeModel(GL_SMOOTH);
		glPolygonMode(GL_FRONT, GL_FILL);

		glViewport(0, 0, SCREEN_W, SCREEN_H);
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		glFrustum(-1.0, 1.0, -1.0, 1.0, 1, 60.0);

      // Set culling mode - not that we have anything to cull 
		glEnable(GL_CULL_FACE);
		glFrontFace(GL_CCW);
			
		glMatrixMode(GL_MODELVIEW);
*/


	glColor3f(0,0,0);
	allegro_gl_use_mipmapping(TRUE);
	allegro_gl_end();

	fnt = allegro_gl_convert_allegro_font(myfnt, AGL_FONT_TYPE_TEXTURED);

	if (!fnt) ERR("Nepovedlo se zkonvertovat font","");
}

void done_game() {
}

int delta_time = 0;
void update_delta_time() {
	static int old_time = time_counter;
	delta_time = time_counter - old_time;
	old_time = time_counter;
}