/*
	Becherovka game 2001 (c) Michal Molhanec

	main.cpp
*/

#ifndef __BASIC_H__
#define __BASIC_H__

#include <list>
#include <vector>
using namespace std;

#define SFUNC static_cast<void (sprite::*)()>

class sprite;

class basic_game /*: public game*/
{
	GLuint world;
	vector<Tex> textury;
	int pocet_textur;
	vector<vector<int> > w;
	int sirka, vyska;
	GLuint player_tex;
	GLuint pozadi_tex;
	//GLuint player_mask;
	GLuint hrac_vpravo[10];
	GLuint hrac_vlevo[10];
	int i_hrac; // index of hrac
	GLuint (*smer)[10];
	vector<Zradlo> zradla;
	int key_time;
	int x, y;
	int score;
	int lives;
	int px;
	int py;
	int yspeed;
	int time;
	int level_num;
	float sprite_rot;
	vector<GLuint> pictures;
	list<sprite*> sprity;
	void (basic_game::*run)();
	string last_filename;
	bool want_death;
	bool want_next_level;
	void death();
	void display_player();
	void display_zradla();
	void testuj_zradlo();
	void display_sprity();
	void proved_sprity();
	void display_world();
	bool can_move_left();
	bool can_move_right();
	bool can_move_up();
	bool can_move_down();
	bool can_move_left(int x, int y, float h);
	bool can_move_right(int x, int y, float h);
	bool can_move_up(int x, int y);
	bool can_move_down(int x, int y);
	void go_left(int max);
	void go_right(int max);
	void go_down(int max);
	void go_up(int max);
	void move_left(int max, sprite& s);
	void move_right(int max, sprite& s);
	void move_down(int max, sprite& s);
	void move_up(int max, sprite& s);
	void stand();
	void fall();
	void jump();
	bool is_visible(sprite* s);
	void do_collisions();
	void do_collision(sprite& a, sprite& b);
	void restart();
	void victory();
	friend class sprite;
	friend class potvora_sprite;
	friend class strela_sprite;
	friend class konec_sprite;
public:
	virtual void display();
	void load_world( const char* filename );
	void init();
	basic_game(){ init(); }
	void load_sprites();
};

extern basic_game* hra;

class sprite 
{
public:
	int x,y;
	float w,h;
	int time;
	int total_time;
	GLuint pict;	// sprite's picture
	bool delete_me;	// i want to be deleted
	void (sprite::*run)();
	sprite(int xx, int yy, GLuint p) : x(xx), y(yy), pict(p), delete_me(false), time(0), total_time(0), w(1.0f), h(1.0f) {}
	void update_time(int delta_time) { time += delta_time; total_time += delta_time; }
	virtual void collision_with_player() {}
};

class skore_sprite : public sprite
{
public:
	void fly() {
		if (time > 1) {
			time = 0;
			y++;
			if (total_time > 150) delete_me = true;
		}
	}
	skore_sprite(int xx, int yy, GLuint p) : sprite(xx,yy,p) { run = SFUNC(&skore_sprite::fly); w = 0.5f; h = 0.5f; }
};

class potvora_sprite : public sprite
{
	enum {vpravo, vlevo} smer;
public:
	void move();
	potvora_sprite(int xx, int yy, GLuint p) : sprite(xx,yy,p), smer(vpravo) { run = SFUNC(&potvora_sprite::move); }
	virtual void collision_with_player() { hra->want_death = true; }
};

class strela_sprite : public sprite
{
public:
	enum Smer {vpravo, vlevo} smer;
	void let();
	strela_sprite(int xx, int yy, GLuint p, Smer pocatecni_smer) : sprite(xx,yy,p), smer(pocatecni_smer) { run = SFUNC(&strela_sprite::let); h = 0.5f; }
};

class konec_sprite : public sprite
{
public:
	void hu() {}
	konec_sprite(int xx, int yy, GLuint p) : sprite(xx,yy,p) { run = SFUNC(&konec_sprite::hu); }
	virtual void collision_with_player() { hra->want_next_level = true; }
};

#endif