/* menu.c
 *
 * Peter Wang <tjaden@psynet.net>
 */


#include <allegro.h>
#include "alt.h"
#include "credits.h"
#include "cursor.h"
#include "data.h"
#include "menu.h"
#include "mousehit.h"
#include "play.h"
#include "scores.h"


static void show_menu()
{
    scare_mouse();
    clear(screen);
    set_palette(data[PALGUNSEL].dat);
    cursor_update();
    blit(data[GUNSEL].dat, screen, 0, 0, 0, 0, 320, 200);
    unscare_mouse();
}


void menu()
{
    int update = 1;

    show_mouse(screen);

    while (1) {
        if (mouse_b & 1) {
	    if (mousehit(29, 39, 76, 88))		/* pistol */
		play_pistol(), update = 1;
	    else if (mousehit(79, 39, 126, 88)) 	/* uzi */
		play_uzi(), update = 1;
	    else if (mousehit(129, 39, 226, 88))	/* shotgun */
		play_shotgun(), update = 1;
	    else if (mousehit(229, 39, 290, 88))	/* lazer */
		play_lazer(), update = 1;
	    else if (mousehit(90, 103, 230, 123))	/* alternate */
		alt_menu(), update = 1;
	    else if (mousehit(19, 152, 118, 170))	/* credit */
		credits(), update = 1;
	    else if (mousehit(123, 151, 227, 171))	/* hiscore */
		hall_of_fame(), update = 1;
	    else if (mousehit(228, 149, 288, 176) || key[KEY_ESC])
		break;

	    while (mouse_b);
	}
    
	if (update) 
	    show_menu(), update = 0;
    }

    show_mouse(NULL);
    while (mouse_b);
    clear_keybuf();
}
