/* intro.c
 *
 * Peter Wang <tjaden@psynet.net>
 */


#include <allegro.h>
#include "data.h"
#include "gamepal.h"
#include "intro.h"
#include "play.h"


static volatile int ticks;

static void ticker()
{
    ticks++;
}

END_OF_STATIC_FUNCTION(ticker);


static void start_ticker()
{
    LOCK_VARIABLE(ticks);
    LOCK_FUNCTION(ticker);
    ticks = 0;
    install_int(ticker, 10);
}


static void stop_ticker()
{
    remove_int(ticker);
}


static void fade_pic(int pic, int pal, SAMPLE *spl, int time)
{
    set_palette(black_palette);
    blit(data[pic].dat, screen, 0, 0, 0, 0, 320, 200);
    if (spl) play_sample(spl, 255, 128, 1000, 1);

    start_ticker();
    fade_in(data[pal].dat, 6 * (speed_up ? 1.5 : 1));
    while ((ticks < time) && (!keypressed()) && (!mouse_b));
    fade_out(6 * (speed_up ? 1.5 : 1));
    stop_ticker();

    if (spl) stop_sample(spl);
    if (keypressed()) clear_keybuf();
}


static void fire_writing(int img, int time)
{
    int frame = 0, fr = -10;
    int dying = 0, vol = 255, i;
    PALETTE pal;
    int fade_time;
    int fade_delta;

    if (!speed_up) {
	fade_time = 30;
	fade_delta = 1;
    }
    else {
	fade_time = 5;
	fade_delta = 6;
    }

    start_ticker();
    play_sample(data[SCRACKLE].dat, vol, 128, 1000, 1);

    while (dying < fade_time) {
	if (fr + 10 < ticks) {
	    if (++frame > 1) frame = 0;
	    blit(data[img + frame].dat, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
	    fr = ticks;
	}

	if (!dying) {
	    if ((ticks >= time) || (mouse_b) || (keypressed()))
		dying = 1;
	}
	else {
	    adjust_sample(data[SCRACKLE].dat, vol, 128, 1000, 1);
	    vol -= 2;

	    get_palette(pal);
	    for (i = 0; i < 255; i++) {
		pal[i].r = MAX(0, pal[i].r - fade_delta);
		pal[i].g = MAX(0, pal[i].g - fade_delta);
		pal[i].b = MAX(0, pal[i].b - fade_delta);
	    }
	    set_palette(pal);

	    dying++;
	}

	/* FIXME: computer speed dependent */
    }
    
    stop_sample(data[SCRACKLE].dat);
    stop_ticker();
    if (keypressed()) clear_keybuf();
}


void intro(void)
{
    fade_pic(PSYKLOGO, PALLOGO, 0, 200);
    fade_pic(WANTED, PALWANTED, data[SWIND].dat, 500);
    clear(screen); 
    set_game_palette();
    fire_writing(INSPIRED1, 500);

    clear(screen);
    set_game_palette();
}


void extro(void)
{
    clear(screen);
    set_game_palette();
    fire_writing(END1, 400);
}
