/* play.c - this file is truly dirty
 *
 * Peter Wang <tjaden@psynet.net>
 */


#include <stdio.h>
#include <allegro.h>
#include "alt.h"
#include "chunks.h"
#include "cursor.h"
#include "data.h"
#include "flashes.h"
#include "gamepal.h"
#include "mousehit.h"
#include "particle.h"
#include "play.h"
#include "random.h"
#include "scores.h"


/* pop up barneys and flags */
static struct pop {
    int y;
    int tics;
    int flags;
} pop[3][3], *pp;

#define RISING      1
#define WAITING     2
#define FALLING     4
#define RESTING     8
#define DYING       16
#define REALBARNEY  32
#define LTARMLESS   64
#define RTARMLESS   128
#define HEADLESS    256
#define BELLYLESS   512
#define ASH         1024

int frame, ani = 0, anitics = 0; /* real barney animation */

int gun;


static int h_ammo;		/* highest amount of ammo with current gun */
static int ammo;		/* current amount of ammo */
static BITMAP *ammopic;		/* pointer to current ammo pic */

static int letgo;		/* mouse has been let go */
static int letgo2;
static int wave;		/* delay for uzi/laser */

static BITMAP *dbuf;


/* Where do I put this?  */
int speed_up;


/*----------------------------------------------------------------------------

    Shooting Range

----------------------------------------------------------------------------*/

#define XPOS(x)     x*90+50
#define YPOS(y)     y*49+39


void UpdateBarneys(void)
{
    int u, v;

    for (v = 0; v < 3; v++) for (u = 0; u < 3; u++) {
	pp = &pop[v][u];

	/* resting */
	if (pp->flags & RESTING)
	    if (--pp->tics == 0) {
		pp->flags = RISING;
		if (!(rand() % realbarney))
		    pp->flags |= REALBARNEY;
	    }
	
	/* rising */
	if (pp->flags & RISING) {
	    pp->y += 5;
	    if (pp->y == 40) {
		pp->flags |= WAITING;
		pp->flags ^= RISING;
		pp->tics = rnd(50, 70);
	    }
	}

	/* waiting */
	if (pp->flags & WAITING) 
	    if (--pp->tics == 0) {
		pp->flags |= FALLING;
		pp->flags ^= WAITING;
	    }

	/* falling */
	if (pp->flags & FALLING) {
	    pp->y -= 5;
	    if (pp->y == 0) {
		pp->flags |= RESTING;
		pp->flags ^= FALLING;
		pp->tics = rnd(50, 300);
	    }
	}
	
	/* dying type falling (faster) */
	if (pp->flags & DYING) {
	    pp->y -= 8;
	    if (pp->y == 0) {
		pp->flags |= RESTING;
		pp->flags ^= DYING;
		pp->tics = rnd(50, 300);
	    }
	}
    }
}


void DrawBarneys(BITMAP *dbuf)
{
    int u, v;
    
    #define XY	XPOS(u), YPOS(v) + 40 - pp->y, 40, pp->y

    for (v = 0; v < 3; v++) for (u = 0; u < 3; u++) {
	pp = &pop[v][u];
	if (pp->flags & RESTING) continue;

	/* barney pics are 40*40 */
	if (pp->flags & LTARMLESS)
	    stretch_sprite(dbuf, data[BNOLTARM].dat, XY);
	else if (pp->flags & RTARMLESS)
	    stretch_sprite(dbuf, data[BNORTARM].dat, XY);
	else if (pp->flags & HEADLESS)
	    stretch_sprite(dbuf, data[BNOHEAD].dat, XY);
	else if (pp->flags & BELLYLESS)
	    stretch_sprite(dbuf, data[BNOBELLY].dat, XY);
	else if (pp->flags & ASH)
	    stretch_sprite(dbuf, data[BASH].dat, XY);
	else if (pp->flags & REALBARNEY)
	    stretch_sprite(dbuf, data[B0 + frame].dat, XY);
	else
	    stretch_sprite(dbuf, data[B0].dat, XY);
    }
    
    #undef XY
}


/* used by HandleUserInput */
void _hurtbarney(int x, int y)
{
    int i;

    score++;
    play_sample(data[SDIE1 + rand() % 4].dat, 255, 128+(mouse_x-160)/2, 1000, 0);
    for (i = rand()%5; i >= 0; i--)
	spawn_blood_flash(x + rnd(-10, 10), y + rnd(-10, 10));
    for (i = 0; i < 50; i++)
	spawn_blood_dot(x + rnd(-10, 10), y + rnd(-10, 10));
}

/* handles mouse clicks */
void HandleUserInput(void)
{
    int u, v, i, j;

    if (!(mouse_b & 1)) letgo = 1;
    if (!(mouse_b & 2)) letgo2 = 1;
    if (wave) wave--;

    if (mouse_b & 1) {		/* LMB fire */
	if (((gun == PISTOL || gun == SHOTGUN) && !letgo) ||
	    ((gun == UZI || gun == LAZER) && wave))
	    return;

	if (ammo <= 0) {
	    if (gun == PISTOL || gun == SHOTGUN) {
		play_sample(data[SREMIND].dat, 255, 128, 1000, 0);
		letgo = 0;
	    }
	    else if (!wave) {
		play_sample(data[SREMIND].dat, 255, 128, 1000, 0);
		wave = 32;
	    }
	    return;
	}
	
	for (v = 0; v < 3; v++) for (u = 0; u < 3; u++) {
	    i = XPOS(u);
	    j = YPOS(v);
	    
	    /* shootable? */
	    if (pop[v][u].flags & WAITING) {
		/* shotgun */
		if (gun == SHOTGUN) {
		    if (pop[v][u].flags & REALBARNEY) {
			/* left arm */
			if (mousehit(i, j, i + 13, j + 15)) {
			    pop[v][u].flags |= LTARMLESS;
			    pop[v][u].flags ^= WAITING;
			    pop[v][u].flags |= FALLING;
			    spawn_chunk(i, j, -4, rnd(-1, 2), -80, BLTARM);
			    _hurtbarney(mouse_x - 3, mouse_y - 3);
			}
			/* right arm */
			else if (mousehit(i + 29, j + 13, i + 39, j + 25)) {
			    pop[v][u].flags |= RTARMLESS;
			    pop[v][u].flags ^= WAITING;
			    pop[v][u].flags |= FALLING;
			    spawn_chunk(i + 29, j + 13, 4, rnd(-1, 2), 80, BRTARM);
			    _hurtbarney(mouse_x - 3, mouse_y - 3);
			}
			/* head */
			else if (mousehit(i + 12, j + 2, i + 35, j + 13)) {
			    pop[v][u].flags |= HEADLESS;
			    pop[v][u].flags ^= WAITING;
			    pop[v][u].flags |= FALLING;
			    spawn_chunk(i + 12, j + 2, rnd(-1, 2), -4, 0, BHEAD);
			    _hurtbarney(mouse_x - 3, mouse_y - 3);
			}
			/* belly */
			else if (mousehit(i + 7, j + 14, i + 28, j + 31)) {
			    pop[v][u].flags |= BELLYLESS;
			    pop[v][u].flags ^= WAITING;
			    pop[v][u].flags |= FALLING;
			    draw_sprite(data[GBACK].dat, data[GUTS].dat,
					rnd(97, 202), rnd(72, 120));
			    if (!speed_up) {
				set_palette(data[PALRED].dat);
				set_palette(data[PALGAME].dat);
			    }
			    _hurtbarney(mouse_x - 3, mouse_y - 3);
			}
		    }
		    /* not real barney */
		    else if (mousehit(i + 4, j + 1, i + 36, j + 37)) {
			pop[v][u].flags |= DYING;
			pop[v][u].flags ^= WAITING;
			_hurtbarney(mouse_x - 3, mouse_y - 3);
		    }
		}
		/* laser */
		else if (mousehit(i + 4, j + 1, i + 36, j + 37) && gun == LAZER) {
		    pop[v][u].flags |= FALLING;
		    /* don't use dying here so its slower so we 
		     can see the ash (use FALLING) */
		    pop[v][u].flags ^= WAITING;
		    
		    if (pop[v][u].flags & REALBARNEY) {
			pop[v][u].flags |= ASH;
			spawn_particles(i + 15 + rnd(5, 10), j + 15 + rnd(5, 10), 50, rnd(39, 55));	/* blood */
			spawn_particles(i + 15 + rnd(5, 10), j + 15 + rnd(5, 10), 50, rnd(240, 254));	/* purple bits */
		    }

		    if (!speed_up) {
			set_palette(data[PALRED].dat);
			set_palette(data[PALGAME].dat);
		    }
		    _hurtbarney(mouse_x - 5, mouse_y - 5);
		}
		/* other gun */
		else if (mousehit(i + 4, j + 1, i + 36, j + 37)) {
		    pop[v][u].flags |= DYING;
		    pop[v][u].flags ^= WAITING;
		    _hurtbarney(mouse_x - 3, mouse_y - 3);
		}
	    }
	}
	    
	if (gun == LAZER)
	    spawn_zap_flash(mouse_x - 12, mouse_y - 12);
	else
	    spawn_gun_flash(mouse_x - 12, mouse_y - 12);

	ammo--;
	shots++;
	    
	letgo = 0;
	
	if (gun == PISTOL)
	    play_sample(data[SFIREPISTOL].dat, 255, 128+(mouse_x-160)/2, 1000, 0);
	else if (gun == UZI) {
	    wave = 4;
	    if (ammo == 11) wave = 12;
	    play_sample(data[SFIREUZI].dat, 255, 128+(mouse_x-160)/2, 1000, 0);
	}
	else if (gun == SHOTGUN) 
	    play_sample(data[SFIRESHOTTY].dat, 255, 128+(mouse_x-160)/2, 1000, 0);
	else if (gun == LAZER) 
	    wave = 1;
    }
    /* RMB reload */
    else if ((mouse_b & 2) && letgo2) {
	ammo = h_ammo;
	play_sample(data[SRELOAD].dat, 255, 128, 1000, 0);
	letgo2 = 0;
	wave = 0;
    }
}


/* This timer keeps track of real time.  */

static volatile int game_clock;

static void game_clocker()
{
    game_clock++;
}

END_OF_STATIC_FUNCTION(game_clocker);


static void start_game_clock()
{
    LOCK_VARIABLE(game_clock);
    LOCK_FUNCTION(game_clocker);
    game_clock = 0;
    install_int(game_clocker, 10); /* 100 bps */
}


static void stop_game_clock()
{
    remove_int(game_clocker);
}


/* This timer keeps track of when an update loop should be done.  */

static volatile int game_ticks;

static void game_ticker()
{
    game_ticks++;
}

END_OF_STATIC_FUNCTION(game_ticker);


void start_game_ticker()
{
    LOCK_VARIABLE(game_ticks);
    LOCK_FUNCTION(game_ticker);
    game_ticks = 0;
    install_int_ex(game_ticker, BPS_TO_TIMER(60));
}


void stop_game_ticker()
{
    remove_int(game_ticker);
}


/* Drawing routine.  */

static void do_draw(BITMAP *dbuf, int timeleft)
{
    int i;
    char s[40];

    blit(data[GBACK].dat, dbuf, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
    draw_sprite(dbuf, data[GFRAME].dat, 0, 0);
    
    DrawBarneys(dbuf);
    
    /* draw ammo */
    if (gun == LAZER)
	for (i = 0; i < ammo; i++)
	    draw_sprite(dbuf, ammopic, i + 3, 182);
    else
	for (i = 0; i < ammo; i++)
	    draw_sprite(dbuf, ammopic, i * 7 + 3, 182);

    /* draw score */
    sprintf(s, "%03d", score);
    textout(dbuf, font, s, 260, 177, GAMEPAL_RED);
    
    /* draw time */
    sprintf(s, "%02d", timeleft);
    textout(dbuf, font, s, 280, 5, GAMEPAL_RED);
    
    draw_flashes(dbuf);
    draw_chunks(dbuf);
    draw_particles(dbuf);
    
    /* blit dbuf to screen */
    cursor_draw(dbuf);
    blit(dbuf, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
}


/* Main game routine.  */

static void play()
{
    int clkend, timeleft, timeleftprev = 0;
    int u, v;
    int draw = 0;
    
    for (v = 0; v < 3; v++) for (u = 0; u < 3; u++) {
	pop[v][u].y = 0;
	pop[v][u].flags = RESTING;
	pop[v][u].tics = rnd(10, 500);
    }
    
    init_flashes();
    init_particles();
    init_chunks();
    reset_score();

    rest(200);

    show_mouse(NULL);
    clear(screen);
    set_game_palette();

    dbuf = create_bitmap(SCREEN_W, SCREEN_H);

    start_game_ticker();
    start_game_clock();
    clkend = gamelength * 100;
    timeleft = clkend;

    /* The game loop.  */
    do {
	while (game_ticks > 0) {
	    /* update animation */
	    if (anitics++ > 10) {
		ani++;
		if (ani < 3)
		    frame = ani;
		if (ani == 3) {
		    frame = 1;
		    ani = -1;
		}
		anitics = 0;
	    }

	    UpdateBarneys();
	    HandleUserInput();
	    update_flashes();
	    update_chunks();
	    update_particles();

	    draw = 1;
	    game_ticks--;
	}

	if (draw) {
	    timeleft = (clkend - game_clock) / 100;
	    if (timeleft != timeleftprev) {
		timeleftprev = timeleft;
		if (timeleft <= 10)
		    play_sample(data[STIME].dat, 255, 128, 1000, 0);
	    }
	    
	    do_draw(dbuf, timeleft);
	    draw = 0;
	}
    } while (!key[KEY_ESC] && timeleft);

    stop_game_clock();
    stop_game_ticker();

    /* end of round */
    clear_keybuf();
    display_scores(gamelength == ALT_60SEC);

    while (mouse_b);
    clear_keybuf();
    while (!keypressed() && !mouse_b);
    while (mouse_b);
    
    destroy_bitmap(dbuf);

    show_mouse(screen);
}


/* Various game launchers.  */

void play_pistol()
{
    ammo = h_ammo = 6;
    ammopic = data[ABULLET].dat;
    gun = PISTOL;
    play_sample(data[SFIREPISTOL].dat, 255, 255, 1000, 0);

    play();
}
    

void play_uzi()
{
    ammo = h_ammo = 22;
    ammopic = data[ABULLET].dat;
    gun = UZI;
    play_sample(data[SFIREUZI].dat, 255, 255, 1000, 0);

    play();
}


void play_shotgun()
{
    ammo = h_ammo = 4;
    ammopic = data[ASHELL].dat;
    gun = SHOTGUN;
    play_sample(data[SFIRESHOTTY].dat, 255, 255, 1000, 0);
    
    play();
}


void play_lazer()
{
    ammo = h_ammo = 200;
    ammopic = data[AELEC].dat;
    gun = LAZER;
    
    play();
}
