/* particle.c
 *
 * Peter Wang <tjaden@psynet.net>
 */


#include <allegro.h>
#include "particle.h"
#include "random.h"


#define MAX_PARTICLES	100


static struct {
    float x, y;
    float xv, yv;
    int c;
    int alive;
} part[MAX_PARTICLES];


void init_particles()
{
    int i;

    for (i = 0; i < MAX_PARTICLES; i++)
	part[i].alive = 0;
}


void spawn_particles(int x, int y, int num, int col)
{
    int i;

    for (i = 0; (i < MAX_PARTICLES) && (num); i++)
	if (!part[i].alive) {
	    part[i].x = x;
	    part[i].y = y;
	    part[i].c = col;
	    do {
		part[i].xv = (float)rnd(-500, 500) / (float)100.0;
		part[i].yv = (float)rnd(-500, 500) / (float)100.0;
	    } while (!part[i].xv && !part[i].yv);
	    part[i].alive = 1;
	    num--;
	}
}


void update_particles()
{
    int i;

    for (i = 0; i < MAX_PARTICLES; i++) 
	if (part[i].alive) {
	    part[i].x += part[i].xv;
	    part[i].y += part[i].yv;
	    if ((part[i].x < 0) || (part[i].x >= SCREEN_W) ||
		(part[i].y < 0) || (part[i].y >= SCREEN_H))
		part[i].alive = 0;
	}
}


void draw_particles(BITMAP *dbuf)
{
    int i;

    for (i = 0; i < MAX_PARTICLES; i++) 
	if (part[i].alive) 
	    putpixel(dbuf, part[i].x, part[i].y, part[i].c);
}
