/* main.c
 *
 * Peter Wang <tjaden@psynet.net>
 */


#include <stdio.h>
#include <time.h>
#include <allegro.h>
#include "cursor.h"
#include "data.h"
#include "intro.h"
#include "menu.h"
#include "play.h"
#include "scores.h"


int main(int argc, char *argv[])
{
    int depth;

    srand(time(0));

    allegro_init();
    install_timer();
    install_keyboard();
    install_sound(DIGI_AUTODETECT, MIDI_NONE, NULL);

    if (install_mouse() < 0) {
	allegro_message("Error installing mouse.\n");
	return 1;
    }

    if (set_gfx_mode(GFX_AUTODETECT, 320, 200, 0, 0) < 0) {
	allegro_message("Error setting video mode.\n");
	return 1;
    }

    /* Certain parts of code feel much too slow under non
       8 bit displays.  */
    if ((depth = desktop_color_depth ()))
	speed_up = (depth != 8);
	
    if (load_data(argv[0]) < 0) {
	allegro_message("Error loading data.\n");
	return 1;
    }

    cursor_init();

    text_mode(-1);

    intro();
    play_sample(data[SANNOYING].dat, 255, 128, 1000, 0);

    menu();

    extro();

    cursor_shutdown();
    unload_data();

    return 0;
}

END_OF_MAIN();
