/* chunks.c
 *
 * Peter Wang <tjaden@psynet.net>
 */


#include <allegro.h>
#include "chunks.h"
#include "data.h"


#define MAX_CHUNKS     5


static struct chunk {
    int x, y;
    int vx, vy;
    int r;
    int pic;
    int alive;
} chunk[MAX_CHUNKS];


void spawn_chunk(int x, int y, int vx, int vy, int rotate, int pic)
{
    struct chunk *p;
    int i;

    for (i = 0; i < MAX_CHUNKS; i++)
	if (!chunk[i].alive) {
	    p = chunk + i;
	    p->x = x;
	    p->y = y;
	    p->vx = vx;
	    p->vy = vy;
	    p->r = rotate;
	    p->pic = pic;
	    p->alive = 1;
	    break;
	}
}


void update_chunks(BITMAP *dbuf)
{
    struct chunk *p;
    int i;

    for (i = 0; i < MAX_CHUNKS; i++) if (chunk[i].alive) {
	p = chunk + i;
	p->x += p->vx;
	p->y += p->vy;
	
	if ((p->x < 0) || (p->x >= SCREEN_W) ||
	    (p->y < 0) || (p->y >= SCREEN_H))
	    p->alive = 0;
    }
}


void draw_chunks(BITMAP *dbuf)
{
    struct chunk *p;
    int i;

    for (i = 0; i < MAX_CHUNKS; i++) if (chunk[i].alive) {
	p = chunk + i;
	if (p->r) {
	    rotate_sprite(dbuf, data[p->pic].dat, p->x, p->y, itofix(p->r));
	    p->r = (p->r + 1) ^ 0xff;
	}
	else
	    draw_sprite(dbuf, data[p->pic].dat, p->x, p->y);
    }
}


void init_chunks(void)
{
    int i;
    
    for (i = 0; i < MAX_CHUNKS; i++)
	chunk[i].alive = 0;
}
