/* alt.c
 *
 * Peter Wang <tjaden@psynet.net>
 */


#include <allegro.h>
#include "alt.h"
#include "data.h"
#include "mousehit.h"


int realbarney = ALT_NORMAL;
int gamelength = ALT_60SEC;


static void make_alt_screen(BITMAP *dbuf)
{
    blit(data[OALTBACK].dat, dbuf, 0, 0, 0, 0, 320, 200);

    draw_sprite(dbuf, data[OALLREALBARNEYS].dat, 50, 40);
    draw_sprite(dbuf, data[OPLAYFOR].dat, 110, 120);

    if (realbarney == ALT_ALLREAL)
	draw_sprite(dbuf, data[OON].dat, 130, 70);
    else
	draw_sprite(dbuf, data[OOFF].dat, 130, 70);
    
    if (gamelength == ALT_60SEC)
	draw_sprite(dbuf, data[O1MIN].dat, 100, 150);
    else
	draw_sprite(dbuf, data[O3MIN].dat, 100, 150);
}


void alt_menu()
{
    BITMAP *dbuf;
    int update = 1;
    
    dbuf = create_bitmap(SCREEN_W, SCREEN_H);

    while (!(mouse_b & 2) && !(key[KEY_ESC])) {
	if (update) {
	    make_alt_screen(dbuf);
	    scare_mouse();
	    blit(dbuf, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
	    unscare_mouse();
	    update = 0;

	    while (mouse_b);
	}

	if (mouse_b & 1) {
	    if (mousehit(130, 70, 174, 89)) {
		realbarney = (realbarney == ALT_NORMAL) ? ALT_ALLREAL : ALT_NORMAL;
		update = 1;
	    }
	    else if (mousehit(100, 150, 235, 172)) {
		gamelength = (gamelength == ALT_60SEC) ? ALT_3MIN : ALT_60SEC;
		update = 1;
	    }
	}
    }
    
    while (mouse_b);
    
    destroy_bitmap(dbuf);
}
