/* scores.c
 *
 * Peter Wang <tjaden@psynet.net>
 */


#include <stdio.h>
#include <string.h>
#include <allegro.h>
#include "data.h"
#include "gamepal.h"
#include "play.h"


#ifdef ALLEGRO_UNIX
#define GLOBAL_SCORES_FILE	"/var/games/barney-scores.hi"
#endif
#define LOCAL_SCORES_FILE	"scores.hi"


#define NAME_LEN	20


int score, shots;


static struct hi {
    int score;
    char name[NAME_LEN+1];
} hi[NUMGUNS][3];


static void set_default_high_scores()
{
    int i;
    
    for (i = 0; i < NUMGUNS; i++) {
	hi[i][0].score = 0;
	hi[i][1].score = 0;
	hi[i][2].score = 0;
	strcpy(hi[i][0].name, "Nil");
	strcpy(hi[i][1].name, "Nil");
	strcpy(hi[i][2].name, "Nil");
    }
}


static void write_high_scores()
{
    FILE *fp;
    int i, j;

#ifdef ALLEGRO_UNIX
    fp = fopen(GLOBAL_SCORES_FILE, "w");
    if (fp) goto opened;
#endif
    
    fp = fopen(LOCAL_SCORES_FILE, "w");
    if (!fp) return;

  opened:
    
    for (i = 0; i < NUMGUNS; i++)
	for (j = 0; j < 3; j++)
	    fprintf(fp, "%03d%s\n", hi[i][j].score, hi[i][j].name);
    
    fclose(fp);
}


static void read_high_scores()
{
    FILE *fp;
    char buf[128];
    char num[5];
    int i, j;

    set_default_high_scores();

#ifdef ALLEGRO_UNIX
    fp = fopen(GLOBAL_SCORES_FILE, "r");
    if (fp) goto opened;
#endif

    fp = fopen(LOCAL_SCORES_FILE, "r");
    if (!fp) return;

  opened:
    
    for (i = 0; i < NUMGUNS; i++)
	for (j = 0; j < 3; j++) {
	    if (!fgets(buf, sizeof buf, fp))
		goto end;
	    if (strlen(buf) < 4)
		continue;
	    buf[strlen(buf)-1] = 0;
	    
	    strncpy(num, buf, 3); 
	    num[3] = 0;
	    hi[i][j].score = atoi(num);

	    strcpy(hi[i][j].name, buf+3);
	}

  end: 
    
    fclose(fp);
}


static void enter_name(char *s)
{
    BITMAP *tmp;
    int c, l = 7;

    /* make a copy */
    tmp = create_bitmap(SCREEN_W, SCREEN_H);
    blit(screen, tmp, 0, 0, 0, 0, SCREEN_W, SCREEN_H);

    strcpy(s, "HISCORE");
    textout_centre(screen, font, s, 160, 170, GAMEPAL_YELLOW);

    while (1) {
	c = readkey();
	if ((c >> 8) == KEY_ENTER)
	    break;
	c &= 0xff;
	if ((c == 8) && l > 0)
	    s[--l] = 0;
	else if ((c > 31) && (c < 127) && (l < 11)) {
	    s[l] = c;
	    s[++l] = 0;
	}

	blit(tmp, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
	textout_centre(screen, font, s, 160, 170, GAMEPAL_YELLOW);
    }
    
    destroy_bitmap(tmp);
}


void display_scores(int allow_highscore)
{
    char s[80];
    int i, j;

    scare_mouse();
    textout_centre(screen, font, "STATS", 160, 20, GAMEPAL_RED);
    sprintf(s, "SHOTS: %03d", shots);
    textout(screen, font, s, 30, 50, GAMEPAL_BLUE);
    sprintf(s, "KILLS:  %03d", score);
    textout(screen, font, s, 30, 90, GAMEPAL_BLUE);
    if (shots) {
	sprintf(s, "ACCURACY: %.1f%%", (float)score / shots * 100);
	textout(screen, font, s, 30, 130, GAMEPAL_BLUE);
    }

    /* check if new high score */
    if (allow_highscore) {
	read_high_scores();
	
	for (i = 0; i < 3; i++)
	    if (score > hi[gun][i].score) {
		enter_name(s);
		for (j = 2; j > i; j--) {
		    hi[gun][j].score = hi[gun][j - 1].score;
		    strcpy(hi[gun][j].name, hi[gun][j - 1].name);
		}
		hi[gun][i].score = score;
		strcpy(hi[gun][i].name, s);
		write_high_scores();
		break;
	    }
    }

    unscare_mouse();
}


static void wait_click()
{
    while (!mouse_b);
    while (mouse_b);
    while (!mouse_b);
}


void hall_of_fame()
{
    static char gunnames[][8] = { "PISTOL", "UZI", "SHOTGUN", "LASER" };
    BITMAP *dbuf;
    char s[10];
    int i, g;

    /* The user should get to click Prev / Next / Exit.  */
    
    dbuf = create_bitmap(SCREEN_W, SCREEN_H);
    
    scare_mouse();
    clear(screen);
    set_game_palette();
    unscare_mouse();

    read_high_scores();

    for (g = 0; g < NUMGUNS; g++) {
	blit(data[HISCORES].dat, dbuf, 0, 0, 0, 0, 320, 200);
	textout_centre(dbuf, font, gunnames[g], 160, 40, GAMEPAL_YELLOW);
	for (i = 0; i < 3; i++) {
	    textout(dbuf, font, hi[g][i].name, 60, 70 + i * 30, GAMEPAL_RED);
	    sprintf(s, "%d", hi[g][i].score);
	    textout(dbuf, font, s, 260, 70 + i * 30, GAMEPAL_RED);
	}

	scare_mouse();
	blit(dbuf, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
	unscare_mouse();
	wait_click();
    }
    
    destroy_bitmap(dbuf);
    
    while (mouse_b);
}


void reset_score()
{
    score = shots = 0;
}
