/*
 * "Mirkwood Forest" By Jon
 * February, 2003
 */

#include <conio.h>
#include <pc.h>
#include <stdlib.h>
#include <allegro.h>
#include <time.h>
#include <iostream.h>
#include <fstream.h>
#include <string.h>

#define INTRO
#define VERSION "4.5"
#define GRASS 46
#define ROCK 233
#define ROCK_COLOR 8
#define TREE_COLOR 2
#define TREE 157
#define FLOOR 249
#define WATER 176
#define WATER_COLOR 11
#define FLOOR_COLOR 6
#define GRASS_COLOR 6
#define SHOP_FREQUENCY 50
#define GOLLUM_FREQUENCY 50
#define FOOD_FREQUENCY 50
#define WALL_FREQUENCY 70
#define GRASS_FREQUENCY 50
#define TREE_FREQUENCY 80
#define ROCK_FREQUENCY 50
#define PLAYER 2
#define PLAYER_COLOR 15
#define SCREENW 80
#define SCREENH 25
#define COINS 5
#define MONSTER_TYPES 70
#define MONSTER_CHAR 234
#define MONSTER_COLOR 5
#define SP 15
#define SP_CHAR 15
#define SP_COLOR 12
#define FOOD_CHAR 235
#define FOOD_COLOR 13
#define FOOD_MAX 10
#define TEXT_SPEED 50
#define MAPS 20
#define RUN_CHANCE 75
#define SWORD 197
#define SHORT_SWORD 116
#define ORC_SWORD 184
#define AXE 226
#define BOW 238
#define CLUB 33
#define SWORD_COLOR 7
#define SHIELD 79
#define SHIELD_COLOR 7
#define BROAD_SWORD 215
#define KATANA 41
#define DAGGER 231
#define WAND 73
#define ROD 179
#define STAFF 244
#define GLOVES 225
#define ELEMENTS 5
#define FIRE 0
#define ICE 1
#define THUNDER 2
#define EARTH 3
#define POISON 4
#define MONSTERS 70
#define ZOMBIE 0
#define ZOM_WEAK 0
#define ZOM_WEAK_NAME "Fire Elemental"
#define SKELETON 1
#define SKE_WEAK 1
#define SKE_WEAK_NAME "Ice Elemental"
#define SPIDER 2
#define SPI_WEAK 2
#define SPI_WEAK_NAME "Thunder Elemental"
#define FOREST_TROLL 3
#define FOR_WEAK 3
#define FOR_WEAK_NAME "Earth Elemental"
#define ENT 4
#define ENT_WEAK 0
#define ENT_WEAK_NAME "Fire Elemental"
#define WURM 5
#define WUR_WEAK 2
#define WUR_WEAK_NAME "Thunder Elemental"
#define RAT 6
#define RAT_WEAK 4
#define RAT_WEAK_NAME "Poison Elemental"
#define ORC_MONSTER 7
#define ORC_WEAK 3
#define ORC_WEAK_NAME "Earth Elemental"
#define DRYAD 8
#define DRY_WEAK 4
#define DRY_WEAK_NAME "Poison Elemental"
#define BEAR 9
#define BEA_WEAK 1
#define BEA_WEAK_NAME "Ice Elemental"
#define BOAR 10
#define BOA_WEAK 1
#define BOA_WEAK_NAME "Ice Elemental"
#define GOOD 1
#define EVIL 2
#define GOLLUM 21

int monster_x[MONSTERS];
int monster_y[MONSTERS];
bool monster_on_map[MONSTERS];
int gollum_x;
int gollum_y;
bool gollum_on_screen;
int sp_x[SP];
int sp_y[SP];
bool sp_on_map[SP];
int shop_x;
int shop_y;
bool shop_on_screen;
int food_x;
int food_y;
bool food_on_screen;
int gold_x[COINS];
int gold_y[COINS];
bool gold_on_map[COINS];
int level[SCREENH][SCREENW];
bool sword_on_map;
int sword_x;
int sword_y;
bool shield_on_map;
int shield_x;
int shield_y;
bool end;

void random_world();
void draw_level();
void gold_setter();
void monster_setter();
void equip_setter();
void sp_setter();
void shop_setter();
void food_setter();
void gollum_setter();
void draw_ascii_picture(char*filename);

class player
{
 public:
 int p_color;
 int p_bgcolor;
 int p_graphic;
 int turns;
 int x;
 int y;
 int old_x;
 int old_y;
 int max_hp;
 int hp;
 int mp;
 int max_mp;
 int atk;
 int def;
 int agl;
 int mag;
 int gp;
 int exp;
 bool repel;
 int repel_counter;
 int nl_exp;
 int elevel;
 int recover;
 int sp;
 int food;
 int cure_magic_level;
 bool player_won;
 int type_mon_killed[MONSTER_TYPES];
 int map_number;
 char name[50];
 int align_id;
 int amulet[ELEMENTS];
 char*type;
 char*align;
 char*weapontype;
 char*gender;
 int wpn_level;
 int shld_level;
 int weapon;
 int found_eqp;
 int monster_ded;
 void gold_handler();
 void monster_handler();
 void sp_handler();
 void monster_collide();
 void gollum_handler();
 void draw();
 void input();
 void teleport();
 void menu();
 void init_stats();
 void battle();
 void level_gain();
 void equip_handler();
 void shop_handler();
 void food_handler();
 void shop();
};

int main()
{
 end=false;
 player hero;
 hero.x=1;
 hero.y=SCREENH;
 textmode(MONO);
 _setcursortype(_NORMALCURSOR);
 _set_screen_lines(28);
 clrscr();
 #ifdef INTRO
 draw_ascii_picture("mflogo.txt");
 cout<<"`Mirkwood Forest'\n";
 cout<<"By: Jon\n";
 #endif
 cout<<"{Version Information} "<<VERSION<<endl;
 #ifdef DEBUG
 cout<<"{DEBUG ENABLED}\n";
 #endif
 cout<<"{Date of Version} "<<__DATE__<<" at "<<__TIME__<<endl;
 cout<<"What is your name? ";
 cin>>hero.name;
 _set_screen_lines(25);
 allegro_init();
 install_keyboard();
 hero.init_stats();
 if(end==true) return 0;
 clrscr();
 srand(time(NULL));
 textmode(C80);
 random_world();
 gotoxy(1,1);
 draw_level();
 hero.draw();
 hero.gold_handler();
 hero.sp_handler();
 hero.shop_handler();
 hero.gollum_handler();
 hero.monster_handler();
 hero.food_handler();
 _setcursortype(_NOCURSOR);
 while(end==false)
 {
  if(hero.map_number==MAPS)
  {
   clrscr();
   textmode(MONO);
   rest(500);
   char score_text;
   ofstream score_file("mfwin.txt",ios::app);
   score_file<<hero.name<<" the "<<hero.align<<" "<<hero.gender<<" "<<hero.type<<" after "<<hero.turns<<" turns."<<endl;
   cout<<hero.name<<" the "<<hero.align<<" "<<hero.gender<<" "<<hero.type<<" escaped the forest!\n";
   cout<<hero.name<<"'s "<<hero.weapontype<<" was at level "<<hero.wpn_level<<".\n";
   cout<<hero.name<<"'s shield was at level "<<hero.shld_level<<".\n";
   cout<<hero.name<<" had "<<hero.gp<<" gold\n";
   cout<<hero.name<<" had "<<hero.food<<" food\n";
   cout<<hero.name<<" got through "<<hero.map_number<<" parts of the forest\n";
   cout<<hero.name<<" found the equipment of "<<hero.found_eqp<<" fallen explorers.\n";
   cout<<hero.name<<" slayed "<<hero.monster_ded<<" monsters.\n";
   cout<<hero.name<<" was at level "<<hero.elevel<<endl;
   cout<<hero.name<<" had "<<hero.exp<<" experience."<<endl;
   cout<<hero.name<<"'s maximum MP was "<<hero.max_mp<<endl;
   cout<<hero.name<<"'s maximum HP was "<<hero.max_hp<<endl;
   cout<<hero.name<<" had "<<hero.sp<<" SP.\n";
   cout<<hero.name<<"'s attack power was "<<hero.atk<<endl;
   cout<<hero.name<<"'s defensive power was "<<hero.def<<endl;
   cout<<hero.name<<"'s agility was "<<hero.agl<<endl;
   cout<<hero.name<<"'s magic power was "<<hero.mag<<endl;
   cout<<"(Press a key other than ESC to view winners, ESC to exit)\n";
   clear_keybuf();
   readkey();
   if(key[KEY_ESC]) return 0;
   clrscr();
   cout<<"Winners:\n";
   cout<<"----------------\n";
   score_file.close();
   ifstream score_file_read("mfwin.txt");
   score_text=score_file_read.get();
   while(score_text!=EOF&&!key[KEY_ESC])
   {
    cout<<score_text;
    score_text=score_file_read.get();
   }
   score_file_read.close();
   cout<<"-----------------\n(Press any key...)\n";
   clear_keybuf();
   readkey();
   return 0;
  }
  if(keypressed())
  {
   hero.turns++;
   if(hero.exp>=hero.nl_exp) hero.level_gain();
   gotoxy(hero.x,hero.y);
   if(level[hero.y][hero.x]==GRASS) textcolor(GRASS_COLOR);
   if(level[hero.y][hero.x]==FLOOR) textcolor(FLOOR_COLOR);
   if(level[hero.y][hero.x]==FLOOR||level[hero.y][hero.x]==GRASS)
   {
    putch(level[hero.y][hero.x]);
   }
   if(level[hero.y][hero.x]!=FLOOR&&level[hero.y][hero.x]!=GRASS)
   {
    textcolor(GRASS_COLOR);
    putch(GRASS);
   }
   hero.input();
   if(end==true) break;
   if(hero.repel_counter>0)
   {
    hero.repel_counter--;
    if(hero.repel_counter==0)
    {
     hero.repel=false;
     char text[]="Evasion shield faded away...(Press a key)";
     textcolor(7);
     gotoxy(1,SCREENH);
     for(int i=0;i<sizeof(text);i++)
     {
      putch(text[i]);
      rest(TEXT_SPEED);
     }
     clear_keybuf();
     readkey();
     gotoxy(1,SCREENH);
     for(int x=1;x!=SCREENW;x++)
     {
      textcolor(GRASS_COLOR);
      putch(GRASS);
     }
    }
   }
   if(hero.repel==false) hero.monster_collide();
   hero.monster_handler();
   if(hero.repel==false) hero.monster_collide();
   hero.draw();
   hero.gold_handler();
   hero.equip_handler();
   hero.sp_handler();
   hero.shop_handler();
   hero.food_handler();
   hero.gollum_handler();
   if(hero.y<2) hero.teleport();
  }
 }
 return 0;
}

void random_world()
{
 int tile;
 for(int y=1;y!=SCREENH;y++)
 {
  for(int x=1;x!=SCREENW;x++)
  {
   tile=(rand()%100);
   if(tile>=WALL_FREQUENCY)
   {
    int type=rand()%100;
    if(type<TREE_FREQUENCY) level[y][x]=TREE;
    if(type>=TREE_FREQUENCY)
    {
     int other_tiles=rand()%100;
     if(other_tiles<ROCK_FREQUENCY) level[y][x]=ROCK;
     if(other_tiles>=ROCK_FREQUENCY) level[y][x]=WATER;
    }
   }
   if(tile<WALL_FREQUENCY)
   {
    int type=rand()%100;
    if(type<GRASS_FREQUENCY) level[y][x]=FLOOR;
    if(type>=GRASS_FREQUENCY) level[y][x]=GRASS;
   }
  }
 }
 gold_setter();
 equip_setter();
 monster_setter();
 sp_setter();
 shop_setter();
 food_setter();
 gollum_setter();
}

void draw_level()
{
 int x,y;
 for(y=1;y!=SCREENH;y++)
 {
  for(x=1;x!=SCREENW;x++)
  {
   if(level[y][x]==FLOOR) textcolor(FLOOR_COLOR);
   if(level[y][x]==ROCK) textcolor(ROCK_COLOR);
   if(level[y][x]==TREE) textcolor(TREE_COLOR);
   if(level[y][x]==GRASS) textcolor(GRASS_COLOR);
   if(level[y][x]==WATER) textcolor(WATER_COLOR);
   putch(level[y][x]);
  }
  if(x==SCREENW) cout<<endl;
 }
 for(int x=1;x!=SCREENW;x++)
 {
  textcolor(GRASS_COLOR);
  putch(GRASS);
 }
}

void monster_setter()
{
 for(int i=0;i<MONSTERS;i++)
 {
 int mplace_x,mplace_y;
 do{
  mplace_x=rand()%SCREENW;
  mplace_y=rand()%SCREENH;
 }while(level[mplace_y][mplace_x]!=GRASS&&level[mplace_y][mplace_x]!=FLOOR);
  monster_x[i]=mplace_x;
  monster_y[i]=mplace_y;
  monster_on_map[i]=true;
 }
}

void gold_setter()
{
 for(int i=0;i<COINS;i++)
 {
 int place_x,place_y;
 do{
  place_x=rand()%SCREENW;
  place_y=rand()%SCREENH;
 }while(level[place_y][place_x]!=GRASS&&level[place_y][place_x]!=FLOOR);
  gold_x[i]=place_x;
  gold_y[i]=place_y;
  gold_on_map[i]=true;
 }
}

void shop_setter()
{
 int place_x,place_y;
 do{
  place_x=rand()%(SCREENW-1);
  place_y=rand()%(SCREENH-1);
 }while(level[place_y][place_x]!=GRASS&&level[place_y][place_x]!=FLOOR);
 shop_x=place_x;
 shop_y=place_y;
 shop_on_screen=false;
 int shop_maybe=(rand()%100)+1;
 if(shop_maybe>=SHOP_FREQUENCY) shop_on_screen=true;
 else shop_on_screen=false;
}

void gollum_setter()
{
 int place_x,place_y;
 do{
  place_x=rand()%(SCREENW-1);
  place_y=rand()%(SCREENH-1);
 }while(level[place_y][place_x]!=GRASS&&level[place_y][place_x]!=FLOOR);
 gollum_x=place_x;
 gollum_y=place_y;
 gollum_on_screen=false;
 int gollum_maybe=(rand()%100)+1;
 if(gollum_maybe>=GOLLUM_FREQUENCY) gollum_on_screen=true;
 else gollum_on_screen=false;
}

void food_setter()
{
 int place_x,place_y;
 do{
  place_x=rand()%(SCREENW-1);
  place_y=rand()%(SCREENH-1);
 }while(level[place_y][place_x]!=GRASS&&level[place_y][place_x]!=FLOOR);
 food_x=place_x;
 food_y=place_y;
 food_on_screen=false;
 int food_maybe=(rand()%100)+1;
 if(food_maybe>=FOOD_FREQUENCY) food_on_screen=true;
 else food_on_screen=false;
}

void sp_setter()
{
 for(int i=0;i<SP;i++)
 {
 int place_x,place_y;
 do{
  place_x=rand()%SCREENW;
  place_y=rand()%SCREENH;
 }while(level[place_y][place_x]!=GRASS&&level[place_y][place_x]!=FLOOR);
  sp_x[i]=place_x;
  sp_y[i]=place_y;
  sp_on_map[i]=true;
 }
}

void equip_setter()
{
 int place_x,place_y;
 do{
  place_x=rand()%SCREENW;
  place_y=rand()%SCREENH;
 }while(level[place_y][place_x]!=GRASS&&level[place_y][place_x]!=FLOOR);
 shield_x=place_x;
 shield_y=place_y;
 shield_on_map=true;
 do{
  place_x=rand()%SCREENW;
  place_y=rand()%SCREENH;
 }while(level[place_y][place_x]!=GRASS&&level[place_y][place_x]!=FLOOR);
 sword_x=place_x;
 sword_y=place_y;
 sword_on_map=true;
}

void draw_ascii_picture(char*filename)
{
 ifstream picture(filename);
 char ch=picture.get();
 while(ch!=EOF)
 {
  cout<<ch;
  ch=picture.get();
 }
 cout<<endl;
 picture.close();
}

void player::init_stats()
{
 memset(type_mon_killed,0,sizeof(type_mon_killed));
 memset(amulet,0,sizeof(amulet));
 int p_styles[4];
 p_styles[0]=1;
 p_styles[1]=2;
 p_styles[2]=64;
 p_styles[3]=234;
 int style_chooser=PLAYER;
 wpn_level=1;
 sp=0;
 shld_level=1;
 found_eqp=0;
 monster_ded=0;
 map_number=0;
 cure_magic_level=1;
 exp=0;
 elevel=1;
 nl_exp=10;
 recover=0;
 gp=0;
 turns=0;
 food=0;
 repel=false;
 textmode(C80);
 p_color=7;
 p_graphic=PLAYER;
 p_bgcolor=0;
 while(true)
 {
  clrscr();
  textcolor(7);
  cout<<"What does "<<name<<" look like?\n";
  cout<<"Choose your player icon:\n";
  cout<<(char)218<<(char)196<<(char)196<<(char)196<<(char)191<<endl;
  putch(179);
  putch(0);
  textcolor(p_color);
  textbackground(p_bgcolor);
  putch(p_graphic);
  textcolor(7);
  textbackground(0);
  putch(0);
  putch(179);
  cout<<endl<<(char)192<<(char)196<<(char)196<<(char)196<<(char)217;
  cout<<"\nColor:    "<<p_color<<"/15\n";
  cout<<"BG Color: "<<p_bgcolor<<"/7\n";
  cout<<"{Up/Down} Increase/Decrease color\n";
  cout<<"{Left/Right} Increase/Decrease background color\n";
  cout<<"{S} Change style\n";
  cout<<"{Enter} Accept\n";
  cout<<"{Escape} Exit\n";
  clear_keybuf();
  readkey();
  if(key[KEY_UP])
  {
   if(p_color<15) p_color++;
   if(p_graphic==MONSTER_CHAR&&p_color==MONSTER_COLOR)
   {
    p_color++;
    if(p_color>15) p_color=0;
   }
  }
  if(key[KEY_DOWN])
  {
   if(p_color>0) p_color--;
   if(p_graphic==MONSTER_CHAR&&p_color==MONSTER_COLOR)
   {
    p_color--;
    if(p_color<0) p_color=15;
   }
  }
  if(key[KEY_LEFT])
  {
   if(p_bgcolor<7) p_bgcolor++;
  }
  if(key[KEY_RIGHT])
  {
   if(p_bgcolor>0) p_bgcolor--;
  }
  if(key[KEY_S])
  {
   if(style_chooser==3) style_chooser=0;
   else style_chooser++;
   p_graphic=p_styles[style_chooser];
   if(p_color==MONSTER_COLOR&&p_graphic==MONSTER_CHAR) p_graphic=PLAYER;
  }
  if(key[KEY_ENTER]) break;
  if(key[KEY_ESC])
  {
   end=true;
   break;
  }
 }
 if(end==true) return;
 while(true)
 {
  max_hp=(rand()%12)+1;
  max_hp+=60;
  hp=max_hp;
  max_mp=(rand()%12)+1;
  max_mp+=10;
  mp=max_mp;
  atk=(rand()%12)+1;
  atk+=10;
  def=(rand()%12)+1;
  def+=10;
  agl=(rand()%12)+1;
  agl+=10;
  mag=(rand()%12)+1;
  mag+=10;
  clrscr();
  textcolor(p_color);
  textbackground(p_bgcolor);
  putch(p_graphic);
  textcolor(7);
  textbackground(0);
  cout<<" "<<name<<":\n";
  cout<<"+------------+------+\n";
  cout<<"|    Stat    | Amnt |\n";
  cout<<"+------------+------+\n";
  cout<<"| Maximum HP |  "<<max_hp<<"  |"<<endl;
  cout<<"| Maximum MP |  "<<max_mp<<"  |"<<endl;
  cout<<"| Attack     |  "<<atk<<"  |"<<endl;
  cout<<"| Defense    |  "<<def<<"  |"<<endl;
  cout<<"| Agility    |  "<<agl<<"  |"<<endl;
  cout<<"| Magic      |  "<<mag<<"  |"<<endl;
  cout<<"+------------+------+\n";
  cout<<"{R} Re-roll -|- {A} Accept -|- {Escape} Quit game"<<endl;
  clear_keybuf();
  readkey();
  if(key[KEY_A]) break;
  if(key[KEY_ESC])
  {
   end=true;
   return;
  }
 }
 while(true)
 {
  clrscr();
  textcolor(p_color);
  textbackground(p_bgcolor);
  putch(p_graphic);
  textcolor(7);
  textbackground(0);
  cout<<" "<<name<<" the..."<<endl;
  cout<<"+-----------+-----+\n";
  cout<<"| Alignment | Key |\n";
  cout<<"+-----------+-----+\n";
  cout<<"| Good      | {G} |"<<endl;
  cout<<"| Evil      | {E} |"<<endl;
  cout<<"+-----------+-----+\n";
  cout<<"{Key} Choose alignment -|- {Escape} Quit game"<<endl;
  clear_keybuf();
  readkey();
  if(key[KEY_G])
  {
   align="Good";
   align_id=GOOD;
   break;
  }
  if(key[KEY_E])
  {
   align="Evil";
   align_id=EVIL;
   break;
  }
  if(key[KEY_ESC])
  {
   end=true;
   return;
  }
 }
 clear_keybuf();
 while(true)
 {
  clrscr();
  textcolor(p_color);
  textbackground(p_bgcolor);
  putch(p_graphic);
  textcolor(7);
  textbackground(0);
  cout<<" "<<name<<" the "<<align<<"..."<<endl;
  cout<<"+---------+------+\n";
  cout<<"| Gender  |  Key |\n";
  cout<<"+---------+------+\n";
  cout<<"| Male    |  {M} |"<<endl;
  cout<<"| Female  |  {F} |"<<endl;
  cout<<"+---------+------+\n";
  cout<<"{Key} Choose gender -|- {Escape} Quit game"<<endl;
  clear_keybuf();
  readkey();
  if(key[KEY_M])
  {
   gender="Male";
   break;
  }
  if(key[KEY_F])
  {
   gender="Female";
   break;
  }
  if(key[KEY_ESC])
  {
   end=true;
   return;
  }
 }
 clear_keybuf();
 clrscr();
 _set_screen_lines(35);
 textcolor(p_color);
 textbackground(p_bgcolor);
 putch(p_graphic);
 textcolor(7);
 textbackground(0);
 cout<<" "<<name<<" the "<<align<<" "<<gender<<"...\n";
 cout<<"+-----+-----------+-------------+----------+--------------+\n";
 cout<<"| Key |   Type    | Status Chng | Algn Bns |    Weapon    |\n";
 cout<<"+-----+-----------+-------------+----------+--------------+\n";
 cout<<"| {F} | Monk      | ATK+2 MAG-2 | Good MAG | Gloves      "<<(char)GLOVES<<"|\n";
 cout<<"| {T} | Minotaur  | ATK+2 AGL-2 | Evil AGL | Club        "<<(char)CLUB<<"|\n";
 cout<<"| {W} | Warrior   | ATK+2 MAG-2 | Evil MAG | Club        "<<(char)CLUB<<"|\n";
 cout<<"| {K} | Knight    | ATK+2 AGL-2 | Good AGL | Sword       "<<(char)SWORD<<"|\n";
 cout<<"| {N} | Ninja     | ATK+2 DEF-2 | Evil DEF | Katana      "<<(char)KATANA<<"|\n";
 cout<<"| {J} | Archer    | ATK+2 DEF-2 | Good DEF | Bow         "<<(char)BOW<<"|\n";
 cout<<"| {Y} | Samurai   | AGL+2 MAG-2 | Good MAG | Katana      "<<(char)KATANA<<"|\n";
 cout<<"| {R} | Ranger    | AGL+2 DEF-2 | Evil DEF | Sword       "<<(char)SWORD<<"|\n";
 cout<<"| {I} | Rogue     | AGL+2 ATK-2 | Evil DEF | Short Sword "<<(char)SHORT_SWORD<<"|\n";
 cout<<"| {E} | Elf       | AGL+2 DEF-2 | Good DEF | Bow         "<<(char)BOW<<"|\n";
 cout<<"| {H} | Halfling  | AGL+2 ATK-2 | Good ATK | Short Sword "<<(char)SHORT_SWORD<<"|\n";
 cout<<"| {M} | Swordsman | AGL+2 MAG-2 | Evil MAG | Broad Sword "<<(char)BROAD_SWORD<<"|\n";
 cout<<"| {Q} | Barbarian | DEF+2 MAG-2 | Good MAG | Club        "<<(char)CLUB<<"|\n";
 cout<<"| {U} | Uruk-hai  | DEF+2 ATK-2 | Evil ATK | Orc Sword   "<<(char)ORC_SWORD<<"|\n";
 cout<<"| {D} | Dwarf     | DEF+2 ATK-2 | Good ATK | Axe         "<<(char)AXE<<"|\n";
 cout<<"| {C} | Gnome     | DEF+2 AGL-2 | Good AGL | Axe         "<<(char)AXE<<"|\n";
 cout<<"| {O} | Orc       | DEF+2 AGL-2 | Evil AGL | Orc Sword   "<<(char)ORC_SWORD<<"|\n";
 cout<<"| {G} | Goblin    | DEF+2 MAG-2 | Evil MAG | Dagger      "<<(char)DAGGER<<"|\n";
 cout<<"| {A} | Red Mage  | MAG+2 DEF-2 | Good DEF | Rod         "<<(char)ROD<<"|\n";
 cout<<"| {B} | Blck Mage | MAG+2 DEF-2 | Evil DEF | Wand        "<<(char)WAND<<"|\n";
 cout<<"| {L} | Wht Mage  | MAG+2 AGL-2 | Good AGL | Rod         "<<(char)ROD<<"|\n";
 cout<<"| {Z} | Ylw Mage  | MAG+2 ATK-2 | Evil ATK | Wand        "<<(char)WAND<<"|\n";
 cout<<"| {X} | Summoner  | MAG+2 AGL-2 | Evil AGL | Staff       "<<(char)STAFF<<"|\n";
 cout<<"| {S} | Wizard    | MAG+2 ATK-2 | Good ATK | Staff       "<<(char)STAFF<<"|\n";
 cout<<"+-----+-----------+-------------+----------+--------------+\n";
 cout<<"{Key} Choose type -|- {Escape} Quit game\n";
 clear_keybuf();
 readkey();
 _set_screen_lines(25);
 weapon=BROAD_SWORD;
 if(key[KEY_ESC])
 {
  end=true;
  return;
 }
 if(key[KEY_T])
 {
  atk+=2;
  agl-=2;
  type="Minotaur";
  weapon=CLUB;
  weapontype="Club";
  if(align_id==EVIL) agl++;
 }
 if(key[KEY_X])
 {
  mag+=2;
  agl-=2;
  type="Summoner";
  weapon=STAFF;
  weapontype="Staff";
  if(align_id==EVIL) agl++;
 }
 if(key[KEY_F])
 {
  agl+=2;
  mag-=2;
  type="Monk";
  weapon=GLOVES;
  weapontype="Gloves";
  if(align_id==GOOD) mag++;
 }
 if(key[KEY_Y])
 {
  atk+=2;
  mag-=2;
  type="Samurai";
  weapon=KATANA;
  weapontype="Katana";
  if(align_id==GOOD) mag++;
 }
 if(key[KEY_Q])
 {
  def+=2;
  mag-=2;
  type="Barbarian";
  weapon=CLUB;
  weapontype="Club";
  if(align_id==GOOD) mag++;
 }
 if(key[KEY_Z])
 {
  mag+=2;
  atk-=2;
  type="Yellow Mage";
  weapon=WAND;
  weapontype="Wand";
  if(align_id==EVIL) atk++;
 }
 if(key[KEY_I])
 {
  agl+=2;
  atk-=2;
  type="Rogue";
  weapon=SHORT_SWORD;
  weapontype="Short Sword";
  if(align_id==EVIL) atk++;
 }
 if(key[KEY_J])
 {
  atk+=2;
  def-=2;
  type="Archer";
  weapon=BOW;
  weapontype="Bow";
  if(align_id==GOOD) def++;
 }
 if(key[KEY_C])
 {
  def+=2;
  agl-=2;
  type="Gnome";
  weapon=AXE;
  weapontype="Axe";
  if(align_id==GOOD) agl++;
 }
 if(key[KEY_R])
 {
  agl+=2;
  def-=2;
  type="Ranger";
  weapon=SWORD;
  weapontype="Sword";
  if(align_id==EVIL) def++;
 }
 if(key[KEY_U])
 {
  def+=2;
  atk-=2;
  type="Uruk-hai";
  weapon=ORC_SWORD;
  weapontype="Orc Sword";
  if(align_id==EVIL) atk++;
 }
 if(key[KEY_A])
 {
  mag+=2;
  def-=2;
  type="Red Mage";
  weapon=ROD;
  weapontype="Rod";
  if(align_id==EVIL) def++;
 }
 if(key[KEY_O])
 {
  def+=2;
  agl-=2;
  type="Orc";
  weapon=ORC_SWORD;
  weapontype="Orc Sword";
  if(align_id==EVIL) agl++;
 }
 if(key[KEY_W])
 {
  atk+=2;
  mag-=2;
  type="Warrior";
  weapon=CLUB;
  weapontype="Club";
  if(align_id==EVIL) mag++;
 }
 if(key[KEY_K])
 {
  atk+=2;
  agl-=2;
  type="Knight";
  weapon=SWORD;
  weapontype="Sword";
  if(align_id==GOOD) agl++;
 }
 if(key[KEY_N])
 {
  atk+=2;
  def-=2;
  type="Ninja";
  weapon=KATANA;
  weapontype="Katana";
  if(align_id==EVIL) def++;
 }
 if(key[KEY_E])
 {
  agl+=2;
  def-=2;
  type="Elf";
  weapon=BOW;
  weapontype="Bow";
  if(align_id==GOOD) def++;
 }
 if(key[KEY_D])
 {
  def+=2;
  atk-=2;
  type="Dwarf";
  weapon=AXE;
  weapontype="Axe";
  if(align_id==GOOD) atk++;
 }
 if(key[KEY_H])
 {
  agl+=2;
  atk-=2;
  type="Halfling";
  weapon=SHORT_SWORD;
  weapontype="Short Sword";
  if(align_id==GOOD) atk++;
 }
 if(key[KEY_G])
 {
  def+=2;
  mag-=2;
  type="Goblin";
  weapon=DAGGER;
  weapontype="Dagger";
  if(align_id==EVIL) mag++;
 }
 if(key[KEY_B])
 {
  mag+=2;
  def-=2;
  type="Black Mage";
  weapon=WAND;
  weapontype="Wand";
  if(align_id==EVIL) def++;
 }
 if(key[KEY_L])
 {
  mag+=2;
  agl-=2;
  type="White Mage";
  weapon=ROD;
  weapontype="Rod";
  if(align_id==GOOD) agl++;
 }
 if(key[KEY_S])
 {
  mag+=2;
  atk-=2;
  type="Wizard";
  weapon=STAFF;
  weapontype="Staff";
  if(align_id==GOOD) atk++;
 }
 if(key[KEY_M]||weapon==BROAD_SWORD)
 {
  agl+=2;
  mag-=2;
  type="Swordsman";
  weapon=BROAD_SWORD;
  weapontype="Broad Sword";
  if(align_id==EVIL) mag++;
 }
}

void player::draw()
{
 gotoxy(x,y);
 textcolor(p_color);
 textbackground(p_bgcolor);
 putch(p_graphic);
 textbackground(0);
 gotoxy(1,1);
}

void player::input()
{
 _setcursortype(_NOCURSOR);
 if(key[KEY_UP]||key[KEY_8]) y--;
 if(key[KEY_DOWN]||key[KEY_2]) y++;
 if(key[KEY_LEFT]||key[KEY_4]) x--;
 if(key[KEY_RIGHT]||key[KEY_6]) x++;
 if(key[KEY_ESC]) menu();
 if(level[y][x]!=GRASS && level[y][x]!=FLOOR && y<SCREENH)
 {
  x=old_x;
  y=old_y;
 }
 if(x<2) x=1;
 if(x>=SCREENW) x=SCREENW-1;
 if(y>=SCREENH) y=SCREENH;
 old_x=x;
 old_y=y;
 #ifdef DEBUG
 if(key[KEY_R])
 {
  random_world();
  draw_level();
  draw();
 }
 if(key[KEY_L])
 {
  exp++;
 }
 if(key[KEY_I])
 {
  textmode(MONO);
  init_stats();
  draw_level();
 }
 if(key[KEY_W]) map_number=MAPS;
 if(key[KEY_D]) hp=0;
 #endif
 clear_keybuf();
}

void player::level_gain()
{
 max_hp+=elevel*2;
 hp=max_hp;
 max_mp+=elevel;
 mp=max_mp;
 atk+=1;
 def+=1;
 agl+=1;
 mag+=1;
 recover=0;
 elevel++;
 cure_magic_level++;
 _setcursortype(_NOCURSOR);
 char text[]="Gained a level...(Press a key)";
 textcolor(7);
 gotoxy(1,SCREENH);
 for(int i=0;i<sizeof(text);i++)
 {
  putch(text[i]);
  rest(TEXT_SPEED);
 }
 clear_keybuf();
 readkey();
 gotoxy(1,SCREENH);
 for(int x=1;x!=SCREENW;x++)
 {
  textcolor(GRASS_COLOR);
  putch(GRASS);
 }
 nl_exp+=((elevel+1)*5)+(rand()%5);
}

void player::teleport()
{
 y=SCREENH;
 old_y=y;
 old_x=x;
 random_world();
 draw_level();
 draw();
 gold_handler();
 monster_handler();
 sp_handler();
 shop_handler();
 food_handler();
 map_number++;
}

void player::menu()
{
 int choice=0;
 clrscr();
 textmode(MONO);
 clear_keybuf();
 while(!key[KEY_ESC])
 {
  clrscr();
  cout<<"+------+\n";
  cout<<"| Menu |\n";
  cout<<"+------+\n";
  cout<<"| Name: "<<name<<" the "<<align<<" "<<type<<endl;
  cout<<"| Gender: "<<gender<<endl;
  cout<<"| Wielding: Level "<<wpn_level<<" "<<weapontype<<endl;
  cout<<"|           Level "<<shld_level<<" Shield"<<endl;
  cout<<"| Experience: Level "<<elevel<<", Next Level "<<exp<<"/"<<nl_exp<<endl;
  cout<<"| Gold: "<<gp<<endl;
  cout<<"| Food (Lembas Bread): "<<food<<"/"<<FOOD_MAX<<endl;
  cout<<"| Map Number: "<<map_number<<"/"<<MAPS<<endl;
  cout<<"+--------+\n";
  cout<<"{A} Amulets\n";
  cout<<"{H} Healing Menu\n";
  cout<<"{M} Abilities\n";
  cout<<"{S} Status\n";
  cout<<"{B} Battle Record\n";
  cout<<"{Q} Exit game\n";
  cout<<"{ESCAPE} Return to game\n";
  readkey();
  if(key[KEY_M])
  {
   while(true)
   {
    clrscr();
    cout<<"+------+\n";
    cout<<"| Menu |\n";
    cout<<"+------+----+\n";
    cout<<"| Abilities |\n";
    cout<<"+-----------+--+\n";
    cout<<"| {C} Curative |\n";
    cout<<"| {E} Evasion  |\n";
    cout<<"+--------------+\n";
    cout<<"{Key} Select ability\n";
    cout<<"{Esc} Return\n";
    clear_keybuf();
    readkey();
    if(key[KEY_ESC]) break;
    if(key[KEY_E])
    {
     clrscr();
     cout<<"40 non-encounter turns = 10MP\n";
     cout<<"You have "<<mp<<"/"<<max_mp<<" MP.\n";
     cout<<"Cast evasion?\n";
     cout<<"{Y} To cast\n";
     cout<<"{Other} To cancel\n";
     clear_keybuf();
     readkey();
     if(key[KEY_Y])
     {
      if(mp-10>=0)
      {
       repel=true;
       repel_counter=40;
       mp-=10;
      }
      else
      {
       cout<<"Not enough MP! (Press any key)\n";
       clear_keybuf();
       readkey();
      }
     }
     else clear_keybuf();
    }
    if(key[KEY_C])
    {
     while(true)
     {
      clrscr();
      cout<<"+----------------+\n";
      cout<<"| Curative Magic Level "<<cure_magic_level<<endl;
      cout<<"+----------------+\n";
      cout<<"| HP: "<<hp<<"/"<<max_hp<<endl;
      cout<<"| MP: "<<mp<<"/"<<max_mp<<endl;
      cout<<"+----------------+\n";
      cout<<"| {C} Cure (-2MP=+5HP)\n";
      if(cure_magic_level>=5)
      {
       cout<<"| {D} Cura (-4MP=+15HP)\n";
      }
      if(cure_magic_level<5)
      {
       cout<<"| Level for Cura: 5\n";
      }
      if(cure_magic_level>=5&&cure_magic_level<15)
      {
       cout<<"| Level for Curaga: 15\n";
      }
      if(cure_magic_level>=15)
      {
       cout<<"| {E} Curaga (-8MP=+35HP)\n";
      }
      cout<<"+----------------+\n";
      cout<<"{Key} Use ability\n";
      cout<<"{Esc} Go back\n";
      clear_keybuf();
      readkey();
      if(key[KEY_ESC]) break;
      if(key[KEY_C])
      {
       if(mp-2>=0&&hp<max_hp)
       {
        mp-=2;
        hp+=5;
        if(hp>max_hp)
        {
         hp=max_hp;
        }
       }
      }
      if(key[KEY_D])
      {
       if(cure_magic_level>=5)
       {
        if(mp-4>=0&&hp<max_hp)
        {
         mp-=4;
         hp+=15;
         if(hp>max_hp)
         {
          hp=max_hp;
         }
        }
       }
      }
      if(key[KEY_E])
      {
       if(cure_magic_level>=15)
       {
        if(mp-8>=0&&hp<max_hp)
        {
         mp-=8;
         hp+=35;
         if(hp>max_hp)
         {
          hp=max_hp;
         }
        }
       }
      }
     }
    }
   }
   clear_keybuf();
  }
  if(key[KEY_Q])
  {
   end=true;
   return;
  }
  if(key[KEY_S])
  {
   clrscr();
   cout<<"+------+\n";
   cout<<"| Menu |\n";
   cout<<"+------+-+\n";
   cout<<"| Status |\n";
   cout<<"+--------+\n";
   cout<<"| Hit Points: "<<hp<<"/"<<max_hp<<endl;
   cout<<"| Magic Points: "<<mp<<"/"<<max_mp<<endl;
   cout<<"| Switch Points: "<<sp<<"\n";
   cout<<"| Attack:     "<<atk<<endl;
   cout<<"| Defense:    "<<def<<endl;
   cout<<"| Agility:    "<<agl<<endl;
   cout<<"| Magic:      "<<mag<<endl;
   cout<<"+--------+\n";
   cout<<"{Any key} Return\n";
   clear_keybuf();
   readkey();
   clear_keybuf();
  }
  if(key[KEY_A])
  {
   clrscr();
   cout<<"+------+\n";
   cout<<"| Menu |\n";
   cout<<"+------+--+\n";
   cout<<"| Amulets |\n";
   cout<<"+---------+\n";
   cout<<"| Amulet of Ardor: "<<amulet[FIRE]<<endl;
   cout<<"| Amulet of Arctic: "<<amulet[ICE]<<endl;
   cout<<"| Amulet of Storms: "<<amulet[THUNDER]<<endl;
   cout<<"| Amulet of Ground: "<<amulet[EARTH]<<endl;
   cout<<"| Amulet of Corruption: "<<amulet[POISON]<<endl;
   cout<<"+--------+\n";
   cout<<"{Any key} Return\n";
   clear_keybuf();
   readkey();
   clear_keybuf();
  }
  if(key[KEY_H])
  {
   while(true)
   {
    clrscr();
    cout<<"+------+\n";
    cout<<"| Menu |\n";
    cout<<"+------+-------+\n";
    cout<<"| Healing Menu |\n";
    cout<<"+--------------+\n";
    cout<<"| HP: "<<hp<<"/"<<max_hp<<endl;
    cout<<"| MP: "<<mp<<"/"<<max_mp<<endl;
    cout<<"| SP: "<<sp<<endl;
    cout<<"| Lembas: "<<food<<"/"<<FOOD_MAX<<endl;
    cout<<"+-----------+\n";
    cout<<"{UP}    HP <= MP\n";
    cout<<"{DOWN}  HP <= Lembas\n";
    cout<<"{LEFT}  HP <= SP\n";
    cout<<"{RIGHT} MP <= SP\n";
    cout<<"{ESC} Return\n";
    clear_keybuf();
    readkey();
    if(key[KEY_UP])
    {
     if(hp<max_hp&&mp>0)
     {
      hp++;
      mp--;
     }
    }
    if(key[KEY_DOWN])
    {
     if(hp<max_hp&&food>0)
     {
      for(int i=0;hp<max_hp&&i<10;hp++,i++);
      food--;
     }
    }
    if(key[KEY_RIGHT])
    {
     if(mp<max_mp&&sp>0)
     {
      sp--;
      mp++;
     }
    }
    if(key[KEY_LEFT])
    {
     if(hp<max_hp&&sp>0)
     {
      sp--;
      hp++;
     }
    }
    if(key[KEY_ESC]) break;
   }
   clear_keybuf();
  }
  if(key[KEY_B])
  {
   clrscr();
   cout<<"+------+\n";
   cout<<"| Menu |\n";
   cout<<"+------+---------+\n";
   if(monster_ded>0)
   {
    cout<<"| Monsters Slain |\n";
    cout<<"+----------------+\n";
    if(type_mon_killed[ZOMBIE]>0) cout<<"| Zombies: "<<type_mon_killed[ZOMBIE]<<" | Weakness: "<<ZOM_WEAK_NAME<<endl;
    if(type_mon_killed[SKELETON]>0) cout<<"| Skeletons: "<<type_mon_killed[SKELETON]<<" | Weakness: "<<SKE_WEAK_NAME<<endl;
    if(type_mon_killed[SPIDER]>0) cout<<"| Spiders: "<<type_mon_killed[SPIDER]<<" | Weakness: "<<SPI_WEAK_NAME<<endl;
    if(type_mon_killed[FOREST_TROLL]>0) cout<<"| Forest Trolls: "<<type_mon_killed[FOREST_TROLL]<<" | Weakness: "<<FOR_WEAK_NAME<<endl;
    if(type_mon_killed[ENT]>0) cout<<"| Ents: "<<type_mon_killed[ENT]<<" | Weakness: "<<ENT_WEAK_NAME<<endl;
    if(type_mon_killed[WURM]>0) cout<<"| Wurms: "<<type_mon_killed[WURM]<<" | Weakness: "<<WUR_WEAK_NAME<<endl;
    if(type_mon_killed[RAT]>0) cout<<"| Rats: "<<type_mon_killed[RAT]<<" | Weakness: "<<RAT_WEAK_NAME<<endl;
    if(type_mon_killed[ORC_MONSTER]>0) cout<<"| Orcs: "<<type_mon_killed[ORC_MONSTER]<<" | Weakness: "<<ORC_WEAK_NAME<<endl;
    if(type_mon_killed[DRYAD]>0) cout<<"| Dryads: "<<type_mon_killed[DRYAD]<<" | Weakness: "<<DRY_WEAK_NAME<<endl;
    if(type_mon_killed[BEAR]>0) cout<<"| Bears: "<<type_mon_killed[BEAR]<<" | Weakness: "<<BEA_WEAK_NAME<<endl;
    if(type_mon_killed[BOAR]>0) cout<<"| Boars: "<<type_mon_killed[BOAR]<<" | Weakness: "<<BOA_WEAK_NAME<<endl;
    cout<<"+----------------+\n";
    cout<<"| Total Monsters Slain: "<<monster_ded<<endl;
    cout<<"+----------------+\n";
   }
   else
   {
    cout<<"| You haven't killed any monsters!!\n";
    cout<<"+----------------+\n";
   }
   cout<<"{Any key} Return\n";
   clear_keybuf();
   readkey();
   clear_keybuf();
  }
  if(key[KEY_ESC])
  {
   textmode(C80);
   _setcursortype(_NOCURSOR);
   gotoxy(1,1);
   draw_level();
   draw();
   gold_handler();
   monster_handler();
   sp_handler();
   shop_handler();
   food_handler();
   return;
  }
 }
}

void player::gold_handler()
{
 for(int i=0;i<COINS;i++)
 {
  if(gold_on_map[i]==true)
  {
   if(x==gold_x[i]&&y==gold_y[i])
   {
    gp+=(25+rand()%25);
    gold_on_map[i]=false;
    char text[]="Found some gold... (Press a key)";
    textcolor(7);
    gotoxy(1,SCREENH);
    for(int i=0;i<sizeof(text);i++)
    {
     putch(text[i]);
     rest(TEXT_SPEED);
    }
    clear_keybuf();
    readkey();
    gotoxy(1,SCREENH);
    for(int x=1;x!=SCREENW;x++)
    {
     textcolor(GRASS_COLOR);
     putch(GRASS);
    }
   }
   else
   {
    textcolor(14);
    gotoxy(gold_x[i],gold_y[i]);
    putch('$');
   }
  }
 }
 return;
}

void player::food_handler()
{
 if(food_on_screen==true)
 {
  if(x==food_x&&y==food_y)
  {
   char text[]="Found a sack of Lembas bread... (Press a key)";
   if(food<FOOD_MAX) food++;
   food_on_screen=false;
   textcolor(7);
   gotoxy(1,SCREENH);
   for(int i=0;i<sizeof(text);i++)
   {
    putch(text[i]);
    rest(TEXT_SPEED);
   }
   clear_keybuf();
   readkey();
   gotoxy(1,SCREENH);
   for(int x=1;x!=SCREENW;x++)
   {
    textcolor(GRASS_COLOR);
    putch(GRASS);
   }
  }
  else
  {
   textcolor(FOOD_COLOR);
   gotoxy(food_x,food_y);
   putch(FOOD_CHAR);
  }
 }
 return;
}

void player::gollum_handler()
{
 if(gollum_on_screen==true)
 {
  if(x==gollum_x&&y==gollum_y)
  {
   char text2[]="Gollum: Do you belives us...? (Y for yes, other for no)";
   char text5[]="He led you farther into the forest!! (Press a key)";
   char text4[]="You were fooled by Gollum!! (Press a key)";
   char text[]="Gollum: We knows a short-cut... (Press a key)";
   gollum_on_screen=false;
   textcolor(7);
   gotoxy(1,SCREENH);
   for(int i=0;i<sizeof(text);i++)
   {
    putch(text[i]);
    rest(TEXT_SPEED);
   }
   clear_keybuf();
   readkey();
   gotoxy(1,SCREENH);
   for(int x=1;x!=SCREENW;x++)
   {
    textcolor(GRASS_COLOR);
    putch(GRASS);
   }
   textcolor(7);
   gotoxy(1,SCREENH);
   for(int i=0;i<sizeof(text2);i++)
   {
    putch(text2[i]);
    rest(TEXT_SPEED);
   }
   clear_keybuf();
   readkey();
   gotoxy(1,SCREENH);
   for(int x=1;x!=SCREENW;x++)
   {
    textcolor(GRASS_COLOR);
    putch(GRASS);
   }
   if(key[KEY_Y])
   {
    y=SCREENH;
    old_y=SCREENH;
    old_x=x;
    int gollum_trustworthy=(rand()%300)+1;
    if(gollum_trustworthy<=150)
    {
     if(map_number>0)
     {
      random_world();
      draw_level();
      draw();
      map_number--;
      sp_handler();
      shop_handler();
      monster_handler();
      gollum_handler();
      equip_handler();
      gold_handler();
      food_handler();
     }
     textcolor(7);
     gotoxy(1,SCREENH);
     for(int i=0;i<sizeof(text4);i++)
     {
      putch(text4[i]);
      rest(TEXT_SPEED);
     }
     clear_keybuf();
     readkey();
     gotoxy(1,SCREENH);
     for(int x=1;x!=SCREENW;x++)
     {
      textcolor(GRASS_COLOR);
      putch(GRASS);
     }
     draw();
    }
    if(gollum_trustworthy>150)
    {
     if(map_number<MAPS)
     {
      random_world();
      draw_level();
      draw();
      map_number++;
      sp_handler();
      shop_handler();
      monster_handler();
      gollum_handler();
      equip_handler();
      gold_handler();
      food_handler();
     }
     textcolor(7);
     gotoxy(1,SCREENH);
     for(int i=0;i<sizeof(text5);i++)
     {
      putch(text5[i]);
      rest(TEXT_SPEED);
     }
     clear_keybuf();
     readkey();
     gotoxy(1,SCREENH);
     for(int x=1;x!=SCREENW;x++)
     {
      textcolor(GRASS_COLOR);
      putch(GRASS);
     }
     draw();
    }
   }
   gotoxy(1,SCREENH);
   for(int x=1;x!=SCREENW;x++)
   {
    textcolor(GRASS_COLOR);
    putch(GRASS);
   }
   draw();
  }
  else
  {
   textcolor(15);
   gotoxy(gollum_x,gollum_y);
   putch(GOLLUM);
  }
 }
 return;
}

void player::shop_handler()
{
 if(shop_on_screen==true)
 {
  if(x==shop_x&&y==shop_y)
  {
   char text[]="Traveling Salesman...(Any key other than Y to cancel, Y to shop)";
   textcolor(7);
   gotoxy(1,SCREENH);
   for(int i=0;i<sizeof(text);i++)
   {
    putch(text[i]);
    rest(10);
   }
   clear_keybuf();
   readkey();
   if(key[KEY_Y])
   {
    shop();
    draw_level();
    monster_handler();
    sp_handler();
    gold_handler();
    shop_handler();
    food_handler();
    draw();
   }
   gotoxy(1,SCREENH);
   for(int x=1;x!=SCREENW;x++)
   {
    textcolor(GRASS_COLOR);
    putch(GRASS);
   }
  }
  else
  {
   textcolor(15);
   gotoxy(shop_x,shop_y);
   putch(1);
  }
 }
 return;
}

void player::shop()
{
 int weapon_expense=wpn_level*10;
 int shield_expense=shld_level*10;
 while(true)
 {
  clrscr();
  cout<<"+--------------------+\n";
  cout<<"| Traveling Salesman |\n";
  cout<<"+--------------------+\n";
  cout<<"| Current Gold: "<<gp<<endl;
  cout<<"+--------------------+\n";
  cout<<"| {S} Buy some SP (1=5 Gold)\n";
  cout<<"| {L} Buy some Lembas (1=20 Gold)\n";
  cout<<"| {W} Buy a new weapon (1="<<weapon_expense<<" Gold)\n";
  cout<<"| {A} Buy a new shield (1="<<shield_expense<<" Gold)\n";
  cout<<"| {D} Done...\n";
  cout<<"+--------------------+\n";
  cout<<"{Key} Choice...\n";
  clear_keybuf();
  readkey();
  if(key[KEY_D]) break;
  if(key[KEY_W])
  {
   weapon_expense=wpn_level*10;
   clrscr();
   cout<<"Buy a higher level weapon for "<<weapon_expense<<" Gold?\n";
   cout<<"{Y} Sure...\n";
   cout<<"{Other} Naw...\n";
   clear_keybuf();
   readkey();
   if(key[KEY_Y])
   {
    if(gp>=weapon_expense)
    {
     wpn_level++;
     gp-=weapon_expense;
     atk+=(rand()%2)+1;
    }
    else
    {
     cout<<"Not enough Gold!! (Press any key)\n";
     clear_keybuf();
     readkey();
    }
   }
  }
  if(key[KEY_A])
  {
   shield_expense=shld_level*10;
   clrscr();
   cout<<"Buy a higher level shield for "<<shield_expense<<" Gold?\n";
   cout<<"{Y} Sure...\n";
   cout<<"{Other} Naw...\n";
   clear_keybuf();
   readkey();
   if(key[KEY_Y])
   {
    if(gp>=shield_expense)
    {
     def+=(rand()%2)+1;
     shld_level++;
     gp-=shield_expense;
    }
    else
    {
     cout<<"Not enough Gold!! (Press any key)\n";
     clear_keybuf();
     readkey();
    }
   }
  }
  if(key[KEY_S])
  {
   int add_sp=0;
   while(true)
   {
    clrscr();
    cout<<"How much SP?\n";
    cout<<"SP: "<<sp<<" + "<<add_sp<<"SP = "<<add_sp*5<<"/"<<gp<<" Gold"<<endl;
    cout<<"{UP} Increase amount of new SP\n";
    cout<<"{DOWN} Decrease amound of new SP\n";
    cout<<"{ENTER} Accept\n";
    clear_keybuf();
    readkey();
    if(key[KEY_UP]) add_sp++;
    if(key[KEY_DOWN])
    {
     if(add_sp>0) add_sp--;
    }
    if(key[KEY_ENTER])
    {
     if(gp>=add_sp*5)
     {
      sp+=add_sp;
      gp-=add_sp*5;
     }
     else
     {
      cout<<"Not enough Gold!! (Press any key)\n";
      clear_keybuf();
      readkey();
     }
     break;
    }
   }
  }
  if(key[KEY_L])
  {
   int add_food=0;
   while(true)
   {
    clrscr();
    cout<<"How much Lembas bread?\n";
    cout<<"Bread: "<<food<<"/"<<FOOD_MAX<<" + "<<add_food<<" Food = "<<add_food*20<<"/"<<gp<<" Gold"<<endl;
    cout<<"{UP} Increase amount of Bread\n";
    cout<<"{DOWN} Decrease amound of Bread\n";
    cout<<"{ENTER} Accept\n";
    clear_keybuf();
    readkey();
    if(key[KEY_UP])
    {
     if(food<FOOD_MAX) add_food++;
    }
    if(key[KEY_DOWN])
    {
     if(add_food>0) add_food--;
    }
    if(key[KEY_ENTER])
    {
     if(gp>=add_food*20)
     {
      food+=add_food;
      gp-=add_food*20;
     }
     else
     {
      cout<<"Not enough Gold!! (Press any key)\n";
      clear_keybuf();
      readkey();
     }
     break;
    }
   }
  }
 }
}

void player::sp_handler()
{
 for(int i=0;i<SP;i++)
 {
  if(sp_on_map[i]==true)
  {
   if(x==sp_x[i]&&y==sp_y[i])
   {
    sp+=(rand()%5)+1;
    if(sp<0) sp=1;
    sp_on_map[i]=false;
    char text[]="Found some SP... (Press a key)";
    textcolor(7);
    gotoxy(1,SCREENH);
    for(int i=0;i<sizeof(text);i++)
    {
     putch(text[i]);
     rest(TEXT_SPEED);
    }
    clear_keybuf();
    readkey();
    gotoxy(1,SCREENH);
    for(int x=1;x!=SCREENW;x++)
    {
     textcolor(GRASS_COLOR);
     putch(GRASS);
    }
   }
   else
   {
    textcolor(SP_COLOR);
    gotoxy(sp_x[i],sp_y[i]);
    putch(SP_CHAR);
   }
  }
 }
 return;
}

void player::equip_handler()
{
 if(shield_on_map==true)
 {
  if(x==shield_x&&y==shield_y)
  {
   shld_level++;
   found_eqp++;
   def+=(rand()%2)+1;
   shield_on_map=false;
   char text[]="Found a new shield... (Press a key)";
   textcolor(7);
   gotoxy(1,SCREENH);
   for(int i=0;i<sizeof(text);i++)
   {
    putch(text[i]);
    rest(TEXT_SPEED);
   }
   clear_keybuf();
   readkey();
   gotoxy(1,SCREENH);
   for(int x=1;x!=SCREENW;x++)
   {
    textcolor(GRASS_COLOR);
    putch(GRASS);
   }
  }
  else
  {
   textcolor(SHIELD_COLOR);
   gotoxy(shield_x,shield_y);
   putch(SHIELD);
  }
 }
 if(sword_on_map==true)
 {
  if(x==sword_x&&y==sword_y)
  {
   found_eqp++;
   if(weapon==WAND||weapon==ROD||weapon==STAFF)
   {
    mag+=(rand()%2)+1;
   }
   else atk+=(rand()%2)+1;
   sword_on_map=false;
   gotoxy(1,SCREENH);
   textcolor(7);
   char text[]="Found a new";
   char text3[]="...(Press any key)";
   wpn_level++;
   gotoxy(1,SCREENH);
   for(int j=0;j<sizeof(text);j++)
   {
    putch(text[j]);
    rest(TEXT_SPEED);
   }
   for(int j=0;j>-1;j++)
   {
    if(weapontype[j]=='\0') break;
    putch(weapontype[j]);
    rest(TEXT_SPEED);
   }
   for(int j=0;j<sizeof(text3);j++)
   {
    putch(text3[j]);
    rest(TEXT_SPEED);
   }
   clear_keybuf();
   readkey();
   gotoxy(1,SCREENH);
   for(int x=1;x!=SCREENW;x++)
   {
    textcolor(GRASS_COLOR);
    putch(GRASS);
   }
  }
  else
  {
   textcolor(SWORD_COLOR);
   gotoxy(sword_x,sword_y);
   putch(weapon);
  }
 }
 return;
}

void player::monster_handler()
{
 for(int i=0;i<MONSTERS;i++)
 {
  if(monster_on_map[i]==true)
  {
   gotoxy(monster_x[i],monster_y[i]);
   if(level[monster_y[i]][monster_x[i]]==FLOOR) textcolor(FLOOR_COLOR);
   if(level[monster_y[i]][monster_x[i]]==ROCK) textcolor(ROCK_COLOR);
   if(level[monster_y[i]][monster_x[i]]==TREE) textcolor(TREE_COLOR);
   if(level[monster_y[i]][monster_x[i]]==GRASS) textcolor(GRASS_COLOR);
   if(level[monster_y[i]][monster_x[i]]==WATER) textcolor(WATER_COLOR);
   putch(level[monster_y[i]][monster_x[i]]);
   int dir=(rand()%4)+1;
   if(dir==1)
   {
    if(monster_y[i]-1>1) monster_y[i]--;
   }
   if(dir==2)
   {
    if(monster_y[i]+1<=SCREENH-1) monster_y[i]++;
   }
   if(dir==3)
   {
    if(monster_x[i]-1>1) monster_x[i]--;
   }
   if(dir==4)
   {
    if(monster_x[i]+1<=SCREENW) monster_x[i]++;
   }
   textcolor(MONSTER_COLOR);
   gotoxy(monster_x[i],monster_y[i]);
   putch(MONSTER_CHAR);
  }
 }
 return;
}

void player::battle()
{
 clrscr();
 textmode(MONO);
 gotoxy(1,1);
 int weakness=0;
 int elemtype=(ELEMENTS+1);
 char*weak_name;
 int m_hp=(rand()%12)+1;
 m_hp+=40;
 m_hp+=map_number;
 m_hp+=elevel*2;
 int m_agl=(rand()%12)+1;
 m_agl+=10;
 m_agl+=map_number;
 m_agl+=elevel*2;
 int m_atk=(rand()%12)+1;
 m_atk+=12;
 m_atk+=map_number;
 m_atk+=elevel*2;
 int m_atkpermanent=m_atk;
 int m_def=(rand()%12)+1;
 m_def+=9;
 m_def+=map_number;
 m_def+=elevel*2;
 int m_spr=(rand()%12)+1;
 m_spr+=9;
 m_spr+=elevel*2;
 int exp_gain=rand()%10;
 exp_gain+=1;
 char*mon_name;
 int mon_id;
 int rnd_mon_name=(rand()%100)+1;
 if(rnd_mon_name<=10) mon_id=ZOMBIE;
 if(rnd_mon_name>10&&rnd_mon_name<=20) mon_id=SKELETON;
 if(rnd_mon_name>20&&rnd_mon_name<=30) mon_id=SPIDER;
 if(rnd_mon_name>30&&rnd_mon_name<=40) mon_id=FOREST_TROLL;
 if(rnd_mon_name>40&&rnd_mon_name<=50) mon_id=ENT;
 if(rnd_mon_name>50&&rnd_mon_name<=60) mon_id=WURM;
 if(rnd_mon_name>60&&rnd_mon_name<=70) mon_id=RAT;
 if(rnd_mon_name>70&&rnd_mon_name<=80)
 {
  if(weapon!=ORC_SWORD) mon_id=ORC_MONSTER;
  if(weapon==ORC_SWORD) mon_id=DRYAD;
 }
 if(rnd_mon_name>80&&rnd_mon_name<=90) mon_id=BEAR;
 if(rnd_mon_name>90) mon_id=BOAR;
 #ifdef DEBUG_ELEM
 mon_id=ORC_MONSTER;
 amulet[THUNDER]=99;
 amulet[EARTH]=99;
 #endif
 if(mon_id==ZOMBIE)
 {
  mon_name="Zombie";
  weakness=ZOM_WEAK;
  weak_name=ZOM_WEAK_NAME;
 }
 if(mon_id==SKELETON)
 {
  mon_name="Skeleton";
  weakness=SKE_WEAK;
  weak_name=SKE_WEAK_NAME;
 }
 if(mon_id==SPIDER)
 {
  mon_name="Spider";
  weakness=SPI_WEAK;
  weak_name=SPI_WEAK_NAME;
 }
 if(mon_id==FOREST_TROLL)
 {
  mon_name="Forest Troll";
  weakness=FOR_WEAK;
  weak_name=FOR_WEAK_NAME;
 }
 if(mon_id==ENT)
 {
  mon_name="Ent";
  weakness=ENT_WEAK;
  weak_name=ENT_WEAK_NAME;
 }
 if(mon_id==WURM)
 {
  mon_name="Wurm";
  weakness=WUR_WEAK;
  weak_name=WUR_WEAK_NAME;
 }
 if(mon_id==RAT)
 {
  mon_name="Rat";
  weakness=RAT_WEAK;
  weak_name=RAT_WEAK_NAME;
 }
 if(mon_id==ORC_MONSTER)
 {
  mon_name="Orc";
  weakness=ORC_WEAK;
  weak_name=ORC_WEAK_NAME;
 }
 if(mon_id==DRYAD)
 {
  mon_name="Dryad";
  weakness=DRY_WEAK;
  weak_name=DRY_WEAK_NAME;
 }
 if(mon_id==BEAR)
 {
  mon_name="Bear";
  weakness=BEA_WEAK;
  weak_name=BEA_WEAK_NAME;
 }
 if(mon_id==BOAR)
 {
  mon_name="Boar";
  weakness=BOA_WEAK;
  weak_name=BOA_WEAK_NAME;
 }

 cout<<"Encounter!\n";
 char text[]="Get ready!";
 for(int i=0;i<sizeof(text);i++)
 {
  putch(text[i]);
  rest(100);
 }
 player_won=false;
 int damage=0;
 if(m_agl>=agl)
 {
  cout<<"\n"<<mon_name<<" struck first!\n";
  damage=(rand()%6)+1;
  damage+=m_atk-def;
  if(damage<0) damage=0;
  hp-=damage;
  cout<<name<<" took "<<damage<<" damage!\n";
  clear_keybuf();
  readkey();
  if(hp<=0)
  {
   cout<<name<<" was killed...\n";
   cout<<name<<" the "<<align<<" "<<gender<<" "<<type<<" was killed...\n";
   cout<<name<<"'s "<<weapontype<<" was at level "<<wpn_level<<".\n";
   cout<<name<<"'s shield was at level "<<shld_level<<".\n";
   cout<<name<<" had "<<gp<<" gold\n";
   cout<<name<<" got through "<<map_number<<" parts of the forest\n";
   cout<<name<<" found the equipment of "<<found_eqp<<" fallen explorers.\n";
   cout<<name<<" slayed "<<monster_ded<<" monsters.\n";
   cout<<name<<" was at level "<<elevel<<endl;
   cout<<name<<" had "<<exp<<" experience."<<endl;
   cout<<name<<"'s maximum MP was "<<max_mp<<endl;
   cout<<name<<" had "<<sp<<" SP.\n";
   cout<<name<<"'s attack power was "<<atk<<endl;
   cout<<name<<"'s defensive power was "<<def<<endl;
   cout<<name<<"'s agility was "<<agl<<endl;
   cout<<name<<"'s magic power was "<<mag<<endl;
   cout<<"/-------\\"<<endl;
   cout<<"|       |"<<endl;
   cout<<"| R I P |"<<endl;
   cout<<"|       |"<<endl;
   cout<<"#########"<<endl;
   rest(500);
   clear_keybuf();
   readkey();
   end=true;
   return;
  }
 }
 while(player_won==false)
 {
  clrscr();
  cout<<"+-----------+\n";
  cout<<"|  Battle   |\n";
  cout<<"+-----------+\n";
  cout<<"| "<<mon_name<<" HP: "<<m_hp<<endl;
  #ifdef DEBUG
  cout<<"| Weakness: "<<weak_name<<endl;
  #endif
  cout<<"| "<<name<<"\n| HP: "<<hp<<"/"<<max_hp<<endl;
  cout<<"| MP: "<<mp<<"/"<<max_mp<<endl;
  cout<<"+---------------------+\n";
  cout<<"|     Battle Menu     |\n";
  cout<<"+---------------------+\n";
  if(hp>(max_hp/5))
  {
   cout<<"|{A} Attack           |\n";
  }
  if(hp<=(max_hp/5))
  {
   cout<<"|{A} Power Attack     |\n";
  }
  cout<<"|{D} Defend           |\n";
  cout<<"|{M} Magic Attack     |\n";
  cout<<"|{E} Elemental Attack |\n";
  cout<<"|{R} Run              |\n";
  cout<<"+---------------------+\n";
  clear_keybuf();
  readkey();
  if(key[KEY_A])
  {
   cout<<"| ";
   cout<<name<<" attacks the "<<mon_name<<"!\n";
   damage=(rand()%12)+1;
   damage+=atk-m_def;
   if(hp<=(max_hp/5))
   {
    damage+=((wpn_level+5)*3);
    cout<<"| It was a critical hit!\n";
    m_atk-=wpn_level+2;
   }
   if(damage<=0) damage=1;
   m_hp-=damage;
   cout<<"| "<<mon_name<<" took "<<damage<<" damage!\n";
   cout<<"+-----------------+\n";
   if(m_hp<=0) break;
  }
  if(key[KEY_M])
  {
   if(mp>=1)
   {
    int mp_spent=0;
    while(true)
    {
     clrscr();
     cout<<"+---------------+\n";
     cout<<"| How much MP to spend?\n";
     cout<<"+---------------+\n";
     cout<<"| Spend: "<<mp_spent<<" out of "<<mp<<"/"<<max_mp<<endl;
     cout<<"+---------------+\n";
     cout<<"{UP} Spend+\n";
     cout<<"{DOWN} Spend-\n";
     cout<<"{ENTER} Cast!\n";
     clear_keybuf();
     readkey();
     if(key[KEY_UP])
     {
      if(mp-mp_spent>0) mp_spent++;
     }
     if(key[KEY_DOWN])
     {
      if(mp_spent>0) mp_spent--;
     }
     if(key[KEY_ENTER]) break;
    }
    damage=(rand()%12)+1;
    damage+=(mag+mp_spent)-m_spr;
    mp-=mp_spent;
    if(damage<=0) damage=1;
    m_hp-=damage;
    cout<<"+-----------------+\n";
    cout<<"| ";
    cout<<name<<" attacks the "<<mon_name<<" with magic!\n";
    cout<<"| "<<mon_name<<" took "<<damage<<" damage!\n";
   }
   else
   {
    cout<<"| You have no MP! Attack was easily deflected!\n";
   }
   cout<<"+-----------------+\n";
   if(m_hp<=0) break;
  }
  if(key[KEY_E])
  {
   while(true)
   {
    clrscr();
    elemtype=(ELEMENTS+1);
    cout<<"+---------------+\n";
    cout<<"| Use which Amulet?\n";
    cout<<"+---------------+\n";
    cout<<"| {F} Amulet of Ardor: "<<amulet[FIRE]<<endl;
    cout<<"| {I} Amulet of Arctic: "<<amulet[ICE]<<endl;
    cout<<"| {E} Amulet of Ground: "<<amulet[EARTH]<<endl;
    cout<<"| {T} Amulet of Storms: "<<amulet[THUNDER]<<endl;
    cout<<"| {P} Amulet of Corruption: "<<amulet[POISON]<<endl;
    cout<<"+---------------+\n";
    cout<<"{Key} Attack with elemental + standard magic\n";
    clear_keybuf();
    readkey();
    if(key[KEY_F])
    {
     if(amulet[FIRE]>0) elemtype=FIRE;
     break;
    }
    if(key[KEY_I])
    {
     if(amulet[ICE]>0) elemtype=ICE;
     break;
    }
    if(key[KEY_T])
    {
     if(amulet[THUNDER]>0) elemtype=THUNDER;
     break;
    }
    if(key[KEY_E])
    {
     if(amulet[EARTH]>0) elemtype=EARTH;
     break;
    }
    if(key[KEY_P])
    {
     if(amulet[POISON]>0) elemtype=POISON;
     break;
    }
   }
   amulet[elemtype]--;
   damage=(rand()%12)+1;
   damage+=(mag-m_spr);
   bool weakness_attacked=false;
   if(weakness==elemtype)
   {
    damage+=(rand()%24)+1;
    weakness_attacked=true;
   }
   if(damage<=0) damage=1;
   m_hp-=damage;
   cout<<"+-----------------+\n";
   cout<<"| ";
   cout<<name<<" attacks the "<<mon_name<<" with elemental magic!\n";
   if(weakness_attacked==true)
   {
    cout<<"| "<<mon_name<<" was weak to the "<<weak_name<<" magic!\n";
   }
   cout<<"| "<<mon_name<<" took "<<damage<<" damage!\n";
   cout<<"+-----------------+\n";
   if(m_hp<=0) break;
  }
  if(key[KEY_D])
  {
   cout<<"| ";
   cout<<name<<" defends...\n";
   m_atk-=(rand()%5)+shld_level;
  }
  if(key[KEY_R])
  {
   int chance_to_run=(rand()%100)+1;
   if(chance_to_run<=RUN_CHANCE)
   {
    cout<<"Coward...\n";
    rest(300);
    textmode(C80);
    gotoxy(1,1);
    draw_level();
    draw();
    gold_handler();
    return;
   }
   cout<<"| Couldn't run!\n";
  }
  cout<<"| The "<<mon_name<<" attacks!\n";
  damage=(rand()%6)+1;
  damage+=m_atk-def;
  if(damage<0) damage=0;
  hp-=damage;
  cout<<"| ";
  cout<<name<<" took "<<damage<<" damage!\n";
  m_atk=m_atkpermanent;
  cout<<"| (Press any key)\n";
  cout<<"+-----------------+\n";
  clear_keybuf();
  readkey();
  if(hp<=0)
  {
   rest(100);
   clrscr();
   cout<<name<<" the "<<align<<" "<<gender<<" "<<type<<" was killed...\n";
   cout<<name<<"'s "<<weapontype<<" was at level "<<wpn_level<<".\n";
   cout<<name<<"'s shield was at level "<<shld_level<<".\n";
   cout<<name<<" had "<<gp<<" gold\n";
   cout<<name<<" got through "<<map_number<<" parts of the forest\n";
   cout<<name<<" found the equipment of "<<found_eqp<<" fallen explorers.\n";
   cout<<name<<" slayed "<<monster_ded<<" monsters.\n";
   cout<<name<<" was at level "<<elevel<<endl;
   cout<<name<<" had "<<exp<<" experience."<<endl;
   cout<<name<<"'s maximum MP was "<<max_mp<<endl;
   cout<<name<<" had "<<sp<<" SP.\n";
   cout<<name<<"'s attack power was "<<atk<<endl;
   cout<<name<<"'s defensive power was "<<def<<endl;
   cout<<name<<"'s agility was "<<agl<<endl;
   cout<<name<<"'s magic power was "<<mag<<endl;
   cout<<"/-------\\"<<endl;
   cout<<"|       |"<<endl;
   cout<<"| R I P |"<<endl;
   cout<<"|       |"<<endl;
   cout<<"#########"<<endl;
   rest(500);
   clear_keybuf();
   readkey();
   end=true;
   return;
  }
 }
 type_mon_killed[mon_id]++;
 monster_ded++;
 cout<<name<<" beat the "<<mon_name<<"!\n";
 cout<<name<<" gained "<<exp_gain<<" experience!\n";
 cout<<"The body has a strange light around it...\n";
 cout<<"Charging amulets...\n";
 int amnt_elem=(rand()%5)+1;
 amulet[weakness]+=amnt_elem;
 cout<<"Stocked "<<amnt_elem<<" "<<weak_name<<"s...(Press any key)\n";
 clear_keybuf();
 readkey();
 exp+=exp_gain;
 clear_keybuf();
 readkey();
 textmode(C80);
 draw_level();
 draw();
 player_won=true;
 gold_handler();
 monster_handler();
 return;
}

void player::monster_collide()
{
 for(int i=0;i<MONSTERS;i++)
 {
  if(monster_x[i]==x&&monster_y[i]==y)
  {
   clear_keybuf();
   battle();
   if(player_won==true) monster_on_map[i]=false;
   monster_x[i]=1;
   monster_y[i]=1;
   food_handler();
   gold_handler();
   sp_handler();
   monster_handler();
   shop_handler();
   return;
  }
 }
}
/*This is line 2428!!*/

