/*=====================================================================
  tables.h   -> Header file containing the defines for Z80 opcodes.

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 Copyright (c) 2000 Santiago Romero Iglesias.
 Email: sromero@escomposlinux.org
 ======================================================================*/  
  
#ifndef TABLES_H
#define TABLES_H
  
/*--- One byte opcodes: ----------------------------------------------*/ 
#define  NOP           0
#define  LD_BC_NN      1
#define  LD_xBC_A      2
#define  INC_BC        3
#define  INC_B         4
#define  DEC_B         5
#define  LD_B_N        6
#define  RLCA          7
#define  EX_AF_AF      8
#define  ADD_HL_BC     9
#define  LD_A_xBC      10
#define  DEC_BC        11
#define  INC_C         12
#define  DEC_C         13
#define  LD_C_N        14
#define  RRCA          15
#define  DJNZ          16
#define  LD_DE_NN      17
#define  LD_xDE_A      18
#define  INC_DE        19
#define  INC_D         20
#define  DEC_D         21
#define  LD_D_N        22
#define  RLA           23
#define  JR            24
#define  ADD_HL_DE     25
#define  LD_A_xDE      26
#define  DEC_DE        27
#define  INC_E         28
#define  DEC_E         29
#define  LD_E_N        30
#define  RRA           31
#define  JR_NZ         32
#define  LD_HL_NN      33
#define  LD_xNN_HL     34
#define  INC_HL        35
#define  INC_H         36
#define  DEC_H         37
#define  LD_H_N        38
#define  DAA           39
#define  JR_Z          40
#define  ADD_HL_HL     41
#define  LD_HL_xNN     42
#define  DEC_HL        43
#define  INC_L         44
#define  DEC_L         45
#define  LD_L_N        46
#define  CPL           47
#define  JR_NC         48
#define  LD_SP_NN      49
#define  LD_xNN_A      50
#define  INC_SP        51
#define  INC_xHL       52
#define  DEC_xHL       53
#define  LD_xHL_N      54
#define  SCF           55
#define  JR_C          56
#define  ADD_HL_SP     57
#define  LD_A_xNN      58
#define  DEC_SP        59
#define  INC_A         60
#define  DEC_A         61
#define  LD_A_N        62
#define  CCF           63
#define  LD_B_B        64
#define  LD_B_C        65
#define  LD_B_D        66
#define  LD_B_E        67
#define  LD_B_H        68
#define  LD_B_L        69
#define  LD_B_xHL      70
#define  LD_B_A        71
#define  LD_C_B        72
#define  LD_C_C        73
#define  LD_C_D        74
#define  LD_C_E        75
#define  LD_C_H        76
#define  LD_C_L        77
#define  LD_C_xHL      78
#define  LD_C_A        79
#define  LD_D_B        80
#define  LD_D_C        81
#define  LD_D_D        82
#define  LD_D_E        83
#define  LD_D_H        84
#define  LD_D_L        85
#define  LD_D_xHL      86
#define  LD_D_A        87
#define  LD_E_B        88
#define  LD_E_C        89
#define  LD_E_D        90
#define  LD_E_E        91
#define  LD_E_H        92
#define  LD_E_L        93
#define  LD_E_xHL      94
#define  LD_E_A        95
#define  LD_H_B        96
#define  LD_H_C        97
#define  LD_H_D        98
#define  LD_H_E        99
#define  LD_H_H        100
#define  LD_H_L        101
#define  LD_H_xHL      102
#define  LD_H_A        103
#define  LD_L_B        104
#define  LD_L_C        105
#define  LD_L_D        106
#define  LD_L_E        107
#define  LD_L_H        108
#define  LD_L_L        109
#define  LD_L_xHL      110
#define  LD_L_A        111
#define  LD_xHL_B      112
#define  LD_xHL_C      113
#define  LD_xHL_D      114
#define  LD_xHL_E      115
#define  LD_xHL_H      116
#define  LD_xHL_L      117
#define  HALT          118
#define  LD_xHL_A      119
#define  LD_A_B        120
#define  LD_A_C        121
#define  LD_A_D        122
#define  LD_A_E        123
#define  LD_A_H        124
#define  LD_A_L        125
#define  LD_A_xHL      126
#define  LD_A_A        127
#define  ADD_B         128
#define  ADD_C         129
#define  ADD_D         130
#define  ADD_E         131
#define  ADD_H         132
#define  ADD_L         133
#define  ADD_xHL       134
#define  ADD_A         135
#define  ADC_B         136
#define  ADC_C         137
#define  ADC_D         138
#define  ADC_E         139
#define  ADC_H         140
#define  ADC_L         141
#define  ADC_xHL       142
#define  ADC_A         143
#define  SUB_B         144
#define  SUB_C         145
#define  SUB_D         146
#define  SUB_E         147
#define  SUB_H         148
#define  SUB_L         149
#define  SUB_xHL       150
#define  SUB_A         151
#define  SBC_B         152
#define  SBC_C         153
#define  SBC_D         154
#define  SBC_E         155
#define  SBC_H         156
#define  SBC_L         157
#define  SBC_xHL       158
#define  SBC_A         159
#define  AND_B         160
#define  AND_C         161
#define  AND_D         162
#define  AND_E         163
#define  AND_H         164
#define  AND_L         165
#define  AND_xHL       166
#define  AND_A         167
#define  XOR_B         168
#define  XOR_C         169
#define  XOR_D         170
#define  XOR_E         171
#define  XOR_H         172
#define  XOR_L         173
#define  XOR_xHL       174
#define  XOR_A         175
#define  OR_B          176
#define  OR_C          177
#define  OR_D          178
#define  OR_E          179
#define  OR_H          180
#define  OR_L          181
#define  OR_xHL        182
#define  OR_A          183
#define  CP_B          184
#define  CP_C          185
#define  CP_D          186
#define  CP_E          187
#define  CP_H          188
#define  CP_L          189
#define  CP_xHL        190
#define  CP_A          191
#define  RET_NZ        192
#define  POP_BC        193
#define  JP_NZ         194
#define  JP            195
#define  CALL_NZ       196
#define  PUSH_BC       197
#define  ADD_N         198
#define  RST_00        199
#define  RET_Z         200
#define  RET           201
#define  JP_Z          202
#define  PREFIX_CB     203
#define  CALL_Z        204
#define  CALL          205
#define  ADC_N         206
#define  RST_08        207
#define  RET_NC        208
#define  POP_DE        209
#define  JP_NC         210
#define  OUT_N_A       211
#define  CALL_NC       212
#define  PUSH_DE       213
#define  SUB_N         214
#define  RST_10        215
#define  RET_C         216
#define  EXX           217
#define  JP_C          218
#define  IN_A_N        219
#define  CALL_C        220
#define  PREFIX_DD     221
#define  SBC_N         222
#define  RST_18        223
#define  RET_PO        224
#define  POP_HL        225
#define  JP_PO         226
#define  EX_HL_xSP     227
#define  CALL_PO       228
#define  PUSH_HL       229
#define  AND_N         230
#define  RST_20        231
#define  RET_PE        232
#define  JP_xHL        233
#define  JP_PE         234
#define  EX_DE_HL      235
#define  CALL_PE       236
#define  PREFIX_ED     237
#define  XOR_N         238
#define  RST_28        239
#define  RET_P         240
#define  POP_AF        241
#define  JP_P          242
#define  DI            243
#define  CALL_P        244
#define  PUSH_AF       245
#define  OR_N          246
#define  RST_30        247
#define  RET_M         248
#define  LD_SP_HL      249
#define  JP_M          250
#define  EI            251
#define  CALL_M        252
#define  PREFIX_FD     253
#define  CP_N          254
#define  RST_38        255
  


/*--- CB Prefix opcodes: ---------------------------------------------*/ 
#define  RLC_B         0
#define  RLC_C         1
#define  RLC_D         2
#define  RLC_E         3
#define  RLC_H         4
#define  RLC_L         5
#define  RLC_xHL       6
#define  RLC_A         7
#define  RRC_B         8
#define  RRC_C         9
#define  RRC_D         10
#define  RRC_E         11
#define  RRC_H         12
#define  RRC_L         13
#define  RRC_xHL       14
#define  RRC_A         15
#define  RL_B          16
#define  RL_C          17
#define  RL_D          18
#define  RL_E          19
#define  RL_H          20
#define  RL_L          21
#define  RL_xHL        22
#define  RL_A          23
#define  RR_B          24
#define  RR_C          25
#define  RR_D          26
#define  RR_E          27
#define  RR_H          28
#define  RR_L          29
#define  RR_xHL        30
#define  RR_A          31
#define  SLA_B         32
#define  SLA_C         33
#define  SLA_D         34
#define  SLA_E         35
#define  SLA_H         36
#define  SLA_L         37
#define  SLA_xHL       38
#define  SLA_A         39
#define  SRA_B         40
#define  SRA_C         41
#define  SRA_D         42
#define  SRA_E         43
#define  SRA_H         44
#define  SRA_L         45
#define  SRA_xHL       46
#define  SRA_A         47
#define  SLL_B         48
#define  SLL_C         49
#define  SLL_D         50
#define  SLL_E         51
#define  SLL_H         52
#define  SLL_L         53
#define  SLL_xHL       54
#define  SLL_A         55
#define  SRL_B         56
#define  SRL_C         57
#define  SRL_D         58
#define  SRL_E         59
#define  SRL_H         60
#define  SRL_L         61
#define  SRL_xHL       62
#define  SRL_A         63
#define  BIT_0_B       64
#define  BIT_0_C       65
#define  BIT_0_D       66
#define  BIT_0_E       67
#define  BIT_0_H       68
#define  BIT_0_L       69
#define  BIT_0_xHL     70
#define  BIT_0_A       71
#define  BIT_1_B       72
#define  BIT_1_C       73
#define  BIT_1_D       74
#define  BIT_1_E       75
#define  BIT_1_H       76
#define  BIT_1_L       77
#define  BIT_1_xHL     78
#define  BIT_1_A       79
#define  BIT_2_B       80
#define  BIT_2_C       81
#define  BIT_2_D       82
#define  BIT_2_E       83
#define  BIT_2_H       84
#define  BIT_2_L       85
#define  BIT_2_xHL     86
#define  BIT_2_A       87
#define  BIT_3_B       88
#define  BIT_3_C       89
#define  BIT_3_D       90
#define  BIT_3_E       91
#define  BIT_3_H       92
#define  BIT_3_L       93
#define  BIT_3_xHL     94
#define  BIT_3_A       95
#define  BIT_4_B       96
#define  BIT_4_C       97
#define  BIT_4_D       98
#define  BIT_4_E       99
#define  BIT_4_H       100
#define  BIT_4_L       101
#define  BIT_4_xHL     102
#define  BIT_4_A       103
#define  BIT_5_B       104
#define  BIT_5_C       105
#define  BIT_5_D       106
#define  BIT_5_E       107
#define  BIT_5_H       108
#define  BIT_5_L       109
#define  BIT_5_xHL     110
#define  BIT_5_A       111
#define  BIT_6_B       112
#define  BIT_6_C       113
#define  BIT_6_D       114
#define  BIT_6_E       115
#define  BIT_6_H       116
#define  BIT_6_L       117
#define  BIT_6_xHL     118
#define  BIT_6_A       119
#define  BIT_7_B       120
#define  BIT_7_C       121
#define  BIT_7_D       122
#define  BIT_7_E       123
#define  BIT_7_H       124
#define  BIT_7_L       125
#define  BIT_7_xHL     126
#define  BIT_7_A       127
#define  RES_0_B       128
#define  RES_0_C       129
#define  RES_0_D       130
#define  RES_0_E       131
#define  RES_0_H       132
#define  RES_0_L       133
#define  RES_0_xHL     134
#define  RES_0_A       135
#define  RES_1_B       136
#define  RES_1_C       137
#define  RES_1_D       138
#define  RES_1_E       139
#define  RES_1_H       140
#define  RES_1_L       141
#define  RES_1_xHL     142
#define  RES_1_A       143
#define  RES_2_B       144
#define  RES_2_C       145
#define  RES_2_D       146
#define  RES_2_E       147
#define  RES_2_H       148
#define  RES_2_L       149
#define  RES_2_xHL     150
#define  RES_2_A       151
#define  RES_3_B       152
#define  RES_3_C       153
#define  RES_3_D       154
#define  RES_3_E       155
#define  RES_3_H       156
#define  RES_3_L       157
#define  RES_3_xHL     158
#define  RES_3_A       159
#define  RES_4_B       160
#define  RES_4_C       161
#define  RES_4_D       162
#define  RES_4_E       163
#define  RES_4_H       164
#define  RES_4_L       165
#define  RES_4_xHL     166
#define  RES_4_A       167
#define  RES_5_B       168
#define  RES_5_C       169
#define  RES_5_D       170
#define  RES_5_E       171
#define  RES_5_H       172
#define  RES_5_L       173
#define  RES_5_xHL     174
#define  RES_5_A       175
#define  RES_6_B       176
#define  RES_6_C       177
#define  RES_6_D       178
#define  RES_6_E       179
#define  RES_6_H       180
#define  RES_6_L       181
#define  RES_6_xHL     182
#define  RES_6_A       183
#define  RES_7_B       184
#define  RES_7_C       185
#define  RES_7_D       186
#define  RES_7_E       187
#define  RES_7_H       188
#define  RES_7_L       189
#define  RES_7_xHL     190
#define  RES_7_A       191
#define  SET_0_B       192
#define  SET_0_C       193
#define  SET_0_D       194
#define  SET_0_E       195
#define  SET_0_H       196
#define  SET_0_L       197
#define  SET_0_xHL     198
#define  SET_0_A       199
#define  SET_1_B       200
#define  SET_1_C       201
#define  SET_1_D       202
#define  SET_1_E       203
#define  SET_1_H       204
#define  SET_1_L       205
#define  SET_1_xHL     206
#define  SET_1_A       207
#define  SET_2_B       208
#define  SET_2_C       209
#define  SET_2_D       210
#define  SET_2_E       211
#define  SET_2_H       212
#define  SET_2_L       213
#define  SET_2_xHL     214
#define  SET_2_A       215
#define  SET_3_B       216
#define  SET_3_C       217
#define  SET_3_D       218
#define  SET_3_E       219
#define  SET_3_H       220
#define  SET_3_L       221
#define  SET_3_xHL     222
#define  SET_3_A       223
#define  SET_4_B       224
#define  SET_4_C       225
#define  SET_4_D       226
#define  SET_4_E       227
#define  SET_4_H       228
#define  SET_4_L       229
#define  SET_4_xHL     230
#define  SET_4_A       231
#define  SET_5_B       232
#define  SET_5_C       233
#define  SET_5_D       234
#define  SET_5_E       235
#define  SET_5_H       236
#define  SET_5_L       237
#define  SET_5_xHL     238
#define  SET_5_A       239
#define  SET_6_B       240
#define  SET_6_C       241
#define  SET_6_D       242
#define  SET_6_E       243
#define  SET_6_H       244
#define  SET_6_L       245
#define  SET_6_xHL     246
#define  SET_6_A       247
#define  SET_7_B       248
#define  SET_7_C       249
#define  SET_7_D       250
#define  SET_7_E       251
#define  SET_7_H       252
#define  SET_7_L       253
#define  SET_7_xHL     254
#define  SET_7_A       255
  

/*--- ED opcodes: ----------------------------------------------------*/ 
#define  IN_B_xC       64
#define  OUT_xC_B      65
#define  SBC_HL_BC     66
#define  LD_xNNe_BC    67
#define  NEG           68
#define  RETN          69
#define  IM_0          70
#define  LD_I_A        71
#define  IN_C_xC       72
#define  OUT_xC_C      73
#define  ADC_HL_BC     74
#define  LD_BC_xNNe    75
#define  ED_4C         76       /* * NEG */
#define  RETI          77
#define  ED_4E         78       /* * IM 0/1 */
#define  LD_R_A        79
#define  IN_D_xC       80
#define  OUT_xC_D      81
#define  SBC_HL_DE     82
#define  LD_xNNe_DE    83
#define  ED_54         84       /* * NEG */
#define  ED_55         85       /* * RET */
#define  IM_1          86
#define  LD_A_I        87
#define  IN_E_xC       88
#define  OUT_xC_E      89
#define  ADC_HL_DE     90
#define  LD_DE_xNNe    91
#define  ED_5C         92       /* * NEG */
#define  ED_5D         93       /* * RET */
#define  IM_2          94
#define  LD_A_R        95
#define  IN_H_xC       96
#define  OUT_xC_H      97
#define  SBC_HL_HL     98
#define  LD_xNNe_HL    99
#define  ED_64         100      /* * NEG */
#define  ED_65         101      /* * RET */
#define  ED_66         102      /* * IM 0 */
#define  RRD           103
#define  IN_L_xC       104
#define  OUT_xC_L      105
#define  ADC_HL_HL     106
#define  LD_HL_xNNe    107
#define  ED_6C         108      /* * NEG */
#define  ED_6D         109      /* * RET */
#define  ED_6E         110      /* * IM 0 */
#define  RLD           111
#define  IN_F_xC       112
#define  ED_71         113      /* * OUT (C), 0 */
#define  SBC_HL_SP     114
#define  LD_xNNe_SP    115
#define  ED_74         116      /* * NEG */
#define  ED_75         117      /* * RET */
#define  ED_76         118      /* * IM 1 */
#define  ED_77         119      /* * NOP */
#define  IN_A_xC       120
#define  OUT_xC_A      121
#define  ADC_HL_SP     122
#define  LD_SP_xNNe    123
#define  ED_7C         124      /* * NEG */
#define  ED_7D         125      /* * RET */
#define  ED_7E         126      /* * IM 2 */
#define  ED_7F         127      /* * NOP */
#define  LDI           160
#define  CPI           161
#define  INI           162
#define  OUTI          163
#define  LDD           168
#define  CPD           169
#define  IND           170
#define  OUTD          171
#define  LDIR          176
#define  CPIR          177
#define  INIR          178
#define  OTIR          179
#define  LDDR          184
#define  CPDR          185
#define  INDR          186
#define  OTDR          187
#define  ED_FE         254
  

/*--- DD xx opcodes: -------------------------------------------------*/ 
/* Those are the DD xx opcodes where HL is treated as IX + a
   signed byte displacement n when required:  DD opcode n:            */ 
  
/*--- FD xx opcodes: -------------------------------------------------*/ 
/* Those are the FD xx opcodes where HL is treated as IY + a
   signed byte displacement n when required:  FD opcode n:            */ 
  
#define  ADD_IXY_BC     9
#define  ADD_IXY_DE     25
#define  LD_IXY_NN      33
#define  LD_xNN_IXY     34
#define  INC_IXY        35
#define  INC_IXYh       36
#define  DEC_IXYh       37
#define  LD_IXYh_N      38
#define  ADD_IXY_IXY    41
#define  LD_IXY_xNN     42
#define  DEC_IXY        43
#define  INC_IXYl       44
#define  DEC_IXYl       45
#define  LD_IXYl_N      46
#define  INC_xIXY       52
#define  DEC_xIXY       53
#define  LD_xIXY_N      54
#define  ADD_IXY_SP     57
#define  LD_B_IXYh      68
#define  LD_B_IXYl      69
#define  LD_B_xIXY      70
#define  LD_C_IXYh      76
#define  LD_C_IXYl      77
#define  LD_C_xIXY      78
#define  LD_D_IXYh      84
#define  LD_D_IXYl      85
#define  LD_D_xIXY      86
#define  LD_E_IXYh      92
#define  LD_E_IXYl      93
#define  LD_E_xIXY      94
#define  LD_IXYh_B      96
#define  LD_IXYh_C      97
#define  LD_IXYh_D      98
#define  LD_IXYh_E      99
#define  LD_IXYh_IXYh   100
#define  LD_IXYh_IXYl   101
#define  LD_H_xIXY      102
#define  LD_IXYh_A      103
#define  LD_IXYl_B      104
#define  LD_IXYl_C      105
#define  LD_IXYl_D      106
#define  LD_IXYl_E      107
#define  LD_IXYl_IXYh   108
#define  LD_IXYl_IXYl   109
#define  LD_L_xIXY      110
#define  LD_IXYl_A      111
#define  LD_xIXY_B      112
#define  LD_xIXY_C      113
#define  LD_xIXY_D      114
#define  LD_xIXY_E      115
#define  LD_xIXY_H      116
#define  LD_xIXY_L      117
#define  LD_xIXY_A      119
#define  LD_A_IXYh      124
#define  LD_A_IXYl      125
#define  LD_A_xIXY      126
#define  ADD_IXYh       132
#define  ADD_IXYl       133
#define  ADD_xIXY       134
#define  ADC_IXYh       140
#define  ADC_IXYl       141
#define  ADC_xIXY       142
#define  SUB_IXYh       148
#define  SUB_IXYl       149
#define  SUB_xIXY       150
#define  SBC_IXYh       156
#define  SBC_IXYl       157
#define  SBC_xIXY       158
#define  AND_IXYh       164
#define  AND_IXYl       165
#define  AND_xIXY       166
#define  XOR_IXYh       172
#define  XOR_IXYl       173
#define  XOR_xIXY       174
#define  OR_IXYh        180
#define  OR_IXYl        181
#define  OR_xIXY        182
#define  CP_IXYh        188
#define  CP_IXYl        189
#define  CP_xIXY        190
#define  POP_IXY        225
#define  EX_IXY_xSP     227
#define  PUSH_IXY       229
#define  JP_IXY         233
#define  LD_SP_IXY      249
  



/*--- DD CB Prefix opcodes: ------------------------------------------*/ 
/* Those are the CB xx opcodes where HL is treated as IX + a
   signed byte displacement n:  DD CB n opcode:                       */ 
/*--- FD CB Prefix opcodes: ------------------------------------------*/ 
/* Those are the CB xx opcodes where HL is treated as IY + a
   signed byte displacement n:  FD CB n opcode:                       */ 
  
#define  RLC_IXYh       4
#define  RLC_IXYl       5
#define  RLC_xIXY       6
#define  RRC_IXYh       12
#define  RRC_IXYl       13
#define  RRC_xIXY       14
#define  RL_IXYh        20
#define  RL_IXYl        21
#define  RL_xIXY        22
#define  RR_IXYh        28
#define  RR_IXYl        29
#define  RR_xIXY        30
#define  SLA_IXYh       36
#define  SLA_IXYl       37
#define  SLA_xIXY       38
#define  SRA_IXYh       44
#define  SRA_IXYl       45
#define  SRA_xIXY       46
#define  SLL_IXYh       52
#define  SLL_IXYl       53
#define  SLL_xIXY       54
#define  SRL_IXYh       60
#define  SRL_IXYl       61
#define  SRL_xIXY       62
#define  BIT_0_IXYh     68
#define  BIT_0_IXYl     69
#define  BIT_0_xIXY     70
#define  BIT_1_IXYh     76
#define  BIT_1_IXYl     77
#define  BIT_1_xIXY     78
#define  BIT_2_IXYh     84
#define  BIT_2_IXYl     85
#define  BIT_2_xIXY     86
#define  BIT_3_IXYh     92
#define  BIT_3_IXYl     93
#define  BIT_3_xIXY     94
#define  BIT_4_IXYh     100
#define  BIT_4_IXYl     101
#define  BIT_4_xIXY     102
#define  BIT_5_IXYh     108
#define  BIT_5_IXYl     109
#define  BIT_5_xIXY     110
#define  BIT_6_IXYh     116
#define  BIT_6_IXYl     117
#define  BIT_6_xIXY     118
#define  BIT_7_IXYh     124
#define  BIT_7_IXYl     125
#define  BIT_7_xIXY     126
#define  RES_0_IXYh     132
#define  RES_0_IXYl     133
#define  RES_0_xIXY     134
#define  RES_1_IXYh     140
#define  RES_1_IXYl     141
#define  RES_1_xIXY     142
#define  RES_2_IXYh     148
#define  RES_2_IXYl     149
#define  RES_2_xIXY     150
#define  RES_3_IXYh     156
#define  RES_3_IXYl     157
#define  RES_3_xIXY     158
#define  RES_4_IXYh     164
#define  RES_4_IXYl     165
#define  RES_4_xIXY     166
#define  RES_5_IXYh     172
#define  RES_5_IXYl     173
#define  RES_5_xIXY     174
#define  RES_6_IXYh     180
#define  RES_6_IXYl     181
#define  RES_6_xIXY     182
#define  RES_7_IXYh     188
#define  RES_7_IXYl     189
#define  RES_7_xIXY     190
#define  SET_0_IXYh     196
#define  SET_0_IXYl     197
#define  SET_0_xIXY     198
#define  SET_1_IXYh     204
#define  SET_1_IXYl     205
#define  SET_1_xIXY     206
#define  SET_2_IXYh     212
#define  SET_2_IXYl     213
#define  SET_2_xIXY     214
#define  SET_3_IXYh     220
#define  SET_3_IXYl     221
#define  SET_3_xIXY     222
#define  SET_4_IXYh     228
#define  SET_4_IXYl     229
#define  SET_4_xIXY     230
#define  SET_5_IXYh     236
#define  SET_5_IXYl     237
#define  SET_5_xIXY     238
#define  SET_6_IXYh     244
#define  SET_6_IXYl     245
#define  SET_6_xIXY     246
#define  SET_7_IXYh     252
#define  SET_7_IXYl     253
#define  SET_7_xIXY     254
  
#endif
