// This code is LGPL, see licence.txt for details
//
#include <allegro.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include "alleg.h"

int get_tile(char *tile)
{
  static DATAFILE *tmp;
  static int i;

  tmp=find_datafile_object(Tiles.get_tiles(),tile);
  for(i=0;Tiles.get_tiles()[i].type==DAT_BITMAP;i++)
    if(tmp==&Tiles.get_tiles()[i])
      return i;
  return -1;
}


INLINE int tol(unsigned char* land,int x,int y,int ymx,int mx,int my)
    {
    int t=land[ymx+x];
    if(x>0)
      {
      t+=land[ymx+x-1];
      if(y>0) t+=land[ymx+x-1-mx];
      if(y<my-1) t+=land[ymx+x-1+mx];
      }
    if(y>0) t+=land[ymx+x-mx];
    if(x<mx-1)
      {
      t+=land[ymx+x+1];
      if(y>0) t+=land[ymx+x+1-mx];
      if(y<my-1) t+=land[ymx+x+1+mx];
      }
    if(y<my-1) t+=land[ymx+x+mx];

    return t;
    }
int generate_map(unsigned char *land,int seed,int sx,int sy,int mass)
  {
  unsigned char *map;
  if(mass<1) mass = 1;
  map=new unsigned char[sx*sy];
  srand(seed);
  memset(map,0,sx*sy);
  memset(land,0,sx*sy);
  int i,j;
  int landmass=0;

  int max;
  int cj=0;
  while(!key[KEY_K]&&landmass<mass)
    {
    landmass=0;

    for(j=0;j<5;j++)
      land[(rand()%sy)*sx+rand()%sx]+=rand()%5+1;

    for(cj=0,j=0;j<sy;cj+=sx,j++)
      for(i=0;i<sx;i++)
        {
        int total=tol(land,i,j,cj,sx,sy);
        map[cj+i]=total>>3;
        landmass+=map[cj+i];
        if(total>0) map[cj+i]+=rand()%2;
        }

    memcpy(land,map,sx*sy);

    }
  max=0;
  for(cj=0,j=0;j<sy;j++,cj+=sx)
    for(i=0;i<sx;i++)
      {
      int total=tol(land,i,j,cj,sx,sy);
      if(i==0||j==0||i==sx-1||j==sy-1)
        total=0;
      map[cj+i]=total/9;
      if(map[cj+i]>max) max=map[cj+i];
      }


  max/=2;
  int flg=0;
  while(!key[KEY_K]&&flg==0) { flg=1;
  for(cj=0,j=0;j<sy;j++,cj+=sx)
    {
    
    for(i=0;i<sx;i++)
      {
      if(map[cj+i]==0)
        {
        if(i-1>=0&&map[cj+i-1]>0)
          {
          if(i+1<sx&&map[cj+i+1]>0)
            {
            if(j-1>=0&&map[cj+i-sx]>0)
              {
              if(j+1<sy&&map[cj+i+sx]>0) land[cj+i]=get_tile("waternsew");
              else land[cj+i]=get_tile("waternew");
              }
            else if(j+1<sy&&map[cj+i+sx]>0) land[cj+i]=get_tile("watersew");
            else land[cj+i]=get_tile("waterew");
            }
          else if(j-1>=0&&map[cj+i-sx]>0)
            {
            if(j+1<sy&&map[cj+i+sx]>0) land[cj+i]=get_tile("waternsw");
            else land[cj+i]=get_tile("waternw");
            }
          else if(j+1<sy&&map[cj+i+sx]>0) land[cj+i]=get_tile("watersw");
          else land[cj+i]=get_tile("waterw");
          }
        else if(i+1<sx&&map[cj+i+1]>0)
          {
          if(j-1>=0&&map[cj+i-sx]>0)
            {
            if(j+1<sy&&map[cj+i+sx]>0) land[cj+i]=get_tile("waternse");
            else land[cj+i]=get_tile("waterne");
            }
          else if(j+1<sy&&map[cj+i+sx]>0) land[cj+i]=get_tile("waterse");
          else land[cj+i]=get_tile("watere");
          }
        else if(j-1>=0&&map[cj+i-sx]>0)
          {
          if(j+1<sy&&map[cj+i+sx]>0) land[cj+i]=get_tile("waterns");
          else land[cj+i]=get_tile("watern");
          }
        else if(j+1<sy&&map[cj+i+sx]>0) land[cj+i]=get_tile("waters");
        else land[cj+i]=get_tile("water1");
        }
      else if(float(map[cj+i])<=(float(max)*2)/3) land[cj+i]=(map[cj+i]%2==0) ? get_tile("grass1") : get_tile("grass2");
      else if(map[cj+i]>0) {
      if(map[cj+i-1]<=max*2/3)
          {
          if(map[cj+i+1]<=max*2/3)
           {
           if(map[cj+i-sx]<=max*2/3)
             {
              if(map[cj+i+sx]<=max*2/3) {flg=0;map[cj+i]=1;}
              else {map[cj+i]=1;flg=0;}
              }
            else if(map[cj+i+sx]<=max*2/3) {flg=0;map[cj+i]=1;}
            else {map[cj+i]=1;flg=0;}
            }
          else if(map[cj+i-sx]<=max*2/3)
            {
            if(map[cj+i+sx]<=max*2/3) {flg=0;map[cj+i]=1;}
            else land[cj+i]=get_tile("treesnw");
            }
          else if(map[cj+i+sx]<=max*2/3) land[cj+i]=get_tile("treessw");
          else land[cj+i]=get_tile("treesw");
          }
        else if(map[cj+i+1]<=max*2/3)
          {
          if(map[cj+i-sx]<=max*2/3)
            {
            if(map[cj+i+sx]<=max*2/3) {flg=0;map[cj+i]=1;}
            else land[cj+i]=get_tile("treesne");
            }
          else if(map[cj+i+sx]<=max*2/3) land[cj+i]=get_tile("treesse");
          else land[cj+i]=get_tile("treese");
          }
        else if(map[cj+i-sx]<=max*2/3)
          {
          if(map[cj+i+sx]<=max*2/3) {flg=0;map[cj+i]=1;}
          else land[cj+i]=get_tile("treesn");
          }
        else if(map[cj+i+sx]<=max*2/3) land[cj+i]=get_tile("treess");
        else land[cj+i]=get_tile("trees1");
        }

      else if(map[cj+i]<=max)
        {
        if(map[cj+i-1]<=max)
          {
          if(map[cj+i+1]<=max)
            {
            if(map[cj+i-sx]<=max)
              {
              if(map[cj+i+sx]<=max) land[cj+i]=get_tile("dirtnsew");
              else land[cj+i]=get_tile("dirtnew");
              }
            else if(map[cj+i+sx]<=max) land[cj+i]=get_tile("dirtsew");
            else land[cj+i]=get_tile("dirtew");
            }
          else if(map[cj+i-sx]<=max)
            {
            if(map[cj+i+sx]<=max) land[cj+i]=get_tile("dirtnsw");
            else land[cj+i]=get_tile("dirtnw");
            }
          else if(map[cj+i+sx]<=max) land[cj+i]=get_tile("dirtsw");
          else land[cj+i]=get_tile("dirtw");
          }
        else if(map[cj+i+1]<=max)
          {
          if(map[cj+i-sx]<=max)
            {
            if(map[cj+i+sx]<=max) land[cj+i]=get_tile("dirtnse");
            else land[cj+i]=get_tile("dirtne");
            }
          else if(map[cj+i+sx]<=max) land[cj+i]=get_tile("dirtse");
          else land[cj+i]=get_tile("dirte");
          }
        else if(map[cj+i-sx]<=max)
          {
          if(map[cj+i+sx]<=max) land[cj+i]=get_tile("dirtns");
          else land[cj+i]=get_tile("dirtn");
          }
        else if(map[cj+i+sx]<=max) land[cj+i]=get_tile("dirts");
        else land[cj+i]=get_tile("dirt1");
        }
      }

    }
  }
  delete []map;
  return 0;
}











