// This code is LGPL, see licence.txt for details
//
#include <stdio.h>
#include <string.h>

#include <allegro.h>
#include <time.h>


#include "alleg.h"

#include "func.h"
#include "points.h"
#include "npc.h"

#include "tile.h"
#include "layer.h"

#include "mapc.h"

c_layer::~c_layer()
{
  if(!copy) {
    if(tiles) delete []tiles;
    if(on_load_name) delete []on_load_name;
    if(on_load) free_hrs_script(on_load);
  }
}

void c_layer::moveTo(int p_x, int p_y)
{
	if (p_x>BUFFER_W && !getFlag(LAYER_CONTINUES))
	p_x %= BUFFER_W;
    if (p_y>BUFFER_H && !getFlag(LAYER_CONTINUES))
	p_y %= BUFFER_H;
    x=p_x;
    y=p_y;
}

void c_layer::changeSize(int p_width, int p_height)
{
	//todo for tile-editor: copy tile-data from old layer into new (and clip if nesseary)
    if(!tiles) delete []tiles;    //hehe don't forget about the memory-leaks!

    if (p_width<0)
	p_width=0;
    if (p_height<0)
	p_height=0;
    width = p_width;
    height= p_height;
    if (width<0)
       width=0;
    if (height<0)
       height=0;
    tiles = new c_tile[width*height]; 
}

void c_layer::setPic(int p_x,int p_y,int p_num)
{
    if (p_x<0||p_y<0||p_x>=width || p_y>=height)
	return;

    int i=p_y*width+p_x;

    tiles[i].setPic(p_num);

    if(p_num>=0&&p_num<Tiles.get_count()) {
      BITMAP *tmp=(BITMAP *)Tiles.get_tiles()[p_num].dat;
      if(Tiles.get_tiles()[p_num].type==DAT_FILE)
        tmp=(BITMAP *)((DATAFILE *)Tiles.get_tiles()[p_num].dat)[0].dat;
      if (tmp->w-32+8>extra_x) extra_x = tmp->w-32+8;
      if (tmp->h-32+8>extra_y) extra_y = tmp->h-32+8;
    }

}

void  c_layer::setTrans(int p_trans)
{
	if (p_trans<0)
	p_trans=0;
    if (p_trans>255)
	p_trans=255;
    trans=p_trans;
}


void c_layer::setFlag(int p_flag, int p_state)
{
    if (p_state==TRUE)
	flags |=p_flag;
    if (p_state==FALSE)
	flags &=~p_flag;
}

void c_layer::setFlags(int p_flags)
{
	flags=p_flags;
}

int c_layer::getFlag(int p_flag)
{
    return (p_flag&flags);
}


int c_layer::getFlags()
{
	return flags;
}

void c_layer::setSpeed(double p_speed_x, double p_speed_y)
{
	speed_x=p_speed_x;
    speed_y=p_speed_y;
}

double c_layer::getSpeed(int p_xory)
{
    if (p_xory == DIR_X)
	return speed_x;
    if (p_xory == DIR_Y)
	return speed_y;
    return 0;
}
void c_layer::setScroll(double p_scroll_x, double p_scroll_y)
{
	scroll_x=p_scroll_x;
    scroll_y=p_scroll_y;
}

double c_layer::getScroll(int p_xory)
{
    if (p_xory == DIR_X)
	return scroll_x;
    if (p_xory == DIR_Y)
	return scroll_y;
    return 0;
}

int c_layer::getSize(int p_woh)
{
    if (p_woh==SIZE_WIDTH)
	return width;
    if (p_woh==SIZE_HEIGHT)
	return height;
    return 0;
}

void c_layer::scroll(int p_x, int p_y, int p_editor) 
 {

    if (!p_editor)
    {
	//do some checking????
    }
	x+=p_x;
    if (x>width*grid_size_x && getFlag(LAYER_CONTINUES))
      x%=width*grid_size_x;
    y+=p_y;
    if (y>height*grid_size_y && getFlag(LAYER_CONTINUES))
      y%=height*grid_size_y;
	//todo: finish this later, when you know more about the tile-engine IN GAME
 }



c_tile * c_layer::getTilePointer(int p_x, int p_y)
{
    if (p_x<0||p_y<0||p_x>=width || p_y>=height)
	return NULL;
    return &tiles[p_y*width+p_x];
}

int c_layer::gridx()
{
    return grid_size_x;
}

int c_layer::gridy()
{
    return grid_size_y;
}

void c_layer::setGrid(int p_x,int p_y)
{
    grid_size_x=p_x;
    grid_size_y=p_y;
}

int c_layer::getz() 
{
    return z;
}

void c_layer::setz(int _z)
{
    z=_z;
}

void c_layer::update()
{
  int i;
  int j=width*height;
  c_tile *tmp=tiles;
  
  scroll((int)speed_x,(int)speed_y,FALSE);
  
  delta++; // should this be always just 1?

  for(i=0;i<j;i++,tmp++)
    if(tmp->getFlag(TILE_PLAYANIMATION))	
      tmp->animationDo(ANIMATION_NEXT);
  
      
  
 
}

#define get_map(mp,x,y,cx,cy) mp[((x)%(cx))+((y)%(cy))*(cx)]


void c_layer::draw(BITMAP *bmp,int p_x, int p_y,int draw_mode)
{                 
  if (!tiles) return;
                                    
  if(trans==255) return;                                  
  if(trans>0&&draw_mode==0) return;
  if(trans==0&&draw_mode==1) return;

  int stx,sty,etx,ety;
  int ssx,temp_ssx,ssy,esx,esy;
  int ccx,ccy;
  int view_at_x=int((p_x*scroll_x)-x);
  int view_at_y=int((p_y*scroll_y)-y);
  int wrap=getFlag(LAYER_CONTINUES);
  int effect;

  if(wrap) {
     while(view_at_x<0) view_at_x+=width*grid_size_x;
     while(view_at_y<0) view_at_y+=height*grid_size_y;
  }

  stx=int(view_at_x/grid_size_x); // top tile row
  sty=int(view_at_y/grid_size_y); // left tile col
  etx=int(((view_at_x+bmp->w+extra_x)/grid_size_x)+1); // bottom tile row
  ety=int(((view_at_y+bmp->h+extra_y)/grid_size_y)+1); // right tile col

  if(!wrap) {
    if(stx<0) stx=0;      //  Bounds checks.
    if(sty<0) sty=0;
    if(etx>width) etx=width;
    if(ety>height) ety=height;
  }

  ssx=((stx+1)*grid_size_x)-view_at_x;   // x position on screen of first tile to draw
  ssy=((sty+1)*grid_size_y)-view_at_y;   // y position on screen of first tile to draw
  esx=((etx+1)*grid_size_x)-view_at_x;   // x position on screen of last tile to draw
  esy=((ety+1)*grid_size_y)-view_at_y;   // y position on screen of last tile to draw

  c_tile *vtmp;
  c_tile *htmp;   
  
  if(getFlag(LAYER_EFFECT0)) effect= 1;
  else if(getFlag(LAYER_EFFECT1)) effect =2;
  else effect=0;

  if(wrap) 
    for(ccy=sty;ssy<esy;ccy++,ssy+=grid_size_y)
      for(ccx=stx,temp_ssx=ssx;temp_ssx<esx;ccx++,temp_ssx+=grid_size_x)
        get_map(tiles,ccx,ccy,width,height).draw(bmp,temp_ssx,ssy,trans,effect,delta,draw_mode);
  else // faster version
    for(vtmp=&tiles[sty*width];ssy<esy;vtmp+=width,ssy+=grid_size_y)
      for(htmp=vtmp+stx,temp_ssx=ssx;temp_ssx<esx;htmp++,temp_ssx+=grid_size_x)
        htmp->draw(bmp,temp_ssx,ssy,trans,effect,delta,draw_mode);

  Tiles.stop_effect();   
}
int c_layer::check_tile(BITMAP *spr,int p_x, int p_y)
{
  if (!tiles) return FALSE;

  int stx,sty,etx,ety;
  int ssx,temp_ssx,ssy,esx,esy;
  int view_at_x=int(p_x-x);
  int view_at_y=int(p_y-y);

  stx=int(view_at_x/grid_size_x); // top tile row
  sty=int(view_at_y/grid_size_y); // left tile col
  etx=int(((view_at_x+spr->w+extra_x)/grid_size_x)+1); // bottom tile row
  ety=int(((view_at_y+spr->h+extra_y)/grid_size_y)+1); // right tile col

  if(stx<0) stx=0;      //  Bounds checks.
  if(sty<0) sty=0;
  if(etx>width) etx=width;
  if(ety>height) ety=height;

  ssx=((stx+1)*grid_size_x)-view_at_x;   // x position on screen of first tile to draw
  ssy=((sty+1)*grid_size_y)-view_at_y;   // y position on screen of first tile to draw
  esx=((etx+1)*grid_size_x)-view_at_x;   // x position on screen of last tile to draw
  esy=((ety+1)*grid_size_y)-view_at_y;   // y position on screen of last tile to draw

  c_tile *vtmp;
  c_tile *htmp;

  for(vtmp=&tiles[sty*width];ssy<esy;vtmp+=width,ssy+=grid_size_y)
    for(htmp=vtmp+stx,temp_ssx=ssx;temp_ssx<esx;htmp++,temp_ssx+=grid_size_x)
      if(htmp->check_tile(spr,temp_ssx,ssy))
        return TRUE;
  return FALSE;
}

void c_layer::drawGrid(int p_x, int p_y, int p_color)
{
    p_x=int(p_x*scroll_x);
    p_y=int(p_y*scroll_y);
    for (int xl=0;xl<=grid_size_x*width;xl+=grid_size_x)
    {
	vline(buffer,-p_x+x+xl,-p_y+y,-p_y+y+height*grid_size_y,p_color);
    }
    for (int yl=0;yl<=grid_size_y*height;yl+=grid_size_y)
    {
	hline(buffer,-p_x+x,-p_y+y+yl,-p_x+x+width*grid_size_x,p_color);
    }
}



int c_layer::randomize()
{
   int i;
   
   unsigned char *map=(unsigned char *)new char[width*height];	

   memset(map,0,width*height);

   generate_map(map,time(NULL),width,height,width*height);

   for(i=0;i<width*height;i++)
     tiles[i].setPic(map[i]);


   delete []map; 

   return 0;
}

int c_layer::getX()
{
	return x;
}

int c_layer::getY()
{
	return y;
}

int c_layer::saveToFile(PACKFILE * file)
{
	if (!file) return -1;
	
	int l;

    //write layer_header
    pack_iputl(x,file);
    pack_iputl(y,file);
    pack_iputl(z,file);
    pack_iputl(width,file);
    pack_iputl(height,file);
    pack_iputl(trans,file);
    pack_iputl(edit_trans,file);
    pack_iputl(flags,file);
    pack_iputl(ftofix(speed_x),file);
    pack_iputl(ftofix(speed_y),file);
    pack_iputl(ftofix(scroll_x),file);
    pack_iputl(ftofix(scroll_y),file);
    pack_iputl(grid_size_x,file);
    pack_iputl(grid_size_y,file);
    pack_iputl(reflect_type,file);
    pack_iputl(reflect_y,file);
    pack_iputl(reflect_z,file);
    pack_iputl(reflect_trans,file);
    
    if(on_load_name)
      l=strlen(on_load_name);
    else l=0;
    pack_iputl(l,file);
    if(l>0) pack_fwrite(on_load_name,l,file);
    
    
    //write all tiles in this layer
    for (int i=0;i<width*height;i++) {
	  tiles[i].saveToFile(file);
    }
	return 0;
}

int c_layer::loadFromFile(PACKFILE * file,int version,int compile)
{
	if (!file)
	return -1;

    int ret,l;
    extra_x=0;
    extra_y=0;
    BITMAP *tmp;
    int ww,hh;
    if(!tiles) delete []tiles;      //hehe don't forget about the memory-leaks!
    on_load_name=NULL;
    on_load=NULL;

    //read layer_header
    switch(version) {
      case 1: {
	 x=pack_igetl(file);
	 y=pack_igetl(file);
	 width=pack_igetl(file);
	 height=pack_igetl(file);
	 trans=pack_igetl(file);
	 edit_trans=pack_igetl(file);
	 flags=pack_igetl(file);
	 speed_x=fixtof(pack_igetl(file));
	 speed_y=fixtof(pack_igetl(file));


	 if (width<0)
	   width=0;
	 if (height<0)
	   height=0;

	 tiles = new c_tile[width*height];

	 //read all tiles in this layer
	 for (int i=0;i<width*height;i++)
	 {
	     ret=tiles[i].loadFromFile(file,version,compile);

             if(ret>=0 && ret<Tiles.get_count() &&Tiles.get_tiles()[ret].type==DAT_BITMAP) {
               tmp=(BITMAP *)Tiles.get_tiles()[ret].dat;
	       if (tmp->w-32+8>extra_x) extra_x = tmp->w-32+8;
	       if (tmp->h-32+8>extra_y) extra_y = tmp->h-32+8;

	     }
	 }
	 break;
       }
      case 2: case 3: case 4: { 
	 x=pack_igetl(file);
	 y=pack_igetl(file);
	 width=pack_igetl(file);
	 height=pack_igetl(file);
	 trans=pack_igetl(file);
	 edit_trans=pack_igetl(file);
	 flags=pack_igetl(file);
	 speed_x=fixtof(pack_igetl(file));
	 speed_y=fixtof(pack_igetl(file));
	 grid_size_x=pack_igetl(file);
	 grid_size_y=pack_igetl(file);


	 if (width<0)
	   width=0;
	 if (height<0)
	   height=0;

	 tiles = new c_tile[width*height];

	 //read all tiles in this layer
	 for (int i=0;i<width*height;i++)
	 {
	     ret = tiles[i].loadFromFile(file,version,compile);

             if(ret>=0 && ret<Tiles.get_count() &&Tiles.get_tiles()[ret].type==DAT_BITMAP) {
               tmp=(BITMAP *)Tiles.get_tiles()[ret].dat;
	       ww=tmp->w-32;
	       hh=tmp->h-32;

	       if (ww>extra_x+8) extra_x = ww+8;
	       if (hh>extra_y+8) extra_y = hh+8;

	     }

	 }
	 break;
       }
       case 5: case 6: case 7: case 8: case 9:{ 
	 x=pack_igetl(file);
	 y=pack_igetl(file);
         z=pack_igetl(file);
	 width=pack_igetl(file);
	 height=pack_igetl(file);
	 trans=pack_igetl(file);
	 edit_trans=pack_igetl(file);
	 flags=pack_igetl(file);
	 speed_x=fixtof(pack_igetl(file));
	 speed_y=fixtof(pack_igetl(file));
	 grid_size_x=pack_igetl(file);
	 grid_size_y=pack_igetl(file);


	 if (width<0)
	   width=0;
	 if (height<0)
	   height=0;

	 tiles = new c_tile[width*height];

	 //read all tiles in this layer
	 for (int i=0;i<width*height;i++)
	 {
	     ret = tiles[i].loadFromFile(file,version,compile);

             if(ret>=0 && ret<Tiles.get_count() &&Tiles.get_tiles()[ret].type==DAT_BITMAP) {
               tmp=(BITMAP *)Tiles.get_tiles()[ret].dat;
	       ww=tmp->w-32;
	       hh=tmp->h-32;

	       if (ww>extra_x+8) extra_x = ww+8;
	       if (hh>extra_y+8) extra_y = hh+8;

	     }

	 }
	 break;
	 }
	    case 10: case 11:{ 
	 x=pack_igetl(file);
	 y=pack_igetl(file);
         z=pack_igetl(file);
	 width=pack_igetl(file);
	 height=pack_igetl(file);
	 trans=pack_igetl(file);
	 edit_trans=pack_igetl(file);
	 flags=pack_igetl(file);
	 speed_x=fixtof(pack_igetl(file));
	 speed_y=fixtof(pack_igetl(file));
	 scroll_x=fixtof(pack_igetl(file));
	 scroll_y=fixtof(pack_igetl(file));
	 grid_size_x=pack_igetl(file);
	 grid_size_y=pack_igetl(file);
     reflect_type=pack_igetl(file);
     reflect_y=pack_igetl(file);
     reflect_z=pack_igetl(file);
     reflect_trans=pack_igetl(file);
     
     if(version>10) {
       l=pack_igetl(file);

       if(l>0) {
         char tempf[50],*tempy;
         pack_fread(tempf,l,file);
         tempf[l]=0;
         tempy=get_filename(tempf);
              
         on_load_name=new char[strlen(tempy)+1];
         strcpy(on_load_name,tempy);
       }
       else on_load_name=NULL;
          
       if(compile&&on_load_name) {
         on_load=compile_hrs_script(on_load_name);
       } else on_load=NULL;
     }

	 if (width<0)
	   width=0;
	 if (height<0)
	   height=0;

	 tiles = new c_tile[width*height];

	 //read all tiles in this layer
	 for (int i=0;i<width*height;i++)
	 {
	     ret = tiles[i].loadFromFile(file,version,compile);

             if(ret>=0 && ret<Tiles.get_count() &&Tiles.get_tiles()[ret].type==DAT_BITMAP) {
               tmp=(BITMAP *)Tiles.get_tiles()[ret].dat;
	       ww=tmp->w-32;
	       hh=tmp->h-32;

	       if (ww>extra_x+8) extra_x = ww+8;
	       if (hh>extra_y+8) extra_y = hh+8;

	     }

	    }
	    break;
       }

       default: return -1;
    }
    return 0;
}
