/* The Segment Pixel Perfect routine by FenrirWolf 3/26/99. */

/* adjusted by Nathan Smith */

#include <allegro.h>
#include "spp.h"

int spp_detect_collision8 (int x1, int y1, BITMAP *sprite1,
                          int x2, int y2, BITMAP *sprite2) {

  static int bx1, by1, bx2, by2, bx3, by3 ; // Our rectangular intersection points

  static int x, y, lenx, leny ;  // Used for the detection loop

  static char **sl1,**sl2,*sw1,*sw2;
  
  // First, do bounding-box detection
  if (((x1 + ((BITMAP *) sprite1)->w) >= x2)  &&
      (x1 < (x2 + ((BITMAP *) sprite2)->w)) &&
      ((y1 + ((BITMAP *) sprite1)->h) >= y2)  &&
      (y1 < (y2 + ((BITMAP *) sprite2)->h))) {

    // Compute the intersection point
    bx1 = x1 - x2 ; if (bx1 < 0) bx1 = 0 ;
    by1 = y1 - y2 ; if (by1 < 0) by1 = 0 ;

    if (x1 < x2) bx2 = x2 - x1 ; else bx2 = 0 ;
    if (y1 < y2) by2 = y2 - y1 ; else by2 = 0 ;

    if (x1 > x2 + ((BITMAP *) sprite2)->w - ((BITMAP *) sprite1)->w)
      bx3 = x2 + ((BITMAP *) sprite2)->w - x1 ;
    else
      bx3 = ((BITMAP *) sprite1)->w ;

    if (y1 > y2 + ((BITMAP *) sprite2)->h - ((BITMAP *) sprite1)->h)
      by3 = y2 + ((BITMAP *) sprite2)->h - y1 ;
    else
      by3 = ((BITMAP *) sprite1)->h ;

    lenx = abs (bx2 - bx3) ;
    leny = abs (by2 - by3) ;

    sl1=(char **)sprite1->line+by2;
    sl2=(char **)sprite2->line+by1;

    // Now, do pixel-perfect detection on the intersection rectangle
    for (y = 0; y < leny; y++,sl1++,sl2++) {
      sw1=*sl1+bx2;
      sw2=*sl2+bx1;
      for (x = 0; x < lenx; x++,sw1++,sw2++)
        if (*sw1 != 0 && *sw2 != 0) 
            return TRUE;
    }
    
          
  }
  return FALSE;
}

int spp_detect_collision15 (int x1, int y1, BITMAP *sprite1,
                          int x2, int y2, BITMAP *sprite2) {

  static int bx1, by1, bx2, by2, bx3, by3 ; // Our rectangular intersection points

  static int x, y, lenx, leny ;  // Used for the detection loop

  static short **sl1,**sl2,*sw1,*sw2,c;



  // First, do bounding-box detection
  if (((x1 + ((BITMAP *) sprite1)->w) >= x2)  &&
       (x1 < (x2 + ((BITMAP *) sprite2)->w)) &&
      ((y1 + ((BITMAP *) sprite1)->h) >= y2)  &&
       (y1 < (y2 + ((BITMAP *) sprite2)->h))) {

    if(bitmap_color_depth(sprite1)==15)
      c=MASK_COLOR_15;
    else c=MASK_COLOR_16;

    // Compute the intersection point
    bx1 = x1 - x2 ; if (bx1 < 0) bx1 = 0 ;
    by1 = y1 - y2 ; if (by1 < 0) by1 = 0 ;

    if (x1 < x2) bx2 = x2 - x1 ; else bx2 = 0 ;
    if (y1 < y2) by2 = y2 - y1 ; else by2 = 0 ;

    if (x1 > x2 + ((BITMAP *) sprite2)->w - ((BITMAP *) sprite1)->w)
      bx3 = x2 + ((BITMAP *) sprite2)->w - x1 ;
    else
      bx3 = ((BITMAP *) sprite1)->w ;

    if (y1 > y2 + ((BITMAP *) sprite2)->h - ((BITMAP *) sprite1)->h)
      by3 = y2 + ((BITMAP *) sprite2)->h - y1 ;
    else
      by3 = ((BITMAP *) sprite1)->h ;

    lenx = abs (bx2 - bx3) ;
    leny = abs (by2 - by3) ;

    sl1=((short **)sprite1->line)+by2;
    sl2=((short **)sprite2->line)+by1;

    // Now, do pixel-perfect detection on the intersection rectangle
    for (y = 0; y < leny; y++,sl1++,sl2++) {
      sw1=*sl1+bx2;
      sw2=*sl2+bx1;
      for (x = 0; x < lenx; x++,sw1++,sw2++)
        if (*sw1 != c && *sw2 != c) 
            return TRUE;
    }
    
          
  }
  return FALSE;
}

int spp_detect_collision24 (int x1, int y1, BITMAP *sprite1,
                          int x2, int y2, BITMAP *sprite2) {

  static int bx1, by1, bx2, by2, bx3, by3 ; // Our rectangular intersection points

  static int x, y, lenx, leny ;  // Used for the detection loop

  static long **sl1,**sl2,*sw1,*sw2,c;



  // First, do bounding-box detection
  if (((x1 + ((BITMAP *) sprite1)->w) >= x2)  &&
       (x1 < (x2 + ((BITMAP *) sprite2)->w)) &&
      ((y1 + ((BITMAP *) sprite1)->h) >= y2)  &&
       (y1 < (y2 + ((BITMAP *) sprite2)->h))) {

    if(bitmap_color_depth(sprite1)==24)
      c=MASK_COLOR_24;
    else c=MASK_COLOR_32;

    // Compute the intersection point
    bx1 = x1 - x2 ; if (bx1 < 0) bx1 = 0 ;
    by1 = y1 - y2 ; if (by1 < 0) by1 = 0 ;

    if (x1 < x2) bx2 = x2 - x1 ; else bx2 = 0 ;
    if (y1 < y2) by2 = y2 - y1 ; else by2 = 0 ;

    if (x1 > x2 + ((BITMAP *) sprite2)->w - ((BITMAP *) sprite1)->w)
      bx3 = x2 + ((BITMAP *) sprite2)->w - x1 ;
    else
      bx3 = ((BITMAP *) sprite1)->w ;

    if (y1 > y2 + ((BITMAP *) sprite2)->h - ((BITMAP *) sprite1)->h)
      by3 = y2 + ((BITMAP *) sprite2)->h - y1 ;
    else
      by3 = ((BITMAP *) sprite1)->h ;

    lenx = abs (bx2 - bx3) ;
    leny = abs (by2 - by3) ;

    sl1=((long **)sprite1->line)+by2;
    sl2=((long **)sprite2->line)+by1;

    // Now, do pixel-perfect detection on the intersection rectangle
    for (y = 0; y < leny; y++,sl1++,sl2++) {
      sw1=*sl1+bx2;
      sw2=*sl2+bx1;
      for (x = 0; x < lenx; x++,sw1++,sw2++)
        if (*sw1 != c && *sw2 != c) 
            return TRUE;
    }
    
          
  }
  return FALSE;
}

int spp_detect_collision (int x1, int y1, BITMAP *sprite1,
                          int x2, int y2, BITMAP *sprite2) {
  if(bitmap_color_depth(sprite1)!=bitmap_color_depth(sprite2)) {
    set_gfx_mode(GFX_TEXT,0,0,0,0);
    allegro_message("Mismatched graphic color depths.");
    exit(1);
  }

  switch(bitmap_color_depth(sprite1)) {
    case 8:
      return spp_detect_collision8(x1,y1,sprite1,x2,y2,sprite2);      
    case 15:
    case 16:
      return spp_detect_collision15(x1,y1,sprite1,x2,y2,sprite2);
    case 24:
    case 32:
      return spp_detect_collision24(x1,y1,sprite1,x2,y2,sprite2);
  }
  set_gfx_mode(GFX_TEXT,0,0,0,0);
  allegro_message("Bad graphic color depth.");
  exit(1);
  return FALSE;
}
int spp_check_red (int x1, int y1, BITMAP *sprite1,
                          int x2, int y2, BITMAP *sprite2) {

  static int bx1, by1, bx2, by2, bx3, by3 ; // Our rectangular intersection points

  static int x, y, lenx, leny ;  // Used for the detection loop

  static short **sl1,**sl2,*sw1,*sw2,c;



  // First, do bounding-box detection
  if (((x1 + ((BITMAP *) sprite1)->w) >= x2)  &&
       (x1 < (x2 + ((BITMAP *) sprite2)->w)) &&
      ((y1 + ((BITMAP *) sprite1)->h) >= y2)  &&
       (y1 < (y2 + ((BITMAP *) sprite2)->h))) {

    if(bitmap_color_depth(sprite1)==15)
      c=MASK_COLOR_15;
    else c=MASK_COLOR_16;

    // Compute the intersection point
    bx1 = x1 - x2 ; if (bx1 < 0) bx1 = 0 ;
    by1 = y1 - y2 ; if (by1 < 0) by1 = 0 ;

    if (x1 < x2) bx2 = x2 - x1 ; else bx2 = 0 ;
    if (y1 < y2) by2 = y2 - y1 ; else by2 = 0 ;

    if (x1 > x2 + ((BITMAP *) sprite2)->w - ((BITMAP *) sprite1)->w)
      bx3 = x2 + ((BITMAP *) sprite2)->w - x1 ;
    else
      bx3 = ((BITMAP *) sprite1)->w ;

    if (y1 > y2 + ((BITMAP *) sprite2)->h - ((BITMAP *) sprite1)->h)
      by3 = y2 + ((BITMAP *) sprite2)->h - y1 ;
    else
      by3 = ((BITMAP *) sprite1)->h ;

    lenx = abs (bx2 - bx3) ;
    leny = abs (by2 - by3) ;

    sl1=((short **)sprite1->line)+by2;
    sl2=((short **)sprite2->line)+by1;

    // Now, do pixel-perfect detection on the intersection rectangle
    for (y = 0; y < leny; y++,sl1++,sl2++) {
      sw1=*sl1+bx2;
      sw2=*sl2+bx1;
      for (x = 0; x < lenx; x++,sw1++,sw2++) {
        if (*sw1 != c && getr(*sw2) == 255) 
            return RED_255;
        else 
          if (*sw1 != c && getr(*sw2) == 128) 
              return RED_128;

      }
    }
    
          
  }
  return 0;
}
int spp_check_green (int x1, int y1, BITMAP *sprite1,
                          int x2, int y2, BITMAP *sprite2) {

  static int bx1, by1, bx2, by2, bx3, by3 ; // Our rectangular intersection points

  static int x, y, lenx, leny ;  // Used for the detection loop

  static short **sl1,**sl2,*sw1,*sw2,c;



  // First, do bounding-box detection
  if (((x1 + ((BITMAP *) sprite1)->w) >= x2)  &&
       (x1 < (x2 + ((BITMAP *) sprite2)->w)) &&
      ((y1 + ((BITMAP *) sprite1)->h) >= y2)  &&
       (y1 < (y2 + ((BITMAP *) sprite2)->h))) {

    if(bitmap_color_depth(sprite1)==15)
      c=MASK_COLOR_15;
    else c=MASK_COLOR_16;

    // Compute the intersection point
    bx1 = x1 - x2 ; if (bx1 < 0) bx1 = 0 ;
    by1 = y1 - y2 ; if (by1 < 0) by1 = 0 ;

    if (x1 < x2) bx2 = x2 - x1 ; else bx2 = 0 ;
    if (y1 < y2) by2 = y2 - y1 ; else by2 = 0 ;

    if (x1 > x2 + ((BITMAP *) sprite2)->w - ((BITMAP *) sprite1)->w)
      bx3 = x2 + ((BITMAP *) sprite2)->w - x1 ;
    else
      bx3 = ((BITMAP *) sprite1)->w ;

    if (y1 > y2 + ((BITMAP *) sprite2)->h - ((BITMAP *) sprite1)->h)
      by3 = y2 + ((BITMAP *) sprite2)->h - y1 ;
    else
      by3 = ((BITMAP *) sprite1)->h ;

    lenx = abs (bx2 - bx3) ;
    leny = abs (by2 - by3) ;

    sl1=((short **)sprite1->line)+by2;
    sl2=((short **)sprite2->line)+by1;

    // Now, do pixel-perfect detection on the intersection rectangle
    for (y = 0; y < leny; y++,sl1++,sl2++) {
      sw1=*sl1+bx2;
      sw2=*sl2+bx1;
      for (x = 0; x < lenx; x++,sw1++,sw2++)
        if (*sw1 != c && getg(*sw2) == 255) 
            return GREEN_255;
    }
    
          
  }
  return 0;
}

int spp_check_blue (int x1, int y1, BITMAP *sprite1,
                          int x2, int y2, BITMAP *sprite2) {

  static int bx1, by1, bx2, by2, bx3, by3 ; // Our rectangular intersection points

  static int x, y, lenx, leny ;  // Used for the detection loop

  static short **sl1,**sl2,*sw1,*sw2,c;



  // First, do bounding-box detection
  if (((x1 + ((BITMAP *) sprite1)->w) >= x2)  &&
       (x1 < (x2 + ((BITMAP *) sprite2)->w)) &&
      ((y1 + ((BITMAP *) sprite1)->h) >= y2)  &&
       (y1 < (y2 + ((BITMAP *) sprite2)->h))) {

    if(bitmap_color_depth(sprite1)==15)
      c=MASK_COLOR_15;
    else c=MASK_COLOR_16;

    // Compute the intersection point
    bx1 = x1 - x2 ; if (bx1 < 0) bx1 = 0 ;
    by1 = y1 - y2 ; if (by1 < 0) by1 = 0 ;

    if (x1 < x2) bx2 = x2 - x1 ; else bx2 = 0 ;
    if (y1 < y2) by2 = y2 - y1 ; else by2 = 0 ;

    if (x1 > x2 + ((BITMAP *) sprite2)->w - ((BITMAP *) sprite1)->w)
      bx3 = x2 + ((BITMAP *) sprite2)->w - x1 ;
    else
      bx3 = ((BITMAP *) sprite1)->w ;

    if (y1 > y2 + ((BITMAP *) sprite2)->h - ((BITMAP *) sprite1)->h)
      by3 = y2 + ((BITMAP *) sprite2)->h - y1 ;
    else
      by3 = ((BITMAP *) sprite1)->h ;

    lenx = abs (bx2 - bx3) ;
    leny = abs (by2 - by3) ;

    sl1=((short **)sprite1->line)+by2;
    sl2=((short **)sprite2->line)+by1;

    // Now, do pixel-perfect detection on the intersection rectangle
    for (y = 0; y < leny; y++,sl1++,sl2++) {
      sw1=*sl1+bx2;
      sw2=*sl2+bx1;
      for (x = 0; x < lenx; x++,sw1++,sw2++)
        if (*sw1 != c && getb(*sw2) == 255) 
            return BLUE_255;
    }
    
          
  }
  return 0;
}

int spp_check_area (int x1, int y1, BITMAP *sprite1,
                          int x2, int y2, BITMAP *sprite2) {
  return spp_check_red(x1,y1,sprite1,x2,y2,sprite2) |
         spp_check_green(x1,y1,sprite1,x2,y2,sprite2) |
         spp_check_blue(x1,y1,sprite1,x2,y2,sprite2);
}

