// This code is LGPL, see licence.txt for details
//
// VM.CPP: The virtual machine
#include <allegro.h>
#include <stdio.h>
#include <math.h>
#include <string.h>
#include <allegro.h>
//#include "fortify.h"
#include "mystring.h"
#include "func.h"
#include "symtab.h"
#include "vm.h"       // VMachine class definition

// VMachine constructor
VMachine::VMachine ()   {
	int i;
	//for (i=0;i<MAX_STR;i++){str[i]=NULL;}
   instr = NULL; ninstr = 0;
   for (i=0; i<MAX_STR; i++)   
      str[i]=NULL;
   total_builtin=0;
}

VMachine::~VMachine () {
//   Reset();
   Clear();
}

// Reset the virtual machine ready to be run again
void VMachine::Reset() {
   if(this==NULL) return;
   int i;
   for (i=total_builtin; i<MAX_STR; i++)    {
      if (str[i] != NULL)  {
         if(str[i]->temp) {clear_hrs_var(str[i]); delete str[i];}
         str[i]=NULL;
      }
   }
   stack.Empty();
}

// Clear the virtual machine completely
void VMachine::Clear ()   {
   if(this==NULL) return;
   int i;
   for (i=0; i<MAX_STR; i++)    {
      if (str[i] != NULL)  {
       if(str[i]->temp) {
         clear_hrs_var(str[i]); 
         delete str[i]; 
       }
       str[i] = NULL;
     }
   }
   if (instr != NULL)  {delete[] instr; instr = NULL; ninstr = 0;}
}

extern SymTab st;
extern IntInstr *intcode;

int find_label(char *target,int ii)
{
  int i;
  if(!target) {
    set_gfx_mode(GFX_TEXT,0,0,0,0);
    allegro_message("Bad target in jump");
    exit(-1);
  }

  int ninstr = intcode->Len();
  IntInstr *cinstr = intcode;
   
  for (i = 0; i < ninstr; i++)   {
    if(cinstr->opcode==JUMPTARGET&&cinstr->target){
      if(strcmp(cinstr->target,target)==0)
        return i - ii;
    }
    cinstr = cinstr->next;
  }


  set_gfx_mode(GFX_TEXT,0,0,0,0);
  allegro_message("Bad target in jump");
  exit(-1);

  return 1; // if it can't find the label JMP forward 1 (do nothing)

}

// Read a program
// (connected to the compiler for extreme laziness purposes)
void VMachine::Read ()   {
   if(this==NULL) return;
   int i=0;

//   intcode->Show();

   SymDesc *s = st.GetFirst();
   while (s != NULL)   {
      switch(s->type) {
        case STR_VAR:
	      str[i] = new hrs_variable;
          str[i]->type=VAR_STR;
          str[i]->constant=FALSE;
          str[i]->temp=FALSE;
          str[i]->dat.var_string = new String (s->value.var->dat.var_string->Val());
          s->SetNo (i); // Set number so we can find its index back later (aarggh.. dirty coding!!)
          i++;
          break;
        case STR_CONST:
          str[i] = new hrs_variable;
          str[i]->type=VAR_STR;
          str[i]->constant=TRUE;
          str[i]->temp=FALSE;
          str[i]->dat.var_string = new String (s->value.var->dat.var_string->Val());
          s->SetNo (i); // Set number so we can find its index back later (aarggh.. dirty coding!!)
          i++;
          break;
        case INT_VAR:
	      str[i] = new hrs_variable;
          str[i]->type=VAR_INT;
          str[i]->constant=FALSE;
          str[i]->temp=FALSE;
          str[i]->dat.var_int = s->value.var->dat.var_int;
          s->SetNo (i); // Set number so we can find its index back later (aarggh.. dirty coding!!)
          i++;
          break;
        case INT_CONST:
          str[i] = new hrs_variable;
          str[i]->type=VAR_INT;
          str[i]->constant=TRUE;
          str[i]->temp=FALSE;
          str[i]->dat.var_int = s->value.var->dat.var_int;
          s->SetNo (i); // Set number so we can find its index back later (aarggh.. dirty coding!!)
          i++;
          break;
        case FLOAT_VAR:
	      str[i] = new hrs_variable;
          str[i]->type=VAR_REAL;
          str[i]->constant=FALSE;
          str[i]->temp=FALSE;
          str[i]->dat.var_real = s->value.var->dat.var_real;
          s->SetNo (i); // Set number so we can find its index back later (aarggh.. dirty coding!!)
          i++;
          break;
        case FLOAT_CONST:
          str[i] = new hrs_variable;
          str[i]->type=VAR_REAL;
          str[i]->constant=TRUE;
          str[i]->temp=FALSE;
          str[i]->dat.var_real = s->value.var->dat.var_real;
          s->SetNo (i); // Set number so we can find its index back later (aarggh.. dirty coding!!)
          i++;
          break;  
        default:
          break;
      }
      s = st.GetNext();
   }
   total_builtin=i;
   ninstr = intcode->Len();
   instr = new Instr[ninstr];
   IntInstr *cinstr = intcode;
   for (i = 0; i < ninstr; i++)   {
      switch (cinstr->opcode)   {
      case OP_NOP:           // no operation
         instr[i] = Instr (OP_NOP, 0);
         break;
      case OP_PUSH:          // push string [var]
         instr[i] = Instr (OP_PUSH, cinstr->str->GetNo());
         break;
      case OP_GETTOP:        // get string from top of stack (=assign) [var]
         instr[i] = Instr (OP_GETTOP, cinstr->str->GetNo());
         break;
      case OP_DISCARD:       // discard top value from the stack
         instr[i] = Instr (OP_DISCARD);
         break;
      case OP_FUNCTION:         // print a string
         instr[i] = Instr (OP_FUNCTION);
         instr[i].call = cinstr -> call;
         break;
      case OP_JMP:           // unconditional jump [dest]
         instr[i] = Instr (OP_JMP, find_label(cinstr->target, i));
         break;
      case OP_OR:          // jump if FALSE [dest]
         instr[i] = Instr (OP_OR, find_label(cinstr->target, i));
         break;
      case OP_AND:          // jump if FALSE [dest]
         instr[i] = Instr (OP_AND, find_label(cinstr->target, i));
         break;
      case OP_JMPF:          // jump if FALSE [dest]
         instr[i] = Instr (OP_JMPF, find_label(cinstr->target, i));
         break;
      case OP_JMPT:          // jump if FALSE [dest]
         instr[i] = Instr (OP_JMPT, find_label(cinstr->target, i));
         break;
      case OP_VAR_EQUAL:     // test whether two strings are equal
         instr[i] = Instr (OP_VAR_EQUAL);
         break;
      case OP_BOOL_EQUAL:    // test whether two bools are equal
         instr[i] = Instr (OP_BOOL_EQUAL);
         break;
      case OP_BOOL_NOT:
         instr[i] = Instr (OP_BOOL_NOT);
         break;
      case OP_VAR_GREATER:
         instr[i] = Instr (OP_VAR_GREATER);
         break;
      case OP_VAR_LESS:
         instr[i] = Instr (OP_VAR_LESS);
         break;
      case OP_ADD:
         instr[i] = Instr (OP_ADD);
         break;
      case OP_SUB:
         instr[i] = Instr (OP_SUB);
         break;
      case OP_MUL:
         instr[i] = Instr (OP_MUL);
         break;
      case OP_DIV:
         instr[i] = Instr (OP_DIV);
         break;
      case OP_NEG:
         instr[i] = Instr (OP_NEG);
         break;
      case OP_MOD:
         instr[i] = Instr (OP_MOD);
         break;
      case OP_POW:
         instr[i] = Instr (OP_POW);
         break;
      case OP_CONCAT:        // concatenate two strings
         instr[i] = Instr (OP_CONCAT);
         break;
      case JUMPTARGET:       // not an opcode but a jump target;
         instr[i] = Instr (OP_NOP);
         break;
      }
      cinstr = cinstr->next;
   }
}

// Execute the program in memory
void VMachine::Execute ()   {
   if(this==NULL) return;
   int ip; // instruction pointer
   int ipc; // instruction pointer change
   int i,j,k;
   hrs_variable *_pars[12];
   hrs_variable *temp;
   int pass_val[12];
   hrs_pars pass;
   pass.pars=_pars;
   ip = 0; // start at instruction 0
   while (ip < ninstr)   {
      ipc = 1; // default: add one to ip
      switch (instr[ip].opcode)   {
      case OP_NOP:
         // No OPeration
         break;
      case OP_PUSH:
         // Push a variable onto the stack
         stack.Push (instr[ip].operand);
         break;
      case OP_GETTOP:
         hrs_var_cpy(str[instr[ip].operand],str[stack.GetTop()]);
         break;
      case OP_DISCARD:
         i=stack.Pop();
         if(str[i]->temp)
           DelTempCopy (i);
         break;
      case OP_FUNCTION:
   
         pass.n=instr[ip].call->argc;
         for(i=0;i<pass.n;i++)
           pass.pars[i]=str[(pass_val[i]=stack.Pop())];
         temp=call_hrs_func(instr[ip].call,&pass);
         for(i=0;i<pass.n;i++)
           if(pass.pars[i]->temp)
             DelTempCopy (pass_val[i]);
         if(temp==NULL) {
           set_gfx_mode(GFX_TEXT,0,0,0,0);
           allegro_message("Error in VM returning from function \"%s\" to script.",instr[ip].call->name);
           exit(1);
         }
         else {
           i=NewTempCopy (temp);
         }
         stack.Push(i);
         break;
      case OP_JMP:
         ipc = instr[ip].operand;
         break;
      case OP_AND:
         i = stack.GetTop();
         if (i == ST_FALSE)
           ipc = instr[ip].operand;
         else stack.Pop();
         break;
      case OP_OR:
         i = stack.GetTop();
         if (i == ST_TRUE)
           ipc = instr[ip].operand;
         else stack.Pop();

         break;
      case OP_JMPT:
         i = stack.Pop();
         if (i == ST_TRUE)   ipc = instr[ip].operand;
         break;
      case OP_JMPF:
         i = stack.Pop();
         if (i == ST_FALSE)   ipc = instr[ip].operand;
         break;
      case OP_VAR_GREATER:
         i = stack.Pop(); j = stack.Pop();
         if(str[i]->type!=VAR_REAL&&str[i]->type!=VAR_INT) break;
         if(str[j]->type!=VAR_REAL&&str[j]->type!=VAR_INT) break;
         if(str[i]->type!=str[j]->type) break;
         
         if(str[i]->type==VAR_INT) {
           if (str[i]->dat.var_int<str[j]->dat.var_int)   k = ST_TRUE; else k = ST_FALSE;
         }
         else {
           if (str[i]->dat.var_real<str[j]->dat.var_real)   k = ST_TRUE; else k = ST_FALSE;
         }
         
         if(str[i]->temp) DelTempCopy (i);
         if(str[j]->temp) DelTempCopy (j);
         stack.Push (k);
         break;
      case OP_VAR_LESS:
         i = stack.Pop(); j = stack.Pop();
         if(str[i]->type!=VAR_REAL&&str[i]->type!=VAR_INT) break;
         if(str[j]->type!=VAR_REAL&&str[j]->type!=VAR_INT) break;
         if(str[i]->type!=str[j]->type) break;
         
         if(str[i]->type==VAR_INT) {
           if (str[i]->dat.var_int>str[j]->dat.var_int)   k = ST_TRUE; else k = ST_FALSE;
         }
         else {
           if (str[i]->dat.var_real>str[j]->dat.var_real)   k = ST_TRUE; else k = ST_FALSE;
         }
         
         if(str[i]->temp) DelTempCopy (i);
         if(str[j]->temp) DelTempCopy (j);
         stack.Push (k);
         break;
      case OP_VAR_EQUAL:
         i = stack.Pop(); j = stack.Pop();
         if (hrs_var_equal (str[i], str[j]))   k = ST_TRUE; else k = ST_FALSE;
         if(str[i]->temp) DelTempCopy (i);
         if(str[j]->temp) DelTempCopy (j);
         stack.Push (k);
         break;
      case OP_BOOL_EQUAL:
         i = stack.Pop(); j = stack.Pop();
         if (i == j)   k = ST_TRUE; else k = ST_FALSE;
         stack.Push (k);
         break;
      case OP_BOOL_NOT:
         i = stack.Pop();
         if(i== ST_FALSE) k=ST_TRUE; else k=ST_FALSE;
         stack.Push(k);
         break;
      case OP_ADD:
         i = stack.Pop(); j = stack.Pop();
         if(str[i]->type!=VAR_INT&&str[i]->type!=VAR_REAL) break;
         if(str[j]->type!=VAR_INT&&str[j]->type!=VAR_REAL) break;
         if(str[i]->type!=str[j]->type) break;
         k = NewTempCopy (j);
         if(str[i]->type==VAR_INT)
           str[k]->dat.var_int+=str[i]->dat.var_int;
         else str[k]->dat.var_real+=str[i]->dat.var_real;
         if(str[i]->temp) DelTempCopy (i);
         if(str[j]->temp) DelTempCopy (j);
         stack.Push (k);
         break;
      case OP_SUB:
         i = stack.Pop(); j = stack.Pop();
         if(str[i]->type!=VAR_INT&&str[i]->type!=VAR_REAL) break;
         if(str[j]->type!=VAR_INT&&str[j]->type!=VAR_REAL) break;
         if(str[i]->type!=str[j]->type) break;
         k = NewTempCopy (j);
         if(str[i]->type==VAR_INT)
           str[k]->dat.var_int-=str[i]->dat.var_int;
         else str[k]->dat.var_real-=str[i]->dat.var_real;
         if(str[i]->temp) DelTempCopy (i);
         if(str[j]->temp) DelTempCopy (j);
         stack.Push (k);
         break;
      case OP_MUL:
         i = stack.Pop(); j = stack.Pop();
         if(str[i]->type!=VAR_INT&&str[i]->type!=VAR_REAL) break;
         if(str[j]->type!=VAR_INT&&str[j]->type!=VAR_REAL) break;
         if(str[i]->type!=str[j]->type) break;
         k = NewTempCopy (j);
         if(str[i]->type==VAR_INT)
           str[k]->dat.var_int*=str[i]->dat.var_int;
         else str[k]->dat.var_real*=str[i]->dat.var_real;
         if(str[i]->temp) DelTempCopy (i);
         if(str[j]->temp) DelTempCopy (j);
         stack.Push (k);
         break;
      case OP_DIV:
         i = stack.Pop(); j = stack.Pop();
         if(str[i]->type!=VAR_INT&&str[i]->type!=VAR_REAL) break;
         if(str[j]->type!=VAR_INT&&str[j]->type!=VAR_REAL) break;
         if(str[i]->type!=str[j]->type) break;
         k = NewTempCopy (j);
         if(str[i]->type==VAR_INT)
           str[k]->dat.var_int/=str[i]->dat.var_int;
         else str[k]->dat.var_real/=str[i]->dat.var_real;
         if(str[i]->temp) DelTempCopy (i);
         if(str[j]->temp) DelTempCopy (j);
         stack.Push (k);
         break;
      case OP_NEG:
         i = stack.Pop();
         if(str[i]->type!=VAR_INT&&str[i]->type!=VAR_REAL) break;
         k = NewTempCopy (i);
         if(str[i]->type==VAR_INT)
           str[k]->dat.var_int=-str[k]->dat.var_int;
         else str[k]->dat.var_real=-str[k]->dat.var_real;
         if(str[i]->temp) DelTempCopy (i);
         stack.Push (k);
         break;
      case OP_MOD:
         i = stack.Pop(); j = stack.Pop();
         if(str[i]->type!=VAR_INT) break;
         if(str[j]->type!=VAR_INT) break;
         k = NewTempCopy (j);
         str[k]->dat.var_int%=str[i]->dat.var_int;
         if(str[i]->temp) DelTempCopy (i);
         if(str[j]->temp) DelTempCopy (j);
         stack.Push (k);
         break;
      case OP_POW:
         i = stack.Pop(); j = stack.Pop();
         if(str[i]->type!=VAR_INT&&str[i]->type!=VAR_REAL) break;
         if(str[j]->type!=VAR_INT&&str[j]->type!=VAR_REAL) break;
         if(str[i]->type!=str[j]->type) break;
         k = NewTempCopy (j);
         if(str[i]->type==VAR_INT)
           str[k]->dat.var_int=int(pow(double(str[k]->dat.var_int),double(str[i]->dat.var_int)));
         else str[k]->dat.var_real=pow(str[k]->dat.var_real,str[i]->dat.var_real);
         if(str[i]->temp) DelTempCopy (i);
         if(str[j]->temp) DelTempCopy (j);
         stack.Push (k);
         break;
      case OP_CONCAT:
         i = stack.Pop(); j = stack.Pop();
         if(str[i]->type!=VAR_STR) break;
         if(str[j]->type!=VAR_STR) break;
         k = NewTempCopy (j); str[k]->dat.var_string->Concatenate (*str[i]->dat.var_string);
         if(str[i]->temp) DelTempCopy (i);
         if(str[j]->temp) DelTempCopy (j);
         stack.Push (k);
         break;
      default:
         break;
      }
      ip += ipc;
   }
}

// Returns the index to a new temp. string
int VMachine::NewTempCopy ()  {
   if(this==NULL) return 0;
   int i;

   for (i=0; i < MAX_STR; i++)   {
      if (str[i] == NULL)  {
         str[i] = new hrs_variable;
         str[i]->type = VAR_EMPTY;
         str[i]->temp = TRUE;
         str[i]->constant = FALSE;
         break;
      }
   }
   if (i == MAX_STR) {
      set_gfx_mode(GFX_TEXT,80,20,0,0);
      allegro_message("Script Engine Error:\nOut of virtual stack space!");
      exit(-1);
   }

   else return i;
}
int VMachine::NewTempCopy (hrs_variable *a)  {
   if(this==NULL) return 0;
   int i;

   for (i=0; i < MAX_STR; i++)   {
      if (str[i] == NULL)  {
         str[i] = a;
//         str[i]->temp=TRUE;
         break;
      }
   }
   if (i == MAX_STR) {
      set_gfx_mode(GFX_TEXT,80,20,0,0);
      allegro_message("Script Engine Error 2:\nOut of virtual stack space!");
      exit(-1);
   }

   else return i;
}

// Returns the index to a new copy of string j
int VMachine::NewTempCopy (int j)  {
   if(this==NULL) return 0;
   int i = NewTempCopy();
   if (i>=0)  {
     hrs_var_cpy(str[i],str[j]);
     str[i]->constant=TRUE;
     str[i]->temp=TRUE;
//   str[i]->Assign (*str[j]);
   }
   return i;
}

// Returns the index to a new copy of string s
int VMachine::NewTempCopy (char *s)  {
   if(this==NULL) return 0;
   int i = NewTempCopy ();
   if (i>=0)  {
     clear_hrs_var(str[i]);
     str[i]->type=VAR_STR;
     str[i]->dat.var_string=new String(s);
     str[i]->constant=TRUE;
     str[i]->temp=TRUE;
   }
   return i;
}

// Deletes the previously generated temp. string
void VMachine::DelTempCopy (int i)  {
   if(this==NULL) return;
   if(i<total_builtin||i>=MAX_STR) return;
   
   if (str[i] != NULL) {
      clear_hrs_var(str[i]); 
      delete str[i]; 
      str[i] = NULL;
   }
}

