#include <allegro.h>
#include <stdio.h>
//#include "fortify.h"
#include "mystring.h"
#include "func.h"
#include "synttree.h"
#include "symtab.h"

void Error (char *format, ...);

// Node names        
char *name[] = {
   "statement list",
   "empty statement",
   "expression statement",
   "print statement",
   "input statement",
   "if..then statement",
   "if..then..else statement",
   "error statement",

   "equals",
   "assign",
   "concatenate",
   "identifier",
   "string constant",
   "coercion to string"
};

// Numbers of children per node type
int children[] = {
   2, 0, 1, 1, 0, 2, 3, 0, 2, 1, 2, 0, 0, 1
};

// Recursively show the contents of the syntax tree
void TreeNode::Show (int level)   {
   int i,nl;
   if (!this)  return;
   if (type != STMT_LIST)   {
      for (i = 0; i < level; i++)   printf ("   ");
      printf ("%s", name[type]);

      nl = level + 1;
      printf ("\n");
   } else nl = level;
   for (i = 0; i < children[type]; i++)   child[i]->Show(nl);
}

// ---------------------- Semantic Checking -------------------------

// Check the semantics of this node
void TreeNode::Check ()  {
   // First, set the type of value the node 'returns'
   switch (type)  {
   case STMT_LIST: case EMPTY_STMT: case EXPR_STMT:
   case IFTHEN_STMT:
   case IFTHENELSE_STMT: case ERROR_STMT:
      rettype = T_VOID;  // statements have no value
      break;
   case EQUAL_EXPR: case NOTEQUAL_EXPR:
   case AND_EXPR: case OR_EXPR: case NOT_EXPR:
   case LT_EXPR: case GT_EXPR: case GTET_EXPR: case LTET_EXPR:
      rettype = T_BOOL;
      break;
   case CONCAT_EXPR:
   case ASSIGN_EXPR: case ADD_EXPR: case SUB_EXPR: case MUL_EXPR:
   case DIV_EXPR: case MOD_EXPR: case POW_EXPR: case NEG_EXPR:
      rettype = T_VAR;
      break;
   case FUNCTION_STMT:
   case IDENT_EXPR:
   case CONST_EXPR:
      rettype = T_VAR;
      break;
   default:
      rettype = T_VOID;
      break;
   }

   // Now, check the semantics
   switch (type)  {
   case IFTHEN_STMT:
   case IFTHENELSE_STMT:
   case WHILE_STMT:
   case DO_STMT:
      if (child[0]->rettype != T_BOOL)
         Error ("if: Condition should be boolean");
      break;
   case EQUAL_EXPR: // no coercions here, types have to be equal
      if (child[0]->rettype != child[1]->rettype)
         Error ("==: Different types");
      break;
   case CONCAT_EXPR:
   case ASSIGN_EXPR:
      break;
   default:
      break;
   }
}
