%{	/* C DECLARATIONS */
#include <allegro.h>
#include <string.h>
#include <malloc.h>
#include <stdio.h>
//#include "fortify.h"
#include "hrs_lex.h"
#include "mystring.h"
#include "func.h"
#include "symtab.h"
#include "synttree.h"


SymTab st;
SyntTree tree;
SyntTree mem;

#define YYDEBUG 1	   
#define YYERROR_VERBOSE  

// Error-reporting function must be defined by the caller
void Error (char *format, ...);

// Forward references
void yyerror (char *msg);
char *MakeName();
int num_args=0;
%}

%start program

/* The structure for passing value between lexer and parser */
%union {
   char *str_val;
   int int_val;
   double float_val;
   SymDesc *symbol;
   TreeNode *tnode;
}

%token ERROR_TOKEN 
%token IF ELSE WHILE FOR DO GOTO
%token ':' ';' '(' ')' '#' '$'
%token '{' '}' 
%token <str_val> ID STRING
%token <int_val> INT
%token <float_val> FLOAT

%right '='
%left AND OR
%left EQUAL NOTEQUAL LTET GTET '<' '>'
%left '+' '-'
%left '*' '/' '%'
%left NEG NOT
%right '^'

%type <symbol> string_identifier int_identifier float_identifier label_identifier
%type <symbol> string_const int_const float_const
%type <tnode>  program statement_list statement while_statement for_statement goto_statement
%type <tnode>  if_statement optional_else_statement compound_statement label_statement
%type <tnode>  expression str_expression float_expression optional_expression_statement
%type <tnode>  compare_expression arg_list str_assign_expression do_statement
%type <tnode>  str_compare_expression int_expression float_assign_expression
%type <tnode>  int_assign_expression int_compare_expression
%type <tnode>  float_compare_expression

%expect 1  /* shift/reduce conflict: dangling ELSE */
           /*    declaration */

	/* BISON DECLARATIONS */

%%

program
	: statement_list	{tree=$1;}
;

statement_list
	: statement statement_list {$$ = new TreeNode (STMT_LIST, $1, $2);$$->next=mem;mem=$$;}
	| /* empty */              {$$ = new TreeNode (EMPTY_STMT);$$->next=mem;mem=$$;}
;

statement
	: ';'                    {$$ = new TreeNode (EMPTY_STMT);$$->next=mem;mem=$$;}
	| expression ';'         {$$ = new TreeNode (EXPR_STMT, $1);$$->next=mem;mem=$$;}
        | label_statement        {$$ = $1;}
        | goto_statement         {$$ = $1;}
	| if_statement           {$$ = $1;}
        | while_statement        {$$ = $1;}
        | do_statement           {$$ = $1;}
        | for_statement          {$$ = $1;}
	| compound_statement     {$$ = $1;}
        | error expression ';'   {$$ = new TreeNode (ERROR_STMT); $$->next=mem;mem=$$;}
	| error ';'              {$$ = new TreeNode (ERROR_STMT);$$->next=mem;mem=$$;}
;

arg_list
        : expression              {$$=$1; num_args++;}
        | expression ',' arg_list {$$ = new TreeNode (ARG_LIST,$1,$3); $$->next=mem;mem=$$;num_args++;}
;
do_statement
        : DO statement WHILE '(' expression ')' ';'
        {
          $$ = new TreeNode (DO_STMT, $5, $2);
          $$->next=mem;mem=$$;
        }
;
while_statement
        : WHILE '(' expression ')' statement
        {
          $$ = new TreeNode (WHILE_STMT, $3, $5);
          $$->next=mem;mem=$$;
        }
;
for_statement
        : FOR '(' optional_expression_statement ';' expression ';' optional_expression_statement ')' statement
        {
          $$=$9;
          if($7!=NULL) {
            $$ = new TreeNode (STMT_LIST, $$, $7 );
            $$->next=mem;mem=$$;
          }
          $$ = new TreeNode (WHILE_STMT, $5, $$);
          $$->next=mem;mem=$$;

          if($3!=NULL) {
            $$ = new TreeNode (STMT_LIST, $3, $$ );
            $$->next=mem;mem=$$;
          }
        }
;
optional_expression_statement
	: expression     {$$ = new TreeNode (EXPR_STMT, $1);$$->next=mem;mem=$$;}
	| /* empty */	 {$$=NULL;}
;
if_statement
	: IF '(' expression ')' statement optional_else_statement
	{
           if ($6 != NULL)
              $$ = new TreeNode (IFTHENELSE_STMT, $3, $5, $6);
           else
              $$ = new TreeNode (IFTHEN_STMT, $3, $5);
           $$->next=mem;mem=$$;
        }
;

optional_else_statement
	: ELSE statement {$$=$2;}
	| /* empty */	 {$$=NULL;}
;
compound_statement
      : '{' statement_list '}' {$$=$2;}
;

expression
        : str_expression        {$$=$1;}
        | int_expression        {$$=$1;}
        | float_expression      {$$=$1;}
        | compare_expression    {$$=$1;}
;

compare_expression
        : str_compare_expression        {$$=$1;}
        | int_compare_expression        {$$=$1;}
        | float_compare_expression      {$$=$1;}
        | '(' compare_expression ')'    {$$=$2;}
        | NOT compare_expression        {$$ = new TreeNode (NOT_EXPR, $2);$$->next=mem;mem=$$;}
        | compare_expression AND compare_expression  {$$ = new TreeNode (AND_EXPR, $1, $3);$$->next=mem;mem=$$;}
        | compare_expression OR compare_expression  {$$ = new TreeNode (OR_EXPR, $1, $3);$$->next=mem;mem=$$;}
;

str_expression
	: str_assign_expression         {$$ = $1;}
        | str_expression '+' str_expression {$$ = new TreeNode (CONCAT_EXPR, $1, $3);$$->next=mem;mem=$$;}
        | string_identifier	{$$ = new TreeNode (IDENT_EXPR); $$->symbol = $1;$$->next=mem;mem=$$;}
	| string_const		{$$ = new TreeNode (IDENT_EXPR); $$->symbol = $1;$$->next=mem;mem=$$;}
        | ID '$' '(' ')'
        {
           // First check if its a function:
           hrs_func *search=get_hrs_func($1);
           if(!search) {
             $$ = new TreeNode (ERROR_STMT);
             yyerror("Function not found.");
           }
           else if(search->argc!=0) {
             fprintf(stderr,"Passed %d\nWanted %d\n",0,search->argc);
             $$ = new TreeNode (ERROR_STMT);
             yyerror("Incorrect number of args passed to function.");
           }
           else {
             $$ = new TreeNode (FUNCTION_STMT);
             $$->call=search;
             $$->next=mem;
             mem=$$;
             num_args=0;
           }
        }
        | ID '$' '(' arg_list ')'
        {
           // First check if its a function:
           hrs_func *search=get_hrs_func($1);
           if(!search) {
             $$ = new TreeNode (ERROR_STMT);
             yyerror("Function not found.");
           }
           else if(num_args!=search->argc) {
             $$ = new TreeNode (ERROR_STMT);
             fprintf(stderr,"Passed %d\nWanted %d\n",num_args,search->argc);
             yyerror("Incorrect number of args passed to function.");
           }
           else {
             $$ = new TreeNode (FUNCTION_STMT, $4);
             $$->call=search;
             $$->next=mem;
             mem=$$;
             num_args=0;
           }
        }
	| '(' str_expression ')'	{$$ = $2;}
;
int_expression
        : int_assign_expression         {$$ = $1;}
        | int_identifier                {$$ = new TreeNode(IDENT_EXPR); $$->symbol = $1; $$->next=mem; mem=$$;}
        | int_const                     {$$ = new TreeNode(IDENT_EXPR); $$->symbol = $1; $$->next=mem;mem=$$;}
        | int_expression '+' int_expression  {$$ = new TreeNode (ADD_EXPR, $1, $3);$$->next=mem;mem=$$;}
        | int_expression '-' int_expression  {$$ = new TreeNode (SUB_EXPR, $1, $3);$$->next=mem;mem=$$;}
        | int_expression '*' int_expression  {$$ = new TreeNode (MUL_EXPR, $1, $3);$$->next=mem;mem=$$;}
        | int_expression '/' int_expression  {$$ = new TreeNode (DIV_EXPR, $1, $3);$$->next=mem;mem=$$;}
        | int_expression '%' int_expression  {$$ = new TreeNode (MOD_EXPR, $1, $3);$$->next=mem;mem=$$;}
        | '-' int_expression %prec NEG       {$$ = new TreeNode (NEG_EXPR, $2);$$->next=mem;mem=$$;}
        | int_expression '^' int_expression  {$$ = new TreeNode (POW_EXPR, $1, $3);$$->next=mem;mem=$$;}
        | ID '(' ')'
        {
           hrs_func *search=get_hrs_func($1);
           if(!search) {
             $$ = new TreeNode (ERROR_STMT);
             yyerror("Function not found.");
           }
           else if(search->argc!=0) {
             fprintf(stderr,"Passed %d\nWanted %d\n",0,search->argc);
             $$ = new TreeNode (ERROR_STMT);
             yyerror("Incorrect number of args passed to function.");
           }
           else {
             $$ = new TreeNode (FUNCTION_STMT);
             $$->call=search;
             $$->next=mem;
             mem=$$;
             num_args=0;
           }
        }
        | ID '(' arg_list ')'
        {
           // First check if its a function:
           hrs_func *search=get_hrs_func($1);
           if(!search) {
             $$ = new TreeNode (ERROR_STMT);
             yyerror("Function not found.");
           }
           else if(num_args!=search->argc) {
             $$ = new TreeNode (ERROR_STMT);
             fprintf(stderr,"Passed %d\nWanted %d\n",num_args,search->argc);
             yyerror("Incorrect number of args passed to function.");
           }
           else {
             $$ = new TreeNode (FUNCTION_STMT, $3);
             $$->call=search;
             $$->next=mem;
             mem=$$;
             num_args=0;
           }
        }
        | '(' int_expression ')'         {$$=$2;}
;
float_expression
        : float_assign_expression         {$$ = $1;}
        | float_identifier                {$$ = new TreeNode(IDENT_EXPR); $$->symbol = $1; $$->next=mem; mem=$$;}
        | float_const                     {$$ = new TreeNode(IDENT_EXPR); $$->symbol = $1; $$->next=mem;mem=$$;}
        | float_expression '+' float_expression   {$$ = new TreeNode (ADD_EXPR, $1, $3);$$->next=mem;mem=$$;}
        | float_expression '-' float_expression   {$$ = new TreeNode (SUB_EXPR, $1, $3);$$->next=mem;mem=$$;}
        | float_expression '*' float_expression   {$$ = new TreeNode (MUL_EXPR, $1, $3);$$->next=mem;mem=$$;}
        | float_expression '/' float_expression   {$$ = new TreeNode (DIV_EXPR, $1, $3);$$->next=mem;mem=$$;}
        | '-' float_expression %prec NEG          {$$ = new TreeNode (NEG_EXPR, $2);$$->next=mem;mem=$$;}
        | float_expression '^' float_expression   {$$ = new TreeNode (POW_EXPR, $1, $3);$$->next=mem;mem=$$;}
        | ID '#' '(' ')'
        {
           hrs_func *search=get_hrs_func($1);
           if(!search) {
             $$ = new TreeNode (ERROR_STMT);
             yyerror("Function not found.");
           }
           else if(search->argc!=0) {
             fprintf(stderr,"Passed %d\nWanted %d\n",0,search->argc);
             $$ = new TreeNode (ERROR_STMT);
             yyerror("Incorrect number of args passed to function.");
           }
           else {
             $$ = new TreeNode (FUNCTION_STMT);
             $$->call=search;
             $$->next=mem;
             mem=$$;
             num_args=0;
           }
        }
        | ID '#' '(' arg_list ')'
        {
           // First check if its a function:
           hrs_func *search=get_hrs_func($1);
           if(!search) {
             $$ = new TreeNode (ERROR_STMT);
             yyerror("Function not found.");
           }
           else if(num_args!=search->argc) {
             $$ = new TreeNode (ERROR_STMT);
             fprintf(stderr,"Passed %d\nWanted %d\n",num_args,search->argc);
             yyerror("Incorrect number of args passed to function.");
           }
           else {
             $$ = new TreeNode (FUNCTION_STMT, $4);
             $$->call=search;
             $$->next=mem;
             mem=$$;
             num_args=0;
           }
        }
        | '(' float_expression ')'         {$$=$2;}
;

str_compare_expression
	: str_expression EQUAL str_expression  {$$ = new TreeNode (EQUAL_EXPR, $1, $3);$$->next=mem;mem=$$;}
        | str_expression NOTEQUAL str_expression  {$$ = new TreeNode (NOTEQUAL_EXPR, $1, $3);$$->next=mem;mem=$$;}
        
;

int_compare_expression
        : int_expression EQUAL int_expression    {$$ = new TreeNode (EQUAL_EXPR, $1, $3);$$->next=mem;mem=$$;}
        | int_expression NOTEQUAL int_expression  {$$ = new TreeNode (NOTEQUAL_EXPR, $1, $3);$$->next=mem;mem=$$;}
        | int_expression '<' int_expression       {$$ = new TreeNode (LT_EXPR, $1, $3);$$->next=mem;mem=$$;}
        | int_expression '>' int_expression       {$$ = new TreeNode (GT_EXPR, $1, $3);$$->next=mem;mem=$$;}
        | int_expression LTET int_expression      {$$ = new TreeNode (LTET_EXPR, $1, $3);$$->next=mem;mem=$$;}
        | int_expression GTET int_expression      {$$ = new TreeNode (GTET_EXPR, $1, $3);$$->next=mem;mem=$$;}
;

float_compare_expression
        : float_expression EQUAL float_expression {$$ = new TreeNode (EQUAL_EXPR, $1, $3);$$->next=mem;mem=$$;}
        | float_expression NOTEQUAL float_expression  {$$ = new TreeNode (NOTEQUAL_EXPR, $1, $3);$$->next=mem;mem=$$;}
        | float_expression '<' float_expression   {$$ = new TreeNode (LT_EXPR, $1, $3);$$->next=mem;mem=$$;}
        | float_expression '>' float_expression   {$$ = new TreeNode (GT_EXPR, $1, $3);$$->next=mem;mem=$$;}
        | float_expression LTET float_expression  {$$ = new TreeNode (LTET_EXPR, $1, $3);$$->next=mem;mem=$$;}
        | float_expression GTET float_expression  {$$ = new TreeNode (GTET_EXPR, $1, $3);$$->next=mem;mem=$$;}
;

str_assign_expression
	: string_identifier '=' str_expression      {$$ = new TreeNode (ASSIGN_EXPR, $3); $$->symbol = $1;$$->next=mem;mem=$$;}
;
int_assign_expression
        : int_identifier '=' int_expression    {$$ = new TreeNode (ASSIGN_EXPR, $3); $$->symbol = $1;$$->next=mem;mem=$$;}
;
float_assign_expression
        : float_identifier '=' float_expression   {$$ = new TreeNode (ASSIGN_EXPR, $3); $$->symbol = $1;$$->next=mem;mem=$$;}
;

goto_statement
        : GOTO label_identifier ';'
        {
          $$ = new TreeNode (GOTO_STMT);
          $$->symbol = $2;
          $$->next=mem;mem=$$;
        }

label_statement
        : label_identifier ':'
	{
          $$ = new TreeNode (LABEL_STMT);
          $$->symbol = $1;
          $$->next=mem;mem=$$;
        }
;
label_identifier
        : ID
        {
          $$ = st.Find ($1);
           if ($$ != NULL) {
             if($$->type!=HRS_LABEL)
             {
               yyerror("Label name already in use.");
             }
             delete []$1;
           }
           else { // doesn't exist yet; create it
              $$ = new SymDesc ($1, HRS_LABEL, line_num);
              st.Add ($$);
           }            
        }
;

float_identifier
        : ID '#'
	{
           $$ = st.Find ($1);
           if ($$ == NULL)   { // doesn't exist yet; create it
              $$ = new SymDesc ($1, FLOAT_VAR, line_num);
              st.Add ($$);
           }
           else delete []$1;
        }
;

int_identifier
        : ID
        {
          $$ = st.Find ($1);
           if ($$ == NULL)   { // doesn't exist yet; create it
              $$ = new SymDesc ($1, INT_VAR, line_num);
              st.Add ($$);
           }
           else delete []$1;
        }
;

string_identifier
        : ID '$'
	{
           $$ = st.Find ($1);
           if ($$ == NULL)   { // doesn't exist yet; create it
              $$ = new SymDesc ($1, STR_VAR, line_num);
              st.Add ($$);
           } 
           else delete []$1;
        }
;
float_const
	: FLOAT
        {
           $$ = new SymDesc (MakeName(), FLOAT_CONST, & $1, line_num);
           st.Add ($$);
        }
;
int_const
	: INT
        {
           $$ = new SymDesc (MakeName(), INT_CONST, & $1, line_num);
           st.Add ($$);
        }
;
string_const
	: STRING		
        {
           $$ = new SymDesc (MakeName(), STR_CONST, $1, line_num);
           st.Add ($$);
        }
;


%%
	/* ADDITIONAL C CODE */

// Generate a unique name for a string constant
char *MakeName ()  {
   char *name = new char [20];
   static int n = 0;
   sprintf (name, "const%010d", ++n);
   return name;
}



