// This code is LGPL...
#include <math.h>       
#include <allegro.h>
#include "alleg.h"

#ifdef USE_FBLEND
#include <fblend.h>
#endif

#include "func.h"
#include "points.h"
#include "npc.h"

#include "tile.h"
#include "layer.h"
#include "map.h"
#include "viewport.h"
#include "points.h"
#include "npc.h"
#include "helper.h"
#include "spp.h"
#include "func.h"

extern int paused;

static BITMAP *pict,*shadow;
int Mobile::override=0;

int battle_count=100;

int in_range(int range,int x1,int y1,int x2,int y2)
{
  int x=x1-x2;
  int y=y1-y2;
  double dist=sqrt(x*x+y*y);

  return (dist<=double(range));

}

static int walk_pat[4] = {0,1,0,2};

int is_facing(int facing,int x1,int y1,int x2,int y2)
{
  int dir_face[4]={4,6,0,2};

  switch(dir_face[facing]) {
    case 0: return (y1>y2);
    case 2: return (x1<x2);
    case 4: return (y1<y2);
    case 6: return (x1>x2);
    default: break;
  } 

  return FALSE;
}

void NPC_exit()
{
  destroy_bitmap(pict);
  destroy_bitmap(shadow);

}

void NPC_init()
{
  pict=create_bitmap(32,90);
  shadow=create_bitmap(32,12);

  if(!pict||!shadow) {
    set_gfx_mode(GFX_TEXT,0,0,0,0);
    allegro_message("Error starting up npc system.");
    exit(1);
  }
}


static int face_dir[8] = { 2,3,3,3,0,1,1,1 };
static int dir_face[4] = { 4,6,0,2 };
   
static int move_dir[16]=
               {
                  0,-1,
                  1,-1,
                  1, 0,
                  1, 1,
                  0, 1,
                 -1, 1,
                 -1, 0,
                 -1,-1
               };

static int dir_move[3][3] =
                       {{ 7, 0, 1 },
                        { 6,-1, 2 },
                        { 5, 4, 3 }};
               

static int shadow_id=6;

int Mobile::get_x()
{
  return x;
}

int Mobile::get_y()
{
  return y;
}
int Mobile::get_z()
{
  return z;
}
int Mobile::get_draw_layer()
{
  return draw_layer;
}
Mobile::Mobile(int _key,char *name,int _x,int _y,int _facing,int _layer,int _dest,int _flags)
{
  char_data=(DATAFILE *)find_datafile_object(characters,name)->dat;

  if(!char_data) {
    set_gfx_mode(GFX_TEXT,0,0,0,0);
    allegro_message("Error creating custum Mobile object.");
    exit(1);
  }

  as=NULL;
  ps=NULL;
  ls=NULL;
  is=NULL;

  key=_key;
  x=x2=_x;
  y=y2=_y;
  facing=face_dir[_facing];

  flags=_flags;

  z=0;
  layer=_layer;

  dest_point = -1;
  follow=0;

  step=0;

  ay1=ax1=0;
  ax2=ay2=600;

  walking=FALSE;
  disabled=FALSE;

  reflection=NULL;

  if(getFlag(CHAR_RANDOM)) {
    x2=y2=0;
  }
  if(getFlag(CHAR_FOLLOW)) {
    follow=-1;
    dest_point=_dest;
  } 
  for(int i=0;i<40;i++)
    in_trig[i]=FALSE;
}

Mobile::Mobile(map_char * templ)
{
  char_data=(DATAFILE *)find_datafile_object(characters,templ->datafile_name)->dat;
  as=templ->as;
  ps=templ->ps;
  ls=templ->ls;
  is=templ->is;

  key=templ->key;
  flags=templ->flags;
  x=templ->x;
  y=templ->y;
  x2=x;
  y2=y;
  facing=face_dir[templ->facing];
  z=0;
  layer=templ->walk_layer;

  dest_point = -1;
  follow=-1;

  step=0;

  ay1=ax1=0;
  ax2=ay2=600;

  walking=FALSE;
  disabled=FALSE;

  reflection=NULL;
  for(int i=0;i<40;i++)
    in_trig[i]=FALSE;
}

Mobile::~Mobile()                 // free memory used
{
  
}
void Mobile::reset_height()
{
  z=0; // this is useful, trust me :)
}
void Mobile::warp_to(int _x,int _y,int _layer,int _facing)
{
  x=_x;y=_y;layer=_layer;
  x2=_x;y2=_y;
  facing=face_dir[_facing];  
  
  
}
void Mobile::set_height(int _z,c_map *mp,class mob_list *m)
{
  int i;
  int old_f=facing;
  int new_z=z-_z;
  int dir;

  if(new_z<0) {
    dir = 4;
    new_z=-new_z;
  }
  else {
    dir = 0;
  }

  for(i=0;i<new_z;i++)
    move(dir,1,mp,m);

  facing=old_f;
  z=_z;
}

void Mobile::walk_to(int pkey,int _follow,c_map *mp)
{
  dest_point=pkey;
  follow=_follow;
  mp->points->getX(dest_point,&x2);
  mp->points->getY(dest_point,&y2);
  double angle=atan2(double(y-y2),double(x-x2))+PI;
  
  if(angle>=PI/4&&angle<PI*3/4)
    facing=face_dir[4];
  else if(angle>=PI*3/4&&angle<PI*5/4)
    facing=face_dir[6];
  else if(angle>=PI*5/4&&angle<PI*7/4)
    facing=face_dir[0];
  else facing=face_dir[2];
}

void Mobile::update(c_map *mp,class mob_list *m)
{
  int i;
  if((disabled&&override!=2)||override==1) return;
  hrs_variable *k=make_int(key);  
  set_global_var("my_key",k);
  delete k;
  has_reflection=FALSE;

  if(is)
  {
    run_hrs_script(is);
    is=NULL;
    if(getFlag(CHAR_RANDOM)) {
      x2=y2=0;
    }
  }

  if(ls) 
    run_hrs_script(ls);
    

  if(getFlag(CHAR_ISPLAYER)&&override!=3)
  {
     int speed=2,dir,xm=1,ym=1;
     if(check_key(key_left)) 
       xm=0;
     else if(check_key(key_right))
       xm=2;
     if(check_key(key_up))
       ym=0;
     else if(check_key(key_down))
       ym=2;

     dir=dir_move[ym][xm];

     if(check_key(key_cancel)) speed++;

     if(dir>=0) {
       facing=face_dir[dir];
       move(dir,speed,mp,m);
     }
     else stop();

  }
 

  if(getFlag(CHAR_FOLLOW)) {
    if(x!=x2||y!=y2) {
      double dist,sx,sy;
      sx=x2-x;
      sy=y2-y;

      dist=1.9/sqrt(sx*sx+sy*sy);

      sx*=dist;
      sy*=dist;
      
      move(dir_move[int(sy)+1][int(sx)+1],1,mp,m);
    }
    else {
      if(dest_point>=0) {
        mp->points->getX(dest_point,&x2);
        mp->points->getY(dest_point,&y2);
        double angle=atan2(double(y-y2),double(x-x2))+PI;
        
        if(angle>=PI/4&&angle<PI*3/4)
          facing=face_dir[4];
        else if(angle>=PI*3/4&&angle<PI*5/4)
          facing=face_dir[6];
        else if(angle>=PI*5/4&&angle<PI*7/4)
          facing=face_dir[0];
        else facing=face_dir[2];

		if(follow>0) follow--;
        if(follow!=0)
          dest_point=mp->points->get_next_key(dest_point);
	    else dest_point=-1;
      }
	  else { // end of the line ;)
	    setFlag(CHAR_FOLLOW,FALSE);
		stop();
	  }
    }
  } 
  if(getFlag(CHAR_RANDOM)) {
    int mx=1,my=1,stp=1,dir;
    if(x2>0) {
      x2--;
      if((x+stp)>ax1&&(x+stp)<ax2)
        mx=2;
      else x2=0;
    }
    
    if(x2<0) {
      x2++;
      if((x-stp)>ax1&&(x-stp)<ax2)
        mx=0;
      else x2=0;
    }
    
    if(y2>0) {
      y2--;
      if((y+stp)>ay1&&(y+stp)<ay2)
        my=2;
      else y2=0;
    }
    
    if(y2<0) {
      y2++;
      if((y-stp)>ay1&&(y-stp)<ay2)
        my=0;
      else y2=0;
    }
    dir=dir_move[my][mx];

    if(dir>=0) {
      facing=face_dir[dir];
      move(dir,stp,mp,m);
    }
    else stop();

    if(x2==0&&y2==0) {
      dir=rand()%256;
      if(dir<8) {
        x2=(rand()%128+16)*move_dir[(dir<<1)  ];
        y2=(rand()%128+16)*move_dir[(dir<<1)+1];
      }
    }

  }


  if(walking) {
	  if (get_int(get_global_var("enemy_type"))>0)
		  battle_count--;
	if(battle_count<0) 
	{
		battle_count=120+rand()%200; // or whatever
		run_hrs_script("battle.hrs");
	}

    step+=STEP_SIZE;
    while(step>=4) step-=4;
  }

  int t=mp->getTriggerCount();

  for(i=0;i<t;i++) {
    if(mp->checkTrigger(i,x,y)) {
      switch(mp->getTriggerAction(i)) {
        case 0: break;
        case 1:
          if(getFlag(CHAR_ISPLAYER)&&check_key(key_action)&&facing==mp->getTriggerDirection(i)) 
            mp->ActivateTrigger(i);
          break;
        case 2:
          if(!getFlag(CHAR_ISPLAYER)) break;
        case 5: 
          mp->ActivateTrigger(i);
          break;
        case 9:
        case 3:
          if(!getFlag(CHAR_ISPLAYER)) break;
        case 6: 
          if(!in_trig[i]) {
            mp->ActivateTrigger(i);
            in_trig[i]=TRUE;
          }
          break;
        case 4:
          if(!getFlag(CHAR_ISPLAYER)) break;
        case 7: 
          in_trig[i]=TRUE;
          break;
        case 8:
          has_reflection=TRUE;
          break;
         
         
        default: break;
      }
    }
    else {
      switch(mp->getTriggerAction(i)) {
        case 0:
        case 1:
        case 2:
        case 5: 
        case 9:
          break;
        case 3:
          if(!getFlag(CHAR_ISPLAYER)) break;
        case 6:
          in_trig[i]=FALSE;
          break;  
        case 4:
          if(!getFlag(CHAR_ISPLAYER)) break;
        case 7: 
          if(in_trig[i]) {
            mp->ActivateTrigger(i);
            in_trig[i]=FALSE;
          }
          break;
        default: break;
      }
    }
  }
  BITMAP *stmp=(BITMAP *)char_data[0].dat;
  draw_layer=layer;
  c_layer *lyr;
  for(i=mp->countLayers()-1;i>=0;i--) {
    lyr = mp->getLayerPointer(i);
    if(lyr->getz()-mp->getLayerPointer(layer)->getz()>=75) 
      draw_layer=i;
    else if(lyr->getz()-mp->getLayerPointer(layer)->getz()>0) 
      if(mp->check_tile(i,stmp,x-(stmp->w>>1),y-(stmp->h>>1))) {
        draw_layer=i;
      }
  }    
    
}

void Mobile::center(c_map *mp,viewport *v)
{
  v->x=x-(v->w>>1);
  v->y=y-(v->h>>1);
  mp->gotoxy(v->x,v->y);
  v->x=mp->getX();
  v->y=mp->getY();
}

void Mobile::move(int dir,int steps,c_map *mp,class mob_list *m)
{
  if(dir<0||dir>=8) return;
  walking=TRUE;
  int i;
  for(i=0;i<steps;i++) {
    if(m->check_walk(mp,key,x+move_dir[(dir<<1)],y+move_dir[(dir<<1)+1])) {
      dir++;
      if(dir>7) dir-=8;
      if(m->check_walk(mp,key,x+move_dir[(dir<<1)],y+move_dir[(dir<<1)+1])) {
        dir-=2;
        if(dir<0) dir+=8;
        if(m->check_walk(mp,key,x+move_dir[(dir<<1)],y+move_dir[(dir<<1)+1])) 
          return;
      
      }
    }


    x+=move_dir[(dir<<1)  ];
    y+=move_dir[(dir<<1)+1];
  }

}
void Mobile::stop()
{
  walking=FALSE;
  if(step>=1&&step<2) step=2;
  if(step>=3) step=0;
}

int remove_bitmap_changes16(BITMAP *a,BITMAP *b)
{
  short **line1,*line2;
  short **line3,*line4;
  int i,j,k;
           
  k=FALSE;         
  line1=(short **)&a->line[0];
  line3=(short **)&b->line[0];

  for(j=0;j<a->h;j++,line1++,line3++) {
    line2=*line1;
    line4=*line3;
    for(i=0;i<a->w;i++,line2++,line4++) 
      if(*line2!=*line4) {
        *line4=(short)MASK_COLOR_16;
        k=TRUE;
      }
  }
  return k;
}
void fix_changes16(BITMAP *a, BITMAP *b,int dither)
{
  short **line1,*line2;
  short **line3,*line4;
  int i,j;

  line1=(short **)&b->line[0];
  line3=(short **)&a->line[0];
  int dithering,dithering2=FALSE;

  if(dither) 
    for(j=0;j<a->h;j++,line1++,line3++) {
      line2=*line1;
      line4=*line3;
      dithering=dithering2=~dithering2;
      for(i=0;i<a->w;i++,line2++,line4++) {
        dithering=~dithering;
        if(*line2!=*line4) {
          if(*line2==(short)MASK_COLOR_16) 
            *line4=(short)MASK_COLOR_16;
          else {
            if(dithering)
              *line4=*line2;
            else 
              *line4=(short)MASK_COLOR_16;
          }
        }
      }
    }
  else
    for(j=0;j<a->h;j++,line1++,line3++) {
      line2=*line1;
      line4=*line3;
      for(i=0;i<a->w;i++,line2++,line4++) {
        if(*line2==(short)MASK_COLOR_16) 
          *line4=(short)MASK_COLOR_16;
      }
    }
}
void Mobile::draw(BITMAP *bmp,c_map *mp,viewport *v)
{
  if (!getFlag(CHAR_VISIBLE)) return;
  int hflip;
  
  BITMAP *stmp,*tmp;
  
  #ifdef USE_FBLEND
  /*if(!tileset::low_color) {
    stmp=(BITMAP *)char_data[shadow_id].dat;
    fblend_trans(stmp,bmp,x-v->x-(stmp->w>>1),y-v->y-(stmp->h>>1),55);
  } */
  #endif
 
  switch(facing) {
    case 0:
      hflip=0;
      tmp=(BITMAP *)char_data[0+(int(step+1)&1)].dat;
      break;
    case 3:
      hflip=1;      
      tmp=(BITMAP *)char_data[2+(int(step+1)&1)].dat;
      break;
    case 1:
      hflip=0;
      tmp=(BITMAP *)char_data[2+(int(step+1)&1)].dat;
      break;
    case 2:   
      hflip=0;
      tmp=(BITMAP *)char_data[4+(int(step+1)&1)].dat;
      break;
    default:
      return;
  }
  if(hflip==1)
    draw_sprite_h_flip(bmp,tmp,x-v->x-(tmp->w>>1),y-v->y-tmp->h);
  else draw_sprite(bmp,tmp,x-v->x-(tmp->w>>1),y-v->y-tmp->h);
  
} 

int Mobile::get_reflect_y(c_map *mp)
{                 
  c_layer *cl=mp->getLayerPointer(layer);
  if(!cl) return 0;
  int rt=cl->get_reflect_type();
  int ry=cl->get_reflect_y();
  switch(rt) {
    case 0:
      ry+=y;
      break;
    case 1:      
      ry+=ry-y;
      break;              
    default: 
      ry=y;
  } 
  return ry;
}
int Mobile::get_reflect_z(c_map *mp)
{                 
  c_layer *cl=mp->getLayerPointer(layer);
  if(!cl) return 0;
  return cl->get_reflect_z();
}
int Mobile::get_reflect_layer(c_map *mp)
{                 
  c_layer *cl=mp->getLayerPointer(layer);
  int zz;
  if(!cl) return 0;
  zz=cl->get_reflect_z();
  
  BITMAP *stmp=(BITMAP *)char_data[0].dat;
  int ll=layer;
  c_layer *lyr;
  int i;
  for(i=mp->countLayers()-1;i>=0;i--) {
    lyr = mp->getLayerPointer(i);
    if(lyr->getz()-zz>0) 
      ll=i;
    
  }    
  return ll;
}
void Mobile::draw_reflection()
{
  if(!this) return;
  if(reflection) {
    draw_sprite(rtarget,reflection,rfx,rfy);
    destroy_bitmap(reflection);
    reflection=NULL;
  } 

}

void Mobile::create_reflection(BITMAP *bmp,c_map *mp,viewport *v)
{
  c_layer *cl=mp->getLayerPointer(layer);
  BITMAP *stmp,*tmp;
  int rt=cl->get_reflect_type();
  int rx=x;
  int ry=cl->get_reflect_y();
  int rz=cl->get_reflect_z();
  int rtrans=cl->get_reflect_trans();
  int rf=facing;
  int hflip=0;
  int flip=0;     // 0 no flip 1 hort 2 vert 3 both
//  int i,flag1;
//  c_layer *lyr;
  int bmc=bitmap_mask_color(pict);
  int rsy=0;
  int rds=0;

  reflection=create_bitmap(pict->w,pict->h);
  
  switch(rt) {
    case 0:
      ry+=y;
      flip=2;
      rsy=16;
      break;
    case 1:      
      ry+=ry-y;
      rf=face_dir[((dir_face[facing]+4)%8)];
      flip=1;
      rds=1;
      break;              
    default: return;
  }
  
  stmp=(BITMAP *)char_data[0].dat;
  
  #ifdef USE_FBLEND
  if(rds==1&&!tileset::low_color) 
      fblend_trans(stmp,bmp,rx-v->x-(stmp->w>>1),ry-v->y-(stmp->h>>1),55);
  #endif
    
  clear_to_color(reflection,bmc);
  
  switch(facing) {
    case 0:
      hflip=int(step)&1;
      tmp=(BITMAP *)char_data[0].dat;
      break;
    case 3:
      hflip=1;      
      tmp=(BITMAP *)char_data[1+(int(step+1)&1)].dat;
      break;
    case 1:
      hflip=0;
      tmp=(BITMAP *)char_data[1+(int(step+1)&1)].dat;
      break;
    case 2:   
      hflip=int(step)&1;
      tmp=(BITMAP *)char_data[3].dat;
      break;
    default:
      return;
  }  
  
  if(hflip==1&&flip==1) flip=0;
  if(hflip==0&&flip==0) flip=1;
  if(hflip==1&&flip==3) flip=2;
  if(hflip==0&&flip==2) flip=3;
    
  if(flip==0)
    draw_sprite(reflection,tmp,(reflection->w-tmp->w)/2,reflection->h-tmp->h);
  else if(flip==1)
    draw_sprite_h_flip(reflection,tmp,(reflection->w-tmp->w)/2,reflection->h-tmp->h);
  else if(flip==2)
    draw_sprite_v_flip(reflection,tmp,(reflection->w-tmp->w)/2,reflection->h-tmp->h);
  else if(flip==3)          
    draw_sprite_vh_flip(reflection,tmp,(reflection->w-tmp->w)/2,reflection->h-tmp->h);
      
  draw_sprite(bmp,reflection,rx-v->x-(reflection->w>>1),ry-v->y-reflection->h);
  destroy_bitmap(reflection);
  reflection=NULL;
  
}
void Mobile::setFlag(int flag,int to)
{
  if(to)
    flags|=flag;
  else flags&=~flag;

}

int Mobile::getFlag(int flag)
{
  return (flags&flag);

}

Mobile *Mobile::get_next()
{
  return next;
}

void mob_list::add_node(c_map *mp,mob_tree *tmp)
{
    mob_tree *tmp2;

    tmp2=tree;
    while(tmp2) {
      if(tmp->get_draw_layer(mp)<tmp2->get_draw_layer(mp)) {
        if(tmp2->left)
          tmp2=tmp2->left;
        else {
          tmp2->left=tmp;
          tmp->parent=tmp2;
          tmp2=NULL;
        }
      }
      else if(tmp->get_draw_layer(mp)>tmp2->get_draw_layer(mp)) {
        if(tmp2->right)
          tmp2=tmp2->right;
        else {
          tmp2->right=tmp;
          tmp->parent=tmp2;
          tmp2=NULL;
        }
      }
      else {
        if(tmp->get_y(mp)<tmp2->get_y(mp)) {
          if(tmp2->left)
            tmp2=tmp2->left;
          else {
            tmp2->left=tmp;
            tmp->parent=tmp2;
            tmp2=NULL;
          }
        }
        else {
          if(tmp2->right)
            tmp2=tmp2->right;
          else {
            tmp2->right=tmp;
            tmp->parent=tmp2;
            tmp2=NULL;
          }
        }      
      }

    }


}
void mob_list::do_character_checks()
{
  BITMAP *tmp,*tmp2;
  
  Mobile *temp=top,*temp2;

  while(temp) {
    temp2=top;
    tmp=(BITMAP *)temp->char_data[4].dat;
    if(!temp->getFlag(CHAR_VISIBLE)) {
      temp=temp->next;
      continue;
    }
    while(temp2) {
      if(temp2==temp||temp->draw_layer<temp2->draw_layer||!temp2->getFlag(CHAR_VISIBLE)) {
        temp2=temp2->next;
        continue; 
      }
    
      tmp2=(BITMAP *)(BITMAP *)temp->char_data[temp->facing*3+walk_pat[int(temp->step)%4]+1].dat;

      if(spp_detect_collision(temp->x-(tmp->w>>1),temp->y-(tmp->h>>1),tmp,temp2->x-(tmp2->w>>1),temp2->y-tmp2->h,tmp2)) 
        temp->draw_layer=temp2->draw_layer;
      
      temp2=temp2->next;
    }  
    temp=temp->next;
  }
 
}

void mob_list::sort(c_map *mp)
{
  if(!needs_sort) return;

  if(!top) return;
  
  if(tree) delete tree;
  
  do_character_checks();
  
  tree=new mob_tree;
  
  tree->left=NULL;
  tree->right=NULL;
  tree->parent=NULL;
  tree->reflection=FALSE;
  tree->m=top;
    
  Mobile *temp=top->next;
  mob_tree *tmp;
    
  while(temp) {
    tmp=new mob_tree;
    tmp->left=NULL;
    tmp->right=NULL;
    tmp->parent=NULL;
    tmp->reflection=FALSE;
    tmp->m=temp;
    add_node(mp,tmp);
    temp=temp->next;
  }        
  
  temp=top;
  while(temp) { // now do the reflections
    if(temp->has_reflection) {
      tmp=new mob_tree;
      tmp->left=NULL;
      tmp->right=NULL;
      tmp->parent=NULL;
      tmp->reflection=TRUE;
      tmp->m=temp;
      add_node(mp,tmp);
    }
    temp=temp->next;
  }
}

mob_list::mob_list()
{
  top=NULL;
  tree=NULL;
  needs_sort=FALSE;
}

mob_list::~mob_list()
{
  clear();
}

void mob_list::clear()
{
  Mobile *temp;
  if(tree) delete tree;
  while(top) {
    temp=top;
    top=top->next;
    delete temp;
  }       
  top=NULL;
  tree=NULL;
  needs_sort=FALSE;
}

void mob_list::update(c_map *mp)
{
  Mobile *temp=top,*temp2;

  while(temp) {
    temp->update(mp,this);
    temp2=top;

    while(temp2) {
      if(temp2!=temp&&(temp->getFlag(CHAR_ISPLAYER)||temp2->getFlag(CHAR_ISPLAYER))) {
        if(in_range(30,temp->x,temp->y,temp2->x,temp2->y)) {
          if(temp2->getFlag(CHAR_ISPLAYER)&&temp->ps) {
            run_hrs_script(temp->ps);
            break;
          }
          else if(temp->getFlag(CHAR_ISPLAYER)&&check_key(key_action)&&temp2->as
           &&is_facing(temp->facing,temp->x,temp->y,temp2->x,temp2->y)) {
             temp2->disabled=TRUE;
             temp->setFlag(CHAR_ISPLAYER,FALSE);
             temp->stop();
             run_hrs_script(temp2->as);
             temp2->disabled=FALSE;
             temp->setFlag(CHAR_ISPLAYER,TRUE);
             break;
           }
        }
      }
      temp2=temp2->next;
    }

    temp=temp->next;
  }
  needs_sort=TRUE;
}

int mob_list::check_walk(c_map *mp,int key,int x,int y)
{
  Mobile *m = get_mob(key);
  BITMAP *tmp=(BITMAP *)m->char_data[4].dat,*tmp2;
  
  if(mp->check_tile(m->layer,tmp,x-(tmp->w>>1),y-(tmp->h>>1)))
    return TRUE;
  
  Mobile *temp=top;

  while(temp) {
    if(temp->key==key) {
      temp=temp->next;
      continue; 
    }
    tmp2=(BITMAP *)temp->char_data[4].dat;

    if(temp->getFlag(CHAR_VISIBLE) && spp_detect_collision(x-(tmp->w>>1),y-(tmp->h>>1),tmp,temp->x-(tmp2->w>>1),temp->y-(tmp2->h>>1),tmp2))
      return TRUE;

    temp=temp->next;
  }
 
  return FALSE;
}

void mob_list::center(int key,c_map *mp,viewport *v)
{
  Mobile *temp=get_mob(key);

  temp->center(mp,v);
}

#define SET_(name2,name) if(strcmp(flag, name2 )==0) { tmp->setFlag( name ,value); return; }

void mob_list::set_npc_flag(int mob,char *flag,int value)
{
  Mobile *tmp=get_mob(mob);
  
  if(!tmp) return;

  SET_("CHAR_FOLLOW",CHAR_FOLLOW)
  SET_("CHAR_RANDOM",CHAR_RANDOM)
  SET_("CHAR_SHADOW",CHAR_SHADOW)
  SET_("CHAR_VISIBLE",CHAR_VISIBLE)
  SET_("CHAR_ISPLAYER",CHAR_ISPLAYER)
  
}
#undef SET_
#define SET_(name2,name) if(strcmp(var, name2 )==0) { tmp -> name = value; return; }
  
void mob_list::set_npc_var(int mob,char *var,int value)
{
  Mobile *tmp=get_mob(mob);

  if(!tmp) return;

  SET_("layer",layer)
  SET_("follow",follow)
  SET_("dest_point",dest_point)
  SET_("facing",facing)
  SET_("ax1",ax1)
  SET_("ay1",ay1)
  SET_("ax2",ax2)
  SET_("ay2",ay2)
  SET_("has_reflection",has_reflection)
  SET_("x2",x2)
  SET_("y2",y2)
  SET_("x",x)
  SET_("x",y)
  SET_("x",z)
}
#undef SET_
#define GET_(name2,name) if(strcmp(flag, name2 )==0) return tmp->getFlag( name );
  
int mob_list::get_npc_flag(int mob,char *flag)
{
  Mobile *tmp=get_mob(mob);
  
  if(!tmp) return FALSE;

  GET_("CHAR_FOLLOW",CHAR_FOLLOW)
  GET_("CHAR_RANDOM",CHAR_RANDOM)
  GET_("CHAR_SHADOW",CHAR_SHADOW)
  GET_("CHAR_VISIBLE",CHAR_VISIBLE)
  GET_("CHAR_ISPLAYER",CHAR_ISPLAYER)

  return FALSE;
}
#undef GET_
#define GET_(name2,name) if(strcmp(var,name2)==0) return tmp-> name ;
int mob_list::get_npc_var(int mob,char *var)
{
  Mobile *tmp=get_mob(mob);

  if(!tmp) return 0;

  GET_("layer",layer)
  GET_("follow",follow)
  GET_("dest_point",dest_point)
  GET_("facing",facing)
  GET_("ax1",ax1)
  GET_("ay1",ay1)
  GET_("ax2",ax2)
  GET_("ay2",ay2)
  GET_("has_reflection",has_reflection)
  GET_("x2",x2)
  GET_("y2",y2)
  GET_("x",x)
  GET_("y",y)
  GET_("z",z)

  return 0;
}
#undef GET_

void mob_list::draw(BITMAP *bmp,c_map *mp,viewport *v)
{
  sort(mp);  // this is the key.

  if(!tree) 
    return;

  mob_tree *temp=tree, *old_temp;

  while(temp->left) temp=temp->left; // move to the top node in the tree
  old_temp=temp;
  
  int i=0,layer_count=mp->countLayers(); 
  
  c_layer *lyr;
  
  while(temp)
  {
    while(temp->get_draw_layer(mp)>i&&i<layer_count) {
      while(old_temp!=temp&&old_temp) {    
        old_temp->m->draw_reflection();
 
        if(old_temp->right) {
          old_temp=old_temp->right;
          while(old_temp->left) old_temp=old_temp->left;
        }
        else {
          while(old_temp->parent&&old_temp->parent->right==old_temp)
            old_temp=old_temp->parent;
          if(old_temp->parent) old_temp=old_temp->parent;
          else old_temp=NULL;
        } 
        
      }
      lyr=mp->getLayerPointer(i++);
      if(lyr->getFlag(LAYER_INVISIBLE)) continue;
      lyr->draw(bmp,mp->getX(),mp->getY(),-1);
    }
    
    temp->draw(bmp,mp,v);
 
    if(temp->right) {
      temp=temp->right;
      while(temp->left) temp=temp->left;
    }
    else {
      while(temp->parent&&temp->parent->right==temp)
        temp=temp->parent;
      if(temp->parent) temp=temp->parent;
      else temp=NULL;
    }
  }       
  while(old_temp!=temp&&old_temp) {    
    old_temp->m->draw_reflection();
 
    if(old_temp->right) {
      old_temp=old_temp->right;
      while(old_temp->left) old_temp=old_temp->left;
    }
    else {
      while(old_temp->parent&&old_temp->parent->right==old_temp)
        old_temp=old_temp->parent;
      if(old_temp->parent) old_temp=old_temp->parent;
      else old_temp=NULL;
    } 
        
  }
      
  while(i<layer_count) {
    lyr=mp->getLayerPointer(i++);
    if(lyr->getFlag(LAYER_INVISIBLE)) continue;
    lyr->draw(bmp,mp->getX(),mp->getY(),-1);
  }
      
   
}

void mob_list::add_mob(Mobile *mob)
{
  if(!mob) return;
  mob->next=top;
  top=mob;

  needs_sort=TRUE;
}

void mob_list::delete_mob(int key)
{
  Mobile *temp = top,*temp2;

  if(!top) return;

  if(top->key==key) {
    top=top->next;
    delete temp;
    needs_sort=TRUE;
    return;
  }

  while(temp->next) 
    if(temp->next->key==key) {
      temp2=temp->next;
      temp->next=temp2->next;
      delete temp2;
      needs_sort=TRUE;
      return;
    }

}

Mobile *mob_list::get_mob(int key)
{
  Mobile *temp=top;

  while(temp) {
    if(temp->key==key)
      break;
    temp=temp->next;
  }
  return temp;
}

Mobile *mob_list::get_top()
{
  return top;
}


