// This code is LGPL... however remember you only have to release the code... if you are
// releasing the compiled version.
//

#include <allegro.h>
#include <stdio.h>
#include "menu.h"
#include "alleg.h"
#include "dummy.h"

void set_pass()
{     
	  //no password for our mini-rpg
      //packfile_password("password here"); // this is set only in one place so the
                               // password doesn't appear in the exe file
                               // more than once.
}

#include "func.h"
#include "points.h"
#include "npc.h"
#include "tile.h"
#include "layer.h"
#include "map.h"
#include "tileedit.h"
#include "tileset.h"
#include "func.h"
#include "dime.h"
#include "viewport.h"
#include "points.h"
#include "npc.h"
char *text_edit(char *txt,int x1,int y1,int x2,int y2);

static int EditEntry();


// Globals:
static int cont,mypause;
static int number,x,y,z,ret;
static char filename[80];
static char number1[10],x1[10],y1[10],z1[10],scriptname[50];
static c_map *map;
static int current_layer;
static int tile1,tile2;
static bool grid;
static s_tilemenu tmenu;
static int mode;          // 1= tiles, 2=add trigger, 3=edit trigger,4=del trigger
static int sub_mode1,sub_mode2;
static int active;        // the active layer or trigger
static int fx,fy;         // the first coordinates when dragging a rect
static bool mouse_down;
static bool acdown;
//static c_points * points;
static int current_walk;    //the key of the walkpoint you're moving (over) -1 for none
static int prev_point;  //defines the key of the previous point made (for adding path's)
extern BITMAP * buffer;
static char map_filename[80];

void draw_tile_menu();
void check_mouse();
void update_menu(); 
void draw_mouse(BITMAP *b);
void remove_mouse(BITMAP *b);

extern int errors;

static DIALOG create_trigger_dialog[] =
  {
   // (dialog proc)     (x)   (y)   (w)   (h)   (fg)  (bg)  (key) (flags)  (d1)  (d2)  (dp)              (dp2) (dp3) 
   { d_box_proc,        0,    0,    305,  109,  0,    0,    0,    0,       0,    0,    NULL,             NULL, NULL  },

   { d_ctext_proc,      150,  8,    100,  16,   0,    0,    0,    0,       0,    0,    (void *)"Enter Trigger Properties",             NULL, NULL  },

   { d_text_proc,       5,    28,   30,   16,   0,    0,    0,    0,       0,    0,    (void *)"Action",             NULL, NULL  },
   { d_edit_proc,       85,   28,   200,  16,   0,    0,    0,    0,       5,    0,    NULL,             NULL, NULL  },

   { d_text_proc,       5,    44,   25,   16,   0,    0,    0,    0,       0,    0,    (void *)"S:",             NULL, NULL  },
   { d_button_proc,     30,   40,   60,   16,   0,    0,    0,    D_EXIT,  0,    0,    (void *)"Edit",             NULL, NULL  },
   { d_button_proc,     100,  40,   60,   16,   0,    0,    0,    D_EXIT,  0,    0,    (void *)"Test",             NULL, NULL  },
   { d_button_proc,     170,  40,   60,   16,   0,    0,    0,    D_EXIT,  0,    0,    (void *)"Import",             NULL, NULL  },
   { d_button_proc,     240,  40,   60,   16,   0,    0,    0,    D_EXIT,  0,    0,    (void *)"Export",             NULL, NULL  },

   { d_text_proc,       5,    60,   30,   16,   0,    0,    0,    0,       0,    0,    (void *)"Direction",             NULL, NULL  },
   { d_edit_proc,       85,   60,   200,  16,   0,    0,    0,    0,       10,   0,    NULL,             NULL, NULL  },

   { d_button_proc,     10,   90,   60,   16,   0,    0,    0,    D_EXIT,  0,    0,    (void *)"Okay",             NULL, NULL  },
   { d_button_proc,     240,  90,   60,   16,   0,    0,    0,    D_EXIT,  0,    0,    (void *)"Cancel",             NULL, NULL  },

   { d_yield_proc,      0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL,             NULL, NULL  },


   { NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL }
};

int setup_menu();

static int EditNpcScript()
{
  int i;
  char *buff,*buff2;

  if(map->active_npc<0) return -1;

  while((mouse_b&1)||(mouse_b&2));
  clear_keybuf();
  remove_mouse(screen);

  buff=map->getNpcScript(map->active_npc,sub_mode2);

  if(buff==NULL) {
    if(sub_mode1==0||sub_mode1==2) {
      buff=new char[2];
      buff[0]=0;
    }
    else return -1;
  }

  if(sub_mode1==0) {  // then edit the script
    buff2=text_edit(buff,50,50,590,430);
    while(key[KEY_ESC]);
    delete []buff;
    map->setNpcScript(map->active_npc,sub_mode2,buff2);
  }
  if(sub_mode1==1) {  // then test the script
    VMachine *r=compile_hrs_script(buff,strlen(buff));

    if(r!=NULL) {
      free_hrs_script(r);
    }
 
    if(errors>0) {
      char tmp[20];
      sprintf(tmp,"%d Error(s) were found.",errors);
      if(alert(tmp,NULL,NULL,"View Errors","Cancel",0,0)==1&&exists("error.log")) {
        PACKFILE *f=pack_fopen("error.log", F_READ);
        buff2=new char[10240];
        i=0;
        while(!pack_feof(f)&&i<10238) {
          buff2[i]=pack_getc(f);
          if(buff2[i]!='\r') i++;
        }
        buff2[i]=0;
        pack_fclose(f);

        char *a=text_edit(buff2,50,50,590,430);

        delete []a;
        delete []buff2;

        }
      }
      else {
        alert("0 Error(s) were found",NULL,NULL,"Ok",NULL,0,0);
      }
      while(key[KEY_ESC]);

  }
  if(sub_mode1==2) {  // then import a script
    strcpy(filename,"*.txt");
    if(file_select("Import Script", filename, "TXT;HRS;")&&!key[KEY_ESC]) {
      if(exists(filename)) {
        PACKFILE *f=pack_fopen(filename, F_READ);
        buff2=new char[10240];
        int i=0;
        while(!pack_feof(f)&&i<10238) {
          buff2[i]=pack_getc(f);
          if(buff2[i]!='\r') i++;
        }
        buff2[i]=0;

        pack_fclose(f);
        delete []buff;
        buff=new char[strlen(buff2)+1];
        strcpy(buff,buff2);
        delete []buff2;
      }
    }
    map->setNpcScript(map->active_npc,sub_mode2,buff);
  }
  if(sub_mode1==3) {  // export the script
    strcpy(filename,"default.txt");
    if(file_select("Export Script", filename, "TXT;HRS;")&&!key[KEY_ESC]) {
      PACKFILE *f=pack_fopen(filename, F_WRITE);
      int i=0;
      while(buff[i]!=0) {
        pack_putc(buff[i++],f);
      }
      pack_fclose(f);
    }
  }
  return 0;
}

static int InsertNpc()
{
  int px=mouse_x+map->getX(),py=mouse_y+map->getY();
  
  while((mouse_b&1)||(mouse_b&2));
  clear_keybuf();
  remove_mouse(screen);
  	
  int i=0,d=0;

  int shadow=TRUE;
  int visible=TRUE;
  int flags=0;

  x=4;
  y=z=0;
  if(dialogf("Create Npc",ALIGN_CENTRE,ALIGN_CENTRE,320,
          "Facing:%int[0,8]"
          "Layer:%int[,]"
          "Character set:%wdatafile[,Select character animation set,FILE]"
	  "Draw Shadow%bool[]"
	  "Visible%bool[]"
          ,&x 
          ,&y
	  ,&z
          ,characters
	  ,&shadow
	  ,&visible
       )==1&&!key[KEY_ESC])
  {
    if(shadow)
	flags|=CHAR_SHADOW;
    if(visible)
	flags|=CHAR_VISIBLE;

    map->addNpc(px,py,(char *)get_datafile_property(&characters[z],DAT_NAME),x,y,flags);
  }
  
  return 0;
}
static int EditNpcOptions()
{
  while((mouse_b&1)||(mouse_b&2));
  clear_keybuf();
  remove_mouse(screen);
  	
  int flags;

  map->getNpc(map->active_npc,&z,&x,&y,&flags);

  int shadow=(flags&CHAR_SHADOW);
  int visible=(flags&CHAR_VISIBLE);

  if(dialogf("Edit Npc",ALIGN_CENTRE,ALIGN_CENTRE,320,
          "Facing:%int[0,8]"
          "Layer:%int[,]"
          "Character set:%wdatafile[,Select character animation set,FILE]"
	  "Draw Shadow%bool[]"
	  "Visible%bool[]"
          ,&x 
          ,&y
	  ,&z
          ,characters
	  ,&shadow
	  ,&visible
       )==1&&!key[KEY_ESC])
  {
    if(shadow)
	flags|=CHAR_SHADOW;
    else flags&=~(CHAR_SHADOW);
    if(visible)
	flags|=CHAR_VISIBLE;
    else flags&=~(CHAR_VISIBLE);

    map->setNpc(map->active_npc,(char *)get_datafile_property(&characters[z],DAT_NAME),x,y,flags);
  }
  return 0;
}
static int DeleteNpc()
{
  while((mouse_b&1)||(mouse_b&2));
  clear_keybuf();
  remove_mouse(screen);

  if(alert("Delete selected Npc?",NULL,NULL,"&Yes","&No",'y','n')==1&&!key[KEY_ESC])
  {
    map->deleteNpc(map->active_npc);
  }

  return 0;
}

static int InsertTrigger()
{
        int ret;
        while((mouse_b&1)||(mouse_b&2));
        clear_keybuf();
  	remove_mouse(screen);
  	x1[0]='\0';
  	y1[0]='\0';
  	scriptname[0]='\0';

  	create_trigger_dialog[3].dp=(void *)x1;
        create_trigger_dialog[10].dp=(void *)y1;

        char *buff=new char[3];
        char *buff2;
        buff[0]='\n';
        buff[1]='\0';

        do
        {
             ret=do_dialog(create_trigger_dialog,0);
             if(ret==5) {
                buff2=text_edit(buff,50,50,590,430);
                while(key[KEY_ESC]);
                delete []buff;
                buff=buff2;
             }
             if(ret==6) {
               VMachine *r=compile_hrs_script(buff,strlen(buff));

               if(r!=NULL) {
                 free_hrs_script(r);
               }
               if(errors>0) {
                 char tmp[20];
                 sprintf(tmp,"%d Error(s) were found.",errors);
                 if(alert(tmp,NULL,NULL,"View Errors","Cancel",0,0)==1&&exists("error.log")) {
                    PACKFILE *f=pack_fopen("error.log", F_READ);
                    buff2=new char[10240];
                    int i=0;
                    while(!pack_feof(f)&&i<10238) {
                      buff2[i]=pack_getc(f);
                      if(buff2[i]!='\r') i++;
                    }
                    buff2[i]=0;
                    pack_fclose(f);

                    char *a=text_edit(buff2,50,50,590,430);

                    delete []a;
                    delete []buff2;

                 }
               }
               else {
                 alert("0 Error(s) were found",NULL,NULL,"Ok",NULL,0,0);
               }
               while(key[KEY_ESC]);
             }
             if(ret==7) {
                strcpy(filename,"*.txt");
                if(file_select("Import Script", filename, "TXT;HRS;")&&!key[KEY_ESC]) {
                  if(exists(filename)) {
                    PACKFILE *f=pack_fopen(filename, F_READ);
                    buff2=new char[10240];
                    int i=0;
                    while(!pack_feof(f)&&i<10238) {
                      buff2[i]=pack_getc(f);
                      if(buff2[i]!='\r') i++;
                    }
                    buff2[i]=0;

                    pack_fclose(f);
                    delete []buff;
                    buff=new char[strlen(buff2)+1];
                    strcpy(buff,buff2);
                    delete []buff2;
                  }
                }
             }
             if(ret==8) {
                strcpy(filename,"default.txt");
                if(file_select("Export Script", filename, "TXT;HRS;")&&!key[KEY_ESC]) {
                  PACKFILE *f=pack_fopen(filename, F_WRITE);
                  int i=0;
                  while(buff[i]!=0) {
                    pack_putc(buff[i++],f);
                  }
                  pack_fclose(f);
                }
              
             }
                
	}
        while(ret!=11&&ret!=12&&!key[KEY_ESC]);

        
        if(ret==12||key[KEY_ESC])
        {
                delete []buff;
                map->deleteTrigger(map->active_trigger);
        }
        else if(ret==11) {
          x=atoi(x1);
          y=atoi(y1);
          map->setTrigger(map->active_trigger,x,y,buff);
        }

        map->active_trigger=-1;

  return 0;
}


static int InsertEntry()
{

        clear_keybuf();
  	remove_mouse(screen);

     x=y=z=0;
     if(dialogf("Create Entry Point",ALIGN_CENTRE,ALIGN_CENTRE,320,
          "Key%int[0,]"
          "Direction%int[-1,8]"
          "Layer%int[,]",
          &x,
          &y,
          &z
       )==1&&!key[KEY_ESC])

     {
        int editreturn=1;
        while ((x==-1 || map->getEntryIndex(x)>-1) && editreturn!=-1)
        {
            alert("Key already exist or wrong key.","Please enter a positive and free key",NULL,"'M-Kay",NULL,'y','n');
       	    map->setEntry(map->active_entry,x,y,z);
            editreturn = EditEntry();
            x=map->getEntryKey(map->active_entry);
            map->setEntry(map->active_entry,-1,map->getEntryDirection(map->active_entry),z);
        }
        if (editreturn!=-1)
        {
        	map->setEntry(map->active_entry,x,y,z);
        }
        if (editreturn==-1)
        {
        	map->deleteEntry(map->active_entry);
        }
    }
    else
    {
    	map->deleteEntry(map->active_entry);
    }

    map->active_entry=-1;
    return 0;
}

static int EditEntry()
{
	if (map->active_entry <0) return -1;
        clear_keybuf();
  	remove_mouse(screen);

        x=map->getEntryKey(map->active_entry);
        y=map->getEntryDirection(map->active_entry);
	z=map->getEntryLayer(map->active_entry);

        if(dialogf("Edit Entry", ALIGN_CENTRE, ALIGN_CENTRE, 320,  
                   "Key%int[0,]"
                   "Direction%int[-1,8]"
                   "Layer%int[,]",
                   &x,&y,&z
           )==1&&!key[KEY_ESC])
        {
                map->setEntry(map->active_entry,x,y,z);
                return 0;
	}
    else
    {
    	return -1;
    }

}




static int EditTrigger()
{
    if (map->active_trigger<0) return -1;
    while((mouse_b&1)||(mouse_b&2));

	clear_keybuf();
  	remove_mouse(screen);
	sprintf(x1,"%d",map->getTriggerAction(map->active_trigger));
        sprintf(y1,"%d",map->getTriggerDirection(map->active_trigger));
        char *buff=map->getTriggerScriptName(map->active_trigger);
        if(buff==NULL) {
          buff=new char[2];
          buff[0]=0;
        }
        char *backup=new char[strlen(buff)+1];
        strcpy(backup,buff);
        

        char *buff2;


  	create_trigger_dialog[3].dp=(void *)x1;
        create_trigger_dialog[10].dp=(void *)y1;

        do
        {
             ret=popup_dialog(create_trigger_dialog,5);
             if(ret==5) {
                buff2=text_edit(buff,50,50,590,430);
                while(key[KEY_ESC]);
                delete []buff;
                buff=buff2;
             }
             if(ret==6) {
               VMachine *r=compile_hrs_script(buff,strlen(buff));

               if(r!=NULL) {
                 free_hrs_script(r);
               }
               if(errors>0) {
                 char tmp[20];
                 sprintf(tmp,"%d Error(s) were found.",errors);
                 if(alert(tmp,NULL,NULL,"View Errors","Cancel",0,0)==1&&exists("error.log")) {
                    PACKFILE *f=pack_fopen("error.log", F_READ);
                    buff2=new char[10240];
                    int i=0;
                    while(!pack_feof(f)&&i<10238) {
                      buff2[i]=pack_getc(f);
                      if(buff2[i]!='\r') i++;
                    }
                    buff2[i]=0;
                    pack_fclose(f);

                    char *a=text_edit(buff2,50,50,590,430);

                    delete []a;
                    delete []buff2;

                 }
               }
               else {
                 alert("0 Error(s) were found",NULL,NULL,"Ok",NULL,0,0);
               }
               while(key[KEY_ESC]);
             }

             if(ret==7) {
                strcpy(filename,"*.txt");
                if(file_select("Import Script", filename, "TXT;HRS;")&&!key[KEY_ESC]) {
                  if(exists(filename)) {
                    PACKFILE *f=pack_fopen(filename, F_READ);
                    buff2=new char[10240];
                    int i=0;
                    while(!pack_feof(f)&&i<10238) {
                      buff2[i]=pack_getc(f);
                      if(buff2[i]!='\r') i++;
                    }
                    buff2[i]=0;

                    pack_fclose(f);
                    delete []buff;
                    buff=new char[strlen(buff2)+1];
                    strcpy(buff,buff2);
                    delete []buff2;
                  }
                }

             }
             if(ret==8) {
                strcpy(filename,"default.txt");
                if(file_select("Export Script", filename, "TXT;HRS;")&&!key[KEY_ESC]) {
                  PACKFILE *f=pack_fopen(filename, F_WRITE);
                  int i=0;
                  while(buff[i]!=0) {
                    pack_putc(buff[i++],f);
                  }
                  pack_fclose(f);
                }
              
             }

	}
        while(ret!=11&&ret!=12&&!key[KEY_ESC]);

        if(ret==12||key[KEY_ESC]) {
          delete[]buff;
          
          map->setTrigger(map->active_trigger,map->getTriggerAction(map->active_trigger),map->getTriggerDirection(map->active_trigger),backup);
        }
        else if(ret==11) {
          x=atoi(x1);
          y=atoi(y1);
          delete []backup;
          map->setTrigger(map->active_trigger,x,y,buff);
        }

    map->active_trigger=-1;

  return 0;
}


static int InsertWalk()
 {
  clear_keybuf();
  remove_mouse(screen);
  int keyt;
  int xt=mouse_x;
  int yt=mouse_y;
  int next_p=-1;
  keyt=map->points->get_free();
  do {
    if( dialogf("Insert Walk Point", ALIGN_CENTRE, ALIGN_CENTRE, 320,
             "Key%int[0,]"
             "Next Key%int[-1,]",
              &keyt,&next_p
     )==1 && !key[KEY_ESC])
    {
	  if (!map->points->is_free(keyt))
            continue;

          map->points->add(xt+map->getX(),yt+map->getY(),keyt,next_p);
    }
  } while(FALSE);
  return 0;
 }


static int EditWalk()
{
	if (current_walk<0) return -1;
  clear_keybuf();
  remove_mouse(screen);
  int keyt;
  int next_p=map->points->get_next_key(current_walk);
  keyt=current_walk;
  do {
    if( dialogf("Edit Walk Point", ALIGN_CENTRE, ALIGN_CENTRE, 320,
             "Key%int[0,]"
             "Next Key%int[-1,]",
              &keyt,&next_p
     )==1 && !key[KEY_ESC])
    {
	  if (map->points->change(current_walk,keyt,next_p)==-1) 
            continue;
    }
  } while(FALSE);
  return 0;
 }

static int RemoveWalk()
{
	if (current_walk<0) return -1;
	if(alert("Delete selected Walk Point??",NULL,NULL,"&Yes","&No",'y','n')==1&&!key[KEY_ESC])
    {
    	map->points->remove(current_walk);
    }
    return 0;
}



static int InsertPath()
{

	int keyt = map->points->get_free();
	int nextkeyt=-1;
	map->points->add(mouse_x+map->getX(),mouse_y+map->getY(),keyt,-1);
	if (prev_point>=0)
	map->points->change(prev_point,prev_point,keyt);
	prev_point=keyt;
	return 0;
}




static int InsertLayer()
{
  clear_keybuf();
  remove_mouse(screen);
  number=map->countLayers();
  x=y=1;
  if(dialogf("Insert Layer", ALIGN_CENTRE, ALIGN_CENTRE, 320,
             "Number%int[0,]" 
             "Width%int[1,]"
             "Height%int[1,]",
             &number,&x,&y
   )==1&&!key[KEY_ESC])
  {

    ret = map->insertLayer(number-1,x,y);
    if (ret!=-1) current_layer=ret;
  }
  return 0;
 }


static int DeleteTrigger()
{
	if (map->active_trigger<0) return -1;
    if(alert("Delete selected Trigger?",NULL,NULL,"&Yes","&No",'y','n')==1&&!key[KEY_ESC])
    {
    	map->deleteTrigger(map->active_trigger);
    }
    return 0;
}


static int DeleteEntry()
{
	if (map->active_entry<0) return -1;
    if(alert("Delete selected Entry?",NULL,NULL,"&Yes","&No",'y','n')==1&&!key[KEY_ESC])
    {
    	map->deleteEntry(map->active_entry);
    }
    return 0;
}



static int DeleteLayer()
 {
	    clear_keybuf();
	    remove_mouse(screen);
    number=0;
    if(dialogf("Delete Layer", ALIGN_CENTRE, ALIGN_CENTRE, 320,
             "Number%int[0,]",&number
      )==1&&!key[KEY_ESC])
            {
	    int ret = map->deleteLayer(number);
	    if (ret!=-1 && current_layer==number) current_layer=map->countLayers()-1;
	    }
	    return 0;
 }
static int EditLayer()
	{
	    clear_keybuf();
	    remove_mouse(screen);
            number=0;
  if(dialogf("Edit Layer", ALIGN_CENTRE, ALIGN_CENTRE, 320,
             "Number%int[0,]",&number
      )==1&&!key[KEY_ESC])
            {

	    if (number>=0 && number<map->countLayers()) current_layer=number;
	    }
	    return 0;
	}
static int SaveMap()
	{
	    clear_keybuf();
	    remove_mouse(screen);
        if(file_select("Save Map", map_filename, "MAP")&&!key[KEY_ESC])
           map->saveToFile(map_filename);
	    return 0; 
	}
static int LoadMap()
	{
	   int ret;
       clear_keybuf();
	   remove_mouse(screen);
       strcpy(map_filename,"*.map");

           if(file_select("Load Map", map_filename, "MAP")!=0&&
              !key[KEY_ESC]&&exists(map_filename)) {
              if((ret=map->loadFromFile(map_filename))!=0){
                set_gfx_mode(GFX_TEXT,0,0,0,0);
                allegro_message("Error: %d Can't load map!",-ret);
                exit(1);
              }
           }
 

           current_layer=map->countLayers()-1;
           return 0;
	}
static int RandLayer()
	{
	    clear_keybuf();
	    remove_mouse(screen);
            number=0;
  if(dialogf("Randomize Layer", ALIGN_CENTRE, ALIGN_CENTRE, 320,
             "Number%int[0,]",&number
      )==1&&!key[KEY_ESC])
            {
	    if (number>=0 && number<map->countLayers()) map->randomizeLayer(number);
	    }
	    return 0;
	}
static int SwitchTileset()
        {
           clear_keybuf();
	   remove_mouse(screen);
            strcpy(filename,"*.dat");
             if(file_select("Load Tileset", filename, "DAT")&&!key[KEY_ESC]) 
               map->switchTileset(filename);



		current_layer=map->countLayers()-1;
	   return 0;
           



        }
static int OptionsLayer()
	{
	  clear_keybuf();
	  remove_mouse(screen);
	  if(current_layer<0||current_layer>=map->countLayers()) {
	    alert("No layer selected!",NULL,NULL,"&Ok",NULL,'o',0);
	    return 0;
	  }
      int o1,o2,o3,o4,o5,o6;
      double sx1,sy1,sx2,sy2;
      int rt,ry,rz,rtrans;

	  z=map->getLayerPointer(current_layer)->getz();
	  x=map->getLayerPointer(current_layer)->gridx();
	  y=map->getLayerPointer(current_layer)->gridy();
      number=map->getLayerPointer(current_layer)->getTrans();
      
      sx1=map->getLayerPointer(current_layer)->getSpeed(DIR_X);
      sy1=map->getLayerPointer(current_layer)->getSpeed(DIR_Y);
      sx2=map->getLayerPointer(current_layer)->getScroll(DIR_X);
      sy2=map->getLayerPointer(current_layer)->getScroll(DIR_Y);
      
	  
	  o1=map->getLayerPointer(current_layer)->getFlag(LAYER_CONTINUES);
      o2=map->getLayerPointer(current_layer)->getFlag(LAYER_INVISIBLE);
      o3=map->getLayerPointer(current_layer)->getFlag(LAYER_WALK);
      o4=map->getLayerPointer(current_layer)->getFlag(LAYER_EFFECT0);
      o5=map->getLayerPointer(current_layer)->getFlag(LAYER_EFFECT1);
      
      if(o4) o6=1;
      else if(o5) o6=2;
      else o6=0;
      
      rt=map->getLayerPointer(current_layer)->get_reflect_type()+1;
      ry=map->getLayerPointer(current_layer)->get_reflect_y();
      rz=map->getLayerPointer(current_layer)->get_reflect_z();
      rtrans=map->getLayerPointer(current_layer)->get_reflect_trans();
  
          if(dialogf("Edit Layer Options", ALIGN_CENTRE, ALIGN_CENTRE, 320,
             "Trans%int[0,]"
             "Wrap edges%bool[]"
             "Invisible%bool[]"
             "Walk Layer%bool[]"
             "Effect%wlist[3,Pick Effect,none;sine effect;heat effect]"
             "Grid Width%int[1,]"
             "Grid Height%int[1,]"
             "Speed X%double[0,]"
             "Speed Y%double[0,]"
             "Scroll X%double[0,]"
             "Scroll Y%double[0,]"
             "Layer Z value%int[,]"
             "Reflect Type%wlist[3,Pick Reflect Type,none;floor reflection;wall mirror]"
             "Reflect Y%int[,]"
             "Reflect Z%int[,]"
             "Reflect Trans%int[,]"
             ,&number,&o1,&o2,&o3,&o6,&x,&y,&sx1,&sy1,&sx2,&sy2,&z,&rt,&ry,&rz,&rtrans
      )==1&&!key[KEY_ESC])
            {
        if(o6==1) { o4=TRUE; o5=FALSE; }
        else if(o6==2) {o4=FALSE; o5=TRUE; }
        else {o4=FALSE; o5=FALSE;}
	    
	    map->getLayerPointer(current_layer)->set_reflect_type(rt-1);
	    map->getLayerPointer(current_layer)->set_reflect_y(ry);
	    map->getLayerPointer(current_layer)->set_reflect_z(rz);
	    map->getLayerPointer(current_layer)->set_reflect_trans(rtrans);
	    map->getLayerPointer(current_layer)->setTrans(number);
	    map->getLayerPointer(current_layer)->setFlag(LAYER_CONTINUES,o1);
	    map->getLayerPointer(current_layer)->setFlag(LAYER_INVISIBLE,o2);
	    map->getLayerPointer(current_layer)->setFlag(LAYER_WALK,o3);
	    map->getLayerPointer(current_layer)->setFlag(LAYER_EFFECT0,o4);
	    map->getLayerPointer(current_layer)->setFlag(LAYER_EFFECT1,o5);
	    map->getLayerPointer(current_layer)->setGrid(x,y);
	    map->getLayerPointer(current_layer)->setSpeed(sx1,sy1);
	    map->getLayerPointer(current_layer)->setScroll(sx2,sy2);
	    map->getLayerPointer(current_layer)->setz(z);
	  }

	  return 0;
	}
static int setTileOptions(int hor,int ver)
{
  c_tile *current_tile=map->getTilePointer(current_layer, hor, ver);
  if(!current_tile) return -1;
  clear_keybuf();
  remove_mouse(screen);
  int f1=current_tile->getFlag(TILE_INVISIBLE);
  int f2=current_tile->getFlag(TILE_ISANIMATION);
  int f3=current_tile->getFlag(TILE_PLAYANIMATION);
  int f4=current_tile->getFlag(TILE_ANIMATIONLOOPS);
  double spd=current_tile->getAnimationSpeed();
  y=current_tile->getAnimationLength();
  z=current_tile->getTrans();
  
  if(dialogf("Edit Tile Option",ALIGN_CENTRE,ALIGN_CENTRE,200,
             "Tile is Invisible%bool[]"
             "Tile is Animated%bool[]"
             "Animation plays automatically%bool[]"
             "Animation Loops (required for autoplay)%bool[]"
             "Trans (-1 for layer trans)%int[-1,255]"
             "Animation Speed%double[0,]"
             "Animation Length%int[0,]",
             &f1,&f2,&f3,&f4,&z,&spd,&y
     )==1&&!key[KEY_ESC]) {
      current_tile->setAnimation(y,spd);
      current_tile->setTrans(z);
      current_tile->setFlag(TILE_INVISIBLE,f1);
      current_tile->setFlag(TILE_ISANIMATION,f2);
      if(f4)
        current_tile->setFlag(TILE_PLAYANIMATION,f3);
      else current_tile->setFlag(TILE_PLAYANIMATION,FALSE);
      current_tile->setFlag(TILE_ANIMATIONLOOPS,f4);
      
    }
  return 0;
}
static int OptionsMap()
{
  clear_keybuf();
  remove_mouse(screen);
  int f1 = 0;
  if(map->getFlag(MAP_INSIDE)) f1=0;
  else if(map->getFlag(MAP_OUTSIDE)) f1=1;
  else if(map->getFlag(MAP_WORLD)) f1=2;
  
  if(dialogf("Map Options",ALIGN_CENTRE,ALIGN_CENTRE,300,
             "Map Type%list[3,Inside Map;Outside Map;World Map]",
             &f1
             )==1&&!key[KEY_ESC])
  {
    switch(f1) {
      case 0:
        map->setFlag(MAP_INSIDE,TRUE);
        map->setFlag(MAP_OUTSIDE,FALSE);
        map->setFlag(MAP_WORLD,FALSE);
        break;
      case 1:
        map->setFlag(MAP_INSIDE,FALSE);
        map->setFlag(MAP_OUTSIDE,TRUE);
        map->setFlag(MAP_WORLD,FALSE);
        break;
      case 2:
        map->setFlag(MAP_INSIDE,FALSE);
        map->setFlag(MAP_OUTSIDE,FALSE);
        map->setFlag(MAP_WORLD,TRUE);
        break;  
    }
  }
	return 0;
}
static int QuitEditor ()
 {
  clear_keybuf();
  remove_mouse(screen);

  if(alert("Do you want to quit?",NULL,NULL,"&Yes","&No",'y','n')==1&&!key[KEY_ESC])
    cont = FALSE;

  return 0;
 }

static MENU main_menu[] = {
   { "Insert Layer",             NULL,      NULL, 0, NULL  },
   { "Delete Layer",             NULL,      NULL, 0, NULL  },
   { "Edit Layer",               NULL,      NULL, 0, NULL  },
   { "Save Map",                 NULL,      NULL, 0, NULL  },
   { "Load Map",                 NULL,      NULL, 0, NULL  },
   { "Randomize Layer",          NULL,      NULL, 0, NULL  },
   { "Edit Layer Options",       NULL,      NULL, 0, NULL  },
   { "Edit Map Options",         NULL,      NULL, 0, NULL  },
   { "Change Tileset",           NULL,      NULL, 0, NULL  },
   { "Quit",                     NULL,      NULL, 0, NULL  },
   { NULL,                       NULL,      NULL, 0, NULL  }
 };


int main()
{
  PALETTE pal;
  int gfx_mode_type=FALSE;
  setup_menu();
  /*tmenu.x1 = 565;
  tmenu.x2 = 634;
  tmenu.y1 = 5;
  tmenu.y2 = 474;
  */


  mode=1;
  mouse_down=FALSE;
  grid=TRUE;
  acdown=TRUE;
  tmenu.sel1=-1;
  tmenu.sel2=-1;
  tile1=tile2=-1;
  current_layer=-1;
  allegroinit(0);

  get_palette(pal);
  set_gfx_mode(GFX_AUTODETECT_WINDOWED,640,480,0,0);
  set_palette(pal);
  destroy_bitmap(buffer);
  buffer=create_bitmap(640,480);
  
  tmenu.x1 = BUFFER_W-75;
  tmenu.x2 = BUFFER_W-6;
  tmenu.y1 = 5;
  tmenu.y2 = BUFFER_H-6;
  set_font(-1); // use BIOS default
  dime_init();
  strcpy(filename,"untitled.map");
        
  map=new c_map;
  
  if(!install_mouse()) {
    set_gfx_mode(GFX_TEXT,0,0,0,0);
    allegro_message("Error with mouse\n");
    exit (1);
  }

  centre_dialog(create_trigger_dialog);
  set_dialog_color(create_trigger_dialog, gui_fg_color, gui_bg_color);

  timer=0;

  cont=TRUE;
  mypause=FALSE;
  int sdown=FALSE;
  int frame=0;
  while (cont)
	{
	while(timer>0) {
        timer--; frame++;
	text_mode(-1);

	if(key[KEY_ESC]) QuitEditor();

	if(mouse_y<3) map->scroll(0,-2,1);
	if(mouse_y>=SCREEN_H-3) map->scroll(0,2,1);
	if(mouse_x<3) map->scroll(-2,0,1);
	if(mouse_x>=SCREEN_W-3) map->scroll(2,0,1);

        if ((key_shifts & KB_CTRL_FLAG)&&(key_shifts & KB_ALT_FLAG)) {
	  if (key[KEY_UP]) map->scrollLayer(current_layer,0,-1,1);
	  if (key[KEY_DOWN]) map->scrollLayer(current_layer,0,1,1);
	  if (key[KEY_RIGHT]) map->scrollLayer(current_layer,1,0,1);
	  if (key[KEY_LEFT]) map->scrollLayer(current_layer,-1,0,1);

        }
        else if ((key_shifts & KB_CTRL_FLAG)) {
	  if (key[KEY_UP]) map->scrollLayer(current_layer,0,-1,1);
	  if (key[KEY_DOWN]) map->scrollLayer(current_layer,0,1,1);
	  if (key[KEY_RIGHT]) map->scrollLayer(current_layer,1,0,1);
	  if (key[KEY_LEFT]) map->scrollLayer(current_layer,-1,0,1);

          while(key[KEY_UP]||key[KEY_DOWN]||key[KEY_RIGHT]||key[KEY_LEFT]);

	}
        else if (key_shifts & KB_ALT_FLAG) {
	  c_layer * cl = map->getLayerPointer(current_layer);
	  if (key[KEY_UP]) map->scrollLayer(current_layer,0,-cl->gridy(),1);
	  if (key[KEY_DOWN]) map->scrollLayer(current_layer,0,cl->gridy(),1);
	  if (key[KEY_RIGHT]) map->scrollLayer(current_layer,cl->gridx(),0,1);
	  if (key[KEY_LEFT]) map->scrollLayer(current_layer,-cl->gridx(),0,1);

	  while(key[KEY_UP]||key[KEY_DOWN]||key[KEY_RIGHT]||key[KEY_LEFT]);
	} 
	else {
	  if (key[KEY_UP]) map->scroll(0,-5,1);
	  if (key[KEY_DOWN]) map->scroll(0,5,1);
	  if (key[KEY_RIGHT]) map->scroll(5,0,1);
	  if (key[KEY_LEFT]) map->scroll(-5,0,1);
	}

    if (key[KEY_OPENBRACE] &&!acdown)
    {
        if (current_layer>0) current_layer--;
        acdown=TRUE;
    }
    if (key[KEY_CLOSEBRACE] &&!acdown)
    {
    	if (current_layer<map->countLayers()-1) current_layer++;
      	acdown=TRUE;
    }
    if (!key[KEY_CLOSEBRACE] && !key[KEY_OPENBRACE])
    {
    	acdown=FALSE;
    }

    if ((key_shifts & KB_CTRL_FLAG)&&key[KEY_S]) SaveMap();
    if ((key_shifts & KB_CTRL_FLAG)&&key[KEY_L]) LoadMap();
#ifdef ALLEGRO_WINDOWS
    if ((key_shifts & KB_ALT_FLAG)&&key[KEY_ENTER]) 
    {
      gfx_mode_type=!gfx_mode_type;
      get_palette(pal);  
      if(!gfx_mode_type)
        set_gfx_mode(GFX_AUTODETECT_WINDOWED,640,480,0,0);
      else 
        set_gfx_mode(GFX_AUTODETECT_FULLSCREEN,640,480,0,0);        
      set_palette(pal);

      while((key_shifts & KB_ALT_FLAG)&&key[KEY_ENTER]);
    }
#endif

    if (key[KEY_O]) OptionsMap();
    if (key[KEY_T]) SwitchTileset();
    if (key[KEY_PRTSCR]) take_shot(buffer);


    grid=!key[KEY_G];

    number=x=y=ret=0;

	if ((mouse_b & 4)) {
	  remove_mouse(screen);
	  show_mouse(screen);
	  ret= do_menu(main_menu,mouse_x,mouse_y);
	  show_mouse(NULL);
	  switch (ret) {
	    case 0: InsertLayer(); break;
	    case 1: DeleteLayer(); break;
	    case 2: EditLayer(); break;
	    case 3: SaveMap(); break;
	    case 4: LoadMap(); break;
	    case 5: RandLayer(); break;
	    case 6: OptionsLayer(); break;
	    case 7: OptionsMap(); break;
            case 8: SwitchTileset(); break;
            case 9: QuitEditor(); break;
	  } 
	}

        if (mode==1)
        {
        	if (key[KEY_F1]) InsertLayer();
        	if (key[KEY_F2]) DeleteLayer();
       		if (key[KEY_F3]) EditLayer();
        	if (key[KEY_F4]) RandLayer();
        	if (key[KEY_F5]) OptionsLayer();
        }

        if (mode>=2 && mode<=5 && !(mouse_b & 1))
        {
        	if (key[KEY_F1]) mode=2;
        	if (key[KEY_F2]) mode=3;
	        if (key[KEY_F3]) mode=4;
                if (key[KEY_F4]) mode=5;
       	}
        if (mode>=6 && mode<=8 && !(mouse_b & 1))
        {
        	if (key[KEY_F1]) mode=6;
        	if (key[KEY_F2]) mode=7;
	        if (key[KEY_F3]) mode=8;

       	}
	if (mode>=9 && mode<=13 && !(mouse_b & 1))
        {
        	if (key[KEY_F1]) mode=9;
        	if (key[KEY_F2]) mode=10;
	        if (key[KEY_F3]) mode=11;
		if (key[KEY_F4]) mode=12;
		if (key[KEY_F5]){ mode=13; prev_point=-1;}
       	}
	if (mode>=14 && mode <= 18 && !(mouse_b & 1))
        {
		if (key[KEY_F1]) mode=14;
        	if (key[KEY_F2]) mode=15;
	        if (key[KEY_F3]) mode=16;
		if (key[KEY_F4]) mode=17;
		if (key[KEY_F5]) {mode=18;sub_mode1=0;sub_mode2=0;}
		if (mode==18) {
		  if(key[KEY_1]) sub_mode1=0;
		  if(key[KEY_2]) sub_mode1=1;
		  if(key[KEY_3]) sub_mode1=2;
		  if(key[KEY_4]) sub_mode1=3;
		  if(key[KEY_5]) sub_mode2=0;
		  if(key[KEY_6]) sub_mode2=1;
		  if(key[KEY_7]) sub_mode2=2;
		  if(key[KEY_8]) sub_mode2=3;
                }
        }

        if (key[KEY_F8]) mode=14;
	if (key[KEY_F9]) {mode=9;prev_point=-1;}
        if (key[KEY_F10]) mode=1;
        if (key[KEY_F11]) mode=2;
        if (key[KEY_F12]) mode=6;

        if(key[KEY_SPACE]) sdown=TRUE;
        else if(sdown) {
          sdown=FALSE;
          mypause=!mypause;
        }

        while(key[KEY_ESC]);

	  check_mouse();
	  update_menu();

          if(!mypause)
            map->update();

          update_objects();
  
	}

        if(frame>0) {
          frame=0;

          draw_background();
   
          draw_mouse(buffer);

          flip();
        }
        else {
          remove_mouse(screen);
          draw_mouse(screen);
        }

    }

   delete map;

   clear_globals();

   return 0;
 }
END_OF_MAIN();

void update_game_logic()
{
  // do nothing.
}
void draw_background()
{
      // ... Draw character + other stuff here ...
      int i;
      clear(buffer);

		  // Demo messages...
      map->drawBack(makecol(35,0,0));
      int color;

      int rr,gg,bb;

      for (i=0;i<map->countLayers();i++)
      {
	if (grid) {
          bb=((i&3)+1)*32;
          gg=(((i>>2)&3)+1)*32;
          rr=(((i>>4)&3)+1)*32;

          color= (map->countLayers()<=0) ? 0 : makecol(rr,gg,bb);
	  map->drawLayerGrid(i,color);
	}
        if(i==current_layer||!map->getLayerPointer(i)->getFlag(LAYER_INVISIBLE))
	  map->drawLayer(buffer,i);
      }

      if(grid) {
        bb=MIN(255,((current_layer&3)+1)*32);
        gg=MIN(255,(((current_layer>>2)&3)+1)*32);
        rr=MIN(255,(((current_layer>>4)&3)+1)*32);

        color =  (map->countLayers()<=0) ? 0 : makecol(rr,gg,bb);
	if (key_shifts & KB_SHIFT_FLAG) map->drawLayerGrid(current_layer,color);
	if (key[KEY_Z]) map->drawLayer(buffer,current_layer);
      }
      map->drawTriggers();
      map->drawEntrys();
      map->drawNpcs();
	  if (mode==13)
	  {
		  if (prev_point>=0)
		  {
			  int xt,yt;
			  if (map->points->getX(prev_point,&xt))
			  {
				  if (map->points->getY(prev_point,&yt))
					  line (buffer,xt-map->getX(),yt-map->getY(),mouse_x,mouse_y,makecol(255,255,255));
			  }
		  }
	  }

      int point_more=FALSE;
      if (mode>=9&&mode<=13) point_more=TRUE;
      map->points->draw(point_more,buffer,map->getX(),map->getY());
      draw_tile_menu();

      textout(buffer,font,"WorldEditor 0.09",0,0,makecol(255,255,255));

      char *tmp=" ";
      if(mypause) tmp="(PAUSED)";

      textprintf(buffer,font,0,8,makecol(255,255,255),"Current Layer: %d %s",current_layer,tmp);

     char * mode_temp="Mode Error #1";
     if (mode==1) mode_temp="Layer Editing";
     if (mode==2) mode_temp="Trigger Editing (Add)";
     if (mode==3) mode_temp="Trigger Editing (Edit Size)";
     if (mode==4) mode_temp="Trigger Editing (Edit Properties)";
     if (mode==5) mode_temp="Trigger Editing (Delete)";
     if (mode==6) mode_temp="Entry Editing (Add/Move)";
     if (mode==7) mode_temp="Entry Editing (Edit Properties)";
     if (mode==8) mode_temp="Entry Editing (Delete)";
     if (mode==9) mode_temp="Walkpoint Editing (Add)";
     if (mode==10) mode_temp="Walkpoint Editing (Move)";
     if (mode==11) mode_temp="Walkpoint Editing (Edit)";
     if (mode==12) mode_temp="Walkpoint Editing (Delete)";
     if (mode==13) mode_temp="Walkpoint Editing (Add Path)";
     if (mode==14) mode_temp="Npc Editing (Add)";
     if (mode==15) mode_temp="Npc Editing (Move)";
     if (mode==16) mode_temp="Npc Editing (Delete)";
     if (mode==17) mode_temp="Npc Editing (Edit Options)";
     if (mode==18) {
       mode_temp="Npc Editing";
       char *sub_temp1=" ";
       char *sub_temp2=" ";
       if(sub_mode1==0) sub_temp1="Edit";
       if(sub_mode1==1) sub_temp1="Test";
       if(sub_mode1==2) sub_temp1="Import";
       if(sub_mode1==3) sub_temp1="Export";
       if(sub_mode2==0) sub_temp2="Init";
       if(sub_mode2==1) sub_temp2="Action";
       if(sub_mode2==2) sub_temp2="Logic";
       if(sub_mode2==3) sub_temp2="Player";
       
       textprintf(buffer,font,0,16,makecol(255,255,255),"Mode: %s (%s %s Script)",mode_temp,sub_temp1,sub_temp2);

     }
     else
       textprintf(buffer,font,0,16,makecol(255,255,255),"Mode: %s",mode_temp);

      

      c_layer * layer;
      for (i=0;i<map->countLayers();i++)
      {
      	layer = map->getLayerPointer(i);
      	if (layer)
      	{
            textprintf(buffer,font,0,24+i*8,makecol(255,255,255),"Layer[%d] size: %dX%d",i,layer->getSize(SIZE_WIDTH),layer->getSize(SIZE_HEIGHT));
             
        }
        else
        {
            textprintf(buffer,font,0,16+i*8,makecol(255,255,255),"Layer[%d] ERROR",i);
                
        }
      }
     
      draw_objects(buffer);

	  if (key[KEY_M])
	  {
		int layer_count=map->countLayers();
		int left, top, down,right;
		left=top=down=right=0;
                for (i=0;i<layer_count;i++)
		{
			c_layer * layer_pointer =  map->getLayerPointer(i);
			int layer_left=layer_pointer->getX();
			int layer_top=layer_pointer->getY();
			int layer_right=layer_left+layer_pointer->getSize(SIZE_WIDTH)*layer_pointer->gridx();
			int layer_down=layer_top+layer_pointer->getSize(SIZE_HEIGHT)*layer_pointer->gridy();
			if (layer_left<left) left=layer_left;
			if (layer_top<top) top=layer_top;
			if (layer_right>right) right=layer_right;
			if (layer_down>down) down=layer_down;
		}
		BITMAP * temp_bmp=create_bitmap(right-left,down-top);
		
		for (i=0;i<layer_count;i++)
		{
			c_layer * layer_pointer =  map->getLayerPointer(i);
			layer_pointer->draw(temp_bmp,left,top);
		}
		double x_multi=double(BUFFER_W)/double(right-left);
		double y_multi=double(BUFFER_H)/double(down-top);
		double multi;
		if (x_multi>y_multi) multi=y_multi;
		else multi=x_multi;
		clear(buffer);
		stretch_blit(temp_bmp,buffer,0,0,temp_bmp->w,temp_bmp->h,0,0,int((double)temp_bmp->w*multi),int((double)temp_bmp->h*multi));
		destroy_bitmap(temp_bmp);
	  }
	  if (key[KEY_E]) tmenu.sel2=-1;
}			


void draw_tile_menu()
{
    int i;
    rectfill(buffer,tmenu.x1,tmenu.y1,tmenu.x2,tmenu.y2,makecol(5,5,5));
    rect(buffer,tmenu.x1,tmenu.y1,tmenu.x2,tmenu.y2,makecol(0,255,255));

    line(buffer,tmenu.x1,tmenu.y2-34,tmenu.x2,tmenu.y2-34,makecol(0,255,255));
    line(buffer,tmenu.x1,tmenu.y1+10,tmenu.x2,tmenu.y1+10,makecol(0,255,255));
    line(buffer,tmenu.x1,tmenu.y2-46,tmenu.x2,tmenu.y2-46,makecol(0,255,255));

    triangle(buffer,tmenu.x1+35,tmenu.y1+2,tmenu.x1+29,tmenu.y1+8,tmenu.x1+41,tmenu.y1+8,makecol(255,0,0));
    triangle(buffer,tmenu.x1+29,tmenu.y2-45+2,tmenu.x1+35,tmenu.y2-45+8,tmenu.x1+41,tmenu.y2-45+2,makecol(255,0,0));


    int x,y;
    x=y=0;
    BITMAP * tmenuback = create_bitmap(tmenu.x2-(tmenu.x1+3),tmenu.y2-46-(tmenu.y1+11));

    if (!tmenuback) {
      set_gfx_mode(GFX_TEXT,0,0,0,0);
      allegro_message("Tmenuback error\n");
      exit (25);
    }

    clear_to_color(tmenuback,makecol(5,5,5));
    BITMAP *temp=NULL;

    for (i=0;i<Tiles.get_count();i++)
    {
        temp = (BITMAP *)Tiles.get_tiles()[i].dat;
        if(Tiles.get_tiles()[i].type!=DAT_BITMAP) {
          if(Tiles.get_tiles()[i].type!=DAT_FILE)
            break;
          if(((DATAFILE *)Tiles.get_tiles()[i].dat)[0].type!=DAT_BITMAP)
            break;
          temp = (BITMAP *)((DATAFILE *)Tiles.get_tiles()[i].dat)[0].dat;

        }
	if(y*34-tmenu.scrolled+3+temp->h>=0) {
	  if(y*34-tmenu.scrolled+3>tmenuback->h) break;
      stretch_blit(temp,tmenuback,0,0,temp->w,temp->h,x*34,y*34-int(tmenu.scrolled)+3,32,32);
      if(key[KEY_N]) textprintf(tmenuback,font,x*34,y*34-int(tmenu.scrolled)+3,makecol(255,255,255),"%d",i);
	}
	x++;
	if (x*34>=tmenuback->w)
	{
		x=0;
		y++;
	}
    }
    if (tmenu.sel1>=0)
    {

        temp = (BITMAP *)Tiles.get_tiles()[tmenu.sel1].dat;
        if(Tiles.get_tiles()[tmenu.sel1].type==DAT_FILE) 
          temp = (BITMAP *)((DATAFILE *)Tiles.get_tiles()[tmenu.sel1].dat)[0].dat;
        
    	stretch_blit(temp,buffer,0,0,temp->w,temp->h,tmenu.x1+2,tmenu.y2-33,32,32);
    }
    if (tmenu.sel2>=0)
    {
        temp = (BITMAP *)Tiles.get_tiles()[tmenu.sel2].dat;
        if(Tiles.get_tiles()[tmenu.sel2].type==DAT_FILE) 
          temp = (BITMAP *)((DATAFILE *)Tiles.get_tiles()[tmenu.sel2].dat)[0].dat;
     	stretch_blit(temp,buffer,0,0,temp->w,temp->h,tmenu.x1+36,tmenu.y2-33,32,32);
    }

    blit (tmenuback,buffer,0,0,tmenu.x1+2,tmenu.y1+11,tmenuback->w,tmenuback->h);

    destroy_bitmap(tmenuback);

}


static int col,mo,ox,oy;

void draw_mouse(BITMAP *b)
{
    mo=TRUE;
    ox=mouse_x;
    oy=mouse_y;
    xor_mode(TRUE);
    if (mode==1) col=makecol(255,255,255);
    if (mode==2 || mode==6) col=makecol(0,255,0);
    if (mode==3 || mode==4 || mode==7)col=makecol(255,255,0);
	if (mode==5 || mode==8 || (mode==1 && key_shifts & KB_CTRL_FLAG)) col=makecol(255,0,0);

    hline(b,ox-5,oy,ox+5,col);
    vline(b,ox,oy-5,oy-1,col);
    vline(b,ox,oy+1,oy+5,col);

    solid_mode();
}

void remove_mouse(BITMAP *b)
{
    if(mo==FALSE) return;
    mo=FALSE;
    xor_mode(TRUE);
    hline(b,ox-5,oy,ox+5,col);
    vline(b,ox,oy-5,oy-1,col);
    vline(b,ox,oy+1,oy+5,col);

    solid_mode();
}


void check_mouse()
{
	//check tile-menu

	if (mouse_b &1 || mouse_b &2)
	{
	    if (mouse_x>tmenu.x1 && mouse_x<tmenu.x2 && mouse_y> tmenu.y1 && mouse_y< tmenu.y1+10)
	    {
               if (int(tmenu.scrolled)>0)
	       {
		  tmenu.scrolling=SCROLL_UP;
                  if (int(tmenu.scrolled) %34 ==0) tmenu.scrolled+=tmenu.scrolling;
	       }
	    }
	    if (mouse_x>tmenu.x1 && mouse_x<tmenu.x2 && mouse_y> tmenu.y2-45 && mouse_y< tmenu.y2-35 && mouse_b &1)
	    {
           int tcount = (int)(Tiles.get_count()/int((tmenu.x2-tmenu.x1)/32))+(int)(bool)(Tiles.get_count()%int((tmenu.x2-tmenu.x1)/32));
	       if (tmenu.y1+11+tcount*34-tmenu.scrolled>tmenu.y2-45)
	       {
		  tmenu.scrolling=SCROLL_DOWN;
                  if (int(tmenu.scrolled) %34 ==0) tmenu.scrolled+=tmenu.scrolling;
	       }
	    }
	    if (mouse_x>tmenu.x1 && mouse_x<tmenu.x2 && mouse_y> tmenu.y1+11 && mouse_y< tmenu.y2-46)
	    {
	       int ver = mouse_y-(tmenu.y1+11);
	       int hor = mouse_x-tmenu.x1;
               ver+=int(tmenu.scrolled);
	       ver /=34;
	       hor /=34;
	       int tnumber=ver *int((tmenu.x2-tmenu.x1)/32)+hor;
               if (tnumber >=0 && tnumber< Tiles.get_count())
	       {
		 if (mouse_b &1) tmenu.sel1=tnumber;
		 if (mouse_b &2) tmenu.sel2=tnumber;
	       } 
	    }
	    if (mouse_x<tmenu.x1 && mouse_y< SCREEN_W)
	    {
             if (mode==1)
             {

	      int hor,ver;
	      hor=ver=0;
	      c_layer * cur_layer = map->getLayerPointer(current_layer);
	      if (cur_layer)
	      {
		hor=(mouse_x+map->getX()-cur_layer->getX())/cur_layer->gridx();
		ver=(mouse_y+map->getY()-cur_layer->getY())/cur_layer->gridy();

		if (key_shifts & KB_CTRL_FLAG) cur_layer->setPic(hor,ver,-1);
                else if (key_shifts & KB_ALT_FLAG) setTileOptions(hor,ver);
                else if (mouse_b & 1) cur_layer->setPic(hor,ver,tmenu.sel1);
		else if (mouse_b & 2) cur_layer->setPic(hor,ver,tmenu.sel2);
			      }
             }
             if (mode==2)
              {
                int mx=mouse_x+map->getX();
                int my=mouse_y+map->getY();

              	if (!mouse_down)
                {

                	active=map->addTrigger(mx,my,mx,my,0,0,NULL);
                    mouse_down=TRUE;
                    fx=mx;
                    fy=my;
                    map->active_trigger=active;
                }
                if (mouse_down)
                {
                	map->setTriggerPoint(active,1,mx,my);
                }
              }
              if (mode==3)
              {
              	if (!mouse_down)
                {
                	int numbertemp,parttemp;
                    map->whatTrigger(mouse_x+map->getX(),mouse_y+map->getY(),&numbertemp,&parttemp);
                    if(parttemp&4) parttemp=2;
                    else if(parttemp&2) parttemp=1;
                    else if(parttemp&1) parttemp=0;
                    else parttemp=-1;
                	map->active_trigger=numbertemp;
                    map->active_trigger_part=parttemp;
                    mouse_down=TRUE;
                    if (parttemp>0)
                        map->setTriggerPoint(numbertemp,parttemp-1,mouse_x+map->getX(),mouse_y+map->getY());

                }
                if (mouse_down)
                {
                    if (map->active_trigger_part>0)
                    	{
                                map->setTriggerPoint(map->active_trigger,map->active_trigger_part-1,mouse_x+map->getX(),mouse_y+map->getY());
                        }
                }

              }
              if (mode==4)
              {
              	EditTrigger();
              }
              if (mode==5)
              {
	          	DeleteTrigger();
              }
              if (mode==6)
              {
              	if (!mouse_down)
                {
                	int numbertemp;
                    map->whatEntry(mouse_x+map->getX(),mouse_y+map->getY(),&numbertemp);
                    if (numbertemp==-1)
                    {
                    	map->active_entry = map->addEntry(mouse_x+map->getX(),mouse_y+map->getY(),-1,0,0);
                        InsertEntry();
                    }
                    else
                    {
                    	map->active_entry=numbertemp;
                        mouse_down=TRUE;
                    }
                }
                if (mouse_down)
                {
                	map->setEntryPoint(map->active_entry,mouse_x+map->getX(),mouse_y+map->getY());
                }
              }
              if (mode==7)
              {
              	EditEntry();
                map->active_entry=-1;
              }
              if (mode==8)
              {
              	DeleteEntry();
	      }
	      if (mode==9)
	      {
		InsertWalk();
	      }
	      if (mode==10)
	      {
		if (!mouse_down)
		  mouse_down=TRUE;
		if (mouse_down)
		{
		  if (current_walk>=0)
			map->points->move(current_walk,mouse_x+map->getX(),mouse_y+map->getY());
		}
	      }
	      if (mode==11) 
	      {
		EditWalk();
	      }
	      if (mode==12)
	      {
		RemoveWalk();
	      }
	      if (mode==13)
	      {
		if(!mouse_down)
		{
		  if (mouse_b & 1) InsertPath();
		  if (mouse_b & 2) prev_point=-1;
		  mouse_down=true;
		}
	      }
              if(mode==14) 
	      {
		InsertNpc();
	      }
              if(mode==15) 
	      {
		if(!mouse_down) 
		  mouse_down=TRUE;
		if(mouse_down) {
		  map->moveNpc(map->active_npc,mouse_x+map->getX(),mouse_y+map->getY());
		}
	      }
              if(mode==16) 
	      {
		DeleteNpc();
	      }
              if(mode==17) 
	      {
		EditNpcOptions();
	      }
	      if(mode==18)
	      {
		EditNpcScript();
	      }

	  }
       }
       else
       {
       	  if (mode==2)
       	  {
       	  	if (mouse_down)
          	{
          		mouse_down=FALSE;
            	InsertTrigger();
          	}
          }
          if (mode>=3 && mode <=5)
          {
          	if (!mouse_down)
            {
            	int numbertemp,parttemp;
                map->whatTrigger(mouse_x+map->getX(),mouse_y+map->getY(),&numbertemp,&parttemp);
                if(parttemp&4) parttemp=2;
                else if(parttemp&2) parttemp=1;
                else if(parttemp&1) parttemp=0;
                else parttemp=-1;
                
            	map->active_trigger=numbertemp;
                if (mode==3) map->active_trigger_part=parttemp;
                else map->active_trigger_part=-1;
                //if (numbertemp!=-1) exit (numbertemp);
            }
            if (mouse_down)
            {
            	mouse_down=FALSE;
            }
          }
          if (mode>=6 && mode<=8)
          {
           	int numbertemp;
            map->whatEntry(mouse_x+map->getX(),mouse_y+map->getY(),&numbertemp);
            map->active_entry=numbertemp;
            mouse_down=FALSE;
          }
	  if (mode>=10 && mode <=13)
	  {
		if (!mouse_down)
		{
			current_walk=map->points->what_point(mouse_x+map->getX(),mouse_y+map->getY());
			map->points->active_point=current_walk;
		}
		if (mouse_down)
		{
			mouse_down=FALSE;
	//	  if (mode==12) delete_walk();
		}
	  }
          if(mode>=14&&mode<=18)
	  {
            if(!mouse_down) 
            {
		map->active_npc=map->whatNpc(mouse_x+map->getX(),mouse_y+map->getY());
		if(mode==15||mode==14)
		  map->active_npc_part=0;
		if(mode==16)
		  map->active_npc_part=2;
		if(mode==17)
		  map->active_npc_part=-1;
		if(mode==18)
		  map->active_npc_part=1;

            }
            if(mouse_down)
	      mouse_down=FALSE;
	  }

       }

}


void update_menu()
{
    tmenu.scrolled +=tmenu.scrolling;
    if (int(tmenu.scrolled) %34 ==0) tmenu.scrolling=NO_SCROLL;
}
