// This code is LGPL...
#include <math.h>
#include <stdio.h>
#include <string.h>
#include <allegro.h>
#include "alleg.h"
#ifdef USE_FBLEND
#include <fblend.h>
#endif
#include "gfx_diag.h"
#include "helper.h"
#include "func.h"
#include "points.h"
#include "npc.h"
#include "tile.h"
#include "layer.h"
#include "map.h"
#include "menu.h"
#include "dummy.h"
#include "func.h"
#include "npc.h"

#define MAX_KEY_DELAY 30

extern mob_list *mobs;
extern c_map *world;
int dtext_show=FALSE;

int dselect_active_id=-1;
int dselect_show=FALSE;


dialog_object *dialogs=NULL;
dialog_object *dialog_list[400];// a list of pointers to dialog_objects


int question_fit(int x,int y,char *name, char *question,char *answers,int speed,int position)
{ 

    if (speed==0) speed=16;
    int width, height,frame_width,frame_height;
    int quest_h, answer_h, answer_l;
	char * total= new char[1028];
    total[0]=0;
    if (strlen(name)>0)
    {
      	strcat(total,"^g");
        strcat(total,name);
        strcat(total,": ^w");
    }
    strcat(total,question);
    strcat(total,"^f^f");
    quest_h=get_text_height(total);
   
    strcat(total,answers);
    
    answer_h=get_text_height(total)-quest_h;
    answer_l=answer_h/font_height();
    
    width=get_text_width(total);
    height=get_text_height(total);
    frame_width=2*10; //is this correct?
    frame_height=2*10; //is this also correct?
    int f,f_w,f_h;
	f_w=frame_width+width;
	f_h=frame_height+height;
	if (position>=0) 
	{
		mobs->disable_mobs(1);
		int npc_x=mobs->get_npc_var(position,"x")-world->getX();
		int npc_y=mobs->get_npc_var(position,"y")-world->getY();
		int f_x=npc_x-int(.5*(width+frame_width))+x;
		int f_y=npc_y-(height+frame_height)+y;
		if (f_x<0) f_x=0;
		if (f_y<0) f_y=0;
		if ((f_x+f_w)>BUFFER_W) f_x=BUFFER_W-f_w;
		if ((f_y+f_h)>BUFFER_H) f_y=BUFFER_H-f_h;
		f= create_frame(-1,f_x,f_y,f_w,f_h);
    
	}
	else f= create_frame(-1,x,y,width+frame_width,height+frame_height);
	//f= create_frame(-1,x,y,width+frame_width,height+frame_height);

    int t= create_text(f,0,0,width,0,total,0);
    
    int menu= create_select_list(f,0,quest_h,0,font_height(),answer_l,0,font_height());
    int s,s2;
    
    
    open_frame(f,speed);
    wait_for_animation(f);
    wait_for_text_scroll(t);
    
    set_active_select(menu);
    
    int number=get_active_select()-menu+1;
    
    int ret=-1;
    while(ret!=4&&ret!=5) {
      ret=get_input();
      
      s=get_active_select();

      if(s!=-1) {
        if(ret==0) s2=up_select(s);
        else if(ret==1) s2=down_select(s);
        else s2=-1;

        if(s2!=-1) set_active_select(s2);
      }

      number = get_active_select()-menu+1;

    }
    close_frame(f,speed);
    wait_for_animation(f);
    destroy_dialog_object(f);
    
    delete [] total;
	if (position>=0) mobs->disable_mobs(0);
	return number;



}


//postition is not used yet, maybe for auto-position on NPC's later
//int dialog_fit(x,y,name,text,speed=16,position=0)
int dialog_fit(int x,int y,char * name,char *text,int speed,int position)
{
	if (speed==0) speed=16;
    int width, height,frame_width,frame_height;
	char * total= new char[strlen(name)+strlen(text) +8];
    total[0]=0;
    if (strlen(name)>0)
    {
      	strcat(total,"^g");
        strcat(total,name);
        strcat(total,": ^w");
    }
    strcat(total,text);
    width=get_text_width(total);
    height=get_text_height(total);
    frame_width=2*10; //is this correct?
    frame_height=2*10; //is this also correct?
    int f,f_w,f_h;
	f_w=frame_width+width;
	f_h=frame_height+height;
	if (position>=0) 
	{
		//mobs->set_npc_var(position,"disabled",1);
		mobs->disable_mobs(1);
		int npc_x=mobs->get_npc_var(position,"x")-world->getX();
		int npc_y=mobs->get_npc_var(position,"y")-world->getY();
		int f_x=npc_x-int(.5*(width+frame_width))+x;
		int f_y=npc_y-(height+frame_height)+y;
		if (f_x<0) f_x=0;
		if (f_y<0) f_y=0;
		if ((f_x+f_w)>BUFFER_W) f_x=BUFFER_W-f_w;
		if ((f_y+f_h)>BUFFER_H) f_y=BUFFER_H-f_h;
		f= create_frame(-1,f_x,f_y,f_w,f_h);
    
	}
	else f= create_frame(-1,x,y,width+frame_width,height+frame_height);
	//f= create_frame(-1,x,y,width+frame_width,height+frame_height);

    int t= create_text(f,0,0,width,0,total,0);
    open_frame(f,speed);
    wait_for_animation(f);
    wait_for_text_scroll(t);
    int ret=-1;
    while(ret!=4) ret=get_input();
    close_frame(f,speed);
    wait_for_animation(f);
    destroy_dialog_object(f);
	//if (position>=0) mobs->set_npc_var(position,"disabled",0);
	if (position>=0) mobs->disable_mobs(0); 
	return 0;
}


int dialog_object::total_objects=0;
int text_speed=5; // the average text scroll speed (this should be a variable)

void draw_child(BITMAP *bmp,dialog_object *parent,dialog_object *child);

void draw_frame(BITMAP *bmp,dialog_object *d)
{
  BITMAP *temp;
  int w,h;

  if(d->type!=DIAG_FRAME) return;

  if(d->data.diag_frame.opened<0) return;

  if(current_frame==NULL) return;

  if(d->data.diag_frame.pict_type!=cf_type) {
 
    if(d->data.diag_frame.pict)
      destroy_bitmap(d->data.diag_frame.pict);
    
    d->data.diag_frame.pict_type=cf_type;
    
    for(w=1;w<d->w;w<<=1);
    for(h=1;h<d->h;h<<=1);
    
    d->data.diag_frame.pict=create_bitmap(w,h);
    
    temp = d->data.diag_frame.pict;
        
    if(!temp) {
      set_gfx_mode(GFX_TEXT,0,0,0,0);
      allegro_message("Frame %d: Can't create_bitmap(%d,%d) in %s on line %d",d->id,d->w,d->h,__FILE__,__LINE__);
      allegro_exit();
      exit(1);
    }
    rectfill(temp,0,0,d->w,d->h,makecol(0,0,0));
    rectfill(temp,d->w,0,w,d->h,bitmap_mask_color(temp));
    rectfill(temp,0,d->h,w,h,bitmap_mask_color(temp));

    stretch_blit(current_frame->left,temp,
               0,0,current_frame->left->w,current_frame->left->h,
               0,0,current_frame->left->w,d->h);
    stretch_blit(current_frame->top,temp,
               0,0,current_frame->top->w,current_frame->top->h,
               0,0,d->w,current_frame->top->h);
    stretch_blit(current_frame->bottom,temp,
               0,0,current_frame->bottom->w,current_frame->bottom->h,
               0,d->h-current_frame->bottom->h,d->w,current_frame->bottom->h);
    stretch_blit(current_frame->right,temp,
               0,0,current_frame->right->w,current_frame->right->h,
               d->w-current_frame->right->w,0,current_frame->right->w,d->h);
    blit(current_frame->top_left,temp,0,0,
       0,0,
       current_frame->top_left->w,current_frame->top_left->h);
    blit(current_frame->top_right,temp,0,0,
       d->w-current_frame->top_right->w,0,
       current_frame->top_right->w,current_frame->top_right->h);
    blit(current_frame->bottom_left,temp,0,0,
       0,d->h-current_frame->bottom_left->h,
       current_frame->bottom_left->w,current_frame->bottom_left->h);
    blit(current_frame->bottom_right,temp,0,0,
       d->w-current_frame->bottom_right->w,d->h-current_frame->bottom_right->h,
       current_frame->bottom_right->w,current_frame->bottom_right->h);
    do_gradient_fill(temp,d->w/2,d->h/2,0,0,d->w,d->h,current_frame->c1,current_frame->c2,current_frame->slope);
    d->data.diag_frame.pict=temp;
  }
  temp=d->data.diag_frame.pict;
  if(temp==NULL) {
    set_gfx_mode(GFX_TEXT,0,0,0,0);
    allegro_message("Error can't find frame!");
    allegro_exit();
    exit(1);
  }
  if(d->data.diag_frame.opened==0) return;

  if(d->data.diag_frame.opened<255) {
	  /*#ifdef USE_FBLEND
      if(bitmap_mask_color(bmp)>8) {
        fblend_trans(temp,bmp,d->x+d->real_x,d->y+d->real_y,d->data.diag_frame.opened>>1);
	  } 
	  else {
	  #endif*/
        h=(d->h*d->data.diag_frame.opened)/256;
        stretch_sprite(bmp,temp,d->x+d->real_x,d->y+d->real_y+((d->h-h)>>1),temp->w,h);
	  /*#ifdef USE_FBLEND
      }
	  #endif*/
      
  }
  else {
    /*#ifdef USE_FBLEND
    if(bitmap_mask_color(bmp)>8) {
      fblend_trans(temp,bmp,d->x+d->real_x,d->y+d->real_y,128);
	} else {
    #endif*/
    draw_sprite(bmp,temp,d->x+d->real_x,d->y+d->real_y);
    /*#ifdef USE_FBLEND
	}
    #endif*/
    if(d->data.diag_frame.child)
      draw_child(bmp,d,d->data.diag_frame.child);
    BITMAP *p;
    if(d->data.diag_frame.uarrow) {
      p=(BITMAP *)current_frame->dat[dia_pijlup].dat;
      draw_sprite(bmp,p,d->x+d->real_x+(d->w-p->w)/2,d->y+d->real_y);
    }
    if(d->data.diag_frame.darrow) {
      p=(BITMAP *)current_frame->dat[dia_pijldown].dat;
      draw_sprite(bmp,p,d->x+d->real_x+(d->w-p->w)/2,d->y+d->real_y+d->h-p->h);
    }
      
  }

  

}

void draw_text(BITMAP *bmp,dialog_object *d)
{
  if(d->type!=DIAG_TEXT) return;

  display_text(bmp,d->x+d->real_x,d->y+d->real_y,d->w,d->data.diag_text.text,d->data.diag_text.drawn);

  if(d->data.diag_text.drawn==-1&&d->data.diag_text.more==1&&dtext_show) {
    BITMAP *p=(BITMAP *)current_frame->dat[dia_pijldown].dat;
    draw_sprite(bmp,p,d->x+d->real_x+d->w-p->w-1,d->y+d->real_y+d->h-p->h-1);
  }
}
void draw_slider(BITMAP *bmp,dialog_object *d)
{
  if(d->type!=DIAG_SLIDER) return;

  if(d->data.diag_slider.type==0) {
    BITMAP *sl=(BITMAP *)current_frame->dat[slider_left].dat;
    BITMAP *sm=(BITMAP *)current_frame->dat[slider_middle].dat;
    BITMAP *sr=(BITMAP *)current_frame->dat[slider_right].dat;
    BITMAP *st=(BITMAP *)current_frame->dat[slider_control].dat;
    
    masked_stretch_blit(sm,bmp,0,0,sm->w,sm->h,d->x+d->real_x,d->y+d->real_y+1,d->w,sm->h);
    masked_blit(sl,bmp,0,0,d->x+d->real_x,d->y+d->real_y,sl->w,sl->h);
    masked_blit(sr,bmp,0,0,d->x+d->real_x+d->w-sr->w,d->y+d->real_y,sr->w,sr->h);
    int w=((d->data.diag_slider.current_value-d->data.diag_slider.min_value)*(d->w-2-st->w))/d->data.diag_slider.max_value+1;
    
    masked_blit(st,bmp,0,0,d->x+d->real_x+w,d->y+d->real_y-(st->h>>2),st->w,st->h);
  }
  if(d->data.diag_slider.type==1) {
    BITMAP *sl=(BITMAP *)current_frame->dat[progress_left].dat;
    BITMAP *sm=(BITMAP *)current_frame->dat[progress_middle].dat;
    BITMAP *sr=(BITMAP *)current_frame->dat[progress_right].dat;
    
    masked_stretch_blit(sm,bmp,0,0,sm->w,sm->h,d->x+d->real_x,d->y+d->real_y,d->w,sm->h);
    masked_blit(sl,bmp,0,0,d->x+d->real_x,d->y+d->real_y,sl->w,sl->h);
    masked_blit(sr,bmp,0,0,d->x+d->real_x+d->w-sr->w,d->y+d->real_y,sr->w,sr->h);
    int w=((d->data.diag_slider.current_value-d->data.diag_slider.min_value-1)*(d->w-2))/d->data.diag_slider.max_value+1;
    progress_bar(bmp,d->x+d->real_x+2,d->y+d->real_y+2,w,d->w-2,2,d->data.diag_slider.c1,d->data.diag_slider.c2);

  }
}

void draw_select(BITMAP *bmp,dialog_object *d)
{
  if(d->type!=DIAG_SELECT) return;
  BITMAP *p=(BITMAP *)current_frame->dat[dia_pijl].dat;
  
  if(dselect_active_id==d->id)
    draw_sprite(bmp,p,d->x+d->real_x,d->y+d->real_y+((d->data.diag_select.top_y+d->data.diag_select.bottom_y-p->h)>>1)+1);
  if(d->data.diag_select.blink&&dselect_show)
    draw_sprite(bmp,p,d->x+d->real_x-1,d->y+d->real_y+((d->data.diag_select.top_y+d->data.diag_select.bottom_y-p->h)>>1)+1-2); 
// the (-1,-2) on blink is so both blink and active can be set at the same time
}

void draw_picture(BITMAP *bmp,dialog_object *d)
{
  if(d->type!=DIAG_PICTURE) return;
  if(d->data.diag_picture.overide==1) set_clip(bmp,0,0,bmp->w,bmp->h);
  if(d->data.diag_picture.pict!=NULL)
    draw_sprite(bmp,d->data.diag_picture.pict,d->x+d->real_x,d->y+d->real_y);
}
// calling draw_objects(bmp); will draw all objects to the screen :)
void draw_objects(BITMAP *bmp)
{
//  dialog_object *tmp;
//  tmp=dialogs;
//  while(tmp) {
    if(dialogs)
      draw_child(bmp,NULL,dialogs);
//    tmp=tmp->next;
//  }

}
// this will update the object logic

int update_objects(dialog_object *d,int obj,int boost_speed)
{
  char *c;
  static int tick=0;
  static int animate=0;

  
  if(d==NULL) return animate;

///  if(d->id==obj) animate=0;

  if(d==dialogs) { 
    tick++;
    animate=0;
    if(tick>30) {  // do this only once per update!
      tick=0;
      dselect_show=!dselect_show;
      dtext_show=!dtext_show;
    }
  }
  
  update_objects(d->next,obj,boost_speed);

  if(d->x!=d->x2) {
    if(obj==-1||d->id==obj) animate=1;
    if(d->x<d->x2-d->speed) d->x+=d->speed*boost_speed;
    else if(d->x>d->x2+d->speed) d->x-=d->speed*boost_speed;
    else d->x=d->x2;
  }

  if(d->y!=d->y2) {
    if(obj==-1||d->id==obj) animate=1;
    if(d->y<d->y2-d->speed) d->y+=d->speed*boost_speed;
    else if(d->y>d->y2+d->speed) d->y-=d->speed*boost_speed;
    else d->y=d->y2;
  }

  if(d->w!=d->w2) {
    if(obj==-1||d->id==obj) animate=1;
    if(d->w<d->w2-d->speed) d->w+=d->speed*boost_speed;
    else if(d->w>d->w2+d->speed) d->w-=d->speed*boost_speed;
    else d->w=d->w2;
  }
  
  if(d->h!=d->h2) {
    if(obj==-1||d->id==obj) animate=1;
    if(d->h<d->h2-d->speed) d->h+=d->speed*boost_speed;
    else if(d->h>d->h2+d->speed) d->h-=d->speed*boost_speed;
    else d->h=d->h2;
  }

  switch(d->type) {
    case DIAG_FRAME:
      if(d->data.diag_frame.opened!=d->data.diag_frame.opened2) {
        if(obj==-1||d->id==obj) animate=1;
        if(d->data.diag_frame.opened>d->data.diag_frame.opened2+d->speed*boost_speed) d->data.diag_frame.opened-=d->speed*boost_speed;
        else if(d->data.diag_frame.opened<d->data.diag_frame.opened2-d->speed*boost_speed) d->data.diag_frame.opened+=d->speed*boost_speed;
        else d->data.diag_frame.opened=d->data.diag_frame.opened2;
      }
      if(d->data.diag_frame.scroll_y!=d->data.diag_frame.scroll_y2) {
        if(obj==-1||d->id==obj) animate=1;
        if(d->data.diag_frame.scroll_y>d->data.diag_frame.scroll_y2+d->speed*boost_speed) d->data.diag_frame.scroll_y-=d->speed*boost_speed;
        else if(d->data.diag_frame.scroll_y<d->data.diag_frame.scroll_y2-d->speed*boost_speed) d->data.diag_frame.scroll_y+=d->speed*boost_speed;
        else d->data.diag_frame.scroll_y=d->data.diag_frame.scroll_y2;
      }

      d->data.diag_frame.uarrow=FALSE; //assume FALSE
      d->data.diag_frame.darrow=FALSE; //assume FALSE
      if(d->data.diag_frame.opened>=256&&d->data.diag_frame.child!=NULL) {
        update_objects(d->data.diag_frame.child,obj,boost_speed);
       // if(d->data.diag_frame.scroll_y>0) d->data.diag_frame.uarrow=TRUE;
        dialog_object *tmp=d->data.diag_frame.child;

        while(tmp!=NULL) {
          if(tmp->type==DIAG_SELECT&&
            tmp->y+tmp->data.diag_select.bottom_y-d->data.diag_frame.scroll_y>d->h-20
          )
            d->data.diag_frame.darrow=TRUE;

          if(tmp->type==DIAG_SELECT&&
            tmp->y+tmp->data.diag_select.top_y-d->data.diag_frame.scroll_y<0
          )
            d->data.diag_frame.uarrow=TRUE;

          tmp=tmp->next;
        }

      }

      break;
    case DIAG_TEXT:  
      if(d->data.diag_text.drawn==-1) 
        break;
      d->data.diag_text.progress--;
      while(d->data.diag_text.drawn!=-1&&d->data.diag_text.progress<0) {
        c=&d->data.diag_text.text[++d->data.diag_text.drawn];
        while(c&&*c=='^') {
          c=&d->data.diag_text.text[++d->data.diag_text.drawn];
          if(c&&*c!='^') {
            if(*c=='s'&&d->data.diag_text.speed>text_speed-20) {
              d->data.diag_text.speed-=5;
              d->data.diag_text.progress=-1;
            }
            if(*c=='f'&&d->data.diag_text.speed<text_speed+20) {
              d->data.diag_text.speed+=5;
              d->data.diag_text.progress=-1;
            }
            if(*c=='m') {
              d->data.diag_text.speed=text_speed;
              d->data.diag_text.progress=-1;           
            }
            c=&d->data.diag_text.text[++d->data.diag_text.drawn];
          }
          else break;
        }
        if(!c||d->data.diag_text.drawn>(int)strlen(d->data.diag_text.text)) d->data.diag_text.drawn=-1;
        d->data.diag_text.progress+=8-d->data.diag_text.speed;

      }
      if(d->data.diag_text.drawn==-1)
        d->data.diag_text.progress=0;
      
      break;
    case DIAG_SLIDER: 
      if(d->data.diag_slider.current_value!=d->data.diag_slider.current_value2) {
        if(obj==-1||d->id==obj) animate=1;
        if(d->data.diag_slider.current_value>d->data.diag_slider.current_value2+d->speed*boost_speed) d->data.diag_slider.current_value-=d->speed*boost_speed;
        else if(d->data.diag_slider.current_value<d->data.diag_slider.current_value2-d->speed*boost_speed) d->data.diag_slider.current_value+=d->speed*boost_speed;
        else d->data.diag_slider.current_value=d->data.diag_slider.current_value2;
      }
      break;
    case DIAG_SELECT: break;
    case DIAG_PICTURE: break;
  }

  return animate;
}
void draw_child(BITMAP *bmp,dialog_object *parent,dialog_object *child)
{
  if(child==NULL) return;
  draw_child(bmp,parent,child->next);
  int cl1=0,cl2=0,cr1=0,cr2=0,ct1=0,ct2=0,cb1=0,cb2=0;
  if(parent&&parent->type==DIAG_FRAME) { 
    int w1=10;
    int w2=10;
    int h1=10;
    int h2=10;
    cl1=bmp->cl;
    cl2=parent->x+parent->real_x+w1;
    cr1=bmp->cr;
    cr2=parent->x+parent->real_x+parent->w-w2;
    ct1=bmp->ct;
    ct2=parent->y+parent->real_y+h1;
    cb1=bmp->cb;
    cb2=parent->y+parent->real_y+parent->h-h2;
    set_clip(bmp,MAX(cl1,cl2),MAX(ct1,ct2),
                 MIN(cr1,cr2),MIN(cb1,cb2));

  
    child->real_x=parent->x+parent->real_x+w1;
    child->real_y=parent->y+parent->real_y+h1-parent->data.diag_frame.scroll_y;
  }
  else {
    child->real_x=0;
    child->real_y=0;
  }
  switch(child->type) {
    case DIAG_FRAME: draw_frame(bmp,child);break;
    case DIAG_TEXT: draw_text(bmp,child); break;
    case DIAG_SLIDER: draw_slider(bmp,child); break;
    case DIAG_SELECT: draw_select(bmp,child); break;
    case DIAG_PICTURE: draw_picture(bmp,child); break;
  }

  if(parent&&parent->type==DIAG_FRAME)
    set_clip(bmp,cl1,ct1,cr1,cb1);
}

int create_picture(int parent,int x,int y,char *filename,int ovr)
{
  dialog_object *d=new dialog_object;
  
  d->id=dialog_object::total_objects++;
  dialog_list[d->id]=d;
  d->real_x=0;
  d->real_y=0;
  d->x=x;
  d->y=y;
  d->speed=1;
  
  d->type=DIAG_PICTURE;
  d->data.diag_picture.overide=ovr;
  
  if(filename[0]=='#') {
     filename++;
     DATAFILE *tmp;
     if(!exists("figure.dat")) 
       d->data.diag_picture.pict=NULL;  
     else {
	   set_pass();
       tmp=load_datafile_object("figure.dat",filename);
        packfile_password(NULL);
       if(tmp) {
         d->data.diag_picture.pict=(BITMAP *)tmp->dat;
         tmp->dat=NULL;
         unload_datafile_object(tmp);           
       }
       else d->data.diag_picture.pict=NULL;
     }
  }
  else if(exists(filename)) 
    d->data.diag_picture.pict=load_bitmap(filename,NULL);
  else 
    d->data.diag_picture.pict=NULL;   

  d->w=d->data.diag_picture.pict->w;
  d->h=d->data.diag_picture.pict->h;
  
  d->x2=d->x;
  d->y2=d->y;
  d->w2=d->w;
  d->h2=d->h;

  if(parent<0||parent>=dialog_object::total_objects-1) {
    d->next=dialogs;
    dialogs=d;    
    d->parent=-1;
  }
  else {
    dialog_object *t=dialog_list[parent];
    if(t->type!=DIAG_FRAME) {
      d->next=dialogs;
      dialogs=d;
      d->parent=-1;
    }
    else {
      d->next=t->data.diag_frame.child;
      t->data.diag_frame.child=d;
      d->parent=parent;
    }
  }
  
  return d->id;
}

int create_select(int parent,int x,int y,int top_y,int bottom_y)
{
  dialog_object *d=new dialog_object;
  
  d->id=dialog_object::total_objects++;
  dialog_list[d->id]=d;
  d->real_x=0;
  d->real_y=0;
  d->x=x;
  d->y=y;

  d->type=DIAG_SELECT;

  d->data.diag_select.top_y=top_y;
  d->data.diag_select.bottom_y=bottom_y;
  d->data.diag_select.up_id=-1,
  d->data.diag_select.down_id=-1;
  d->data.diag_select.left_id=-1;
  d->data.diag_select.right_id=-1;
  d->data.diag_select.blink=FALSE;  
  
  d->w=20;
  d->h=font_height();
  d->x2=d->x;
  d->y2=d->y;
  d->w2=d->w;
  d->h2=d->h;
  d->speed=1;
  
  if(parent==-1||parent<0||parent>=dialog_object::total_objects-1) {
    d->next=dialogs;
    dialogs=d;    
    d->parent=-1;
  }
  else {
    dialog_object *t=dialog_list[parent];
    if(t->type!=DIAG_FRAME) {
      d->next=dialogs;
      dialogs=d;
      d->parent=-1;
    }
    else {
      d->next=t->data.diag_frame.child;
      t->data.diag_frame.child=d;
      d->parent=parent;
    }
  }
  
  return d->id;
}

int create_text(int parent,int x,int y,int w,int v,char *text,int more)
{
  dialog_object *d=new dialog_object;
  
  d->id=dialog_object::total_objects++;
  dialog_list[d->id]=d;
  d->real_x=0;
  d->real_y=0;
  d->x=x;
  d->y=y;

  d->type=DIAG_TEXT;

  d->data.diag_text.text=new char[strlen(text)+1];
  strcpy(d->data.diag_text.text,text);
  d->data.diag_text.drawn=v;
  d->data.diag_text.speed=text_speed;
  d->data.diag_text.progress=0;
  d->data.diag_text.more=more;  
  
  d->w=w;
  d->h=(parent!=-1) ? dialog_list[parent]->h-20 : 20;
  d->x2=d->x;
  d->y2=d->y;
  d->w2=d->w;
  d->h2=d->h;
  d->speed=1;
  
  if(parent==-1||parent<0||parent>=dialog_object::total_objects-1) {
    d->next=dialogs;
    dialogs=d;    
    d->parent=-1;
  }
  else {
    dialog_object *t=dialog_list[parent];
    if(t->type!=DIAG_FRAME) {
      d->next=dialogs;
      dialogs=d;
      d->parent=-1;
    }
    else {
      d->next=t->data.diag_frame.child;
      t->data.diag_frame.child=d;
      d->parent=parent;
    }
  }
  
  return d->id;
}


int create_frame(int parent,int x,int y,int w,int h)
{
  dialog_object *d=new dialog_object;
  
  d->id=dialog_object::total_objects++;
  dialog_list[d->id]=d;
  d->real_x=0;
  d->real_y=0;
  d->x=x;
  d->y=y;
  d->w=w;
  d->h=h;
  d->x2=x;
  d->y2=y;
  d->w2=w;
  d->h2=h;
  d->speed=1;
  
  
  d->type=DIAG_FRAME;

  d->data.diag_frame.child=NULL;
  d->data.diag_frame.pict_type=-1;
  d->data.diag_frame.pict=NULL;
  d->data.diag_frame.scroll_y=0;
  d->data.diag_frame.scroll_y2=0;
  d->data.diag_frame.opened=0;
  d->data.diag_frame.opened2=0;
  
  
  if(parent<0||parent>=dialog_object::total_objects-1) {
    d->next=dialogs;
    dialogs=d;    
    d->parent=-1;
  }
  else {
    dialog_object *t=dialog_list[parent];
    if(t->type!=DIAG_FRAME) {
      d->next=dialogs;
      dialogs=d;
      d->parent=-1;
    }
    else {
      d->next=t->data.diag_frame.child;
      t->data.diag_frame.child=d;
      d->parent=parent;
    }
  }
  
  return d->id;
}
int create_slider(int parent,int x,int y,int w,int min,int max,int p,int c1,int c2)
{
  dialog_object *d=new dialog_object;
  
  d->id=dialog_object::total_objects++;
  dialog_list[d->id]=d;
  d->real_x=0;
  d->real_y=0;
  d->x=x;
  d->y=y;
  d->w=w;
  d->h=font_height();
  d->type=DIAG_SLIDER;
  d->x2=d->x;
  d->y2=d->y;
  d->w2=d->w;
  d->h2=d->h;
  d->speed=1;
  

  d->data.diag_slider.current_value=min;
  d->data.diag_slider.min_value=min;
  d->data.diag_slider.max_value=max;
  d->data.diag_slider.type=p;
  d->data.diag_slider.c1=c1;
  d->data.diag_slider.c2=c2;
  
  if(parent==-1||parent<0||parent>=dialog_object::total_objects-1) {
    d->next=dialogs;
    dialogs=d;    
    d->parent=-1;
  }
  else {
    dialog_object *t=dialog_list[parent];
    if(t->type!=DIAG_FRAME) {
      d->next=dialogs;
      dialogs=d;
      d->parent=-1;
    }
    else {
      d->next=t->data.diag_frame.child;
      t->data.diag_frame.child=d;
      d->parent=parent;
    }
  }
  
  return d->id;
}
void destroy_dialog_object(int n)
{
  if(n==-1) {
    dialog_object *d=dialogs,*t;
    while (d) {
      t=d->next;
      destroy_dialog_object(d->id);
      d=t;
    }
    dialog_object::total_objects=0;
    dialogs=NULL;
    return;
  }
  if(n<0||n>=dialog_object::total_objects)
    return;
  dialog_object *d=dialog_list[n];
  if(d==NULL) return;
  if(d==dialogs) dialogs=d->next;
  if(d->type==DIAG_FRAME) {
    dialog_object *tmp,*t;
    tmp=d->data.diag_frame.child;
    while(tmp) {
      t=tmp->next;
      destroy_dialog_object(tmp->id);
      tmp=t;
    }
    if(d->data.diag_frame.pict!=NULL)
      destroy_bitmap(d->data.diag_frame.pict);
  }
  if(d->type==DIAG_TEXT)
    if(d->data.diag_text.text)
      delete []d->data.diag_text.text;
  
  if(d->type==DIAG_PICTURE)
    destroy_bitmap(d->data.diag_picture.pict);
    
  dialog_object *t=dialogs;
  while(t&&t!=d) {
    if(t->next==d)
      t->next=d->next;
    t=t->next;
  }
    
  dialog_list[d->id]=NULL;
  delete d; 
 
}

void move_object(int obj_number,int x,int y,int speed)
{
  if(speed<=0) {
    dialog_list[obj_number]->x2=x;
    dialog_list[obj_number]->y2=y;
    dialog_list[obj_number]->x=x;
    dialog_list[obj_number]->y=y;
  }
  else {
    dialog_list[obj_number]->x2=x;
    dialog_list[obj_number]->y2=y;
    dialog_list[obj_number]->speed=speed;
  }
}

void resize_object(int obj_number,int w,int h,int speed)
{
  if(speed<=0) {
    dialog_list[obj_number]->w2=w;
    dialog_list[obj_number]->h2=h;
    dialog_list[obj_number]->w=w;
    dialog_list[obj_number]->h=h;
  }
  else {
    dialog_list[obj_number]->w2=w;
    dialog_list[obj_number]->h2=h;
    dialog_list[obj_number]->speed=speed;
  }
}

int get_object_width(int obj_number)
{
  return dialog_list[obj_number]->w;
}
int get_object_height(int obj_number)
{
  return dialog_list[obj_number]->h;
}

void open_frame(int frame_number,int speed)
{
  if(dialog_list[frame_number]->type!=DIAG_FRAME) return;
  
  if(speed<=0) {
    dialog_list[frame_number]->data.diag_frame.opened2=256;
    dialog_list[frame_number]->data.diag_frame.opened=256;
  }
  else {
    dialog_list[frame_number]->data.diag_frame.opened2=256;
    dialog_list[frame_number]->speed=speed;
  }
}
void close_frame(int frame_number,int speed)
{
  if(dialog_list[frame_number]->type!=DIAG_FRAME) return;
  
  if(speed<=0) {
    dialog_list[frame_number]->data.diag_frame.opened2=0;
    dialog_list[frame_number]->data.diag_frame.opened=0;
  }
  else {
    dialog_list[frame_number]->data.diag_frame.opened2=0;
    dialog_list[frame_number]->speed=speed;
  }
}

void change_text(int text_number,int v,char *text,int more)
{
  if(dialog_list[text_number]->type!=DIAG_TEXT) return;

  dialog_list[text_number]->data.diag_text.drawn=v;
  dialog_list[text_number]->data.diag_text.more=more;
  dialog_list[text_number]->data.diag_text.speed=text_speed;
  dialog_list[text_number]->data.diag_text.progress=0;

  if(text) {
    if(dialog_list[text_number]->data.diag_text.text)
      delete []dialog_list[text_number]->data.diag_text.text;
    dialog_list[text_number]->data.diag_text.text=new char[strlen(text)+1];
    strcpy(dialog_list[text_number]->data.diag_text.text,text);
  }

}

void stop_text_scroll(int text_number)
{
  if(dialog_list[text_number]->type!=DIAG_TEXT) return;

  dialog_list[text_number]->data.diag_text.drawn=-1;
}
int is_text_scrolling(int text_number)
{
  if(dialog_list[text_number]->type!=DIAG_TEXT) return FALSE;

  return (dialog_list[text_number]->data.diag_text.drawn!=-1) ? 1 : 0;
}

void change_picture(int pict_number,char *filename)
{
  dialog_object *d=dialog_list[pict_number];

  if(d->type!=DIAG_PICTURE) return;

  destroy_bitmap(d->data.diag_picture.pict);
  
  if(filename[0]=='#') {
     filename++;
     DATAFILE *tmp;
     if(!exists("figure.dat")) 
       d->data.diag_picture.pict=NULL;  
     else {
		 set_pass();
       tmp=load_datafile_object("figure.dat",filename);
		packfile_password(NULL);
       if(tmp) {
         d->data.diag_picture.pict=(BITMAP *)tmp->dat;
         tmp->dat=NULL;
         unload_datafile_object(tmp);           
       }
       else d->data.diag_picture.pict=NULL;
     }
  }
  else if(exists(filename)) 
    d->data.diag_picture.pict=load_bitmap(filename,NULL);
  else 
    d->data.diag_picture.pict=NULL;
}

void set_active_select(int select_number)
{
  if(select_number<0) return;

  dialog_object *d=dialog_list[select_number];

  if(d->type!=DIAG_SELECT) return;

  dselect_active_id=select_number;

  if(d->parent<0) return;

  dialog_object *p=dialog_list[d->parent];

  if(p->type!=DIAG_FRAME) return;

  if(d->y+d->data.diag_select.bottom_y-p->data.diag_frame.scroll_y>p->h-20)
    p->data.diag_frame.scroll_y2=d->y+d->data.diag_select.bottom_y-p->h+20;

  if(d->y+d->data.diag_select.top_y-p->data.diag_frame.scroll_y<0) 
    p->data.diag_frame.scroll_y2=d->y+d->data.diag_select.top_y;

  }

void clear_active_select()
{
  dselect_active_id=-1;
}

int get_active_select()
{
  return dselect_active_id;
}

void select_blink_on(int select_number)
{
  if(dialog_list[select_number]->type!=DIAG_SELECT)
    return;

  dialog_list[select_number]->data.diag_select.blink=TRUE;
}

void select_blink_off(int select_number)
{
  if(dialog_list[select_number]->type!=DIAG_SELECT)
    return;

  dialog_list[select_number]->data.diag_select.blink=FALSE;
}

int get_select_blink(int select_number)
{
  if(dialog_list[select_number]->type!=DIAG_SELECT)
    return 0;

  return (dialog_list[select_number]->data.diag_select.blink) ? 1 : 0;
}
int left_select(int select_number)
{
  if(dialog_list[select_number]->type!=DIAG_SELECT)
    return -1;

  return dialog_list[select_number]->data.diag_select.left_id;
}
int right_select(int select_number)
{
  if(dialog_list[select_number]->type!=DIAG_SELECT)
    return -1;

  return dialog_list[select_number]->data.diag_select.right_id;
}
int up_select(int select_number)
{
  if(dialog_list[select_number]->type!=DIAG_SELECT)
    return -1;

  return dialog_list[select_number]->data.diag_select.up_id;
}
int down_select(int select_number)
{
  if(dialog_list[select_number]->type!=DIAG_SELECT)
    return -1;

  return dialog_list[select_number]->data.diag_select.down_id;
}
void set_left_select(int select_number,int select_number2)
{
  if(dialog_list[select_number]->type!=DIAG_SELECT)
    return;

  dialog_list[select_number]->data.diag_select.left_id=select_number2;
}
void set_right_select(int select_number,int select_number2)
{
  if(dialog_list[select_number]->type!=DIAG_SELECT)
    return;

  dialog_list[select_number]->data.diag_select.right_id=select_number2;
}
void set_up_select(int select_number,int select_number2)
{
  if(dialog_list[select_number]->type!=DIAG_SELECT)
    return;

  dialog_list[select_number]->data.diag_select.up_id=select_number2;
}
void set_down_select(int select_number,int select_number2)
{
  if(dialog_list[select_number]->type!=DIAG_SELECT)
    return;

  dialog_list[select_number]->data.diag_select.down_id=select_number2;
}

int create_select_list(int parent,int x,int y,int dx,int dy,int number,int top_y,int bottom_y)
{
  int i;
  int ret,r1,r2;
  int nx,ny;

  r1=create_select(parent,x,y,top_y,bottom_y);
  ret=r1;
  nx=x+dx;
  ny=y+dy;
  for(i=1;i<number;i++) {
    r2=create_select(parent,nx,ny,top_y,bottom_y);
    if(dy!=0) {
      if(ny>y) {
        set_down_select(r1,r2);
        set_up_select(r2,r1);
      }
      else if(ny<y) {
        set_down_select(r2,r1);
        set_up_select(r1,r2);
      }
    }
    if(dx!=0) {
      if(nx>x) {
        set_right_select(r1,r2);
        set_left_select(r2,r1);
      }
      else if(nx<x) {
        set_right_select(r2,r1);
        set_left_select(r1,r2);
      }
    }
    r1=r2;
    x=nx;
    y=ny;
    nx=x+dx;
    ny=y+dy;
  }

  return ret;
}
int create_select_grid(int parent,int x,int y,int dx,int dy,int x_number,int y_number,int top_y,int bottom_y)
{
  int w=x_number;
  int h=y_number;
  int *grid;
  int i,j;

  if(w<1) w=1;
  if(h<1) h=1;

  if(dx<1||dy<1) 
  {
    w=1;
    h=1;
  }

  grid = new int [w*h];

  for(j=0;j<h;j++)
    for(i=0;i<w;i++) 
      grid[i+j*w]=create_select(parent,x+i*dx,y+j*dy,top_y,bottom_y);
  
  for(j=0;j<h;j++)
    for(i=0;i<w;i++) {
      if(i!=w-1)
        set_right_select(grid[i+j*w],grid[i+1+j*w]);
      if(j!=h-1)
        set_down_select(grid[i+j*w],grid[i+(j+1)*w]);
      if(i!=0)
        set_left_select(grid[i+j*w],grid[i-1+j*w]);
      if(j!=0)
        set_up_select(grid[i+j*w],grid[i+(j-1)*w]);
    }


  return grid[0];
  
}



int get_slider_value(int slider_number)
{
  if(dialog_list[slider_number]->type!=DIAG_SLIDER)
    return 0;

  return dialog_list[slider_number]->data.diag_slider.current_value;
}

void set_slider_value(int slider_number,int value,int speed)
{
  if(dialog_list[slider_number]->type!=DIAG_SLIDER)
    return;

  if(value<dialog_list[slider_number]->data.diag_slider.min_value)
    value=dialog_list[slider_number]->data.diag_slider.min_value;
  if(value>dialog_list[slider_number]->data.diag_slider.max_value)
    value=dialog_list[slider_number]->data.diag_slider.max_value;

  if(speed==-1) {
    dialog_list[slider_number]->data.diag_slider.current_value2=value;
    dialog_list[slider_number]->data.diag_slider.current_value=value;
  
  }
  else {
    dialog_list[slider_number]->data.diag_slider.current_value2=value;
    //dialog_list[slider_number]->data.diag_slider.current_value=value;
    dialog_list[slider_number]->speed=speed;
  }
}
void change_slider_color(int slider_number,int c1,int c2)
{
  if(dialog_list[slider_number]->type!=DIAG_SLIDER)
    return;

  dialog_list[slider_number]->data.diag_slider.c1=c1;
  dialog_list[slider_number]->data.diag_slider.c2=c2;
  
}

int get_input()
{
  static int loops=0;
  int update=FALSE;
  int got_key=-1;

  draw_background(); // there is a reason for this :)

  timer=0;
  int i;
  
  while(TRUE) {
    i=timer;timer-=i;
    while(i>0) {
      i--; update=TRUE;
      if(check_key(key_up))
        got_key=0;
      else if(check_key(key_down))
        got_key=1;
      else if(check_key(key_left))
        got_key=2;
      else if(check_key(key_right))
        got_key=3;
      else if(check_key(key_action))
        got_key=4;
      else if(check_key(key_cancel))
        got_key=5;
      else if(check_key(key_menu))
        got_key=6;
      else if(check_key(key_select))
        got_key=7;
      else {
        loops=0;
        got_key=-1;
      }

      
      if(loops>0) {
        loops--;
      }           
      else
        if(got_key!=-1) {
          loops=MAX_KEY_DELAY;
          return got_key;
        }
      
      update_game_logic();
      update_objects();      
    }
    if(update) {
      update=FALSE;
      draw_background();
      flip();
    }
  }
  return -1;
}
void wait_for_text_scroll(int text_object)
{
  static int loops=0;
  int update=FALSE;
  int got_key=-1;

  draw_background();

  timer=0;
  int i;


  while(is_text_scrolling(text_object)==1) {
    i=timer;timer-=i;
    while(i>0) {
      i--; update=TRUE;
      if(check_key(key_action))
        got_key=4;
      else if(check_key(key_cancel))
        got_key=5;
      else {
        loops=0;
        got_key=-1;
      }

      if(loops>0) {
        loops--;
      }
      else 
        if(got_key!=-1) {
          loops=MAX_KEY_DELAY;
          stop_text_scroll(text_object);
        }

      update_game_logic();
      update_objects();
    }
    if(update) {
      update=FALSE;
      draw_background();
      flip();
    }
  }
}

void wait_for_animation(int text_object)
{
  static int loops=0;
  int update=FALSE;
  int got_key=-1;
  int i=0;
  int quit=1;

  draw_background();
  
  timer=0;
  int d=0;
  int boost=1;

  while(quit==1) {
    i=timer; timer-=i;
      
    while(i>0) {
      i--; update=TRUE;
      update_game_logic();
      
      if(check_key(key_action)) {
        got_key=4;
      }
      else if(check_key(key_cancel)) {
        got_key=5;      
      }
      else {
        loops=0;
        got_key=-1;
      }
      if(loops>0) {
        loops--;
      }
      else 
        if(got_key!=-1) {
          loops=MAX_KEY_DELAY;
          boost=2;
        }
      
      quit=update_objects(dialogs,text_object,boost);
      

    }
    if(update) {
      update=FALSE;
      draw_background();
      flip();
    }
    else 
     yield_timeslice();
  }
}






