// tileset.h

#ifndef TILESET_HEADER
#define TILESET_HEADER

#include "pmask.h"

struct tt_tile {
  BITMAP *base;
  BITMAP *effect;
  PMASK *mask;
  
  short id;
  int delta;
  unsigned char solid;
};

struct t_tile {
  tt_tile *tile;
  int length;    // number of animations..
};

void CalcTables();

class tileset
{
  private:
    t_tile *tiles;
    char *name;
    int size;
    static int first;

    DATAFILE *dat;
    
  public:
    static int use_vram_masked;
    static int use_vram_solid;
    static int low_color;
    tileset() {if(first) {first=FALSE;CalcTables();}dat=NULL;tiles=NULL;name=NULL;size=0;}
    ~tileset() {free();}
    int get_count();
    DATAFILE *get_tiles() {return dat;}
    int check(char *_name); // check if this is the right tileset
    void free();
    void load(char *_name);
    void draw(BITMAP *bmp,int pic,int frame,int p_x,int p_y,int trans,int effect,int delta,int draw_mode=-1);
    int check_mask(int pict,int x1,int y1,BITMAP *spr2,int x2,int y2);
    void stop_effect();
    void apply_effect(int pic,int frame,int effect,int delta,int y);
};



#endif /* TILESET_HEADER */
