#define LAYER_CONTINUES 1        // parts of the layer that are outside the screen will continue at beginning
#define LAYER_INVISIBLE 2        // what do you think?
#define LAYER_WALK      4        // this is a walk layer.
#define LAYER_EFFECT0   8		 // Use layer effect # 0
#define LAYER_EFFECT1   16		 // Use layer effect # 1


class c_layer
{
  private:
    c_tile * tiles;
    int x,y;
    int z;              // this is how high up the layer is...
    int grid_size_x,grid_size_y;
    int extra_x,extra_y;
    int width,height;	//in tiles (grid_size_x pixels)
    int trans,edit_trans; //transparancy used in game and in editor
    int flags;
    double speed_x, speed_y;   // this moves the layer by itself
    double scroll_x, scroll_y; // normally 1,1 this controls how fast
                               // normal scrolls happens
    int delta;                 // current cycle of the current effect.                           

    int reflect_type;       // -1 none, 0 floor reflection, 1 wall reflection
    int reflect_y;          // the y offset of the reflection
    int reflect_z;          // the z value of the reflection
    int reflect_trans;      // the transparancy of the reflection
    
    char *on_load_name;
    VMachine *on_load;
  public:              
    int copy;
    c_layer()
    {
		tiles=(c_tile *)0;
		on_load_name=(char *)0;
		on_load=(VMachine *)0;
    	z=x=y=width=height=trans=flags=0;
        grid_size_x=grid_size_y=32;
        speed_x=speed_y=0;
        tiles = NULL;
        extra_x=extra_y=0;
        scroll_x=scroll_y=1;
        delta=0;
        reflect_type=-1;
        reflect_trans=reflect_y=reflect_z=0;
        copy = FALSE;
    }    
    ~c_layer();
    void update();
    void moveTo(int p_x, int p_y);
    void changeSize(int p_width, int p_height);
    void setGrid(int p_x, int p_y);
    int gridx();
    int gridy();
    int getz();
    void setz(int _z);
    void setTrans(int p_trans);
    int getTrans() {return trans;}
    void setFlag(int p_flag, int p_state);
    int getFlag(int p_flag);
    void setFlags(int p_flags);
    int getFlags();
    void setSpeed(double p_speed_x, double p_speed_y);
    void setScroll(double p_scroll_x, double p_scroll_y); 
    double getScroll(int p_xory);
    double getSpeed(int p_xory);
    int getSize(int p_woh);
    void scroll(int p_x,int p_y, int p_editor);
    void draw(BITMAP *bmp,int p_x, int p_y,int draw_mode=-1);
    int check_tile(BITMAP *spr,int p_x,int p_y);
//    void draw_y(BITMAP *bmp,int p_x, int p_y,BITMAP *t,int _x,int _y,int draw_mode=-1);
    void drawGrid(int p_x, int p_y, int p_color);
    int randomize();
    void setPic(int p_x,int p_y,int p_num);
    c_tile* getTilePointer(int p_x, int p_y);
    int getX();
    int getY();
    int loadFromFile(PACKFILE *file,int version,int compile);
    int saveToFile(PACKFILE *file);
    int get_reflect_type() {return reflect_type;}
    int get_reflect_y() {return reflect_y;}
    int get_reflect_z() {return reflect_z;}
    int get_reflect_trans() {return reflect_trans;}
    void set_reflect_type(int _t) {reflect_type=_t;}
    void set_reflect_y(int _t) {reflect_y=_t;}
    void set_reflect_z(int _t) {reflect_z=_t;}
    void set_reflect_trans(int _t) {reflect_trans=_t;}
    
};






