// This code is LGPL, see licence.txt for details
//
#include <stdio.h> 
#include <string.h>

#include <allegro.h>
#include "spp.h"

#include "alleg.h"

#include "func.h"

#include "tile.h"
#include "layer.h"


int c_tile::animationDo(int p_action)
{
    if(animation_start<0) return 0;

    switch(p_action)
    {
    case ANIMATION_STOP:
	setFlag(TILE_PLAYANIMATION,FALSE);
    break;
    case ANIMATION_PLAY:
        if(!getFlag(TILE_ISANIMATION)) return -1;
	setFlag(TILE_PLAYANIMATION,TRUE);
        animation_progress=0;
    break;
    case ANIMATION_NEXT:
        animation_progress+=animation_speed;
	if (animation_progress>animation_length)
	{
          if(getFlag(TILE_ANIMATIONLOOPS)) {
	    int temp1 =(int)(animation_progress/animation_length);
	    double temp2 = animation_progress/animation_length;
	    double temp3 = temp2-(double)temp1;
	    animation_progress= (double) temp3*(double)animation_length;
          } 
          else setFlag(TILE_PLAYANIMATION,FALSE);
	}

    break;
    default:
      return 0;
                
    }

    if(Tiles.get_tiles()[animation_start].type==DAT_FILE) {
      //DATAFILE *tmp=(DATAFILE *)Tiles.get_tiles()[animation_start].dat;
      //pict = (BITMAP *) tmp[int(animation_progress)].dat;
      pict=animation_start;
      frame=int(animation_progress);
    }
    else {
      int p = int(animation_progress) + animation_start;

      if(p>=0&&p<Tiles.get_count()) {
        pict = p;
      }
      else pict = -1;
      frame=-1;
    }

    return (int)animation_progress;
}

int c_tile::getSize(int p_woh)
{
	if(pict<0) return -1;

    BITMAP * temp;
    temp = (BITMAP *)Tiles.get_tiles()[pict].dat;

    if (p_woh == SIZE_WIDTH)
	return temp->w;
    else if (p_woh == SIZE_HEIGHT)
	return temp->h;
    else
	return -1;
}


void c_tile::setFlags(int p_flags)
{
	flags=p_flags;
}

double c_tile::getAnimationSpeed()
{
    return animation_speed;
}
int c_tile::getAnimationLength()
{
    return animation_length;
}


int c_tile::getFlags()
{
	return flags;
}

void c_tile::setAnimation(int p_animation_length, double p_animation_speed)
{
    if (!animation_length)
		setFlag(TILE_ISANIMATION,FALSE);
    else
	setFlag(TILE_ISANIMATION,TRUE);
    animation_length=p_animation_length;
    animation_speed =p_animation_speed;
}

void c_tile::setPic(int p_pic)
{
//	int s;
        if(p_pic>=0&&p_pic<Tiles.get_count()) {
          pict=p_pic;
          if(Tiles.get_tiles()[p_pic].type==DAT_FILE) {
            frame=0;
            setAnimation(atoi(get_datafile_property(&Tiles.get_tiles()[p_pic], DAT_ID('L','E','N',' '))),
                         atof(get_datafile_property(&Tiles.get_tiles()[p_pic], DAT_ID('S','P','D',' '))));
            setFlag(TILE_ANIMATIONLOOPS,(atoi(get_datafile_property(&Tiles.get_tiles()[p_pic], DAT_ID('L','O','O','P')))==1) ? TRUE : FALSE);
            setFlag(TILE_STARTANIMATION,(atoi(get_datafile_property(&Tiles.get_tiles()[p_pic], DAT_ID('A','U','T','O')))==1) ? TRUE : FALSE);

            if(getFlag(TILE_STARTANIMATION))
              animationDo(ANIMATION_PLAY);

          }
	}
	else pict=-1;          
	
    animation_start=pict;

}


int c_tile::draw(BITMAP *bmp,int p_x, int p_y, int p_trans,int effect,int delta,int draw_mode)
{
    if (getFlag(TILE_INVISIBLE)) 
      return 0;
    if (getFlag(TILE_HASOWNTRANS)) 
      p_trans=trans;
                           
    Tiles.draw(bmp,pict,frame,p_x,p_y,p_trans,effect,delta,draw_mode);
    
    return 0;
}
int c_tile::check_tile(BITMAP *spr,int p_x,int p_y)
{
//    int i;
    if (pict==-1)
      return FALSE;

    DATAFILE *pic=&(Tiles.get_tiles()[pict]);

    if(pic->type!=DAT_BITMAP) return FALSE;

    BITMAP *tmp=(BITMAP *)pic->dat;
    
    return spp_detect_collision(p_x-tmp->w,p_y-tmp->h,tmp,0,0,spr);
}
/*
int c_tile::draw_y(BITMAP *bmp,int p_x, int p_y, int p_trans,BITMAP *t,int _x,int _y,int draw_mode)
{
    if(pict<0) return -1;              
    BITMAP * temp;
    temp = (BITMAP *)Tiles.get_tiles()[pict].dat;

    if(t) {
      if(!spp_detect_collision(p_x-temp->w,p_y-temp->h,temp,_x,_y,t))
        return -1;
    }
    else if(p_y<_y) return -1;
	
    return draw(bmp,p_x, p_y, p_trans,draw_mode);  
}*/
void c_tile::setTrans(int p_trans)
{
	if (p_trans ==-1)
	  setFlag(TILE_HASOWNTRANS,FALSE);
	else
	  setFlag(TILE_HASOWNTRANS,TRUE);
    if (p_trans<0)
	p_trans=0;
    if (p_trans>255)
	p_trans=255;

    trans=p_trans;
}
int c_tile::getTrans()
{
   if(getFlag(TILE_HASOWNTRANS))
     return trans;
   return -1;
}
int c_tile::saveToFile(PACKFILE * file)
{
	int l;
	if (!file)
	return -1;
    pack_iputl(ftofix(animation_progress),file);
    pack_iputl(ftofix(animation_speed),file);
    pack_iputl(animation_length,file);
    pack_iputl(flags,file);
    pack_iputl(trans,file);
    
    if(on_load_name)
      l=strlen(on_load_name);
    else l=0;
    pack_iputl(l,file);
    if(l>0) pack_fwrite(on_load_name,l,file);
    

    static char g[50];
    if(pict>=0) {
      strcpy(g,get_datafile_property(&Tiles.get_tiles()[pict], DAT_ID('N','A','M','E')));
	  int str_length=strlen(g);

	  pack_iputl(str_length,file);
	  pack_fwrite(g,str_length,file);
    }
    else pack_iputl(-1,file);  //empty
        
    return 0;
}

int c_tile::loadFromFile(PACKFILE *file,int version,int compile)
{           
    int i,l;
    if (!file)
      return -1;

    animation_start = -1;

    DATAFILE *tmp=NULL;

    switch(version) {
      case 1: case 2: case 3: case 4: case 5: case 6: case 7: case 8: case 9: case 10: case 11: {
	animation_progress=fixtof(pack_igetl(file));
	animation_speed=fixtof(pack_igetl(file));
	animation_length=pack_igetl(file);
	flags=pack_igetl(file);
	trans=pack_igetl(file);

    if(version>10) {
       l=pack_igetl(file);

       if(l>0) {
         char tempf[50],*tempy;
         pack_fread(tempf,l,file);
         tempf[l]=0;
         tempy=get_filename(tempf);
              
         on_load_name=new char[strlen(tempy)+1];
         strcpy(on_load_name,tempy);
       }
       else on_load_name=NULL;
          
       if(compile&&on_load_name) {
         on_load=compile_hrs_script(on_load_name);
       } else on_load=NULL;
    }

	static char g[50];
	int str_length=pack_igetl(file);

	if(str_length==-1) {
	  pict=-1;
	}
    else if(Tiles.get_tiles()!=NULL) {
	  pack_fread(g,str_length,file);
	  g[str_length]=0;

      tmp = find_datafile_object(Tiles.get_tiles(),g);

      if(tmp!=NULL) {
        if(tmp->type==DAT_FILE)
          frame=0; 
        pict = -1;
        for(i=0;i<Tiles.get_count();i++)
          if(&Tiles.get_tiles()[i]==tmp) {
            pict = i;
            break;
          }        
      }
      else pict=-1;

	}

	break;
      }
      default: return -1;
    }

    if(pict<0)
      return -1;
              
    animation_start=pict;          
    
    return pict;
    
}
