// This code is LGPL, see licence.txt for details
//
#include <allegro.h>
#include <stdio.h>
#include <string.h>
//#include "fortify.h"
#include "mystring.h"
#include "func.h"
#include "symtab.h"

SymDesc::SymDesc (char *_name, SymType _type, char *_cont, int _line)    {
   if(this==NULL) return;
   name = _name; type = _type;
   value.var = new hrs_variable;
   value.var->type=VAR_STR;
   if(_cont) value.var->dat.var_string = new String(_cont);
   else value.var->dat.var_string = new String;
   value.var->constant=TRUE;
   if(_cont) delete [] _cont;
   line = _line;
   next = NULL;
}
SymDesc::SymDesc (char *_name, SymType _type, int *_cont, int _line)    {
   if(this==NULL) return;
   name = _name; type = _type;
   value.var = new hrs_variable;
   value.var->type=VAR_INT;
   if(_cont) value.var->dat.var_int = *_cont;
   else value.var->dat.var_int = 0;
   value.var->constant=TRUE;
   line = _line;
   next = NULL;
}
SymDesc::SymDesc (char *_name, SymType _type, double *_cont, int _line)    {
   if(this==NULL) return;
   name = _name; type = _type;
   value.var = new hrs_variable;
   value.var->type=VAR_REAL;
   if(_cont) value.var->dat.var_real = *_cont;
   else value.var->dat.var_real = 0;
   value.var->constant=TRUE;
   line = _line;
   next = NULL;
}
SymDesc::SymDesc (char *_name, SymType _type, int _line)    {
   if(this==NULL) return;
   name = _name; type = _type;
   value.var = new hrs_variable;
   switch(type) {
     case STR_CONST:
       value.var->constant=TRUE;
     case STR_VAR:
       value.var->type=VAR_STR;
       value.var->dat.var_string = new String;
       break;
     case INT_CONST:
       value.var->constant=TRUE;
     case INT_VAR:
       value.var->type=VAR_INT;
       value.var->dat.var_int = 0;
       break;
     case FLOAT_CONST:
       value.var->constant=TRUE;
     case FLOAT_VAR:
       value.var->type=VAR_REAL;
       value.var->dat.var_real = 0;
       break;
     default: // error
       break;
   }
   line = _line;
   next = NULL;
}
SymDesc::~SymDesc ()  {
   if (this == NULL)   return;
   if (name != NULL)  {delete [] name; name=NULL;}
   switch(type) {
     case STR_VAR:
     case STR_CONST:
       if(value.var) {
         if(value.var->dat.var_string)
           delete value.var->dat.var_string;

         delete value.var;
       }
       break;
     default:
       if(value.var)
         delete value.var;

       break;
   }
   delete next;
   next=NULL;
}

void SymDesc::Show ()   {
   printf ("| %-20s | %4d |\n", name, line);
}

SymTab::SymTab()   {
   start = NULL; current = NULL;
}

SymTab::~SymTab()   {
   delete start;
   start = NULL; current=NULL;
}
void SymTab::clear() {
   delete start;
   start = NULL; current = NULL;
}
bool SymTab::Add (SymDesc *symb)  {
   if(!symb) return FALSE;
   if (Find (symb->name) != NULL) {
      delete symb;
      return FALSE;
   }

   if (start == NULL)
      start = symb;
   else  {
      SymDesc *search = start;
      while (search->next != NULL)
         search = search->next;
      search->next = symb;
   }
   return TRUE;
}

SymDesc *SymTab::Find (char *name)   {
   if(name==NULL) return NULL;
   SymDesc *search = start;
   while (search != NULL && (search->name==NULL || strcmp (search->name, name) != 0))
      search = search->next;
   return search;
}

void SymTab::Show ()  {
   SymDesc *search = start;
   puts ("+----------------------+------+");
   puts ("| Name                 | Line |");
   puts ("+----------------------+------+");
   while (search != NULL)  {
      search->Show ();
      search = search->next;
   }
   puts ("+----------------------+------+");
}
