// This code is LGPL, see licence.txt for details
//
#include <stdarg.h>
#include <allegro.h>
#include <stdio.h>
//#include "fortify.h"
#include "mystring.h"
#include "hrs_lex.h"
#include "parse.h"
#include "func.h"
#include "symtab.h"
#include "synttree.h"
#include "intcode.h"

int errors = 0;
PACKFILE *error_log;
static char buf[512];

static int write_log;
static char error_log_name[255];

void start_error_log(char *filename,char *source)
{
  strcpy(error_log_name,filename);
  sprintf (buf, "Parsing file: %s\n", source);
  write_log=0;
  errors=0;
  line_num=1;
   
}

// Function used to report errors
void Error (char *format, ...)   {
   if(write_log==0) {
     write_log=1;
     error_log=pack_fopen(error_log_name,F_WRITE);
     pack_fwrite(buf,strlen(buf),error_log);
   }

   va_list args;

   errors++;
   sprintf (buf, "Line %d: ", line_num);
   pack_fwrite(buf,strlen(buf),error_log);
   
   va_start(args, format);
   vsprintf(buf, format, args);
   pack_fwrite(buf,strlen(buf),error_log);
   va_end(args);
   sprintf(buf,"\n");
   pack_fwrite(buf,strlen(buf),error_log);
   
}

// Show an error count
void end_error_log ()  {
   if(write_log==1) {
     write_log=0;
     sprintf (buf, "%d error(s) were found.\n", errors);
     pack_fwrite(buf,strlen(buf),error_log);
     pack_fclose(error_log);
   }
}

// Function called by the parser when an error occurs while parsing
// (parse error or stack overflow)
void yyerror(char *msg) {
   Error (msg);
}

// This function is called by the lexer when the end-of-file
// is reached; you can reset yyin (the input FILE*) and return 0
// if you want to process another file; otherwise just return 1.

extern "C" int yywrap(void) {
  return 1;
}
extern SymTab st;
extern SyntTree tree;
extern SyntTree mem;

IntInstr *intcode;
#include "vm.h"   

VMachine *compile_hrs_script(char *filename) {
   if(!exists(filename)) return NULL;
  
   VMachine *vm;

   vm=NULL;
   mem=NULL;
   tree=NULL;

   start_error_log("error.log",filename);

   p_yyin = pack_fopen (filename, F_READ);
   pack_fseek(p_yyin,0);
   yyrestart(p_yyin);
   yyparse (); // call the parser
   pack_fclose (p_yyin);

   end_error_log ();

   if(!errors)   {
      intcode = GenIntCode (tree);
      intcode->Number(1);

      vm = new VMachine;

      if(vm!=NULL)
        vm->Read();

      delete intcode;
   }

   st.clear();
   delete mem;
   return vm;

}
VMachine *compile_hrs_script(char *textbuffer,int length) {
   char filename[20];

   int i=0;

   do {
     sprintf(filename,"temp%d.hrs",i++);
   } while(exists(filename));

   PACKFILE *f=pack_fopen(filename, F_WRITE);
   i=0;
   while(i<length) {
     pack_putc(textbuffer[i++],f);
   }
   pack_fclose(f);
   

   VMachine *vm;

   vm=NULL;
   mem=NULL;
   tree=NULL;

   start_error_log("error.log",filename);

   p_yyin = pack_fopen (filename, F_READ);
   pack_fseek(p_yyin,0);
   yyrestart(p_yyin);
   yyparse (); // call the parser
   pack_fclose (p_yyin);

   end_error_log ();

   if(!errors)   {
      intcode = GenIntCode (tree);
      intcode->Number(1);

      vm = new VMachine;

      if(vm!=NULL)
        vm->Read();

      delete intcode;
   }

   st.clear();
   delete mem;

   delete_file(filename);

   return vm;
}

VMachine *compile_chunk(PACKFILE *pp)
{
   VMachine *vm;

   vm=NULL;
   mem=NULL;
   tree=NULL;

   char *filename="Packfile Chunk";

   start_error_log("error.log",filename);

   p_yyin = pack_fopen_chunk (pp,FALSE);
   pack_fseek(p_yyin,0);
   yyrestart(p_yyin);
   yyparse (); // call the parser
   pack_fclose_chunk (p_yyin);

   end_error_log ();

   if(!errors)   {
      intcode = GenIntCode (tree);
      intcode->Number(1);

      vm = new VMachine;

      if(vm!=NULL)
        vm->Read();

      delete intcode;
   }

   st.clear();
   delete mem;
   return vm;

} 

void run_hrs_script(VMachine *script) {
  if(script==NULL) return;

  script->Execute();
  script->Reset();
}

void free_hrs_script(VMachine *script) {
  if(script==NULL) return;
  delete script;
}
void run_hrs_script(char *textbuffer,int length) {

   VMachine *vm;

   vm = compile_hrs_script(textbuffer,length);

   if(vm) vm->Execute();

   delete vm;

}

void run_hrs_script(char *filename) {

   VMachine *vm;

   vm = compile_hrs_script(filename);     

   if(vm) vm->Execute();

   delete vm;

}


struct hrs_func *global_hrs_funcs=NULL;

struct hrs_variable *global_hrs_variables=NULL;




#define d_func(x) ((hrs_variable *(*)x)func->func)

hrs_variable *call_hrs_func(hrs_func *func,hrs_pars *p)
{
  if(p==NULL) return NULL;
  if(func==NULL) return NULL;
  if(p->n!=func->argc) return NULL;
  hrs_variable **pars=p->pars;
  switch(func->argc) {
    case 0: return d_func(())();
    case 1: return d_func((hrs_variable *))(pars[0]);
    case 2: return d_func((hrs_variable *,hrs_variable *))(pars[0],pars[1]);
    case 3: return d_func((hrs_variable *,hrs_variable *,hrs_variable *))(pars[0],pars[1],pars[2]);
    case 4: return d_func((hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *))(pars[0],pars[1],pars[2],pars[3]);
    case 5: return d_func((hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *))(pars[0],pars[1],pars[2],pars[3],pars[4]);
    case 6: return d_func((hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *))(pars[0],pars[1],pars[2],pars[3],pars[4],pars[5]);
    case 7: return d_func((hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *))(pars[0],pars[1],pars[2],pars[3],pars[4],pars[5],pars[6]);
    case 8: return d_func((hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *))(pars[0],pars[1],pars[2],pars[3],pars[4],pars[5],pars[6],pars[7]);
    case 9: return d_func((hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *))(pars[0],pars[1],pars[2],pars[3],pars[4],pars[5],pars[6],pars[7],pars[8]);
    case 10: return d_func((hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *))(pars[0],pars[1],pars[2],pars[3],pars[4],pars[5],pars[6],pars[7],pars[8],pars[9]);
    case 11: return d_func((hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *))(pars[0],pars[1],pars[2],pars[3],pars[4],pars[5],pars[6],pars[7],pars[8],pars[9],pars[10]);
    case 12: return d_func((hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *,hrs_variable *))(pars[0],pars[1],pars[2],pars[3],pars[4],pars[5],pars[6],pars[7],pars[8],pars[9],pars[10],pars[11]);
    default: return NULL;
  }
}

hrs_func *get_hrs_func(char *name)
{
  hrs_func *search;
  search=global_hrs_funcs;

  while(search!=NULL&&(strcmp(name,search->name)!=0) )
    search=search->next;

  return search;
}

hrs_variable *get_global_var(char *name)
{
  hrs_variable *search;

  search=global_hrs_variables;

  while(search!=NULL&&(strcmp(name,search->name)!=0) )
    {search=search->next;}

  return search;
}


void remove_global_var(char *name)
{
  hrs_variable *search,*os;

  os=NULL;

  search=global_hrs_variables;

  while(search!=NULL&&(strcmp(name,search->name)!=0) )
    {os=search;search=search->next;}

  if(search!=NULL) {
    if(os==NULL)
      global_hrs_variables=search->next;
    else
      os->next=search->next;
    clear_hrs_var(search);
    delete []search->name;
    delete search;
  }
}

void set_global_var(char *name,hrs_variable *var)
{
  hrs_variable *search;

  search=get_global_var(name);

  if(search==NULL) {
    search = new hrs_variable;
    search->constant=FALSE;
    search->temp=FALSE;
    search->type=VAR_EMPTY;
    search->name=new char[strlen(name)+1];
    strcpy(search->name,name);

    search->next=global_hrs_variables;
    global_hrs_variables=search;
  }
  
  hrs_var_cpy(search,var);
  
}

void add_hrs_func(char *name,void *func,int argc)
{
  if(name[strlen(name)-1]=='%') name[strlen(name)-1]=0;
  hrs_func *search;
  search=get_hrs_func(name);

  if(search!=NULL) {
    return;
  }

  search=new hrs_func;
  search->name=new char[strlen(name)+1];
  strcpy(search->name,name);
  search->func=func;
  search->argc=argc;

  search->prev=NULL;
  search->next=global_hrs_funcs;
  global_hrs_funcs=search;
}

hrs_pars *make_par(int argc,...)
{
  static hrs_pars p;
  static hrs_variable *vars[12];
  p.n=argc;
  p.pars=vars;
  int i;

  va_list ap;
  va_start(ap,argc);
  for(i=0;i<argc;i++)
    vars[i]=va_arg(ap,hrs_variable *);
  va_end(ap);
  
  return &p;
}

void clear_globals()
{
  hrs_func *start=global_hrs_funcs;
  hrs_func *next;

  while(start!=NULL) {
    next=start->next;
    delete []start->name;
    delete start;
    start=next;
  }
  global_hrs_funcs=NULL;

  hrs_variable *vstart=global_hrs_variables;
  hrs_variable *vnext;

  while(start!=NULL) {
    vnext=vstart->next;
    clear_hrs_var(vstart);
    delete []vstart->name;
    delete vstart;
    vstart=vnext;
  }
  global_hrs_variables=NULL;

}
int clear_hrs_var(hrs_variable *a)
{
  switch(a->type) {
    case VAR_STR:
      if(a->dat.var_string)
        delete a->dat.var_string;
      break;
  }
  a->type=VAR_EMPTY;
  a->constant=FALSE;
  a->temp=FALSE;
  return 0;
}
int hrs_var_cpy(hrs_variable *a,hrs_variable *b)
{
  if(a->constant==TRUE) return FALSE;

  if(a->type!=VAR_EMPTY&&a->type!=b->type) {
   clear_hrs_var(a);
  }

  if(a->type==VAR_EMPTY) {
    a->type=b->type;
    switch(a->type) {
      case VAR_STR:
        a->dat.var_string=new String;
        break;
    }
  }

  switch(a->type) {
    case VAR_STR:
      a->dat.var_string->Assign(*b->dat.var_string);
      break;
    case VAR_INT:
      a->dat.var_int=b->dat.var_int;
      break;
    case VAR_REAL:
      a->dat.var_real=b->dat.var_real;
      break;
  }
  return 0;
}
int hrs_var_equal(hrs_variable *a,hrs_variable *b)
{
  if(a->type!=b->type) return FALSE;
  switch(a->type) {
    case VAR_STR:
      return (strcmp(a->dat.var_string->Val(),b->dat.var_string->Val())==0);
    case VAR_INT:
      return (a->dat.var_int==b->dat.var_int);
    case VAR_REAL:
      return (a->dat.var_real==b->dat.var_real);
  }

  return FALSE;
}
int get_int(hrs_variable *a)
{
  switch(a->type) {
    case VAR_INT:
      return a->dat.var_int;
    case VAR_REAL:
      return int(a->dat.var_real);
    case VAR_STR:
      return 0;
    default:
      return 0;
  };

}
float get_float(hrs_variable *a)
{
  switch(a->type) {
    case VAR_INT:
      return float(a->dat.var_int);
    case VAR_REAL:
      return a->dat.var_real;
    case VAR_STR:
      return 0.0;
    default:
      return 0.0;
  };
}
char *get_string(hrs_variable *a)
{
  static char *empty="\0";
  switch(a->type) {
    case VAR_INT:
      return empty;
    case VAR_REAL:
      return empty;
    case VAR_STR:
      return a->dat.var_string->Val();
    default:
      return empty;
  };
}
hrs_variable *make_void(void)
{
  hrs_variable *ret = new hrs_variable;
  ret->constant=TRUE;
  ret->temp=TRUE;
  ret->type=VAR_INT;
  ret->dat.var_int=0;
  return ret;
}

hrs_variable *make_int(int a)
{
  hrs_variable *ret = new hrs_variable;
  ret->constant=TRUE;
  ret->temp=TRUE;
  ret->type=VAR_INT;
  ret->dat.var_int=a;
  return ret;
}
hrs_variable *make_float(float x)
{
  hrs_variable *ret = new hrs_variable;
  ret->constant=TRUE;
  ret->temp=TRUE;
  ret->type=VAR_REAL;
  ret->dat.var_real=x;
  return ret;
};
hrs_variable *make_string(char *s)
{
  hrs_variable *ret = new hrs_variable;
  ret->constant=TRUE;
  ret->temp=TRUE;
  ret->type=VAR_STR;
  ret->dat.var_string=new String;
  ret->dat.var_string->Assign(s);
  return ret;
}

