// This code is LGPL...
#include <math.h>
#include <time.h>
#include <stdlib.h>
#include <allegro.h>
#include "alleg.h"
#include "particle.h"

class particle
{
   private:
     float x,y;
     float dx,dy;
     float rx,ry;
     float tx,ty;
     int c;
     int time; // number of steps til death
     int trans;
   public:
     int trail; // leave a trail?
     int size;  // how big.. (Note: trails and sizes > 1 don't mix)
     particle *next;
     particle(float _x,float _y,float _dx,float _dy,float _rx,float _ry,int _c,int _time,int _trail,int _trans)
     {size=1; next=NULL;x=_x; y=_y; dx=_dx;dy=_dy;rx=_rx;ry=_ry;c=_c;time=_time;trail=_trail;trans=_trans;
     tx=int(dx*trail);
     ty=int(dy*trail);
     }

     int step();
     void draw(BITMAP *bmp);
};


int particle::step()
{
  if(time>=0) {
    if(time==0) return FALSE;
    time--;

  }
  x+=dx + ((rx>0) ? float(rand()%int(rx)) : 0);
  y+=dy + ((ry>0) ? float(rand()%int(ry)) : 0);

  return TRUE;
}

void particle::draw(BITMAP *bmp)
{
   if(trans) {
     set_trans_blender(0,0,0,125);
     drawing_mode(DRAW_MODE_TRANS,NULL,0,0);
   }
   if(trail>=1) {
     line(bmp,int(x),int(y),int(x+tx),int(y+ty),c);
   }
   else if(size>1) {
     int cc,i;
     for(i=size-1;i>0;i--) {
       cc=makecol((getr(c)*(size-i))/size,(getg(c)*(size-i))/size,(getb(c)*(size-i))/size);
       circlefill(bmp,int(x),int(y),i,cc);
     }
     putpixel(bmp,int(x),int(y),c);

   }
   else
     putpixel(bmp,int(x),int(y),c);
  
   if(trans) {
     solid_mode();
   }
}

static particle *drops=NULL;
  
static int total_drops=0;
static int angle;

void add_rain_drop()
{
  if(total_drops>800) return;

  float x=float(rand()%(SCREEN_W+40))-20;
  float y=float(rand()%SCREEN_H)-60;
  float r=float(rand()%30)/10+5;
  float dx=-r*sin(angle);
  float dy=r*cos(angle);
  float t;
  if((-1*dx)>dy) {
    t=dx;
    dx=-1*dy;
    dy=-1*t;
  }

  int time = rand()%30+60;

  particle *new_drop = new particle(x,y,dx,dy,0,0,makecol(220,220,220),time,1,1);

  new_drop->next=drops;
  drops=new_drop;
  total_drops++;
}
void add_snow_flake()
{
  if(total_drops>800) return;

  float x=float(rand()%(SCREEN_W+20))-20;
  float y=float(rand()%(SCREEN_H+20))-20;
  float r=float(rand()%30)/30+1;
  float angle2=rand()%64+64;
  float dx=r*sin(angle2);
  float dy=-r*cos(angle2);
//  float t;

  int gr =rand()%196+64;
  int time = rand()%20+30;

  particle *new_drop = new particle(x,y,dx/2,dy/2,2,2,makecol(gr,gr,gr),time,0,0);
  new_drop->size=rand()%2+1;
  new_drop->next=drops;
  drops=new_drop;
  total_drops++;


}

void add_star()
{
  if(total_drops>800) return;

  float x=0;
  float y=float(rand()%(SCREEN_H+20))-20;
//  float r=1;
//  float angle2=0;
  float dx=(float(rand()%32+32))/8;
  float dy=0;
//  float t;

  int gr =rand()%196+64;
  int time = int(SCREEN_W/dx);

  particle *new_drop = new particle(x,y,dx,dy,0,0,makecol(gr,gr,gr),time,0,0);
  new_drop->size=1;
  new_drop->next=drops;
  drops=new_drop;
  total_drops++;


}

void update_particles()
{
  particle *tmp;
  particle *tmp2;
      tmp=drops;
      tmp2=NULL;

      while(tmp!=NULL) {
        if(!tmp->step()) {
          total_drops--;
          if(tmp2==NULL) {
            drops=tmp->next;
            delete tmp;
            tmp=drops;
          }
          else {
            tmp2->next=tmp->next;
            delete tmp;
            tmp=tmp2->next;
          }
          continue;
        }

        tmp2=tmp;
        tmp=tmp->next;
      }


}
void clear_particles()
{
  particle *tmp=drops,*tmp2;
  while(tmp!=NULL)
  {
    tmp2=tmp->next;
    delete tmp;
    tmp=tmp2;
  }
  drops=NULL;

}
void draw_particles(BITMAP *bmp)
{
  particle *tmp;

  tmp=drops;

  while(tmp!=NULL) {
    tmp->draw(bmp);
    tmp=tmp->next;
  }


}


void particle_init ()
{
  angle=75;
  atexit(clear_particles);   
}


