// This code is LGPL, see licence.txt for details
//
//////////////////////////
//
//  Landscape:
//
//    3d landscape designed to look like the outside in ff3(US).
//
//    Don't change this file unless you know what your doing
//
#define tile_width      32
#define tile_height     32

//#include "fortify.h"
#include <allegro.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>

#include "landscape.h"

   struct quad_f
   {
      V3D_f *v[4];
   };

   class grid3d
   {
   private:
      quad_f *grid;
      V3D_f *points;
      V3D_f *ptemp;
   
      int size_x,size_y; // x and y of grid
      BITMAP *surface;

      V3D_f *tmp[8],_tmp[8],*vtmp[8],_vtmp[8];
      int tout[8],tvc;

   public:
      BITMAP *get_surface();
      grid3d(int sx,int sy);
      ~grid3d();
      void display(BITMAP *bmp,int fog,int ptex); // draw the world on bmp
      void first_pass(int fog,double angle1,double angle2,int height); // first pass of seting up the map
   
   };
   BITMAP *grid3d::get_surface()
   {
      return surface;
   }
   grid3d::grid3d(int x,int y)
   {
      int a,i,j;
      int scale_factor=60;

      scale_factor=3840/(x+y);

      surface=create_bitmap(512,512);
      clear(surface);
      size_x=x;
      size_y=y;
      grid=new quad_f[size_x*size_y];
      points=new V3D_f[(size_x+1)*(size_y+1)];
      ptemp= new V3D_f[(size_x+1)*(size_y+1)];
   
   
      for(j=0;j<(y+1);j++)
         for(i=0;i<(x+1);i++) {
         //      points[i+j*(size_x+1)]=new V3D_f;
            points[i+j*(size_x+1)].x=((i-size_x/2)*scale_factor);
            points[i+j*(size_x+1)].y=((j-size_y/2)*scale_factor);
            points[i+j*(size_x+1)].z=0;
            points[i+j*(size_x+1)].u=(surface->w*i)/size_x;
            points[i+j*(size_x+1)].v=(surface->h*j)/size_y;
         }
      for(j=0;j<y;j++)
         for(i=0;i<x;i++) {
         #define create_vert(a,ii,jj)                           \
        grid[i+j*size_x].v[a]=&ptemp[(i+ii)+(j+jj)*(size_x+1)];
            create_vert(0,0,0);
            create_vert(1,1,0);
            create_vert(2,1,1);
            create_vert(3,0,1);
         #undef create_vert
         }

      for(a=0;a<8;a++) {
         tmp[a]=&_tmp[a];
         vtmp[a]=&_vtmp[a];
      }

   }

   grid3d::~grid3d()
   {
//      int a,b;
   
      destroy_bitmap(surface);
      delete [] ptemp;
      delete [] points;
      delete [] grid;
   }

   void grid3d::first_pass(int fog,double angle1,double angle2,int height)
   {
      int i;
//      int a;
   
      MATRIX_f roller;
      MATRIX_f camera;
      float xup=0;
      float yup=0;
      float zup=-1;
   
      float xpos=0;
      float ypos=0;
      float zpos=-height;
      float fov=48;
      float aspect=1;
   
      float xfront=0;
      float yfront=1;
      float zfront=0;
   
      get_x_rotate_matrix_f(&roller, angle2*128.0/PI);
      apply_matrix_f(&roller, xfront, yfront, zfront, &xfront, &yfront, &zfront);
   
      get_z_rotate_matrix_f(&roller, angle1*128.0/PI);
      apply_matrix_f(&roller, xfront, yfront, zfront, &xfront, &yfront, &zfront);
   
   
   /* build the camera matrix */
      get_camera_matrix_f(&camera,
                         xpos, ypos, zpos,        /* camera position */
                         xfront, yfront, zfront,  /* in-front vector */
                         xup, yup, zup,           /* up vector */
                         fov,                     /* field of view */
                         aspect);                 /* aspect ratio */
           
      for(i=0;i<(size_x+1)*(size_y+1);i++) {
         memcpy(&ptemp[i],&points[i],sizeof(V3D_f));
         apply_matrix_f(&camera,
                       ptemp[i].x, ptemp[i].y, ptemp[i].z,
                       &ptemp[i].x,&ptemp[i].y,&ptemp[i].z);
         if(fog)
            ptemp[i].c=int(MIN(MAX((800-abs(int(ptemp[i].z))),0),255));
      
      }
   }
   void grid3d::display(BITMAP *bmp,int fog,int ptex)
   {
      int i,a;

      int poly_type;
      if(fog) {
         if(ptex) poly_type=POLYTYPE_PTEX_LIT;
         else poly_type=POLYTYPE_ATEX_LIT;
         set_trans_blender(255,255,255,128);
      }
      else {
         if(ptex) poly_type=POLYTYPE_PTEX;
         else poly_type=POLYTYPE_ATEX;
      }
      set_projection_viewport(0,0,bmp->w,bmp->h);

      for(i=0;i<size_x*size_y;i++) {
         tvc=clip3d_f(poly_type,0.1,800,4,(AL_CONST V3D_f **)grid[i].v,tmp,vtmp,tout);
      
         for(a=0;a<tvc;a++)                
            persp_project_f(tmp[a]->x, tmp[a]->y, tmp[a]->z,
                           &tmp[a]->x,&tmp[a]->y);
         
      
         polygon3d_f(bmp,poly_type,surface,tvc,tmp);
      }
   }
   void draw_horizon(BITMAP *bmp) // just a temp version...
   {
      clear_to_color(bmp,makecol(0,128,255));
   }

   static grid3d *landscape;
   static int map_mode;
   static int landscape_setup = FALSE;
   static int optimize;
   static int enable_fog;
   static int grid_size; 
   void set_landscape_mode(int n)
   {
      map_mode=n;
   }

   void landscape_init()
   {
      if(landscape_setup) 
         return;

      landscape_setup=TRUE;
      grid_size=get_config_int("[3d_options]","grid_size",8);
      enable_fog=get_config_int("[3d_options]","fog",1);
      optimize=get_config_int("[3d_options]","optimize",1);

      if(grid_size<2)
        grid_size=2;

      if(grid_size>64)
        grid_size=64;

      landscape=new grid3d(grid_size,grid_size);
      map_mode=MAP_WALK;
   }
   void kill_landscape()
   {
      if(!landscape_setup) 
         return;

      set_config_int("[3d_options]","grid_size",grid_size);
      set_config_int("[3d_options]","fog",enable_fog);
      set_config_int("[3d_options]","optimize",optimize);

      landscape_setup=FALSE;
      delete landscape;
   }
   BITMAP *get_map_buffer(BITMAP *bmp)
   {
      if(map_mode>MAP_NORMAL)
         return landscape->get_surface();
      return bmp;
   }
   int first_pass(double direction,double tilt,int height)
   {
      switch(map_mode) {
         case MAP_NORMAL: // do nothing
            break;
      
         case MAP_WALK:
            landscape->first_pass(FALSE,PI,PI/4,256);
            break;

         case MAP_RIDE:
            landscape->first_pass((enable_fog==1) ? TRUE : FALSE,direction,PI/7,200);
            break;
      
         case MAP_FLY:
            landscape->first_pass((enable_fog==1) ? TRUE : FALSE,direction,tilt,height);
            break;
      
         default:
            return FALSE;
      };
      return TRUE;

   }
   int draw_landscape(BITMAP *bmp)
   {
      switch(map_mode) {
         case MAP_NORMAL: // do nothing
            break;
      
         case MAP_WALK:
            landscape->display(bmp,FALSE,(optimize>=1) ? FALSE : TRUE);
            break;

         case MAP_RIDE:
         case MAP_FLY:
            draw_horizon(bmp);
            landscape->display(bmp,(enable_fog==1) ? TRUE : FALSE,(optimize<=1) ? TRUE : FALSE);
            break;
      
         default:
            return FALSE;
      };
      return TRUE;
   }

#define makegray(x) (makecol((x),(x),(x)))
   int draw_mini_map(BITMAP *d,unsigned char *map,int size_x,int size_y,int x,int y,int sx,int sy,int cx,int cy,double direction) {
      if(map_mode==MAP_NORMAL) 
         return 1;
      float pee1=float(size_y)/float(sy);
      float pee2=float(size_x)/float(sx);
      BITMAP *temp=create_bitmap(sx-1,sy-1);
      clear(temp);
      for(float ca=0,a=0;a<sy-1;a++,ca+=pee1)
         for(float cb=size_x*int(ca+0.5),b=0;b<sx-1;b++,cb+=pee2)
            putpixel(temp,int(b),int(a),makegray(map[int(cb+0.5)]+1));
   
      circlefill(temp,int(cx/pee2/32)%sx,int(cy/pee1/32)%sy,1,makecol(128,0,0));
      putpixel(temp,int(cx/pee2/32)%sx,int(cy/pee1/32)%sy,makecol(196,0,0));
      if(map_mode>=MAP_RIDE)
         putpixel(temp,int(cx/pee2/32)%sx-int(sin(direction)*4),int(cy/pee1/32)%sy+int(cos(direction)*4),makecol(196,0,0));
   
      set_trans_blender(0,0,0,196);
      draw_trans_sprite(d,temp,x,y);
      destroy_bitmap(temp);
   
      return 0;
   }

