// This code is free!! do with it as you please
//
#include <allegro.h>
#include <fblend.h>
#include <stdio.h>
#include "menu.h"
#include "helper.h"
#include "alleg.h"
#include "dummy.h"
#include "func.h"
#include "points.h"
#include "npc.h"
#include "tile.h"
#include "layer.h"
#include "map.h"
#include "tileset.h"
#include "func.h"
#include "viewport.h"
#include "points.h"
#include "npc.h"
#include "particle.h"
#include "music.h"

#ifdef LINUX
#include <unistd.h>
#endif

void set_pass()
{     
	  //no password for our mini-rpg
      //packfile_password("password here"); // this is set only in one place so the
                               // password doesn't appear in the exe file
                               // more than once.
}

static int map_on;
static int map_hide;
int paused;
static int cont;
static int weather;
static int ending;
static viewport *v;
extern class c_map *world;
extern class mob_list *mobs;

static int skipping_frames;
static int frame_rate;
static int frame_count;
static int loop_rate;
static int loop_count;

volatile static int do_count=0;
void do_frame_count() 
{
	do_count=1;
}
END_OF_FUNCTION(do_frame_count); 


void update_game_logic()
{
  if(!map_hide&&map_on&&!paused) {
    switch(weather) {
      case 0: break;
      case 1: add_rain_drop(); add_rain_drop(); break;
      case 2: add_snow_flake(); add_snow_flake(); break;
    }                         
    //update_objects();

    update_particles();
    
    mobs->update(world);
    
    world->update();

    v->update();

    mobs->center(0,world,v);
  }
  
  music_update();

}

void redraw_buffer()
{
  //clear(buffer);
  clear_to_color(buffer,makecol(0,0,0));
  if(!map_hide&&map_on) {
    mobs->draw(buffer,world,v);
    draw_particles(buffer);
  }

  draw_objects(buffer); // the gui display even with the map off
}
      
void warp_to(char *map,int entry) // this is the main map loader
{
  int xx=0,yy=0,layer=0,m_dir;

  // Load the new map
  if(world->loadFromFile(map,TRUE)!=0){
     set_gfx_mode(GFX_TEXT,0,0,0,0);
     allegro_message("Can't load map!");
     exit(1);
  }

  // Extract information from the entry point.
  world->getEntryLocation(&xx,&yy,world->getEntryIndex(entry));
  layer=world->getEntryLayer(world->getEntryIndex(entry));
  m_dir=world->getEntryDirection(world->getEntryIndex(entry));

  mobs->clear(); // remove all old mobs

  // load new mobs here:
  world->load_mobs(mobs);

  // Setup the player character:

  mobs->add_mob(new Mobile(0,"joe",xx,yy,m_dir,layer,-1,CHAR_ISPLAYER | CHAR_VISIBLE));

  mobs->center(0,world,v); // center the view on the player character..
  
  mobs->update(world); // must run update once to ensure they are ready for drawing.
  
}

hrs_variable *wait_for_npc(hrs_variable *npc_id,hrs_variable *time_out)
{
  mobs->disable_mobs(2);
  int time=0;
  int timeout=get_int(time_out);
  int npc=get_int(npc_id);
  int done=FALSE;
                            
  if(timeout==0) return make_void();
  if(timeout<0) time=timeout-1;
              
  timer=0;
  while(time<timeout&&!done)
  {
    while(timer>0) {
      update_game_logic();
      
      if(mobs->get_npc_flag(npc,"follow")==0)
        done=TRUE;
      
      timer--;
      if(timeout>0) time ++;
    }
    redraw_buffer();
  }
    
  mobs->disable_mobs(0);
  return make_void();
}
hrs_variable *hfade_out(hrs_variable *speed)
{
   int i;
   int spd = get_int(speed) %256;
   if (map_hide==TRUE) return make_void();
   /*if(bitmap_mask_color(screen)==0) {
   
   PALETTE pal;
   PALETTE newt;
   
   get_palette(pal);
   
   if(spd<=0) spd=1;
      
   timer=0;
   
   for (i = 32; i >= 1; i -= (timer + spd)| 1) {
     timer=0;
     fade_interpolate(pal,black_palette,newt, i<<3, 0, 255);
     set_palette(newt);
     music_update();
     if(spd==0) while(timer<1);
   }
   clear(screen);
   set_palette(pal);
   } else {*/
     if(spd<=0) spd=1;
     if(spd>32) spd=32; 
     timer=0;
   
     for (i = 255; i >= 1; i -= spd) {
       timer=0;
       fblend_fade_to_color(buffer, screen, 0, 0, makecol(0,0,0),i);
       music_update();
       while(timer<1);
     }
     clear(screen);
   //}
   map_hide=TRUE; 
   return make_void();
}


hrs_variable *hfade_in(hrs_variable *speed)
{
   int i;
   int spd = get_int(speed) %256-1;  
   if (map_hide==FALSE) return make_void();
  /* if(bitmap_mask_color(screen)==0) {
   
   if(spd<=0) spd=1;
   map_hide=FALSE;
   PALETTE pal;
   PALETTE newt; 
   
   get_palette(pal);
   set_palette(black_palette);
   draw_background();
   
   timer=0;
      
   for (i = 1; i < 32; i += (spd + timer) | 1) {
     timer=0;
     fade_interpolate(black_palette,pal,newt, i<<3, 0, 255);
     set_palette(newt);
     music_update();
     if(spd==0) while(timer<1);
   }
   set_palette(pal);
   } else {*/
     map_hide=FALSE;
     draw_background();
     if(spd<=0) spd=1;
     if(spd>32) spd=32; 
     timer=0;
   
     for (i = 1; i < 255; i += spd) {
       timer=0;
       fblend_fade_to_color(buffer, screen, 0, 0, makecol(0,0,0),i);
       music_update();
       while(timer<1);
     }
   //}
   flip();
   
   
   return make_void();
}

hrs_variable *warp_to2(hrs_variable *map,hrs_variable *entry)
{
  warp_to(get_string(map),get_int(entry));
  return make_void();
}

hrs_variable *set_height(hrs_variable *i,hrs_variable *z)
{
  mobs->get_mob(get_int(i))->set_height(get_int(z),world,mobs);

  return make_void();
}

hrs_variable *reset_height(hrs_variable *i)
{
  mobs->get_mob(get_int(i))->reset_height();

  return make_void();
}

hrs_variable *get_mob_x(hrs_variable *i)
{
  return make_int(mobs->get_mob(get_int(i))->get_x());
}

hrs_variable *get_mob_y(hrs_variable *i)
{
  return make_int(mobs->get_mob(get_int(i))->get_y());
}


hrs_variable *message2(hrs_variable *text,hrs_variable *time)
{
  int w;
  int h;

  w=(SCREEN_W-get_text_width(get_string(text)))/2;
  h=(SCREEN_H-get_text_height(get_string(text)))/2;

  int t=create_text(-1,w,h,SCREEN_W-w,-1,get_string(text),0);
  
  get_input();
  
  destroy_dialog_object(t);
  
  return make_void();
}

hrs_variable *set_weather(hrs_variable *i)
{
  weather=get_int(i);
  return make_void();
}

hrs_variable *clear_weather()
{
  clear_particles();
  return make_void();
}

hrs_variable *quit_game(hrs_variable *i)
{
  cont=FALSE;
  if(get_int(i)==1) ending=FALSE;
  return make_void();
}

hrs_variable *map_on2()
{
  map_on=TRUE;
  return make_void();
}
hrs_variable *map_off2()
{
  map_on=FALSE;
  return make_void();
}
hrs_variable *set_npc_flag(hrs_variable *mob,hrs_variable *flag,hrs_variable *value)
{
  mobs->set_npc_flag(get_int(mob),get_string(flag),(get_int(value)==1));

  return make_void();
}
hrs_variable *get_npc_flag(hrs_variable *mob,hrs_variable *flag)
{
  return make_int((mobs->get_npc_flag(get_int(mob),get_string(flag))) ? 1 : 0);
}
hrs_variable *set_npc_var(hrs_variable *mob,hrs_variable *var,hrs_variable *value)
{
  mobs->set_npc_var(get_int(mob),get_string(var),get_int(value));

  return make_void();
}
hrs_variable *get_npc_var(hrs_variable *mob,hrs_variable *var)
{
  return make_int(mobs->get_npc_var(get_int(mob),get_string(var)));
}
hrs_variable *walk_to(hrs_variable *mob,hrs_variable *dest,hrs_variable *follow)
{
  Mobile *tmp=mobs->get_mob(get_int(mob));
  tmp->walk_to(get_int(dest),get_int(follow),world);
  mobs->set_npc_flag(get_int(mob),"CHAR_FOLLOW",TRUE);
  mobs->set_npc_flag(get_int(mob),"CHAR_RANDOM",FALSE);

  return make_void();

}
hrs_variable *stop_npc(hrs_variable *mob)
{
  mobs->set_npc_flag(get_int(mob),"CHAR_FOLLOW",TRUE);
  mobs->set_npc_flag(get_int(mob),"CHAR_RANDOM",FALSE);
  mobs->set_npc_var(get_int(mob),"follow",0);
  return make_void();
}
hrs_variable *wander_around(hrs_variable *mob,hrs_variable *trig)
{
  int trigger=get_int(trig);
  int x1,y1,x2,y2;
  world->getTriggerArea(trigger,&x1,&y1,&x2,&y2);
  mobs->set_npc_flag(get_int(mob),"CHAR_RANDOM",TRUE);
  mobs->set_npc_flag(get_int(mob),"CHAR_FOLLOW",FALSE);
  mobs->set_npc_var(get_int(mob),"follow",0);
  mobs->set_npc_var(get_int(mob),"ax1",x1);
  mobs->set_npc_var(get_int(mob),"ay1",y1);
  mobs->set_npc_var(get_int(mob),"ax2",x2);
  mobs->set_npc_var(get_int(mob),"ay2",y2);
  return make_void();
  
}

hrs_variable *set_tile(hrs_variable *layer,hrs_variable *x,hrs_variable *y,hrs_variable *pic)
{
	world->setPic(get_int(layer),get_int(x),get_int(y),get_int(pic));
	return make_int(0);
}
hrs_variable *set_tile2(hrs_variable *entry_point,hrs_variable *pic)
{
	int xx,yy,layer,hor,ver;
	world->getEntryLocation(&xx,&yy,world->getEntryIndex(get_int(entry_point)));
	layer=world->getEntryLayer(world->getEntryIndex(get_int(entry_point)));
    c_layer *cur_layer=world->getLayerPointer(layer);
	
	hor=xx/cur_layer->gridx();
	ver=yy/cur_layer->gridy();

    world->setPic(layer,hor,ver,get_int(pic));
	return make_int(0);
}

hrs_variable *freeze_mobs(hrs_variable *override)
{
  mobs->disable_mobs(get_int(override));
  return make_void();
}


int main()
{
  allegroinit(0); // sets up allegro and sets the screen mode.
  srand(time(NULL));
  LOCK_VARIABLE(do_count);
  LOCK_FUNCTION(do_frame_count);
  install_int_ex(do_frame_count,SECS_TO_TIMER( 1 ));
  
  add_hrs_func("freeze_mobs",(void *)freeze_mobs,1);
  add_hrs_func("set_tile",(void *)set_tile,4);
  add_hrs_func("set_tile2",(void *)set_tile2,2);
  add_hrs_func("stop_npc",(void *)stop_npc,1);
  add_hrs_func("walk_to",(void *)walk_to,3);
  add_hrs_func("wander_around",(void *)wander_around,2);
  add_hrs_func("wait_for_npc",(void *)wait_for_npc,2);
  add_hrs_func("warp_to",(void *)warp_to2,2);
  add_hrs_func("fade_in",(void *)hfade_in,1);
  add_hrs_func("fade_out",(void *)hfade_out,1);
  add_hrs_func("set_height",(void *)set_height,2);
  add_hrs_func("reset_height",(void *)reset_height,1);
  add_hrs_func("get_mob_x",(void *)get_mob_x,1);
  add_hrs_func("get_mob_y",(void *)get_mob_y,1);
  add_hrs_func("message",(void *)message2,2);
  add_hrs_func("set_weather",(void *)set_weather,1);
  add_hrs_func("clear_weather",(void *)clear_weather,0);
  add_hrs_func("quit_game",(void *)quit_game,1);
  add_hrs_func("map_on",(void *)map_on2,0);
  add_hrs_func("map_off",(void *)map_off2,0);
  add_hrs_func("set_npc_flag",(void *)set_npc_flag,3);
  add_hrs_func("get_npc_flag",(void *)get_npc_flag,2);
  add_hrs_func("set_npc_var",(void *)set_npc_var,3);
  add_hrs_func("get_npc_var",(void *)get_npc_var,2);

  v = new viewport;
  
  frame_rate=0;
  frame_count=0;
  skipping_frames=0;
  loop_rate=0;
  loop_count=0;
  v->w=SCREEN_W;
  v->h=SCREEN_H;

  cont=TRUE;
  ending=TRUE;
  weather=0;
  map_on=TRUE;
  map_hide=FALSE;
  paused=FALSE;
    
  run_hrs_script("start.hrs");  // just for example
    
  int loops=0;

  timer=0;
  skipping_frames=15;
  while(cont)
  {
        if (do_count)
	{
                loop_rate=loop_count;
                loop_count=0;
		frame_rate=frame_count;
		frame_count=0;
		do_count=0;
	}

        frame_count++;
        redraw_buffer();
        //textprintf(buffer, font, 0, 0, makecol(255,255,255),"Frame rate: %d",frame_rate);
        //textprintf(buffer, font, 0, 16, makecol(255,255,255),"Loop rate: %d",loop_rate);
        flip();
#ifdef LINUX
	usleep(1); //be nice to scheduler
#endif
	loops=timer;
        timer-=loops;
    while(loops>0)
    {
      loops--;
      loop_count++;

      update_game_logic();
      update_objects();

      if(check_key(key_menu)) {
        paused=TRUE;
        run_hrs_script("menu.hrs");
        paused=FALSE;
      }
      if(key[KEY_ESC]) cont=FALSE;

      if(key[KEY_F1]) take_shot(buffer);

    }

     
  }
  
  if(ending)
    run_hrs_script("end.hrs");


  delete v;

  return 0;
}
END_OF_MAIN();
