// This code is LGPL, see licence.txt for details
//

#include <allegro.h>
#include "alleg.h"
#include "tileset.h"
#include "helper.h"
#include "menu.h"
#include "points.h"
#include "func.h"
#include "npc.h"
#include "tile.h"
#include "layer.h"
#include "map.h"
#include "npc.h"
#include "particle.h"
#include "music.h"

//some functions to init allegro etc.
   BITMAP * buffer=NULL;
   BITMAP * background=NULL;

   DATAFILE *characters=NULL;

   class tileset Tiles;
   class c_map *world=NULL;
   class mob_list *mobs=NULL;
   static int flip_mode;

static BITMAP *front_buffer, *buffer2=NULL;


// Timer:
   volatile int timer;
   void do_timer() {
      timer++;
   }
   END_OF_FUNCTION(do_timer);



void allegroclose()
{
  if(mobs) delete mobs;
  if(world) delete world;
  NPC_exit();
  if(buffer) destroy_bitmap(buffer);
  if(background) destroy_bitmap(background);
  unload_datafile(characters);
  Tiles.free();   
  music_close();
  delete color_map;
  delete rgb_map; 
   
}
int allegroinit(int mode)
{  
      int d;
	  PALETTE pal;
      
      
      LOCK_VARIABLE(timer);
      LOCK_FUNCTION(do_timer);
      
      allegro_init();
      install_timer();
      install_keyboard();
      
      music_init();
      setup_menu();
   
      set_global_var("w",make_int(320));
      set_global_var("h",make_int(240));
      set_global_var("d",make_int(8));
	  set_global_var("speed",make_int(50));



      run_hrs_script("config.hrs");

      install_int_ex(do_timer,BPS_TO_TIMER(get_int(get_global_var("speed"))));
      d=get_int(get_global_var("d"));
	  set_color_depth(d);
	  if(set_gfx_mode(GFX_AUTODETECT,get_int(get_global_var("w")),get_int(get_global_var("h")),0,0)) {
		if(set_gfx_mode(GFX_AUTODETECT,2*get_int(get_global_var("w")),2*get_int(get_global_var("h")),0,0)) {
	      allegro_message("error setting graphics mode");
		  exit(1);
		}
		else flip_mode=3;
	  }
      else flip_mode=0;
      
      install_joystick(JOY_TYPE_AUTODETECT);
      
      set_config_file("aod.cfg");

      set_pass();
	
      color_map=new COLOR_MAP;
      rgb_map=new RGB_MAP;
	
      set_color_conversion(COLORCONV_TOTAL);
      characters=load_datafile("char.dat");

      if(!characters) {
        set_gfx_mode(GFX_TEXT,0,0,0,0);
        allegro_message("Error loading character sprites from \'char.dat\'");
        exit(1);
      }

	  
      load_frames();

      packfile_password(NULL);

      dialogs=NULL;

      set_trans_blender(0,0,0,128);

      buffer=create_bitmap(get_int(get_global_var("w")),get_int(get_global_var("h")));
      

      if(d==8)
        tileset::low_color=TRUE;
      
      background=create_bitmap(SCREEN_W,SCREEN_H);
      clear(buffer);   
      clear(background);
      text_mode(-1);

      world = new c_map;
      mobs = new mob_list;
      
      particle_init();
      NPC_init();
  
      atexit(allegroclose);
     
      return 0;
}


int flip()
{
   BITMAP *b;
   switch(flip_mode) {
     case 0:
       acquire_screen();
       blit(buffer,screen,0,0,0,0,buffer->w,buffer->h);
       release_screen();
       break;
     case 1:
       b=buffer;
       buffer=front_buffer;
       front_buffer=b;
       show_video_bitmap(front_buffer);
       break;
     case 2:
       if(poll_scroll()) break;

       b=buffer;
       buffer=buffer2;
       buffer2=front_buffer;
       front_buffer=b;
       request_video_bitmap(front_buffer);

       break;
	 case 3:
	   acquire_screen();
       stretch_blit(buffer,screen,0,0,buffer->w,buffer->h,0,0,SCREEN_W,SCREEN_H);
       release_screen();
       break;
   }
   return 0;
}

