
#define SIZE_WIDTH                      0
#define SIZE_HEIGHT                     1

#define ANIMATION_STOP                  1    //these three used for animation() in class tile
#define ANIMATION_PLAY                  2
#define ANIMATION_NEXT                  3

#define TILE_INVISIBLE                  1    //haven't really used this.... but maybe it could be handy sometimes ???
#define TILE_ISANIMATION                2   //does it have an animation?
#define TILE_PLAYANIMATION              4   //Is the animation for this tile playing?
#define TILE_STARTANIMATION             8   //Should the animation start automatically?
#define TILE_HASOWNTRANS                16
#define TILE_ANIMATIONLOOPS             32  // The animation loops
//#define TILE_HALF_BLOCKED               64  // the 32x32 area of the tile is partly blocked
//#define TILE_FULL_BLOCKED               128 // the 32x32 area of the tile is fully blocked


class c_layer;
class VMachine;

class c_tile
{
    private:
    int animation_start;
    double animation_progress;
    double animation_speed;
    int animation_length;
    int pict;
    int flags;
    int frame;
    int trans;                                    //if tile has own transparancy then use this value as transparancy
    c_layer *parent;
    char *on_load_name;
    VMachine *on_load;
    
  public:

    c_tile()
    {
        on_load_name=NULL;
		on_load=NULL;
		parent=NULL;
		animation_start=-1;
        animation_speed=0;
        animation_length=0;
        animation_progress=0;
        flags=0;
        pict=-1;
        frame=-1;
        parent=NULL;
    }
    c_tile(int p_flags, int p_pic, int p_trans,int p_animation_length,double p_animation_speed)
    {   //this controctur will probably only be used when resizing layers in map-edit-mode
        animation_progress=0;
        animation_length=p_animation_length;
        animation_speed=p_animation_speed;
        flags=p_flags;
        pict = p_pic;
        if (p_trans<0) p_trans=0;
        if (p_trans>255) p_trans=255;
        trans = p_trans;
        parent=NULL;
        frame=-1;
    }
    ~c_tile()
    {
      if(on_load_name) delete []on_load_name;
      if(on_load) free_hrs_script(on_load);
    }

    int animationDo(int p_action);
    int getSize(int p_woh);
    void setFlags(int p_flags); 			//all flags in one, for loading tiles
    inline int getFlag(int p_flag) {return (flags&p_flag);}

    inline void setFlag(int p_flag, int p_state)
    {
      if (p_state==TRUE)
	flags |=p_flag;
      if (p_state==FALSE)
	flags &=~p_flag;
    }

    void setAnimation(int p_animation_length, double p_animation_speed); //use this animation
    int getAnimationLength();
    double getAnimationSpeed();
    void setPic(int p_pic);       //use this bitmap
    int draw(BITMAP *bmp,int p_x, int p_y,int p_trans,int effect,int delta,int draw_mode=-1);
    int check_tile(BITMAP *spr,int p_x,int p_y);
//    int draw_y(BITMAP *bmp,int p_x, int p_y,int p_trans,BITMAP *t,int _x,int _y,int draw_mode=-1);
    void setTrans(int p_trans); 			//set the transparancy... -1 means use global trans
    int getTrans();
    int getFlags();
    int loadFromFile(PACKFILE *file,int version,int compile);
    int saveToFile(PACKFILE *file);
};





