#ifndef _MAP_HEADER_
#define _MAP_HEADER_

#define MAP_TRIGGERCOUNT 	50
#define MAP_ENTERCOUNT		25
#define MAP_NPCCOUNT		50
#define MAP_VERSION              11

//Flags:
#define MAP_INSIDE       1    // A inside area
#define MAP_OUTSIDE      2    // A outside area
#define MAP_WORLD        4    // A world map



struct s_trigger
{
    int x1,y1;
    int x2,y2;
    int action;                 // 0 nothing happens.
                                // 1 Player uses action key in the 
								//   right direction.
                                // 2 Player is inside. 
                                // 3 Player enters.
								// 4 Player leaves.
								// 5 Mobile or Player is inside.
                                // 6 Mobile or Player enters.
                                // 7 Mobile or Player leaves.
                                // 8 This is a mirror area.
                                
    char *script_named;         // stores the script here. 
				// once it just stored the name but the code was changed

    VMachine *script;           // Compiled version of the script.
    
    int direction;              // direction required to face with
                                // -1 any 0 north 1 east 2 south 3 west

};

struct s_enter
{                               
    int x,y;                    // the character will enter here
    int key;                    // The key to this entry point. The script
                                // engine will use goto_map("name.map",key);
    int direction;              // the character will be facing this direction
    int layer;
};

class c_map
{
  private:
    int x,y;
    int layer_count;
    c_layer * layers;
    int trigger_count;
    s_trigger triggers[MAP_TRIGGERCOUNT];
    int entry_count;
    s_enter entrys[MAP_ENTERCOUNT];
    int npc_count;
    map_char npcs[MAP_NPCCOUNT];
    char *tileset_name;
    int flags;
    char *on_load_name;
    VMachine *on_load;
    
  public:
   void setPic(int layer, int x, int y, int pic);
    int active_trigger; //used for map-editor only
    int active_entry;	//for map-editor. These three should be private, I'll do that later
    int active_trigger_part; //which part of the trigger is active?
    int active_npc;
    int active_npc_part;
    c_points *points;

    c_map()
    {
		on_load_name=NULL;
		layers=NULL;
		tileset_name=NULL;
        x=y=layer_count=trigger_count=npc_count=entry_count=flags=0;
        active_npc=active_npc_part=active_trigger=active_entry=active_trigger_part=-1;
        layers=NULL;
        tileset_name=NULL;
        points=new c_points;

    }
    int clear();
    ~c_map()
    {
        clear();
        delete points;
    }
    int getFlag(int p_flag);
    void setFlag(int p_flag,int p_state);
    void update();
    int switchTileset(char *p_name);
    int loadFromFile(char * p_name,int compile = FALSE);
    int saveToFile(char * p_name);
    int randomizeLayer(int p_number);
    int deleteLayer(int p_number);
    int insertLayer(int p_after,int p_width, int p_height);  //inserts a layer between layers[after] and layers[after+1] -1 means on top 0 means make first
    int whatNpc(int p_x,int p_y);
    int drawNpcs();
    void deleteNpc(int key);
    void moveNpc(int key,int p_x,int p_y);
    void getNpc(int key,int *name_index,int *facing,int *walk_layer,int *flags);
    int addNpc(int p_x,int p_y,char *name, int facing, int walk_layer,int flags);
    void setNpc(int key,char *name, int facing, int walk_layer,int flags);
    void setNpcScript(int key,int which,char *script);
    char *getNpcScript(int key,int which);
    void load_mobs(class mob_list *m);
    int addTrigger(int p_x1, int p_y1, int p_x2, int p_y2, int p_action, int p_direction, char * p_name);
    int addEntry(int p_x,int p_y,int p_key, int p_direction,int p_layer);
    int setEntryPoint(int p_number, int p_x,int p_y);
    int setEntry(int p_number, int p_key, int p_direction,int p_layer);
    void whatEntry(int p_x, int p_y, int * p_number);
    void getEntryLocation(int *p_x,int *p_y,int p_number);
    void drawEntrys();
    int getEntryKey(int p_number);
    int getEntryDirection(int p_number);
    int getEntryIndex(int p_key);
    int getEntryLayer(int p_number);
    int deleteEntry(int p_number);
    int getTriggerArea(int p_number,int *x1,int *y1,int *x2,int *y2);
    int setTriggerPoint(int p_number, int p_point,int p_x, int p_y); //p_point=0: left-top, 1: right-down
    int setTrigger(int p_number, int p_action,int p_direction, char * p_name);
    char * getTriggerScriptName(int p_number);
    int getTriggerAction(int p_number);
    int getTriggerDirection(int p_number);
    int deleteTrigger(int number);
    void whatTrigger(int p_x, int p_y,int * p_number,int * p_part);
    void ActivateTrigger(int p_number);
    int getTriggerCount();
    int checkTrigger(int p_num,int x,int y);
    int addEnter(int p_x, int p_y, int p_direction);
    void draw(BITMAP *bmp,int draw_mode=-1);
    void drawLayer(BITMAP *bmp,int p_number,int draw_mode=-1);
    void drawLayer_at(BITMAP *bmp,int p_number,int offset_x,int offset_y,int draw_mode=-1);
//    void drawLayer_at_y(BITMAP *bmp,int p_number,int offset_x,int offset_y,BITMAP *t,int _x,int _y,int draw_mode=-1);
    int check_tile(int layer,BITMAP *spr,int p_x,int p_y);
    void drawLayerGrid(int p_number, int p_color);
    void drawBack(int p_color);
    void drawTriggers();
    void drawMirrors_at(BITMAP *bmp,int offset_x,int offset_y);
    c_layer * getLayerPointer(int p_number);
    void scroll (int p_x, int p_y, int p_editor);
    void gotoxy (int p_x, int p_y, int p_editor=FALSE);
    void scrollLayer(int p_number,int p_x, int p_y, int p_editor);
    int countLayers();
    int countTriggers();
    int countEnters();
    int getX();
    int getY();
    c_tile * getTilePointer(int p_layer,int p_x, int p_y);

};



#endif
