#ifndef _INTCODE_H_
#define _INTCODE_H_

// The opcodes (these will probably also be our final bytecode opcodes)
enum Opcode  {
   OP_NOP,           // no operation
   OP_PUSH,          // push string [var]
   OP_GETTOP,        // get string from top of stack (=assign) [var]
   OP_DISCARD,       // discard top value from the stack
   OP_FUNCTION,      // call a function
   OP_JMP,           // unconditional jump [dest]
   OP_OR,            // jump if TRUE and don't pop the stack else pop it
   OP_AND,           // jump if FALSE and don't pop the stack else pop it
   OP_JMPF,          // jump if FALSE [dest]
   OP_JMPT,          // jump if TRUE [dest]
   OP_VAR_LESS,      // test if one var is less than another
   OP_VAR_GREATER,   // test if one var is greater than another
   OP_VAR_EQUAL,     // test whether two vars are equal
   OP_BOOL_EQUAL,    // test whether two bools are equal
   OP_BOOL_NOT,      // flip the TRUE/FALSE status
   OP_CONCAT,        // concatenate two strings
   OP_ADD,           // some number stuff...
   OP_SUB,
   OP_MUL,
   OP_DIV,
   OP_POW,
   OP_NEG,
   OP_MOD,
   JUMPTARGET        // not an opcode but a jump target;
                     // the target field points to the jump instruction
};

// Intermediate code instruction
class IntInstr {
public:
   IntInstr ()   {opcode = OP_NOP; next=NULL; target=NULL; str=NULL;}
   IntInstr (Opcode _opcode)   {opcode = _opcode; next=NULL; target=NULL; str=NULL;}
//   IntInstr (Opcode _opcode, IntInstr *_target)   {opcode = _opcode; target=_target; next=NULL; str=NULL;}
   IntInstr (Opcode _opcode, SymDesc *_str)   {opcode = _opcode;str = _str;next=NULL;target=NULL;}
   ~IntInstr() {if(this==NULL) return; if(target) delete[]target; delete next;}
   void Show ();
   void Number (int ln); // number the lines of this code block
   int  Len ()   {
      IntInstr *i = next; int cnt = 1;
      while (i != NULL)   {cnt++; i=i->next;}
      return cnt;
   }

   int       n;         // line number
   Opcode    opcode;    // the opcode
   SymDesc  *str;       // string operand
   hrs_func *call;      // function call target
   char *target;    // jump target operand
   IntInstr *next;      // the next instruction
};

IntInstr *GenIntCode (SyntTree tree);

#endif
