#ifndef _HELPER_HEADER_
#define _HELPER_HEADER_

// no more than MAX_FRAME different frame types are allowed!!!
#define MAX_FRAME 20

#ifndef PI
#ifdef M_PI
#define PI M_PI
#else
#define PI 3.14159265358979323846264338327
#endif
#endif

// this function reads if a key is pressed but it merges
// the left and right Alt, Control, and Shift keys.
// will also be able to handle joystick in the future
/*
#define check_key(x) \
(\
  ((x)==KEY_ALT) ? (key_shifts & KB_ALT_FLAG) : \
  ((x)==KEY_LCONTROL) ? (key_shifts & KB_CTRL_FLAG) : \
 ((x)==KEY_LSHIFT) ? (key_shifts & KB_SHIFT_FLAG) :  \
  (key[(x)]) \
)
*/
// the keys with their default values
// the player will be able to change them ** changed! player will
// not be able to change them....
#define key_left 0
#define key_right 1
#define key_up 2
#define key_down 3
#define key_action 4
#define key_cancel 5
#define key_menu 6
#define key_select 7


/*
extern int key_left;
extern int key_right;
extern int key_up;
extern int key_down;
extern int key_action;
extern int key_cancel;
extern int key_menu;
extern int key_select;
*/
struct frame 
{
  DATAFILE *dat;
  BITMAP *left;
  BITMAP *top_left;
  BITMAP *bottom_left;
  BITMAP *top;
  BITMAP *bottom;
  BITMAP *right;
  BITMAP *top_right;
  BITMAP *bottom_right;
  int c1,c2;
  float slope;
  frame *next;
};

extern frame frames[MAX_FRAME];
extern frame *current_frame;
extern int cf_type;

int check_key(int x);
int get_fonts();
void set_font(int n);
int font_height();
int font_length(char *text);
void load_frames();
int get_frames();
int get_current_frame();
void set_frame(int number);
void unload_frames();
void progress_bar(BITMAP *bmp,int x,int y,int w,int w2,int h,int c1,int c2);
//void fill_gradient(BITMAP *bmp,int x,int y,int c1,int c2,float slope);
void do_gradient_fill(BITMAP *bmp, int x, int y, int x1,int y1,int x2,int y2,int c1,int c2,float slope);
void display_text(BITMAP *bmp,int x,int y,int w,char *text,int nc);
int get_text_height(char *text);
int get_text_width(char *text);

#endif
