// This code is LGPL, see licence.txt for details
//
#include <math.h>
#include <allegro.h>
#include <string.h>

#include "alleg.h"

#ifdef USE_FBLEND
#include <fblend.h>
#endif

#include "tileset.h"

#ifdef SPP
#include "spp.h"
#else
#include "pmask.h"
#endif

int tileset::use_vram_solid=FALSE;
int tileset::use_vram_masked=FALSE;
int tileset::low_color=FALSE;

static int sine[64];
int tileset::first=TRUE;

void effect0(BITMAP *effect,BITMAP *source,int d2)
{
   int y,sx;

   clear_to_color(effect,bitmap_mask_color(effect));
   
   int ey=32-source->h;

   for(y=0;y<source->h;y++) {
     sx=(sine[(((y+ey)<<1)+d2)&63])+8;

     stretch_blit(source,effect,0,y,source->w,1,sx,y+8,source->w,1);
   }

   
}
void effect1(BITMAP *effect,BITMAP *source,int d2)
{
   int y,sy;

   clear_to_color(effect,bitmap_mask_color(effect));
   
   int ey=32-source->h;

   for(y=-8;y<source->h+8;y++) {
     sy=y+(sine[(((y+ey)<<1)+d2)&63]);
          
     if(sy>=0&&sy<source->h) 
       blit(source,effect,0,sy,8,y+8,source->w,1);
   }

   
}


void CalcTables()
{
  int i;
   /* Pre-calculate the sin(something)*whatever */
  for (i=0;i<64;i++)
  {
    sine[i]=(int)((sin(i*(6.28318531/64)))*4+0.5);
  }
}

void tileset::stop_effect()
{
  // empty
}           

void tileset::apply_effect(int pic,int frame,int effect,int delta,int y)
{
  
  if(effect==tiles[pic].tile[frame].id) {
    if(effect==0) return;
    if(delta==tiles[pic].tile[frame].delta) return;
  }

  tiles[pic].tile[frame].id=effect;
  tiles[pic].tile[frame].delta=delta;

  BITMAP *tmp=tiles[pic].tile[frame].base;
  BITMAP *tmp2=tiles[pic].tile[frame].effect;

  if(!tmp2) return;

  switch(effect) {
    case 0:
      blit(tmp,tmp2,0,0,0,0,tmp->w,tmp->h);
      return;
    case 1:
      effect0(tmp2,tmp,delta);
      return;
    case 2:
      effect1(tmp2,tmp,delta);
      return;
  }
}

void tileset::draw(BITMAP *bmp,int pic,int frame,int p_x,int p_y,int trans,int effect,int delta,int draw_mode)
{   
  BITMAP *pict;
  
  int solid;
  
  if(trans>0) {
    if(draw_mode==0) return; 
    if(trans==255) return; // invisible
  }
  else if(draw_mode==1) return;
  
  if(pic<0||pic>=size) return;

  if(frame<0) frame=0;
  if(frame>=tiles[pic].length) return;

  apply_effect(pic,frame,0,0,p_y);

  if(trans==0&&tiles[pic].tile[frame].effect)
    pict=tiles[pic].tile[frame].effect; 
  else
    pict=tiles[pic].tile[frame].base; 

  solid=tiles[pic].tile[frame].solid;
      
  if(!pict) return;
  
  if(trans>0) {
    #ifdef USE_FBLEND
    if(!low_color) 
      fblend_trans(pict,bmp,p_x-pict->w,p_y-pict->h,(255-trans)%255);
    else
    #endif 
      draw_trans_sprite(pict,bmp,p_x-pict->w,p_y-pict->h);
  }
  else if (solid)
    blit(pict,bmp,0,0,p_x-pict->w,p_y-pict->h,pict->w,pict->h);
  else  
    masked_blit(pict,bmp,0,0,p_x-pict->w,p_y-pict->h,pict->w,pict->h);
}
#ifndef SPP
PMASK *check_cache(BITMAP *bmp)
{
  static BITMAP *bmp2=NULL;
  static PMASK p;

  if(bmp!=bmp2) {
    bmp2=bmp;
    init_allegro_pmask(&p, bmp);
  }

  return &p;

}
#endif
int tileset::check_mask(int pic,int x1,int y1,BITMAP *spr2,int x2,int y2)
{
  BITMAP *pict;
  PMASK *spr2_mask;

  if(pic<0||pic>=size) return FALSE;

  pict=tiles[pic].tile[0].base;

  if(!pict) return TRUE;
#ifdef SPP
  return spp_detect_collision(x1-pict->w,y2-pict->h,pict,x2,y2,spr2);
#else
  spr2_mask=check_cache(spr2);

  return check_pmask_collision(tiles[pic].tile[0].mask, spr2_mask, x1-pict->w,y2-pict->h, x2,y2);
#endif
}

int tileset::get_count()
{
  return size;

}
int tileset::check(char *_name)
{
  if(!_name||!name) return FALSE;
  return (strcmp(name,_name)==0);
}
void tileset::free()
{            
  int i,j;
  if(name) delete []name;

  if(tiles) {
    for(i=0;i<size;i++) {
      for(j=0;j<tiles[i].length;j++)
          destroy_bitmap(tiles[i].tile[j].effect);
      
    }
    delete []tiles;
  }
  if(dat) unload_datafile(dat);

  dat=NULL;
  name=NULL;
  tiles=NULL;
}

unsigned char check_image(BITMAP *bmp)
{
  static int bx1, by1, bx2, by2, bx3, by3 ; // Our rectangular intersection points

  static int x, y, lenx, leny ;  // Used for the detection loop

  static short **sl1,*sw1,c;


  if(bitmap_color_depth(bmp)==15)
    c=MASK_COLOR_15;
  else
    c=MASK_COLOR_16;
     

  lenx=bmp->w;
  leny=bmp->h;

  sl1=((short **)bmp->line);

    // Now, do pixel-perfect detection on the intersection rectangle
  for (y = 0; y < leny; y++,sl1++) {
    sw1=*sl1+bx2;
    for (x = 0; x < lenx; x++,sw1++)
      if (*sw1 == c) 
          return 0;
  }
    
          
  return 1;
}

void tileset::load(char *_name)
{
  int i,j,k;
  DATAFILE *tmp;

  if(!_name||!exists(_name)) {
    set_gfx_mode(GFX_TEXT,0,0,0,0);
    allegro_message("Error! Can't find tileset: %s",_name);
    exit(1);
  }

  if(check(_name)) return;

  set_pass();                   

  free();       

  set_color_conversion(COLORCONV_TOTAL|COLORCONV_DITHER);

  dat=load_datafile(_name);
  name=new char[strlen(_name)+1];
  strcpy(name,_name);           
  
  size=0;
  for(i=0;dat[i].type!=DAT_END;i++) {
    switch(dat[i].type) {
      case DAT_BITMAP:
        size++; 
        break;
      case DAT_FILE:
        size++;
        break;
	  case DAT_PALETTE:
		set_palette((RGB *)dat[i].dat);
		create_rgb_table(rgb_map, (RGB *)dat[i].dat, NULL);
        set_color_conversion(COLORCONV_TOTAL);
        create_trans_table(color_map, (RGB *)dat[i].dat, 128, 128, 128, NULL);
      	break;
    }    
  }
  unload_datafile(dat);
  dat=load_datafile(_name);
  tiles = new t_tile [size];

  for(i=0,j=0;dat[i].type!=DAT_END;i++) {    
    switch(dat[i].type) {
      case DAT_BITMAP:
        tiles[j].length=1;
        tiles[j].tile=new tt_tile[1];
        tiles[j].tile[0].base=(BITMAP *)dat[i].dat;
        tiles[j].tile[0].solid=FALSE;
        #ifndef SPP
        tiles[j].tile[0].mask=create_allegro_pmask((BITMAP *)dat[i].dat);
        #endif
        if(tiles[j].tile[0].solid&&use_vram_solid) tiles[j].tile[0].effect=create_video_bitmap(tiles[j].tile[0].base->w,tiles[j].tile[0].base->h);
        else if(!tiles[j].tile[0].solid&&use_vram_masked) tiles[j].tile[0].effect=create_video_bitmap(tiles[j].tile[0].base->w,tiles[j].tile[0].base->h);
        else tiles[j].tile[0].effect=create_bitmap(tiles[j].tile[0].base->w,tiles[j].tile[0].base->h);
        tiles[j].tile[0].id=-1;
		j++;
        break;
      case DAT_FILE:
        tiles[j].length=0;
        tmp=(DATAFILE *)dat[i].dat;
        for(k=0;tmp[k].type==DAT_BITMAP;k++)
          tiles[j].length++;
        if(tiles[j].length==0) {j--;break;}
        tiles[j].tile=new tt_tile[tiles[j].length];
        for(k=0;tmp[k].type==DAT_BITMAP;k++) {
          
          #ifndef SPP
          if(k==0) tiles[j].tile[0].mask=create_allegro_pmask((BITMAP *)tmp[k].dat);
          #endif

          tiles[j].tile[k].base=(BITMAP *)tmp[k].dat;
          tiles[j].tile[k].solid=FALSE;
          if(tiles[j].tile[k].solid&&use_vram_solid) tiles[j].tile[k].effect=create_video_bitmap(tiles[j].tile[k].base->w,tiles[j].tile[k].base->h);
          else if(!tiles[j].tile[k].solid&&use_vram_masked) tiles[j].tile[k].effect=create_video_bitmap(tiles[j].tile[k].base->w,tiles[j].tile[k].base->h);
          else tiles[j].tile[k].effect=create_bitmap(tiles[j].tile[k].base->w,tiles[j].tile[k].base->h);;
          tiles[j].tile[k].id=-1;
        }
		j++;
        break;
      
    }
  }

  packfile_password(NULL);

}

