// This code is LGPL, see licence.txt for details
//

#include <stdio.h>
#include <string.h>
#include <allegro.h>
#include "alleg.h"
#include "func.h"
#include "points.h"
#include "npc.h"

#include "tile.h"
#include "layer.h"
#include "map.h"
#include "vm.h"

static int face_dir[8] = { 2,3,3,3,0,1,1,1 };

static char map_format[5] = "nbmf";

#ifndef errno
int errno;
#endif

int c_map::saveToFile(char * p_name)
{
    int i;
    PACKFILE * file;

    file = pack_fopen(p_name,F_WRITE_PACKED);
    if (!file)
    {
        
        return -1;
    }
    //write header/////////

    pack_fwrite(map_format,4,file); //Nathan and Bram's Map File
    pack_iputl(MAP_VERSION,file); 

    file=pack_fopen_chunk(file,FALSE);

    pack_iputl(x,file);
    pack_iputl(y,file);
    pack_iputl(layer_count,file);
    pack_iputl(trigger_count,file);
    pack_iputl(entry_count,file);
    pack_iputl(npc_count,file);

    pack_iputl(flags,file);
    int l=strlen(tileset_name);
    pack_iputl(l,file);
    pack_fwrite(tileset_name,l,file);
    if(on_load_name)
      l=strlen(on_load_name);
    else l=0;
    pack_iputl(l,file);
    if(l>0) pack_fwrite(on_load_name,l,file);
    


    file=pack_fclose_chunk(file);

    file=pack_fopen_chunk(file,FALSE);

    ///write all layers
    for (i=0;i<layer_count;i++)
    {
	layers[i].saveToFile(file);
    }

    file=pack_fclose_chunk(file);
    file=pack_fopen_chunk(file,FALSE);

    for(i=0;i<trigger_count;i++)
    {
	pack_iputl(triggers[i].x1,file);
	pack_iputl(triggers[i].y1,file);
	pack_iputl(triggers[i].x2,file);
	pack_iputl(triggers[i].y2,file);
	pack_iputl(triggers[i].action,file);
	pack_iputl(triggers[i].direction,file);

        
	int str_len;
        if(triggers[i].script_named) 
          str_len = strlen(triggers[i].script_named);
        else str_len=-1;

	pack_iputl(str_len,file);

	file=pack_fopen_chunk(file,FALSE);
        if(str_len>0)
          pack_fwrite(triggers[i].script_named,str_len,file);
        file=pack_fclose_chunk(file);

    }

    file=pack_fclose_chunk(file);

    file=pack_fopen_chunk(file,FALSE);

    for(i=0;i<entry_count;i++)
    {
	pack_iputl(entrys[i].x,file);
	pack_iputl(entrys[i].y,file);
	pack_iputl(entrys[i].key,file);
	pack_iputl(entrys[i].direction,file); 
        pack_iputl(entrys[i].layer,file);
    }

    file=pack_fclose_chunk(file);

    file=pack_fopen_chunk(file,FALSE);

    points->save(file);

    file=pack_fclose_chunk(file);
    
    file=pack_fopen_chunk(file,FALSE);

    for(i=0;i<npc_count;i++)
    {
	pack_iputl(npcs[i].key,file);
	pack_iputl(npcs[i].x,file);
	pack_iputl(npcs[i].y,file);
	pack_iputl(npcs[i].facing,file);
	pack_iputl(npcs[i].walk_layer,file);
	pack_iputl(npcs[i].flags,file);

        if(!npcs[i].datafile_name)
          pack_iputl(-1,file);
        else {
          pack_iputl(strlen(npcs[i].datafile_name),file);
          file=pack_fopen_chunk(file,FALSE);
          pack_fwrite(npcs[i].datafile_name,strlen(npcs[i].datafile_name),file);
          file=pack_fclose_chunk(file);

        }

        if(!npcs[i].init_script)
          pack_iputl(-1,file);
        else {
          pack_iputl(strlen(npcs[i].init_script),file);
          file=pack_fopen_chunk(file,FALSE);
          pack_fwrite(npcs[i].init_script,strlen(npcs[i].init_script),file);
          file=pack_fclose_chunk(file);
        }

        if(!npcs[i].action_script)
          pack_iputl(-1,file);
        else {
          pack_iputl(strlen(npcs[i].action_script),file);
          file=pack_fopen_chunk(file,FALSE);
          pack_fwrite(npcs[i].action_script,strlen(npcs[i].action_script),file);
          file=pack_fclose_chunk(file);
        }

        if(!npcs[i].player_script)
          pack_iputl(-1,file);
        else {
          pack_iputl(strlen(npcs[i].player_script),file);
          file=pack_fopen_chunk(file,FALSE);
          pack_fwrite(npcs[i].player_script,strlen(npcs[i].player_script),file);
          file=pack_fclose_chunk(file);
        }

        if(!npcs[i].logic_script)
          pack_iputl(-1,file);
        else {
          pack_iputl(strlen(npcs[i].logic_script),file);
          file=pack_fopen_chunk(file,FALSE);
          pack_fwrite(npcs[i].logic_script,strlen(npcs[i].logic_script),file);
          file=pack_fclose_chunk(file);
        }
    }

    file=pack_fclose_chunk(file);


    //todo save the rest!!!
    pack_fclose(file);
    return 0;
}

#define pick_tileset()  {     \
    char tempf[50],*tempy;     \
    while((!tileset_name||!exists(tileset_name))&&!key[KEY_ESC]) {  \
      if(tileset_name)      \
        delete []tileset_name; \
      tileset_name=NULL;     \
                             \
      strcpy(tempf,"*.dat");  \
                               \
      if(file_select("Pick Tileset", tempf, "DAT")) { \
        tempy = get_filename(tempf);      \
        tileset_name=new char[strlen(tempy)+1];\
        strcpy(tileset_name,tempy);            \
      }  \
          \
    }      \
    if(!key[KEY_ESC]) \
      Tiles.load(tileset_name);\
    }

int c_map::switchTileset(char *p_name)
  {
    if(!exists(p_name)) return -1;
    p_name = get_filename(p_name);

    tileset_name=new char[strlen(p_name)+1];
    strcpy(tileset_name,p_name);

    Tiles.load(tileset_name);



    return 0;
  }

int c_map::clear()
{
  int i;
  if(!tileset_name)
    delete []tileset_name;
  
  while(layer_count>0)
    deleteLayer(0);

  for(i=0;i<npc_count;i++) {
    if(npcs[i].datafile_name)
      delete []npcs[i].datafile_name;
    if(npcs[i].init_script)
      delete []npcs[i].init_script;
    if(npcs[i].action_script)
      delete []npcs[i].action_script;
    if(npcs[i].logic_script)
      delete []npcs[i].logic_script;
    if(npcs[i].player_script)
      delete []npcs[i].player_script;
    if(npcs[i].is)
      delete npcs[i].is;
    if(npcs[i].as)
      delete npcs[i].as;
    if(npcs[i].ls)
      delete npcs[i].ls;
    if(npcs[i].ps)
      delete npcs[i].ps;
    
    if(on_load_name) delete []on_load_name;
    if(on_load) free_hrs_script(on_load);
  }

  x=y=npc_count=layer_count=trigger_count=entry_count=flags=0;
  active_npc=active_npc_part=active_trigger=active_entry=active_trigger_part=-1;
  layers=NULL;
  tileset_name=NULL;

  return 0;
}
void c_map::setFlag(int p_flag, int p_state)
{
    if (p_state==TRUE)
       flags |=p_flag;
    if (p_state==FALSE)
       flags &=~p_flag;
}
int c_map::getFlag(int p_flag)
{
    return (int)(p_flag&flags);
}
int c_map::loadFromFile(char * p_name,int compile)
{
    int i;
    PACKFILE * file;
    file = pack_fopen(p_name, F_READ_PACKED);
    if (!file)
    {
	//error, couldn't open file!!!!
	  return -1;
    }
    //delete everything from memory

    //read header/////////
    char header[6];

    pack_fread(header,4,file); //Nathan and Bram's Map File
    header[4]=0;
    if(strcmp(header,map_format)!=0) return -2; // not our file!!

    int version;

    version=pack_igetl(file);

    clear();
    points->clear();
    on_load_name=NULL;
    on_load=NULL;
    
    if(compile==TRUE && version < MAP_VERSION) {
      set_gfx_mode(GFX_TEXT,0,0,0,0);
      allegro_message("Old map format found.\n It must be converted to the newest version!\n");
      exit(1);
    }

    switch (version)
    {
	case 1: {
	    file=pack_fopen_chunk(file,FALSE);

	    x=pack_igetl(file);
	    y=pack_igetl(file);
	    layer_count=pack_igetl(file);
	    trigger_count=pack_igetl(file);
	    entry_count=pack_igetl(file);
	    flags=pack_igetl(file);

            pick_tileset();

	    file=pack_fclose_chunk(file);

	    file=pack_fopen_chunk(file,FALSE);


	    ///read all layers
	    layers = new c_layer[layer_count];

	    for (int i=0;i<layer_count;i++)
		{
			layers[i].loadFromFile(file,version,compile);
		}

	    file=pack_fclose_chunk(file);

	break;
	}
	case 2: {
	    file=pack_fopen_chunk(file,FALSE);

	    x=pack_igetl(file);
	    y=pack_igetl(file);
	    layer_count=pack_igetl(file);
	    trigger_count=pack_igetl(file);
	    entry_count=pack_igetl(file);
	    flags=pack_igetl(file);

        pick_tileset();

	    file=pack_fclose_chunk(file);

	    file=pack_fopen_chunk(file,FALSE);


	    ///read all layers
	    layers = new c_layer[layer_count];

	    for (int i=0;i<layer_count;i++)
		{
			layers[i].loadFromFile(file,version,compile);
		}

	    file=pack_fclose_chunk(file);

	break;
	}
	case 3: {
	    file=pack_fopen_chunk(file,FALSE);

	    x=pack_igetl(file);
	    y=pack_igetl(file);
	    layer_count=pack_igetl(file);
	    trigger_count=pack_igetl(file);
	    entry_count=pack_igetl(file);
	    flags=pack_igetl(file);

            pick_tileset();

	    file=pack_fclose_chunk(file);

	    file=pack_fopen_chunk(file,FALSE);


	    ///read all layers
	    layers = new c_layer[layer_count];

            for (i=0;i<layer_count;i++)
		{
			layers[i].loadFromFile(file,version,compile);
		}

	    file=pack_fclose_chunk(file);

	    file=pack_fopen_chunk(file,FALSE);

	    for (i=0;i<trigger_count;i++)
		{
			triggers[i].x1=pack_igetl(file);
			triggers[i].y1=pack_igetl(file);
			triggers[i].x2=pack_igetl(file);
			triggers[i].y2=pack_igetl(file);
			triggers[i].action=pack_igetl(file);
			triggers[i].direction=pack_igetl(file);

			int str_len = pack_igetl(file);

			triggers[i].script_named=new char[str_len+1];

                        if(str_len>0) {
			  pack_fread(triggers[i].script_named,str_len,file);
					 triggers[i].script_named[str_len]=0;
			}

		}

	    file=pack_fclose_chunk(file);
	    file=pack_fopen_chunk(file,FALSE);

	    for (i=0;i<entry_count;i++)
		{
			entrys[i].x=pack_igetl(file);
			entrys[i].y=pack_igetl(file);
			entrys[i].key=pack_igetl(file);
			entrys[i].direction=pack_igetl(file);

		}

	    file=pack_fclose_chunk(file);


	break;
	}
        case 4: case 5: {
	    file=pack_fopen_chunk(file,FALSE);

	    x=pack_igetl(file);
	    y=pack_igetl(file);
	    layer_count=pack_igetl(file);
	    trigger_count=pack_igetl(file);
	    entry_count=pack_igetl(file);
	    flags=pack_igetl(file);
            int l=pack_igetl(file);

            if(l>0) {
              char tempf[50],*tempy;
              pack_fread(tempf,l,file);
              tempf[l]=0;
              tempy=get_filename(tempf);
              
              tileset_name=new char[strlen(tempy)+1];
              strcpy(tileset_name,tempy);
            }
            else 
              pick_tileset();
            
            Tiles.load(tileset_name);

	    file=pack_fclose_chunk(file);

	    file=pack_fopen_chunk(file,FALSE);


	    ///read all layers
	    layers = new c_layer[layer_count];

            for (i=0;i<layer_count;i++)
		{
			layers[i].loadFromFile(file,version,compile);
		}

	    file=pack_fclose_chunk(file);

	    file=pack_fopen_chunk(file,FALSE);

	    for (i=0;i<trigger_count;i++)
		{
			triggers[i].x1=pack_igetl(file);
			triggers[i].y1=pack_igetl(file);
			triggers[i].x2=pack_igetl(file);
			triggers[i].y2=pack_igetl(file);
			triggers[i].action=pack_igetl(file);
			triggers[i].direction=pack_igetl(file);

			int str_len = pack_igetl(file);

			triggers[i].script_named=new char[str_len+1];

                        if(str_len>0) {
			  pack_fread(triggers[i].script_named,str_len,file);
				 triggers[i].script_named[str_len]=0;
			}

		}

	    file=pack_fclose_chunk(file);
	    file=pack_fopen_chunk(file,FALSE);

	    for (i=0;i<entry_count;i++)
		{
			entrys[i].x=pack_igetl(file);
			entrys[i].y=pack_igetl(file);
			entrys[i].key=pack_igetl(file);
			entrys[i].direction=pack_igetl(file);

		}

	    file=pack_fclose_chunk(file);


	break;
	}
        case 6: {
	    file=pack_fopen_chunk(file,FALSE);

	    x=pack_igetl(file);
	    y=pack_igetl(file);
	    layer_count=pack_igetl(file);
	    trigger_count=pack_igetl(file);
	    entry_count=pack_igetl(file);
	    flags=pack_igetl(file);
            int l=pack_igetl(file);

            if(l>0) {
              char tempf[50],*tempy;
              pack_fread(tempf,l,file);
              tempf[l]=0;
              tempy=get_filename(tempf);
              
              tileset_name=new char[strlen(tempy)+1];
              strcpy(tileset_name,tempy);
            }
            else 
              pick_tileset();
            
            Tiles.load(tileset_name);

	    file=pack_fclose_chunk(file);

	    file=pack_fopen_chunk(file,FALSE);


	    ///read all layers
	    layers = new c_layer[layer_count];

            for (i=0;i<layer_count;i++)
		{
			layers[i].loadFromFile(file,version,compile);
		}

	    file=pack_fclose_chunk(file);

	    file=pack_fopen_chunk(file,FALSE);

	    for (i=0;i<trigger_count;i++)
		{
			triggers[i].x1=pack_igetl(file);
			triggers[i].y1=pack_igetl(file);
			triggers[i].x2=pack_igetl(file);
			triggers[i].y2=pack_igetl(file);
			triggers[i].action=pack_igetl(file);
			triggers[i].direction=pack_igetl(file);

			int str_len = pack_igetl(file);

			triggers[i].script_named=new char[str_len+1];

                        if(str_len>0) {
                            pack_fread(triggers[i].script_named,str_len,file);
							triggers[i].script_named[str_len]=0;
						}
                   }

	    file=pack_fclose_chunk(file);
	    file=pack_fopen_chunk(file,FALSE);

	    for (i=0;i<entry_count;i++)
		{
			entrys[i].x=pack_igetl(file);
			entrys[i].y=pack_igetl(file);
			entrys[i].key=pack_igetl(file);
			entrys[i].direction=pack_igetl(file);
                        entrys[i].layer=pack_igetl(file);

		}

	    file=pack_fclose_chunk(file);


	break;
	}
        case 7: {
	    file=pack_fopen_chunk(file,FALSE);

	    x=pack_igetl(file);
	    y=pack_igetl(file);
	    layer_count=pack_igetl(file);
	    trigger_count=pack_igetl(file);
	    entry_count=pack_igetl(file);
	    flags=pack_igetl(file);
            int l=pack_igetl(file);

            if(l>0) {
              char tempf[50],*tempy;
              pack_fread(tempf,l,file);
              tempf[l]=0;
              tempy=get_filename(tempf);
              
              tileset_name=new char[strlen(tempy)+1];
              strcpy(tileset_name,tempy);
            }
            else 
              pick_tileset();
            
            Tiles.load(tileset_name);

	    file=pack_fclose_chunk(file);

	    file=pack_fopen_chunk(file,FALSE);


	    ///read all layers
	    layers = new c_layer[layer_count];

            for (i=0;i<layer_count;i++)
		{
			layers[i].loadFromFile(file,version,compile);
		}

	    file=pack_fclose_chunk(file);

	    file=pack_fopen_chunk(file,FALSE);

	    for (i=0;i<trigger_count;i++)
		{
			triggers[i].x1=pack_igetl(file);
			triggers[i].y1=pack_igetl(file);
			triggers[i].x2=pack_igetl(file);
			triggers[i].y2=pack_igetl(file);
			triggers[i].action=pack_igetl(file);
			triggers[i].direction=pack_igetl(file);

			int str_len = pack_igetl(file);

			if(compile==TRUE&&str_len!=-1) {
                          triggers[i].script=compile_chunk(file);
                          triggers[i].script_named=NULL;
                        }
                        else {
                          triggers[i].script=NULL;
                          file=pack_fopen_chunk(file,FALSE);
                          if(str_len>0) {
                              triggers[i].script_named=new char[str_len+1];
                              pack_fread(triggers[i].script_named,str_len,file);
                          	 triggers[i].script_named[str_len]=0;
                          } else triggers[i].script_named=NULL;
                          file=pack_fclose_chunk(file);
                        }
	    
		}

	    file=pack_fclose_chunk(file);
	    file=pack_fopen_chunk(file,FALSE);

	    for (i=0;i<entry_count;i++)
		{
			entrys[i].x=pack_igetl(file);
			entrys[i].y=pack_igetl(file);
			entrys[i].key=pack_igetl(file);
			entrys[i].direction=pack_igetl(file);
                        entrys[i].layer=pack_igetl(file);

		}

	    file=pack_fclose_chunk(file);


	break;
	}
        case 8: {
	    file=pack_fopen_chunk(file,FALSE);

	    x=pack_igetl(file);
	    y=pack_igetl(file);
	    layer_count=pack_igetl(file);
	    trigger_count=pack_igetl(file);
	    entry_count=pack_igetl(file);
	    flags=pack_igetl(file);
            int l=pack_igetl(file);

            if(l>0) {
              char tempf[50],*tempy;
              pack_fread(tempf,l,file);
              tempf[l]=0;
              tempy=get_filename(tempf);
              
              tileset_name=new char[strlen(tempy)+1];
              strcpy(tileset_name,tempy);
            }
            else 
              pick_tileset();
            
            Tiles.load(tileset_name);

	    file=pack_fclose_chunk(file);

	    file=pack_fopen_chunk(file,FALSE);


	    ///read all layers
	    layers = new c_layer[layer_count];

            for (i=0;i<layer_count;i++)
		{
			layers[i].loadFromFile(file,version,compile);
		}

	    file=pack_fclose_chunk(file);

	    file=pack_fopen_chunk(file,FALSE);

	    for (i=0;i<trigger_count;i++)
		{
			triggers[i].x1=pack_igetl(file);
			triggers[i].y1=pack_igetl(file);
			triggers[i].x2=pack_igetl(file);
			triggers[i].y2=pack_igetl(file);
			triggers[i].action=pack_igetl(file);
			triggers[i].direction=pack_igetl(file);

			int str_len = pack_igetl(file);

			if(compile==TRUE&&str_len!=-1) {
                          triggers[i].script=compile_chunk(file);
                          triggers[i].script_named=NULL;
                        }
                        else {
                          triggers[i].script=NULL;
                          file=pack_fopen_chunk(file,FALSE);
                          if(str_len>0) {
                              triggers[i].script_named=new char[str_len+1];
                              pack_fread(triggers[i].script_named,str_len,file);
                          	 triggers[i].script_named[str_len]=0;
                          } else triggers[i].script_named=NULL;
                          file=pack_fclose_chunk(file);
                        }
	    
		}

	    file=pack_fclose_chunk(file);
	    file=pack_fopen_chunk(file,FALSE);

	    for (i=0;i<entry_count;i++)
		{
			entrys[i].x=pack_igetl(file);
			entrys[i].y=pack_igetl(file);
			entrys[i].key=pack_igetl(file);
			entrys[i].direction=pack_igetl(file);
                        entrys[i].layer=pack_igetl(file);

		}

	    file=pack_fclose_chunk(file);

            file=pack_fopen_chunk(file,FALSE);
            
            points->load(file);

            file=pack_fclose_chunk(file);


	break;
	}
        case 9: case 10: case 11: {
	    file=pack_fopen_chunk(file,FALSE);

	    x=pack_igetl(file);
	    y=pack_igetl(file);
	    layer_count=pack_igetl(file);
	    trigger_count=pack_igetl(file);
	    entry_count=pack_igetl(file);
        npc_count=pack_igetl(file);

	    flags=pack_igetl(file);
        int l=pack_igetl(file);

        if(l>0) {
           char tempf[50],*tempy;
           pack_fread(tempf,l,file);
           tempf[l]=0;
           tempy=get_filename(tempf);
              
           tileset_name=new char[strlen(tempy)+1];
           strcpy(tileset_name,tempy);
        }
        else 
           pick_tileset();
        
        if(version>10) {
          l=pack_igetl(file);

          if(l>0) {
            char tempf[50],*tempy;
            pack_fread(tempf,l,file);
            tempf[l]=0;
            tempy=get_filename(tempf);
              
            on_load_name=new char[strlen(tempy)+1];
            strcpy(on_load_name,tempy);
          }
          else on_load_name=NULL;
          
          if(compile&&on_load_name) {
            on_load=compile_hrs_script(on_load_name);
          } else on_load=NULL;
        }
            
        Tiles.load(tileset_name);

	    file=pack_fclose_chunk(file);

	    file=pack_fopen_chunk(file,FALSE);


	    ///read all layers
	    layers = new c_layer[layer_count];

            for (i=0;i<layer_count;i++)
		{
			layers[i].loadFromFile(file,version,compile);
		}

	    file=pack_fclose_chunk(file);

	    file=pack_fopen_chunk(file,FALSE);

	    for (i=0;i<trigger_count;i++)
		{
			triggers[i].x1=pack_igetl(file);
			triggers[i].y1=pack_igetl(file);
			triggers[i].x2=pack_igetl(file);
			triggers[i].y2=pack_igetl(file);
			triggers[i].action=pack_igetl(file);
			triggers[i].direction=pack_igetl(file);

			int str_len = pack_igetl(file);

			if(compile&&str_len!=-1) {
                          triggers[i].script=compile_chunk(file);
                          triggers[i].script_named=NULL;
                        }
                        else {
                          triggers[i].script=NULL;
                          file=pack_fopen_chunk(file,FALSE);
                          if(str_len>0) {
                              triggers[i].script_named=new char[str_len+1];
                              pack_fread(triggers[i].script_named,str_len,file);
                          	 triggers[i].script_named[str_len]=0;
                          } else triggers[i].script_named=NULL;
                          file=pack_fclose_chunk(file);
                        }
	    
		}

	    file=pack_fclose_chunk(file);
	    file=pack_fopen_chunk(file,FALSE);

	    for (i=0;i<entry_count;i++)
		{
			entrys[i].x=pack_igetl(file);
			entrys[i].y=pack_igetl(file);
			entrys[i].key=pack_igetl(file);
			entrys[i].direction=pack_igetl(file);
                        entrys[i].layer=pack_igetl(file);

		}

	    file=pack_fclose_chunk(file);

            file=pack_fopen_chunk(file,FALSE);
            
            points->load(file);

            file=pack_fclose_chunk(file);
    
            file=pack_fopen_chunk(file,FALSE);

            for(i=0;i<npc_count;i++)
            {
		npcs[i].key=pack_igetl(file);
                for(int j=0;j<i;j++) 
                  if(npcs[i].key==npcs[j].key) {
                     npcs[i].key++; 
                     j=0;
                  }
                
		npcs[i].x=pack_igetl(file);
		npcs[i].y=pack_igetl(file);
		npcs[i].facing=pack_igetl(file);
		npcs[i].walk_layer=pack_igetl(file);
		npcs[i].flags=pack_igetl(file);

		int str_len = pack_igetl(file);

                if(str_len>0) {
                  file=pack_fopen_chunk(file,FALSE);
                  npcs[i].datafile_name=new char[str_len+1];
                  pack_fread(npcs[i].datafile_name,str_len,file);
		  npcs[i].datafile_name[str_len]=0;
                  file=pack_fclose_chunk(file);
                  npcs[i].pict=(BITMAP *)(
                    ((DATAFILE *)find_datafile_object(characters,npcs[i].datafile_name)->dat)[1+face_dir[npcs[i].facing]*3].dat
                    );

                } else npcs[i].datafile_name=NULL;

		str_len = pack_igetl(file);

                if(str_len>0) {
                  if(compile) {
                    npcs[i].is=compile_chunk(file);
		    npcs[i].init_script=NULL;
                  }
                  else {
                    file=pack_fopen_chunk(file,FALSE);
		    npcs[i].is=NULL;
                    npcs[i].init_script=new char[str_len+1];
                    pack_fread(npcs[i].init_script,str_len,file);
		    npcs[i].init_script[str_len]=0;
                    file=pack_fclose_chunk(file);
                  }
                } 
                else {
                  npcs[i].init_script=NULL;
		  npcs[i].is=NULL;
                }

		str_len = pack_igetl(file);
                if(str_len>0) {
                  if(compile) {
                    npcs[i].as=compile_chunk(file);
		    npcs[i].action_script=NULL;
                  }
                  else {
                    file=pack_fopen_chunk(file,FALSE);
		    npcs[i].as=NULL;
                    npcs[i].action_script=new char[str_len+1];
                    pack_fread(npcs[i].action_script,str_len,file);
		    npcs[i].action_script[str_len]=0;
                    file=pack_fclose_chunk(file);
                  }
                } 
                else {
                  npcs[i].action_script=NULL;
		  npcs[i].as=NULL;
                }

		str_len = pack_igetl(file);
                if(str_len>0) {
                  if(compile) {
                    npcs[i].ps=compile_chunk(file);
		    npcs[i].player_script=NULL;
                  }
                  else {
                    file=pack_fopen_chunk(file,FALSE);
		    npcs[i].ps=NULL;
                    npcs[i].player_script=new char[str_len+1];
                    pack_fread(npcs[i].player_script,str_len,file);
		    npcs[i].player_script[str_len]=0;
                    file=pack_fclose_chunk(file);
                  }
                } 
                else {
                  npcs[i].player_script=NULL;
		  npcs[i].ps=NULL;
                }

		str_len = pack_igetl(file);
                if(str_len>0) {
                  if(compile) {
                    npcs[i].ls=compile_chunk(file);
		    npcs[i].logic_script=NULL;
                  }
                  else {
                    file=pack_fopen_chunk(file,FALSE);
		    npcs[i].ls=NULL;
                    npcs[i].logic_script=new char[str_len+1];
                    pack_fread(npcs[i].logic_script,str_len,file);
		    npcs[i].logic_script[str_len]=0;
                    file=pack_fclose_chunk(file);
                  }
                } 
                else {
                  npcs[i].logic_script=NULL;
		  npcs[i].ls=NULL;
                }
	    }
	
	    file=pack_fclose_chunk(file);

	break;
	}
	default: return -3;
    }

    pack_fclose(file);
    return 0;
}

int c_map::randomizeLayer(int p_number)
{
   if (p_number<0 || p_number>= layer_count) return -1;

   layers[layer_count-1].randomize();

   return 0;
}

int c_map::insertLayer(int p_after, int p_width, int p_height)
{
	c_layer * layers_temp = new c_layer[layer_count+1];
    if (layers_temp == NULL)
		return -1;
    if (p_after<-2) p_after=-1;
    if (p_after>layer_count-1|| p_after==-2) p_after=layer_count-1;
    for (int i=0;i<layer_count;i++)
    {
	memcpy(&layers_temp[i+(int)(i>p_after)],&layers[i],(int)sizeof(c_layer));
	layers[i].copy=TRUE;
    }
    layer_count++;
    delete[] layers;
    layers=layers_temp;
    layers[p_after+1].changeSize(p_width,p_height);
    return p_after+1;
}

int c_map::deleteLayer(int p_number)
{
	if (p_number<0 || p_number>= layer_count) return -1;
    c_layer * layers_temp = new c_layer[layer_count-1];
    for (int i=0;i<layer_count -1;i++)
    {
		memcpy(&layers_temp[i],&layers[i+(int)(i>=p_number)],(int)sizeof(c_layer));
		layers[i+(int)(i>=p_number)].copy=TRUE;
    }
    layer_count--;
    delete[] layers;
    layers=layers_temp;
    return 0;
}



int c_map::countLayers()
{
	return layer_count;
}


c_layer * c_map::getLayerPointer(int p_number)
{
	if (p_number<0 || p_number >=layer_count)
	return NULL;
    return &layers[p_number];
}

void c_map::draw(BITMAP *bmp,int draw_mode)
{
  for (int i=0;i<layer_count;i++)
  {
    if(!layers[i].getFlag(LAYER_INVISIBLE))
      layers[i].draw(bmp,x,y,draw_mode);
  }

}
void c_map::update()
{
  for (int i=0;i<layer_count;i++)
  {
    if(!layers[i].getFlag(LAYER_INVISIBLE))
      layers[i].update();
  }
}	
int c_map::check_tile(int layer,BITMAP *spr,int p_x,int p_y)
{
  if (layer<0 || layer>= layer_count) {
    set_gfx_mode(GFX_TEXT,0,0,0,0);
    allegro_message("Bad layer set for c_map::check_tile.\n");
    exit(1);
  }
  return layers[layer].check_tile(spr,p_x,p_y);
}
void c_map::drawBack(int p_color)
{ 
    int _x=-x,_y=-y;
    if(_x<0) _x=0;
    if(_y<0) _y=0;

    if(_x==0&&_y==0)
      clear_to_color(buffer,p_color);

    else if(_x<=SCREEN_W&&_y<=SCREEN_H)
      rectfill(buffer,-x,-y,SCREEN_W,SCREEN_H,p_color);
}

void c_map::drawLayer(BITMAP *bmp,int p_number,int draw_mode)
{
    if (p_number>=0 && p_number<layer_count)
	layers[p_number].draw(bmp,x,y,draw_mode);
}
/*void c_map::drawLayer_at_y(BITMAP *bmp,int p_number,int x_offset,int y_offset,BITMAP *t,int _x,int _y,int draw_mode)
{
    if (p_number>=0 && p_number<layer_count)
	layers[p_number].draw_y(bmp,x+x_offset,y+y_offset,t,_x,_y,draw_mode);

}*/
void c_map::drawLayer_at(BITMAP *bmp,int p_number,int x_offset,int y_offset,int draw_mode)
{
    if (p_number>=0 && p_number<layer_count)
	layers[p_number].draw(bmp,x+x_offset,y+y_offset,draw_mode);

}
void c_map::drawLayerGrid(int p_number, int p_color)
{
    if (p_number>=0 && p_number<layer_count)
	layers[p_number].drawGrid(x,y,p_color);
}

void c_map::scroll (int p_x, int p_y, int p_editor)
{
    if(!p_editor)
    {
	p_x+=x;
	p_y+=y;
	gotoxy(p_x,p_y);
    }
    else
    {
	x+=p_x;
	y+=p_y;
    }
}

void c_map::gotoxy (int p_x,int p_y, int p_editor)
{
  if(!p_editor) {
    if(getFlag(MAP_OUTSIDE)) {
      if(p_x<0) p_x=0;
      if(p_x>=layers[0].getSize(SIZE_WIDTH)*layers[0].gridx()-SCREEN_W)
        p_x=layers[0].getSize(SIZE_WIDTH)*layers[0].gridx()-SCREEN_W-1;
      if(p_y<0) p_y=0;
      if(p_y>=layers[0].getSize(SIZE_HEIGHT)*layers[0].gridy()-SCREEN_H)
        p_y=layers[0].getSize(SIZE_HEIGHT)*layers[0].gridy()-SCREEN_H-1;
    }
    else if(getFlag(MAP_WORLD)) {
      while (p_x<0) 
        p_x +=layers[0].getSize(SIZE_WIDTH)*layers[0].gridx();
      while (p_y<0) 
        p_y +=layers[0].getSize(SIZE_HEIGHT)*layers[0].gridy();
      while (p_x>layers[0].getSize(SIZE_WIDTH)*layers[0].gridx()) 
        p_x -=layers[0].getSize(SIZE_WIDTH)*layers[0].gridx();
      while (p_y>layers[0].getSize(SIZE_HEIGHT)*layers[0].gridy()) 
        p_y -=layers[0].getSize(SIZE_HEIGHT)*layers[0].gridy();
    }
  }
  x=p_x;
  y=p_y;

}

int c_map::getX()
{
	return x;
}


int c_map::getY()
{
	return y;
}

c_tile * c_map::getTilePointer(int p_layer,int p_x, int p_y)
{
    c_layer * layer_temp = getLayerPointer(p_layer);
    if (layer_temp)
    {
	c_tile * tile_temp= layer_temp->getTilePointer(p_x,p_y);
	if (tile_temp) return tile_temp;
    }
    return NULL;
}

void c_map::scrollLayer(int p_number,int p_x, int p_y, int p_editor)
{
	if (p_number<0 || p_number>=layer_count) return;
	layers[p_number].scroll(p_x,p_y,p_editor);
}
int c_map::whatNpc(int p_x,int p_y)
{
   int i;
   for (i=0;i<npc_count;i++)
   {
     if (p_x>=npcs[i].x-5 && p_x<=npcs[i].x+5 && p_y>=npcs[i].y-5 && p_y <=npcs[i].y+5) 
       return npcs[i].key;
   }
   return -1;
}

void c_map::deleteNpc(int key)
{
  int ikey=-1;
  int i;
  for(i=0;i<npc_count;i++)
    if(npcs[i].key==key) {
      ikey=i;
      break;
    }
  if(ikey==-1) return;
  key=ikey;

  if(npcs[key].datafile_name)
    delete []npcs[key].datafile_name;

  if(npcs[key].init_script)
    delete []npcs[key].init_script;
  if(npcs[key].action_script)
    delete []npcs[key].action_script;
  if(npcs[key].logic_script)
    delete []npcs[key].logic_script;
  if(npcs[key].player_script)
    delete []npcs[key].player_script;
    
  npc_count--;

  for(i=key;i<npc_count;i++)
  {
    memcpy(&npcs[i],&npcs[i+1],sizeof(map_char));
  }
}

int c_map::drawNpcs()
{
  int i,g,w,col1,col2,col3;
  g=makecol(0,255,0);
  w=makecol(255,255,0);
  col1=col2=col3=g;

  int ikey=-1;
  for(i=0;i<npc_count;i++)
    if(npcs[i].key==active_npc) {
      ikey=i;
      break;
    }

  if(active_npc_part==2) {
     active_npc_part=-1;
     w=makecol(255,0,0);
  }
 

  for(i=0;i<npc_count;i++)
  {
    if(i==ikey) {
      if(active_npc_part==-1) {
        col1=w;
        col2=w;
        col3=w;
      }
      else if(active_npc_part==0) {
        col1=w;
        col2=g;
        col3=g;
      }
      else if(active_npc_part==1) {
        col1=g;
        col2=g;
        col3=w;
      }
    }
    textprintf(buffer,font,-x+npcs[i].x-10-npcs[i].pict->w,-y+npcs[i].y-18-npcs[i].pict->h,g,"%d",npcs[i].key);
    draw_sprite(buffer,npcs[i].pict,-x+npcs[i].x-9-npcs[i].pict->w,-y+npcs[i].y-9-npcs[i].pict->h);
    rect(buffer,-x+npcs[i].x-10-npcs[i].pict->w,-y+npcs[i].y-10-npcs[i].pict->h,-x+npcs[i].x-9,-y+npcs[i].y-9,col3);
    line(buffer,-x+npcs[i].x-8,-y+npcs[i].y-8,-x+npcs[i].x-1,-y+npcs[i].y-1,col2);
    putpixel(buffer,-x+npcs[i].x,-y+npcs[i].y,col1);
    rect(buffer,-x+npcs[i].x-5,-y+npcs[i].y-5,-x+npcs[i].x+5,-y+npcs[i].y+5,col1);
  }
  return 0;
}
void c_map::getNpc(int key,int *name_index,int *facing,int *walk_layer,int *flags)
{
  int ikey=-1;
  int i;
  for(i=0;i<npc_count;i++)
    if(npcs[i].key==key) {
      ikey=i;
      break;
    }
  if(ikey==-1) return;
  key=ikey;

  *facing=npcs[key].facing;
  *walk_layer=npcs[key].walk_layer;
  *flags=npcs[key].flags;
  i=0;

  while(characters[i].type!=DAT_END) {
    if(strcmp((char *)get_datafile_property(&characters[i],DAT_NAME),npcs[key].datafile_name)==0) {
      *name_index=i;
      break;
    }
    i++;
  }
}

int c_map::addNpc(int p_x,int p_y,char *name, int facing, int walk_layer,int flags)
{
  if(npc_count >= MAP_NPCCOUNT) return -1;

  npcs[npc_count].x=p_x;
  npcs[npc_count].y=p_y;
  npcs[npc_count].datafile_name=new char[strlen(name)+1];
  npcs[npc_count].key=-1;

  int test=32;

  while(npcs[npc_count].key!=test) {
    npcs[npc_count].key=test;
    for(int i=0;i<npc_count;i++)
      if(test==npcs[i].key) {
        test++;
        i=0;
        continue;
      }
  }

  npcs[npc_count].facing=facing;
  npcs[npc_count].walk_layer=walk_layer;
  npcs[npc_count].flags=flags;
  npcs[npc_count].init_script=NULL;
  npcs[npc_count].action_script=NULL;
  npcs[npc_count].logic_script=NULL;
  npcs[npc_count].player_script=NULL;
  npcs[npc_count].is=NULL;
  npcs[npc_count].as=NULL;
  npcs[npc_count].ls=NULL;
  npcs[npc_count].ps=NULL;
  strcpy(npcs[npc_count].datafile_name,name);

  npcs[npc_count].pict=(BITMAP *)(
   ((DATAFILE *)find_datafile_object(characters,name)->dat)[1+face_dir[facing]*3].dat
   );

  npc_count++;
  return npcs[npc_count].key;
}

void c_map::moveNpc(int key,int p_x,int p_y)
{
  int ikey=-1;
  for(int i=0;i<npc_count;i++)
    if(npcs[i].key==key) {
      ikey=i;
      break;
    }
  if(ikey==-1) return;
  key=ikey;

  npcs[key].x=p_x;
  npcs[key].y=p_y;


}
void c_map::setNpc(int key,char *name, int facing, int walk_layer,int flags)
{
  int ikey=-1;
  for(int i=0;i<npc_count;i++)
    if(npcs[i].key==key) {
      ikey=i;
      break;
    }
  if(ikey==-1) return;
//  key=ikey;

  if(npcs[ikey].datafile_name)
    delete []npcs[ikey].datafile_name;

  npcs[ikey].datafile_name=new char[strlen(name)+1];
  npcs[ikey].facing=facing;
  npcs[ikey].walk_layer=walk_layer;
  npcs[ikey].flags=flags;
  strcpy(npcs[ikey].datafile_name,name);

  npcs[ikey].pict=(BITMAP *)(
   ((DATAFILE *)find_datafile_object(characters,name)->dat)[1+face_dir[facing]*3].dat
   );

}
void c_map::setNpcScript(int key,int which,char *script)
{
  int ikey=-1;
  for(int i=0;i<npc_count;i++)
    if(npcs[i].key==key) {
      ikey=i;
      break;
    }
  if(ikey==-1) return;
  key=ikey;

  switch(which) {
    case 0:
      npcs[key].init_script=script;
      break;
    case 1:
      npcs[key].action_script=script;
      break;
    case 2:
      npcs[key].logic_script=script;
      break;
    case 3:
      npcs[key].player_script=script;
      break;
  } 

}
char *c_map::getNpcScript(int key,int which)
{
  int ikey=-1;
  for(int i=0;i<npc_count;i++)
    if(npcs[i].key==key) {
      ikey=i;
      break;
    }
  if(ikey==-1) return NULL;
  key=ikey;

  switch(which) {
    case 0:
      return npcs[key].init_script ;
    case 1:
      return npcs[key].action_script ;
    case 2:
      return npcs[key].logic_script ;
    case 3:
      return npcs[key].player_script ;
  } 
  return NULL;
}
void c_map::load_mobs(class mob_list *m)
{
  for(int i=0;i<npc_count;i++)
  {
    m->add_mob(new Mobile(&npcs[i]));
  }
}

int c_map::addTrigger(int p_x1, int p_y1, int p_x2, int p_y2, int p_action, int p_direction, char * p_name)
{
    if (trigger_count >=MAP_TRIGGERCOUNT) return -1;
        trigger_count++;
    triggers[trigger_count-1].x1=p_x1;
    triggers[trigger_count-1].y1=p_y1;
    triggers[trigger_count-1].x2=p_x2;
    triggers[trigger_count-1].y2=p_y2;
    triggers[trigger_count-1].action=p_action;
    triggers[trigger_count-1].direction=p_direction;
    if(p_name!=NULL) { 
      char *name_temp = new char[strlen(p_name)+1];
      strcpy(name_temp,p_name);
      triggers[trigger_count-1].script_named=name_temp;
    }
    else 
      triggers[trigger_count-1].script_named=NULL;
    
    return trigger_count-1;
}

int c_map::getTriggerArea(int p_number, int *p_x, int *p_y,int *p_x2,int *p_y2)
{
  if (p_number>=trigger_count || p_number<0) return -1;
  *p_x=triggers[p_number].x1;
  *p_y=triggers[p_number].y1;
  *p_x2=triggers[p_number].x2;
  *p_y2=triggers[p_number].y2;
  return 0;
}
int c_map::setTriggerPoint(int p_number, int p_point,int p_x, int p_y)
{
    if (p_number>=trigger_count || p_number<0) return -1;
    if (!p_point)
    {
	triggers[p_number].x1=p_x;
	triggers[p_number].y1=p_y;
    }
    if (p_point)
    {
	triggers[p_number].x2=p_x;
	triggers[p_number].y2=p_y;
    }
    return 0;
}


int c_map::setTrigger(int p_number, int p_action,int p_direction, char * p_name)
{
    if (p_number>=trigger_count || p_number<0) return -1;
    triggers[p_number].action=p_action;
    triggers[p_number].direction=p_direction;

//        char *name_temp = new char[strlen(p_name)+1];
//    strcpy(name_temp,p_name);
        triggers[p_number].script_named=p_name;
    return 0;
}

void c_map::drawTriggers()
{ 
   int col;
   for (int i=0;i<trigger_count;i++)
   {
	if (i==active_trigger) col=makecol(255,255,0);
	else col=makecol(0,255,0);
        textprintf(buffer,font,-x+triggers[i].x1+7,-y+triggers[i].y1-8,col,"%d",i);
	rect(buffer,-x+triggers[i].x1,-y+triggers[i].y1,-x+triggers[i].x2,-y+triggers[i].y2,col);
	if (i==active_trigger && active_trigger_part==1) col=makecol(0,255,255);
	rect(buffer,-x+triggers[i].x1-5,-y+triggers[i].y1-5,-x+triggers[i].x1+5,-y+triggers[i].y1+5,col);
	if (i==active_trigger && active_trigger_part==2) col=makecol(0,255,255);
	if (i==active_trigger && active_trigger_part!=2) col=makecol(255,255,0);
	rect(buffer,-x+triggers[i].x2-5,-y+triggers[i].y2-5,-x+triggers[i].x2+5,-y+triggers[i].y2+5,col);
   } 
}                       



void c_map::drawMirrors_at(BITMAP *bmp,int x_offset,int y_offset)
{
   int mx=x+x_offset,my=y+y_offset;
   int col=makecol(0,0,0);
   for (int i=0;i<trigger_count;i++)
   {
	if(triggers[i].action!=8) continue;
	rectfill(bmp,-mx+triggers[i].x1,-my+triggers[i].y1,-mx+triggers[i].x2,-my+triggers[i].y2,col);
   } 
}                       


int c_map::getTriggerCount()
{
  return trigger_count;
}
int c_map::checkTrigger(int p_num,int p_x,int p_y)
{
  if (((p_y>=triggers[p_num].y1 && p_y<= triggers[p_num].y2) ||
       (p_y<=triggers[p_num].y1 && p_y>= triggers[p_num].y2)) && 
      ((p_x>=triggers[p_num].x1 && p_x<=triggers[p_num].x2) ||
       (p_x<=triggers[p_num].x1 && p_x>=triggers[p_num].x2)))
     return TRUE;

  return FALSE;
}
void c_map::whatTrigger(int p_x, int p_y,int * p_number,int * p_part)
{
    *p_number=-1;
    *p_part=0;
	for (int i=0;i<trigger_count;i++)
	{
		if (((p_y>=triggers[i].y1 && p_y<= triggers[i].y2) || (p_y<=triggers[i].y1 && p_y>= triggers[i].y2)) && ((p_x>=triggers[i].x1 && p_x<=triggers[i].x2) || (p_x<=triggers[i].x1 && p_x>=triggers[i].x2)))
		{
                        if(*p_number!=i) *p_part=0;
			*p_number=i;
			*p_part|=1;
		}
		if (p_y>=triggers[i].y1-5 && p_y<= triggers[i].y1+5 && p_x>=triggers[i].x1-5 && p_x<=triggers[i].x1+5)
		{
                        if(*p_number!=i) *p_part=0;
			*p_number=i;
			*p_part|=2;
		}
		if (p_y>=triggers[i].y2-5 && p_y<= triggers[i].y2+5 && p_x>=triggers[i].x2-5 && p_x<=triggers[i].x2+5)
		{	
                        if(*p_number!=i) *p_part=0;
			*p_number=i;
			*p_part|=4;
		}
	}
}

int c_map::deleteTrigger(int p_number)
{
	if (p_number<0 || p_number >=trigger_count) return -1;
	trigger_count--;
    if (trigger_count >0)
    {
	triggers[p_number].action=triggers[trigger_count].action;
	triggers[p_number].direction=triggers[trigger_count].direction;
	triggers[p_number].x1=triggers[trigger_count].x1;
		triggers[p_number].x2=triggers[trigger_count].x2;
		triggers[p_number].y1=triggers[trigger_count].y1;
		triggers[p_number].y2=triggers[trigger_count].y2;
	delete[]triggers[p_number].script_named;
	triggers[p_number].script_named=triggers[trigger_count].script_named;

    }
    return 0;
}



char * c_map::getTriggerScriptName(int p_number)
{
	if (p_number<0 || p_number >=trigger_count) return NULL;
    return triggers[p_number].script_named;
}

int c_map::getTriggerAction(int p_number)
{
	if (p_number<0 || p_number >=trigger_count) return -1;
    return triggers[p_number].action;

}

int c_map::getTriggerDirection(int p_number)
{
	if (p_number<0 || p_number >=trigger_count) return -1;
    return triggers[p_number].direction;

}
void c_map::ActivateTrigger(int p_number)
{
  if (p_number<0 || p_number >=trigger_count) return;

  if(triggers[p_number].script==NULL) {
    set_gfx_mode(GFX_TEXT,0,0,0,0);
    allegro_message("Trigger %d has a broken script.",p_number);
    exit(1);
  }

  triggers[p_number].script->Execute();
  triggers[p_number].script->Reset();
  //run_hrs_script(triggers[p_number].script);

}


int c_map::addEntry(int p_x,int p_y,int p_key, int p_direction,int p_layer)
{
    if (trigger_count >=25) return -1;
	entry_count++;
    entrys[entry_count-1].x=p_x;
    entrys[entry_count-1].y=p_y;
    entrys[entry_count-1].key=p_key;
    entrys[entry_count-1].direction=p_direction;
    entrys[entry_count-1].layer=p_layer;
    
    return entry_count-1;
}

int c_map::setEntryPoint(int p_number, int p_x,int p_y)
{
	if (p_number<0 || p_number>= entry_count) return -1;
    entrys[p_number].x=p_x;
    entrys[p_number].y=p_y;
	return 0;
}

int c_map::setEntry(int p_number, int p_key, int p_direction,int p_layer)
{
    if (p_number<0 || p_number>= entry_count) return -1;
    entrys[p_number].key=p_key;
    entrys[p_number].direction=p_direction;
    entrys[p_number].layer=p_layer;
    return 0;
}

void c_map::whatEntry(int p_x, int p_y, int * p_number)
{
	*p_number=-1;
    for (int i=0;i<entry_count;i++)
    {
	if (p_x>=entrys[i].x-5 && p_x<=entrys[i].x+5 && p_y>=entrys[i].y-5 && p_y <=entrys[i].y+5)
		*p_number=i;
	}
}
void c_map::getEntryLocation(int *p_x, int *p_y, int  p_number)
{
    if (p_number<0 || p_number>= entry_count) return;
    *p_x=entrys[p_number].x;
    *p_y=entrys[p_number].y;
}

void c_map::drawEntrys()
{
	int col;
    for (int i=0;i<entry_count;i++)
    {
	if (i==active_entry) col=makecol(255,255,0);
	else col=makecol(0,255,0);
	putpixel(buffer,-x+entrys[i].x,-y+entrys[i].y,col);
	textprintf(buffer,font,-x+entrys[i].x-5,-y+entrys[i].y-13,col,"%d",entrys[i].key);
	rect(buffer,-x+entrys[i].x-5,-y+entrys[i].y-5,-x+entrys[i].x+5,-y+entrys[i].y+5,col);
    }
}

int c_map::deleteEntry(int p_number)
{
    if (p_number<0 || p_number>=entry_count) return -1;
	entry_count--;
    if (entry_count >0)
    {
	entrys[p_number].x=entrys[entry_count].x;
	entrys[p_number].y=entrys[entry_count].y;
	entrys[p_number].direction=entrys[entry_count].direction;
        entrys[p_number].key=entrys[entry_count].key;
        entrys[p_number].layer=entrys[entry_count].key;
    }
    return 0;
}


int c_map::getEntryKey(int p_number)
{
	if (p_number<0 || p_number >=entry_count) return -1;
    return entrys[p_number].key;
}
int c_map::getEntryLayer(int p_number)
{
	if (p_number<0 || p_number >=entry_count) return -1;
    return entrys[p_number].layer;
}

int c_map::getEntryDirection(int p_number)
{
	if (p_number<0 || p_number >=entry_count) return -1;
    return entrys[p_number].direction;
}

int c_map::getEntryIndex(int p_key)
{
	int ret=-1;
	for (int i =0;i<entry_count;i++)
    {
	if (p_key==entrys[i].key)
		ret=i;
    }
    return ret;
}



void c_map::setPic(int layer, int x, int y, int pic)
{
	layers[layer].setPic(x,y,pic);
}
