// This code is LGPL...
//#include "fortify.h"
#include <time.h>
#include <allegro.h>
#include <stdlib.h>
#include <stdio.h>
#include "mystring.h"
#include "func.h"
#include "alleg.h"
#include "helper.h"
#include "menu.h"
#include "alleg.h"
#include "music.h"


hrs_variable * dialog_fit2(hrs_variable *x,hrs_variable *y,hrs_variable *name,hrs_variable *text,hrs_variable *speed,hrs_variable *position)
{
  return make_int(dialog_fit(get_int(x),get_int(y),get_string(name),get_string(text),get_int(speed),get_int(position)));
}
hrs_variable * question_fit2(hrs_variable *x,hrs_variable *y,hrs_variable *name,hrs_variable *question,hrs_variable *answers,hrs_variable *speed,hrs_variable *position)
{
  return make_int(question_fit(get_int(x),get_int(y),get_string(name),get_string(question),get_string(answers),get_int(speed),get_int(position)));
}

hrs_variable * hrand () {
  return make_int(rand());
}
hrs_variable * makecol2(hrs_variable *r,hrs_variable *g,hrs_variable *b) {
    return make_int(makecol(get_int(r),get_int(g),get_int(b)));
}

hrs_variable *num2str(hrs_variable *var1)
{
  char buf[50];

  switch(var1->type) {
    case VAR_INT:
      sprintf(buf,"%d",get_int(var1));
      break;
    case VAR_REAL:
      sprintf(buf,"%g",get_float(var1));
      break;
    default:
      sprintf(buf,"0");
      break;
  }

  return make_string(buf);
}
hrs_variable *  run_hrs_script2(hrs_variable *filename)
{
	run_hrs_script(get_string(filename));
    return make_int(0);
}

hrs_variable *get_global2(hrs_variable *name)
{
   hrs_variable *search=get_global_var(get_string(name));

   if(search==NULL) {
     return make_int(0);
   }
   else return search;
}
hrs_variable *set_global2(hrs_variable *name,hrs_variable *var)
{
   set_global_var(get_string(name),var);
   return make_int(0);
}
#define hrs_vfunction0(func      )    \
hrs_variable *func##2 (hrs_variable *v1)           \
{ \
  func ( ); \
  return make_void (); \
}
#define hrs_function0(return1,func      )    \
hrs_variable *func##2 (hrs_variable *v1)           \
{ \
  return make_##return1 ( func () ); \
}
#define hrs_vfunction1(func,var_type1      )    \
hrs_variable *func##2 (hrs_variable *v1)           \
{ \
  func (get_##var_type1 ( v1 )); \
  return make_void (); \
}
#define hrs_function1(return1,func,var_type1      )    \
hrs_variable *func##2 (hrs_variable *v1)           \
{ \
  return make_##return1 ( func ( get_##var_type1 (v1 ))); \
}
#define hrs_vfunction2(func,var_type1,var_type2      )    \
hrs_variable *func##2 (hrs_variable *v1,hrs_variable *v2)           \
{ \
  func (get_##var_type1 ( v1 ), get_##var_type2 ( v2 )); \
  return make_void (); \
}
#define hrs_function2(return1,func,var_type1,var_type2      )    \
hrs_variable *func##2 (hrs_variable *v1, hrs_variable *v2)           \
{ \
  return make_##return1 ( func ( get_##var_type1 (v1 ),get_##var_type2 (v2 ))); \
}
#define hrs_vfunction3(func,var_type1,var_type2,var_type3      )    \
hrs_variable *func##2 (hrs_variable *v1,hrs_variable *v2,hrs_variable *v3)           \
{ \
  func (get_##var_type1 ( v1 ), get_##var_type2 ( v2 ), get_##var_type3 ( v3 )); \
  return make_void (); \
}
#define hrs_function3(return1,func,var_type1,var_type2,var_type3      )    \
hrs_variable *func##2 (hrs_variable *v1, hrs_variable *v2,hrs_variable *v3)           \
{ \
  return make_##return1 ( func ( get_##var_type1 (v1 ),get_##var_type2 (v2 ),get_##var_type3 ( v3 ))); \
}
#define hrs_vfunction4(func,var_type1,var_type2,var_type3,var_type4      )    \
hrs_variable *func##2 (hrs_variable *v1,hrs_variable *v2,hrs_variable *v3,hrs_variable *v4)           \
{ \
  func (get_##var_type1 ( v1 ), get_##var_type2 ( v2 ), get_##var_type3 ( v3 ), get_##var_type4 ( v4 )); \
  return make_void (); \
}
#define hrs_function4(return1,func,var_type1,var_type2,var_type3,var_typ4      )    \
hrs_variable *func##2 (hrs_variable *v1, hrs_variable *v2,hrs_variable *v3,hrs_varaible *v4)           \
{ \
  return make_##return1 ( func ( get_##var_type1 (v1 ),get_##var_type2 (v2 ),get_##var_type3 ( v3 ), get_##var_type4 ( v4 ))); \
}


//int create_picture2(int parent,int x,int y,char *filename,int ovr);
hrs_variable *create_picture2(hrs_variable *part,hrs_variable *x,hrs_variable *y,hrs_variable *filename,hrs_variable *ovr)
{
  return make_int(create_picture(get_int(part),get_int(x),get_int(y),get_string(filename),get_int(ovr)));
}

//int create_select2(int parent,int x,int y,int top_y,int bottom_y);
hrs_variable *create_select2(hrs_variable *parent,hrs_variable *x,hrs_variable *y,hrs_variable *top_y,hrs_variable *bottom_y)
{
  return make_int(create_select(get_int(parent),get_int(x),get_int(y),get_int(top_y),get_int(bottom_y)));
}

//int create_text2(int parent,int x,int y,int w,int v,char *text,int more);
hrs_variable *create_text2(hrs_variable *parent,hrs_variable *x,hrs_variable *y,hrs_variable *w,hrs_variable *v,hrs_variable *text,hrs_variable *more)
{
  return make_int(create_text(get_int(parent),get_int(x),get_int(y),get_int(w),get_int(v),get_string(text),get_int(more)));
}

//int create_frame2(int parent,int x,int y,int w,int h);
hrs_variable *create_frame2(hrs_variable *parent,hrs_variable *x,hrs_variable *y,hrs_variable *w,hrs_variable *h)
{
  return make_int(create_frame(get_int(parent),get_int(x),get_int(y),get_int(w),get_int(h)));
}

//int create_slider2(int parent,int x,int y,int w,int min,int max,int p,int c1,int c2);
hrs_variable *create_slider2(hrs_variable *parent,hrs_variable *x,hrs_variable *y,hrs_variable *w,hrs_variable *min,hrs_variable *max,hrs_variable *p,hrs_variable *c1,hrs_variable *c2)
{
  return make_int(create_slider(get_int(parent),get_int(x),get_int(y),get_int(w),get_int(min),get_int(max),get_int(p),get_int(c1),get_int(c2)));
}

//int create_select_list2(int parent,int x,int y,int dx,int dy,int number,int top_y,int bottom_y);
hrs_variable *create_select_list2(hrs_variable *parent,hrs_variable *x,hrs_variable *y,hrs_variable *dx,hrs_variable *dy,hrs_variable *number,hrs_variable *top_y,hrs_variable *bottom_y)
{
  return make_int(create_select_list(get_int(parent),get_int(x),get_int(y),get_int(dx),get_int(dy),get_int(number),get_int(top_y),get_int(bottom_y)));
}

//int create_select_grid2(int parent,int x,int y,int dx,int dy,int x_number,int y_number,int top_y,int bottom_y);
hrs_variable *create_select_grid2(hrs_variable *parent,hrs_variable *x,hrs_variable *y,hrs_variable *dx,hrs_variable *dy,hrs_variable *x_number,hrs_variable *y_number,hrs_variable *top_y,hrs_variable *bottom_y)
{
  return make_int(create_select_grid(get_int(parent),get_int(x),get_int(y),get_int(dx),get_int(dy),get_int(x_number),get_int(y_number),get_int(top_y),get_int(bottom_y)));
}



hrs_vfunction1(destroy_dialog_object,int);
hrs_vfunction4(move_object,int,int,int,int);
hrs_vfunction4(resize_object,int,int,int,int);
hrs_function1(int,get_object_width,int);
hrs_function1(int,get_object_height,int);
hrs_vfunction2(open_frame,int,int);
hrs_vfunction2(close_frame,int,int);
hrs_vfunction4(change_text,int,int,string,int);
hrs_vfunction1(stop_text_scroll,int);
hrs_function1(int,is_text_scrolling,int);
hrs_vfunction2(change_picture,int,string);
hrs_vfunction1(set_active_select,int);
hrs_vfunction0(clear_active_select);
hrs_function0(int,get_active_select);
hrs_vfunction1(select_blink_on,int);
hrs_vfunction1(select_blink_off,int);
hrs_function1(int,get_select_blink,int);
hrs_function1(int,left_select,int);
hrs_function1(int,right_select,int);
hrs_function1(int,up_select,int);
hrs_function1(int,down_select,int);
hrs_vfunction2(set_left_select,int,int);
hrs_vfunction2(set_right_select,int,int);
hrs_vfunction2(set_up_select,int,int);
hrs_vfunction2(set_down_select,int,int);
hrs_function1(int,get_slider_value,int);
hrs_vfunction3(set_slider_value,int,int,int);
hrs_vfunction3(change_slider_color,int,int,int);
hrs_function0(int,get_input);
hrs_vfunction1(wait_for_text_scroll,int);
hrs_vfunction1(wait_for_animation,int);
hrs_function0(int,font_height);
hrs_function1(int,font_length,string);
hrs_vfunction1(set_frame,int);
hrs_function0(int,get_frames);
hrs_function0(int,get_current_frame);

hrs_vfunction2(music_set,string,int);
hrs_vfunction0(music_play);
hrs_vfunction0(music_stop);
hrs_vfunction0(music_pause);
hrs_vfunction0(music_unpause);
hrs_vfunction1(music_set_vol,int);
hrs_function0(int,music_get_vol);

PACKFILE *f=NULL;

hrs_variable *start_save(hrs_variable *filename) 
{
 
    f = pack_fopen(get_string(filename),F_WRITE_PACKED);
    return make_void();
}
hrs_variable *save_variable(hrs_variable *var_name) 
{
  if(!f) return make_void();
  char buf[50];
  hrs_variable *var=get_global_var(get_string(var_name));
  pack_iputl(strlen(var->name),f); 
  pack_fwrite(var->name,strlen(var->name),f); // the name of the variable
  pack_iputl(var->type,f); 

  switch(var->type) {
    case VAR_INT:
      pack_iputl(get_int(var),f); 
      
      break;
    case VAR_REAL:
      sprintf(buf,"%g",get_float(var));
      pack_iputl(strlen(buf),f); 
      pack_fwrite(buf,strlen(buf),f); // the name of the variable
      break;
    case VAR_STR:
      pack_iputl(strlen(get_string(var)),f); 
      pack_fwrite(var,strlen(get_string(var)),f); // the name of the variable
      break;
  }
  return make_void();
}
hrs_variable *end_save()
{
    if(!f) return make_void();
    pack_fclose(f);

	return make_void();
}

hrs_variable *load_game(hrs_variable *filename)
{
  f = pack_fopen(get_string(filename),F_READ_PACKED);
  
  if(!f) return make_void();
  
  char buf[50];
  char varname[50];
  char string[512];
  int l,type;
  float g;
  
  while(!pack_feof(f)) {
      l=pack_igetl(f); 
      pack_fread(varname,l,f); // the name of the variable
      type=pack_igetl(f); 

	  switch(type) {
          case VAR_INT:
			set_global_var(varname,make_int(pack_igetl(f))); 				
			break;
		  case VAR_REAL:
			l=pack_igetl(f); 
			pack_fread(buf,l,f); // the name of the variable
			sscanf(buf,"%g",&g);
            set_global_var(varname,make_float(g));
			break;
		  case VAR_STR:
			l=pack_igetl(f); 
			pack_fread(string,l,f); // the name of the variable
			set_global_var(varname,make_string(string));
			break;
	  }
  }
		  
  pack_fclose(f);
  return make_void();


}
int setup_menu()  {
   add_hrs_func("start_save",(void *)start_save,1);
   add_hrs_func("save_variable",(void *)save_variable,1);
   add_hrs_func("end_save",(void *)end_save,0);
   add_hrs_func("load_game",(void *)load_game,1);

   add_hrs_func("get_global",(void *)get_global2,1);
   add_hrs_func("set_global",(void *)set_global2,2);
   add_hrs_func("run_hrs_script",(void *)run_hrs_script2,1);
   add_hrs_func("str",(void *)num2str,1);
   add_hrs_func("makecol",(void *)makecol2,3);
   add_hrs_func("rand",(void *)hrand,0);

   add_hrs_func("create_picture",(void *)create_picture2,5);
   add_hrs_func("create_select",(void *)create_select2,5);
   add_hrs_func("create_text",(void *)create_text2,7);
   add_hrs_func("create_frame",(void *)create_frame2,5);
   add_hrs_func("create_slider",(void *)create_slider2,9);
   add_hrs_func("create_select_list",(void *)create_select_list2,8);
   add_hrs_func("create_select_grid",(void *)create_select_grid2,9);
   add_hrs_func("destroy_dialog_object",(void *)destroy_dialog_object2,1);
   add_hrs_func("move_object",(void *)move_object2,4);
   add_hrs_func("resize_object",(void *)resize_object2,4);
   add_hrs_func("get_object_width",(void *)get_object_width2,1);
   add_hrs_func("get_object_height",(void *)get_object_height2,1);
   add_hrs_func("open_frame",(void *)open_frame2,2);
   add_hrs_func("close_frame",(void *)close_frame2,2);
   add_hrs_func("change_text",(void *)change_text2,4);
   add_hrs_func("stop_text_scroll",(void *)stop_text_scroll2,1);
   add_hrs_func("is_test_scrolling",(void *)is_text_scrolling2,1);
   add_hrs_func("change_picture",(void *)change_picture2,2);
   add_hrs_func("set_active_select",(void *)set_active_select2,1);
   add_hrs_func("clear_active_select",(void *)clear_active_select2,0);
   add_hrs_func("get_active_select",(void *)get_active_select2,0);
   add_hrs_func("select_blink_on",(void *)select_blink_on2,1);
   add_hrs_func("select_blink_off",(void *)select_blink_off2,1);
   add_hrs_func("get_select_blink",(void *)get_select_blink2,1);
   add_hrs_func("left_select",(void *)left_select2,1);
   add_hrs_func("right_select",(void *)right_select2,1);
   add_hrs_func("up_select",(void *)up_select2,1);
   add_hrs_func("down_select",(void *)down_select2,1);
   add_hrs_func("set_left_select",(void *)set_left_select2,2);
   add_hrs_func("set_right_select",(void *)set_right_select2,2);
   add_hrs_func("set_up_select",(void *)set_up_select2,2);
   add_hrs_func("set_down_select",(void *)set_down_select2,2);
   add_hrs_func("get_slider_value",(void *)get_slider_value2,1);
   add_hrs_func("set_slider_value",(void *)set_slider_value2,3);
   add_hrs_func("change_slider_color",(void *)change_slider_color2,3);
   add_hrs_func("get_input",(void *)get_input2,0);
   add_hrs_func("wait_for_text_scroll",(void *)wait_for_text_scroll2,1);
   add_hrs_func("wait_for_animation",(void *)wait_for_animation2,1);
   add_hrs_func("font_height",(void *)font_height2,0);
   add_hrs_func("font_length",(void *)font_length2,1);
   add_hrs_func("set_frame",(void *)set_frame2,1);
   add_hrs_func("get_frames",(void *)get_frames2,0);
   add_hrs_func("get_current_frame",(void *)get_current_frame2,0);
   add_hrs_func("dialog_fit",(void *)dialog_fit2,6);
   add_hrs_func("question_fit",(void *)question_fit2,7);

   add_hrs_func("music_set",(void *)music_set2,2);
   add_hrs_func("music_play",(void *)music_play2,0);
   add_hrs_func("music_stop",(void *)music_stop2,0);
   add_hrs_func("music_pause",(void *)music_pause2,0);
   add_hrs_func("music_unpause",(void *)music_unpause2,0);
   add_hrs_func("music_set_vol",(void *)music_set_vol2,1);
   add_hrs_func("music_get_vol",(void *)music_get_vol2,0);

   return 0;
}


