%{
#include <allegro.h>
#include <string.h>
#include <assert.h>
//#include "fortify.h"
#include "mystring.h"
#include "func.h"
#include "symtab.h"
#include "synttree.h"
#include "hrsparser.cpp.h"
extern "C" int yywrap ();
int line_num=1;
void EatCComment();
void EatCPPComment();
int Identifier();
void StringConst();
void IntConst();
void FloatConst();
PACKFILE *p_yyin;
#define yy_buffer_state yy_buffer_state2
#define YY_BUFFER_STATE YY_BUFFER_STATE2
typedef struct yy_buffer_state *YY_BUFFER_STATE;
struct yy_buffer_state
	{
	PACKFILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;
#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2
	};
#define yy_current_buffer yy_current_buffer2
static YY_BUFFER_STATE yy_current_buffer = 0;

#define yyin p_yyin
#undef stdin
#define stdin p_yyin
#define FILE PACKFILE

#define yy_switch_to_buffer yy_switch_to_buffer2
#define yy_load_buffer_state yy_load_buffer_state2
#define yy_create_buffer yy_create_buffer2
#define yy_delete_buffer yy_delete_buffer2
#define yy_init_buffer yy_init_buffer2
#define yy_flush_buffer yy_flush_buffer2
#define yy_scan_buffer yy_scan_buffer2
#define yy_scan_string yy_scan_string2
#define yy_scan_bytes yy_scan_bytes2

void yy_switch_to_buffer YY_PROTO(( YY_BUFFER_STATE new_buffer ));
void yy_load_buffer_state YY_PROTO(( void ));
YY_BUFFER_STATE yy_create_buffer YY_PROTO(( FILE *file, int size ));
void yy_delete_buffer YY_PROTO(( YY_BUFFER_STATE b ));
void yy_init_buffer YY_PROTO(( YY_BUFFER_STATE b, FILE *file ));
void yy_flush_buffer YY_PROTO(( YY_BUFFER_STATE b ));
YY_BUFFER_STATE yy_scan_buffer YY_PROTO(( char *base, yy_size_t size ));
YY_BUFFER_STATE yy_scan_string YY_PROTO(( yyconst char *yy_str ));
YY_BUFFER_STATE yy_scan_bytes YY_PROTO(( yyconst char *bytes, int len ));

#define YY_FLUSH_BUFFER yy_flush_buffer( yy_current_buffer )
#define YY_NEVER_INTERACTIVE 1
#define yyrestart yyrestart2
void yyrestart YY_PROTO(( FILE *input_file ));
#undef YY_NEW_FILE
#define YY_NEW_FILE yyrestart( yyin )



#define yyterminate()                       \
  if ( yy_current_buffer ) {                \
    yy_delete_buffer( yy_current_buffer );  \
    yy_current_buffer=NULL;                 \
  }                                         \
  return YY_NULL

#define YY_INPUT yy_input

void YY_INPUT(char *buf,int &result,int &max_size);

%}
LETTER          [a-zA-Z_]
DIGIT		[0-9]
ALPHANUM        [a-zA-Z_0-9]
INT             {DIGIT}+
FLOAT           {DIGIT}*"."{DIGIT}+
NOTFLOAT        {DIGIT}*"."
IDENT           {LETTER}{ALPHANUM}*[%]?
STR		\"([^\\\"]|"\\\""|[^\"])*\"
NOTSTR		\"([^\\\"]|"\\\""|[^\"])+
COMMENTCPP	"//"
COMMENTC	"/*"
WHITESPACE	[ \t\r]+
LINEFEED        "\n"

%%
"if"		{return IF;}
"else"		{return ELSE;}
"while"         {return WHILE;}
"do"            {return DO;}
"for"           {return FOR;}
"goto"          {return GOTO;}
"="		{return '=';}
"=="		{return EQUAL;}
"!="            {return NOTEQUAL;}
"!"             {return NOT;}
"+"		{return '+';}
"-"             {return '-';}
"*"             {return '*';}
"/"/[^*/]       {return '/';}
"%"             {return '%';}
"$"             {return '$';}
"#"             {return '#';}
"^"             {return '^';}
">"             {return '>';}
"<"             {return '<';}
">="            {return GTET;}
"<="            {return LTET;}
"&&"            {return AND;}
"||"            {return OR;}
"("		{return '(';}
")"		{return ')';}
"{"		{return '{';}
"}"		{return '}';}
":"             {return ':';}
";"		{return ';';}
","             {return ',';}
{STR}		{StringConst(); return STRING;}
{NOTSTR}	{return ERROR_TOKEN;}
{FLOAT}         {FloatConst(); return FLOAT;}
{NOTFLOAT}      {return ERROR_TOKEN;}
{INT}           {IntConst(); return INT;}
{IDENT}		{return Identifier ();}
{COMMENTCPP}	{EatCPPComment();}             
{COMMENTC}	{EatCComment();}	
{WHITESPACE}	{}          
{LINEFEED}      {line_num++;}
.		{return ERROR_TOKEN;}

%%

void EatCPPComment()
{
  char c;

  while ((c = yyinput()) != '\n' && c != 0);
  
  if(c=='\n') line_num++;
}

void EatCComment()
{
  char c,oc;
  oc=yyinput();

  if(oc==0) return;
  if(oc=='\n') line_num++;

  while (((c = yyinput()) != '/' || oc!='*') && c != 0) {
    oc=c;
    if(oc=='\n') line_num++;
  }
  
}

// Pass the id name
int Identifier ()  {
   assert(strlen(yytext)>0);

   if(yytext[yyleng-1]=='%') yytext[yyleng-1]=0;

   yylval.str_val = new char[strlen(yytext)+1];
   strcpy (yylval.str_val, yytext);

   return ID;
   
}
void IntConst() {
  yylval.int_val=atoi(yytext);
}
void FloatConst() {
  yylval.float_val=atof(yytext);
}

// Pass the string constant
void StringConst()  {
   assert(strlen(yytext)>0);
   int l,i,j;
   l = yyleng - 2;
   
   yylval.str_val = new char[l+1];
                 
   if(!yylval.str_val) return;

   for(i=0,j=1;j<l+1;i++,j++) {
     if(yytext[j]=='\\') {
       j++;
       switch(yytext[j]) {
	 case '\\':
	   yylval.str_val[i]='\\'; break;
	 case 'n':
	   yylval.str_val[i]='\n'; break;
         case 't':
           yylval.str_val[i]='\t'; break;
         case 'r':
	   yylval.str_val[i]='\r'; break;
	 case 'a':
	   yylval.str_val[i]='\a'; break;
	 case '\"':
	   yylval.str_val[i]='\"'; break;
	 case '\'':
	   yylval.str_val[i]='\''; break;
         default:
	   yylval.str_val[i]='\\';
	   j--;
           break;
       }
     } 
     else
       yylval.str_val[i]=yytext[j];
   }
                        
   //strncpy (yylval.str_val, &yytext[1], l);
   yylval.str_val[i] = 0;
}

void YY_INPUT(char *buf,int &result,int &max_size) {
	if ( yy_current_buffer->yy_is_interactive )
		{
		int c = '*', n;
		for ( n = 0; n < max_size &&
			     (c = pack_getc( p_yyin )) != EOF && c != '\n'; ++n )
			buf[n] = (char) c;
		if ( c == '\n' )
			buf[n++] = (char) c;
		if ( c == EOF && pack_ferror( p_yyin ) )
			YY_FATAL_ERROR( "input in flex scanner failed" );
		result = n;
		}
	else if ( ((result = pack_fread( buf, max_size, p_yyin )) == 0)
		  && pack_ferror( p_yyin ) )
		YY_FATAL_ERROR( "input in flex scanner failed" );
}
